/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.egurkha.util.EgUtilities;
import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MerakiAppTrafficBase
extends GenericTest {
    protected String apiKey = "";
    protected boolean isSSL = false;
    private boolean ssl_enabled = false;
    protected String url_string = "";
    private static final String ORGANIZATIONS_URI = "organizations";
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private static Hashtable lastTimeHash = new Hashtable();
    private static String gSync = new String("gSync");
    private static Hashtable syncHash = new Hashtable();
    private String sync = new String("Meraki_Sync");
    private long lastTime = 0L;
    EgUtilities egutil = EgUtilities.createInstance();
    protected static Hashtable totalTrafficHash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MerakiAppTrafficBase(String[] stringArray) {
        super(stringArray);
        String string;
        this.needAgentlessDD = true;
        try {
            this.apiKey = this.getValueForParam("api_key");
            string = this.getValueForParam("ssl");
            if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                this.isSSL = true;
            }
            this.url_string = this.isSSL ? "https://" + this.targetHost + "/api/v0/" : "http://" + this.targetHost + "/api/v0/";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string = gSync;
        synchronized (string) {
            String string2 = (String)syncHash.get(this.reportingName);
            if (string2 == null) {
                string2 = new String(this.reportingName);
                syncHash.put(this.reportingName, string2);
                this.setLastExectionTime();
            }
            this.sync = (String)syncHash.get(this.reportingName);
        }
    }

    private void setLastExectionTime() {
        lastTimeHash.put(this.reportingName, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName);
        this.lastTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectMetrics() {
        String string = this.sync;
        synchronized (string) {
            this.getLastExectionTime();
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            long l3 = (long)(0.9 * (double)this.measurePeriod);
            boolean bl = false;
            if (l2 >= l3) {
                bl = true;
                this.lastTime = l;
                this.setLastExectionTime();
            } else {
                bl = false;
            }
            if (bl) {
                this.collectTrafficMetrics();
                this.lastTime = System.currentTimeMillis();
                this.setLastExectionTime();
            }
        }
    }

    private void collectTrafficMetrics() {
        try {
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = this.getNetworkHash();
            if (hashtable2 == null || hashtable2.size() == 0) {
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable2.get(string2);
                String string4 = "";
                if (string2 != null && string2.indexOf(":") > 0) {
                    string4 = string2.substring(string2.indexOf(":") + 1, string2.length()).trim();
                }
                if ((string = this.getJSONDataFromURL("networks/" + string4 + "/traffic?timespan=7200", true)) == null || string.trim().length() == 0) continue;
                JSONArray jSONArray = null;
                try {
                    jSONArray = new JSONArray(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                JSONObject jSONObject = null;
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                String string12 = "";
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < jSONArray.length(); ++i) {
                    jSONObject = jSONArray.getJSONObject(i);
                    string5 = this.getValueFromJSONObject(jSONObject, "application");
                    string6 = this.getValueFromJSONObject(jSONObject, "destination");
                    string7 = this.getValueFromJSONObject(jSONObject, "port");
                    string8 = this.getValueFromJSONObject(jSONObject, "protocol");
                    string9 = this.getValueFromJSONObject(jSONObject, "sent");
                    string10 = this.getValueFromJSONObject(jSONObject, "recv");
                    string11 = this.getValueFromJSONObject(jSONObject, "numClients");
                    string12 = this.getValueFromJSONObject(jSONObject, "activeTime");
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(string5);
                    arrayList2.add(string6);
                    arrayList2.add(string7);
                    arrayList2.add(string8);
                    arrayList2.add(string9);
                    arrayList2.add(string10);
                    arrayList2.add(string11);
                    arrayList2.add(string12);
                    arrayList.add(arrayList2);
                }
                if (hashtable.containsKey(string3)) {
                    ArrayList arrayList3 = (ArrayList)hashtable.get(string3);
                    arrayList3.add(arrayList);
                } else {
                    hashtable.put(string3, arrayList);
                }
                totalTrafficHash.put(this.reportingName, hashtable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getNetworkHash() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            string5 = this.getJSONDataFromURL(ORGANIZATIONS_URI, true);
            if (string5 == null) {
                return null;
            }
            JSONArray jSONArray = null;
            try {
                jSONArray = new JSONArray(string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JSONObject jSONObject = null;
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    jSONObject = jSONArray.getJSONObject(i);
                    string = this.getValueFromJSONObject(jSONObject, "id");
                    string2 = this.getValueFromJSONObject(jSONObject, "name");
                    String string6 = this.getJSONDataFromURL("organizations/" + string + "/networks", true);
                    if (string6 == null) {
                        return null;
                    }
                    JSONArray jSONArray2 = null;
                    try {
                        jSONArray2 = new JSONArray(string6);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    JSONObject jSONObject2 = null;
                    for (int j = 0; j < jSONArray2.length(); ++j) {
                        jSONObject2 = jSONArray2.getJSONObject(j);
                        string4 = this.getValueFromJSONObject(jSONObject2, "id");
                        string3 = this.getValueFromJSONObject(jSONObject2, "name");
                        String string7 = string + ":" + string4;
                        String string8 = "NETWORK_ID:" + string4 + " NETWORK_NAME:" + string3;
                        hashtable.put(string7, string3);
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private String getJSONDataFromURL(String string, boolean bl) {
        String string2 = this.url_string + string;
        return this.getJSONDataFromURL(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJSONDataFromURL(String string) {
        HttpURLConnection httpURLConnection = null;
        String string2 = null;
        try {
            Object object;
            Object object2;
            ConnectionThread connectionThread;
            Object object3;
            if (this.isSSL && !this.ssl_enabled) {
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                object3 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                connectionThread = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                object2 = new TrustManager[]{myX509TrustManager};
                object = SSLContext.getInstance((String)"SSL");
                object.init(keyManagerArray, (TrustManager[])object2, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = object.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
                this.ssl_enabled = true;
            }
            object3 = new URL(string);
            httpURLConnection = (HttpURLConnection)((URL)object3).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(500);
            httpURLConnection.addRequestProperty("X-Cisco-Meraki-API-Key", this.apiKey);
            httpURLConnection.addRequestProperty("Content-Type", "application/json");
            httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.connect();
            connectionThread = new ConnectionThread(httpURLConnection, false);
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            object2 = new StringBuilder();
            if (bl) {
                n = connectionThread.code;
                if (n != 200) {
                    this.putErrorMessageToLogfile("Error in getJSONDataFromURL method REST url connection ..." + n);
                }
                if ((object = connectionThread.data) == null || ((ArrayList)object).isEmpty() || ((ArrayList)object).size() == 0) {
                    this.putWarningMessageToLogfile(" Data null or empty data");
                }
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    ((StringBuilder)object2).append((String)((ArrayList)object).get(i));
                }
            }
            if (!bl || n != 200) {
                this.putWarningMessageToLogfile(" Timing out or invalid response code:" + n);
            }
            string2 = ((StringBuilder)object2).toString();
        }
        catch (Exception exception) {
            this.putErrorMessageToLogfile("Error in getJSONDataFromURL " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            httpURLConnection = null;
        }
        return string2;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get(string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (JSONException jSONException) {
            string2 = "-";
            jSONException.printStackTrace();
        }
        return string2;
    }
}

