/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ListenerThread
implements Runnable {
    private MBeanServerConnection connection;
    private String nodeId = null;
    private long measurePeriod = 0L;
    private GCNotificationListener gcListener = null;
    boolean isListenerFaildToAttach = false;

    public ListenerThread(String string, MBeanServerConnection mBeanServerConnection, long l) {
        this.nodeId = string;
        this.connection = mBeanServerConnection;
        this.measurePeriod = l;
    }

    public void run() {
        try {
            this.gcListener = new GCNotificationListener(this.nodeId, this.measurePeriod);
            try {
                Set<ObjectName> set = this.connection.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null);
                Iterator<ObjectName> iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = ((Object)iterator.next()).toString();
                    try {
                        ObjectName objectName = new ObjectName(string);
                        this.connection.addNotificationListener(objectName, this.gcListener, null, null);
                        System.out.println("GCNotificationListener added for the " + this.nodeId + " successfully for the Object Name " + objectName);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        System.out.println("ListenerThread - InstanceNotFoundException for the " + this.nodeId + " & ObjectName " + string);
                        this.isListenerFaildToAttach = true;
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println("ListenerThread - Exception occured while attaching the Listener for the " + this.nodeId + " & ObjectName  " + string + " due to " + illegalArgumentException.getMessage());
                        System.out.println("ListenerThread - GCNotificationListener is not available for the target application Java version");
                        this.isListenerFaildToAttach = true;
                        break;
                    }
                    catch (Exception exception) {
                        System.out.println("ListenerThread - Exception occured while attaching the Listener inside run method , for the " + this.nodeId + " & ObjectName  " + string);
                        exception.printStackTrace();
                        this.isListenerFaildToAttach = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception occured while calling listener class - " + exception.getMessage());
        }
    }

    public void removeExistingNotification() {
        if (this.gcListener != null && this.connection != null) {
            try {
                Set<ObjectName> set = this.connection.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null);
                Iterator<ObjectName> iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = ((Object)iterator.next()).toString();
                    try {
                        ObjectName objectName = new ObjectName(string);
                        this.connection.removeNotificationListener(objectName, this.gcListener);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        System.out.println("InstanceNotFoundException for the ObjectName " + string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured while removeExistingNotification :" + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public boolean isListenerFaildToAttach() {
        return this.isListenerFaildToAttach;
    }
}

