/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

class JiraIssuesTest
extends JiraBase {
    private boolean isFirst = true;
    private boolean isSsl = false;
    private boolean ssl_enabled = false;
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    String user = "";
    String password = "";
    String url = "";
    String consoleURL = "";
    String host = "";
    String targetHost = "";
    String portNo = "";
    String auth = "";
    String encodedAuth = "";
    public Hashtable ddHashtable = new Hashtable();
    public Hashtable ddReportedInLast60m_ht = new Hashtable();
    public Hashtable ddUnassignedIssues_ht = new Hashtable();
    public Hashtable ddOpenIssues_ht = new Hashtable();
    public Hashtable ddRecentlyCreatedIssues_ht = new Hashtable();
    public Hashtable prevhash = new Hashtable();
    public ArrayList prevList = new ArrayList();
    public ArrayList ddPrevList = new ArrayList();
    public ArrayList excludedIssueTypes_al = new ArrayList();
    public ArrayList excludedProjects_al = new ArrayList();
    public Hashtable prevDDHash = new Hashtable();
    public Hashtable prevDDReportedInLast60m_ht = new Hashtable();
    private final String DEFAULT_URI_SUFFIX = "";
    String synString = new String();
    String excludedProjects = "none";
    String excludedIssueTypes = "none";

    public JiraIssuesTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.isDynamicInfoTest = true;
        this.needAgentlessDD = true;
        try {
            String string;
            StringTokenizer stringTokenizer;
            this.user = this.getValueForParam("Username");
            this.password = this.getValueForParam("password");
            this.host = this.getValueForParam("host");
            this.targetHost = this.getValueForParam("trgtHost");
            this.portNo = this.getValueForParam("port");
            this.excludedProjects = this.getValueForParam("excluded_Projects");
            this.excludedIssueTypes = this.getValueForParam("excluded_IssueTypes");
            this.consoleURL = this.getValueForParam("console_URL");
            if (this.consoleURL == null || this.consoleURL.trim().equalsIgnoreCase("unconfigured") || this.consoleURL.trim().equalsIgnoreCase("none") || this.consoleURL.trim().equalsIgnoreCase("")) {
                this.logToErrorFile("Error", this.entity, "consoleURL is required");
            }
            String string2 = this.getValueForParam("ssl");
            this.encodedAuth = new String(Base64.encode((String)(this.user + ":" + this.password)));
            if (this.excludedIssueTypes != null && !this.excludedIssueTypes.trim().equalsIgnoreCase("none")) {
                stringTokenizer = new StringTokenizer(this.excludedIssueTypes, ",");
                this.excludedIssueTypes_al = new ArrayList();
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    this.excludedIssueTypes_al.add(string);
                }
            }
            if (this.excludedProjects != null && !this.excludedProjects.trim().equalsIgnoreCase("none")) {
                stringTokenizer = new StringTokenizer(this.excludedProjects, ",");
                this.excludedProjects_al = new ArrayList();
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    this.excludedProjects_al.add(string);
                }
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getJiraProjectNames();
            if (hashtable2 != null && hashtable2.size() > 0) {
                Set set = hashtable2.keySet();
                for (String string : set) {
                    ArrayList arrayList = (ArrayList)hashtable2.get(string);
                    if (string != null && this.excludedProjects_al != null && this.excludedProjects_al.contains(string) || arrayList == null || arrayList != null && arrayList.size() == 0) continue;
                    if (arrayList != null) {
                        arrayList.add("All");
                    }
                    for (String string2 : arrayList) {
                        if (string2 != null && this.excludedIssueTypes_al != null && this.excludedIssueTypes_al.contains(string2)) continue;
                        ArrayList arrayList2 = this.getJqls(string, string2);
                        ArrayList<Double> arrayList3 = new ArrayList<Double>();
                        if (arrayList2 == null || arrayList2.size() <= 0) continue;
                        for (String string3 : arrayList2) {
                            JSONObject jSONObject = new JSONObject();
                            jSONObject.put((Object)"jql", (Object)string3);
                            jSONObject.put((Object)"startAt", (Object)0);
                            jSONObject.put((Object)"maxResults", (Object)50);
                            String string4 = this.synString;
                            synchronized (string4) {
                                Long l = this.getTotalCountForMeasure(jSONObject);
                                if (l < 0L) {
                                    l = -5L;
                                }
                                arrayList3.add(new Double(l.longValue()));
                            }
                        }
                        if (string2 != null && !string2.trim().equalsIgnoreCase("All")) {
                            this.addDDForDueIn24H(string, string2);
                            this.addDDForReportedInLast60m(string, string2);
                            this.addDDForOpenIssues(string, string2);
                            this.addDDForRecentlyCreatedIssues(string, string2);
                        }
                        this.addNewMeasure(string + ":" + string2, arrayList3);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity + " Got an Exception in computeMeasures method.", throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getJiraProjectNames() {
        String string = "/rest/api/2/project";
        String string2 = "";
        Hashtable hashtable = null;
        try {
            string2 = this.consoleURL + string;
            Client client2 = Client.create();
            WebResource webResource = client2.resource(string2);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string3 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                if (string3 != null && !string3.equals("")) {
                    JSONParser jSONParser = new JSONParser();
                    hashtable = new Hashtable();
                    Object object = jSONParser.parse(string3.toString());
                    JSONArray jSONArray = (JSONArray)object;
                    for (JSONObject jSONObject : jSONArray) {
                        String string4 = (String)jSONObject.get((Object)"id");
                        String string5 = (String)jSONObject.get((Object)"name");
                        String string6 = this.synString;
                        synchronized (string6) {
                            JSONArray jSONArray2 = this.getJiraIssueTypes(string4);
                            if (jSONArray2 != null) {
                                Iterator iterator = jSONArray2.iterator();
                                ArrayList<String> arrayList = new ArrayList<String>();
                                while (iterator.hasNext()) {
                                    JSONObject jSONObject2 = (JSONObject)iterator.next();
                                    String string7 = (String)jSONObject2.get((Object)"name");
                                    arrayList.add(string7);
                                }
                                hashtable.put(string5, arrayList);
                            }
                        }
                    }
                }
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, "Failed to get project names... Invalid Username or Password");
            } else {
                this.logToErrorFile("Error", this.entity, "Failed to get project names. reqURL: " + string2 + " Response Status Code: " + n);
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, "Got exception in getJiraProjectNames method. reqURL: " + string2 + " Exception Message: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        return hashtable;
    }

    public JSONArray getJiraIssueTypes(String string) {
        String string2 = "/rest/api/2/project/" + string;
        String string3 = "";
        Hashtable hashtable = null;
        JSONArray jSONArray = null;
        try {
            string3 = this.consoleURL + string2;
            Client client2 = Client.create();
            WebResource webResource = client2.resource(string3);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string4 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                if (string4 != null && !string4.equals("")) {
                    JSONParser jSONParser = new JSONParser();
                    hashtable = new Hashtable();
                    Object object = jSONParser.parse(string4.toString());
                    JSONObject jSONObject = (JSONObject)object;
                    String string5 = (String)jSONObject.get((Object)"id");
                    String string6 = (String)jSONObject.get((Object)"name");
                    jSONArray = (JSONArray)jSONObject.get((Object)"issueTypes");
                }
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, " Failed to get IssueTypes... Invalid Username or Password");
            } else {
                this.logToErrorFile("Error", this.entity, " Failed to get IssueTypes. reqURL: " + string3 + " Response Status Code: " + n);
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, "Got exception in getJiraIssueTypes method. reqURL: " + string3 + " Exception Message: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        return jSONArray;
    }

    public ArrayList getJqls(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null && string2.trim().equalsIgnoreCase("All")) {
            arrayList.add("project in (\"" + string + "\")");
            arrayList.add("project in (\"" + string + "\") AND resolution = Unresolved");
            arrayList.add("project in (\"" + string + "\") AND assignee is empty");
            arrayList.add("project in (\"" + string + "\") AND created >= -1w order by created DESC");
            arrayList.add("project in (\"" + string + "\") AND resolutiondate >= -1w order by updated DESC");
            arrayList.add("project in (\"" + string + "\") AND resolution = Unresolved AND due <= 24h ORDER BY due ASC");
            arrayList.add("project in (\"" + string + "\") AND created >= -60m ORDER BY created DESC");
            arrayList.add("project in (\"" + string + "\") AND resolution = Unresolved AND priority in (Highest, High) AND created >= -10m ORDER BY created DESC");
        } else {
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\"");
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND resolution = Unresolved");
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND assignee is empty");
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND created >= -1w order by created DESC");
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND resolutiondate >= -1w order by updated DESC");
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND resolution = Unresolved AND due <= 24h ORDER BY due ASC");
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND created >= -60m ORDER BY created DESC");
            arrayList.add("project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND resolution = Unresolved AND priority in (Highest, High) AND created >= -10m ORDER BY created DESC");
        }
        return arrayList;
    }

    public Long getTotalCountForMeasure(JSONObject jSONObject) {
        String string = "/rest/api/2/search";
        String string2 = "YWRtaW46ZWd1cmtoYTEyMw==";
        String string3 = "";
        Long l = 0L;
        try {
            String string4 = jSONObject.toString();
            string3 = this.consoleURL + string;
            Client client2 = Client.create();
            WebResource webResource = client2.resource(string3);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)string4);
            int n = clientResponse.getStatus();
            String string5 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                if (string5 != null && !string5.equals("")) {
                    JSONParser jSONParser = new JSONParser();
                    Object object = jSONParser.parse(string5.toString());
                    JSONObject jSONObject2 = (JSONObject)object;
                    Long l2 = (Long)jSONObject2.get((Object)"total");
                    if (l2 < 0L) {
                        l2 = -5L;
                    }
                    l = l2;
                }
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, " Failed to get Total Count For Measure.. Invalid Username or Password");
            } else {
                this.logToErrorFile("Error", this.entity, " Failed to get Total Count For Measure. reqURL: " + string3 + " Response Status Code: " + n);
            }
        }
        catch (Throwable throwable) {
            this.logToErrorFile("Error", this.entity, " Got exception in getTotalCountForMeasure method. reqURL: " + string3 + " Exception Message: " + throwable.getMessage());
            throwable.printStackTrace();
        }
        return l;
    }

    public void addDDForDueIn24H(String string, String string2) {
        String string3 = "";
        string3 = string2 != null && string2.trim().equalsIgnoreCase("All") ? "project in (\"" + string + "\") AND priority in (Highest, High) AND resolution = Unresolved AND due <= 24h ORDER BY due ASC" : "project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND priority in (Highest, High) AND resolution = Unresolved AND due <= 24h ORDER BY due ASC";
        ArrayList arrayList = this.getDDForMeasure(string3);
        this.ddHashtable.put(string + ":" + string2, arrayList);
    }

    public void addDDForReportedInLast60m(String string, String string2) {
        String string3 = "";
        string3 = string2 != null && string2.trim().equalsIgnoreCase("All") ? "project in (\"" + string + "\") AND priority in (Highest, High) AND created >= -60m ORDER BY created DESC" : "project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND priority in (Highest, High) AND created >= -60m ORDER BY created DESC";
        ArrayList arrayList = this.getDDForMeasure(string3);
        this.ddReportedInLast60m_ht.put(string + ":" + string2, arrayList);
    }

    public void addDDForOpenIssues(String string, String string2) {
        String string3 = "";
        string3 = string2 != null && string2.trim().equalsIgnoreCase("All") ? "project in (\"" + string + "\") AND priority in (Highest, High) AND resolution = Unresolved" : "project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND priority in (Highest, High) AND resolution = Unresolved";
        ArrayList arrayList = this.getDDForMeasure(string3);
        this.ddOpenIssues_ht.put(string + ":" + string2, arrayList);
    }

    public void addDDForUnassignedIssues(String string, String string2) {
        String string3 = "";
        string3 = string2 != null && string2.trim().equalsIgnoreCase("All") ? "project in (\"" + string + "\") AND priority in (Highest, High) AND assignee is empty" : "project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND priority in (Highest, High) AND assignee is empty";
        ArrayList arrayList = this.getDDForMeasure(string3);
        this.ddUnassignedIssues_ht.put(string + ":" + string2, arrayList);
    }

    public void addDDForRecentlyCreatedIssues(String string, String string2) {
        String string3 = "";
        string3 = string2 != null && string2.trim().equalsIgnoreCase("All") ? "project in (\"" + string + "\") AND priority in (Highest, High) AND created >= -1w order by created DESC" : "project in (\"" + string + "\") AND issuetype = \"" + string2 + "\" AND priority in (Highest, High) AND created >= -1w order by created DESC";
        ArrayList arrayList = this.getDDForMeasure(string3);
        this.ddRecentlyCreatedIssues_ht.put(string + ":" + string2, arrayList);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.254", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "eGfirewall"};
        JiraIssuesTest jiraIssuesTest = new JiraIssuesTest(stringArray2);
        try {
            jiraIssuesTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                System.out.println(" Timed out and hence going to kill the thread :" + System.currentTimeMillis());
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                System.out.println(" Timed out and killed the thread :" + System.currentTimeMillis());
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        System.out.println(" sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis());
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println("" + exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

