/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBODBCTest
extends IIBResourceStatisticsBase {
    private static final int ODBC_STAT_MEASURE_COUNT = 6;
    public Hashtable prevhash = new Hashtable();

    public IIBODBCTest(String[] args) {
        super(args);
        this.setMeasureCount(6);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable currHashtable = new Hashtable();
        currHashtable = this.getData("ODBC");
        if (currHashtable == null || currHashtable.size() == 0 || currHashtable.isEmpty()) {
            return;
        }
        if (currHashtable != null) {
            Enumeration en = currHashtable.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (this.prevhash != null && this.prevhash.size() > 0) {
                    ArrayList prevlist = (ArrayList)this.prevhash.get(key);
                    ArrayList currentlist = (ArrayList)currHashtable.get(key);
                    if (prevlist == null || currentlist == null) continue;
                    double suceessExecutions = 0.0;
                    double failedExecutions = 0.0;
                    double successRate = 0.0;
                    double failedRate = 0.0;
                    double totalExecutionRate = 0.0;
                    double currSuccessExection = (Double)currentlist.get(0);
                    double currFailedExecutions = (Double)currentlist.get(1);
                    double prevSuccessExection = (Double)prevlist.get(0);
                    double prevFailedExecutions = (Double)prevlist.get(1);
                    if (currSuccessExection > 0.0 && prevSuccessExection > 0.0) {
                        suceessExecutions = currSuccessExection - prevSuccessExection;
                    } else {
                        successRate = -5.0;
                        this.printOut("WARNING : current and previous suceess Executions are less than zero");
                    }
                    if (currFailedExecutions > 0.0 && prevFailedExecutions > 0.0) {
                        failedExecutions = currFailedExecutions - prevFailedExecutions;
                    } else {
                        failedExecutions = -5.0;
                        this.printOut("WARNING : current and  previous failed Executions are less than zero");
                    }
                    if (suceessExecutions > 0.0 && failedExecutions > 0.0) {
                        if (this.timeSinceLastTest > 0.0) {
                            successRate = suceessExecutions / this.timeSinceLastTest;
                            failedRate = failedExecutions / this.timeSinceLastTest;
                            totalExecutionRate = (suceessExecutions + failedExecutions) / this.timeSinceLastTest;
                        } else {
                            this.printOut("WARNING : timeSinceLastTest value is  less than zero");
                            successRate = -5.0;
                            failedRate = -5.0;
                            totalExecutionRate = -5.0;
                        }
                    } else {
                        this.printOut("WARNING : suceessExecutions  and failedExecutions value is  less than zero");
                        successRate = -5.0;
                        failedRate = -5.0;
                        totalExecutionRate = -5.0;
                    }
                    double activeConnections = (Double)currentlist.get(2);
                    double closedConnections = (Double)currentlist.get(3);
                    double connectionsErrors = (Double)currentlist.get(4);
                    if (EgTest.debug) {
                        this.printOut(" suceessExecutions ======>" + suceessExecutions);
                        this.printOut(" failedExecutions ======>" + failedExecutions);
                        this.printOut(" successRate ======>" + successRate);
                        this.printOut(" failedRate ======>" + failedRate);
                        this.printOut(" TotalExecutionRate =====>" + totalExecutionRate);
                        this.printOut(" activeConnections ======>" + activeConnections);
                        this.printOut(" closedConnections ======>" + closedConnections);
                        this.printOut(" connectionsErrors ======>" + connectionsErrors);
                    }
                    ArrayList<Double> measurelist = new ArrayList<Double>();
                    measurelist.add(new Double(successRate));
                    measurelist.add(new Double(failedRate));
                    measurelist.add(new Double(totalExecutionRate));
                    measurelist.add(new Double(activeConnections));
                    measurelist.add(new Double(closedConnections));
                    measurelist.add(new Double(connectionsErrors));
                    if (EgTest.debug) {
                        this.printOut(" key1====>" + key + " value1===>" + measurelist);
                    }
                    this.addNewMeasure(key, measurelist);
                    continue;
                }
                ArrayList<Double> al = new ArrayList<Double>();
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                if (EgTest.debug) {
                    this.printOut("NotAvaliablevalue key==>" + key + " value===>" + al);
                }
                this.addNewMeasure(key, al);
            }
            this.prevhash = currHashtable;
            if (EgTest.debug) {
                this.printOut("previoushash======>" + this.prevhash);
            }
        }
    }

    public static void main(String[] args) {
        IIBODBCTest obj = new IIBODBCTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

