/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class IBMDb2AgentsTest
extends GenericTest {
    private static final int MEASURES_COUNT = 5;
    private String user;
    private String password;
    private String dbName;
    private double lastAgentsFromPool = -1.0;
    private double lastAgentsCreatedEmptyPool = -1.0;
    private double lastAgentsStolen = -1.0;

    public static void main(String[] stringArray) {
        new IBMDb2AgentsTest(stringArray).computeMeasures(null);
    }

    public IBMDb2AgentsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.getAgentsStats();
        if (arrayList != null) {
            this.addNewMeasure(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getAgentsStats() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        double d10 = -5.0;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string = dB2JdbcHelper.getDbmSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string);
        String string2 = "SELECT AGENTS_REGISTERED,AGENTS_WAITING_ON_TOKEN,IDLE_AGENTS,AGENTS_FROM_POOL,AGENTS_CREATED_EMPTY_POOL,AGENTS_STOLEN FROM table(" + string + ") DBM";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                d = resultSet.getDouble("AGENTS_REGISTERED");
                d2 = resultSet.getDouble("AGENTS_WAITING_ON_TOKEN");
                d3 = resultSet.getDouble("IDLE_AGENTS");
                d4 = resultSet.getDouble("AGENTS_FROM_POOL");
                d5 = resultSet.getDouble("AGENTS_CREATED_EMPTY_POOL");
                d6 = resultSet.getDouble("AGENTS_STOLEN");
                d8 = d2 / d * 100.0;
            }
            if (this.lastAgentsFromPool != -1.0 && this.lastAgentsCreatedEmptyPool != -1.0 && this.lastAgentsStolen != -1.0) {
                double d11;
                double d12 = d4 - this.lastAgentsFromPool;
                double d13 = d5 - this.lastAgentsCreatedEmptyPool;
                double d14 = d12 + d13;
                d9 = d14 > 0.0 ? d12 / d14 * 100.0 : 100.0;
                if (d9 == 0.0) {
                    d9 = 100.0;
                }
                if ((d11 = d6 - this.lastAgentsStolen) >= 0.0 || this.timeSinceLastTest > 0.0) {
                    d7 = d11 / this.timeSinceLastTest;
                }
            }
            this.lastAgentsFromPool = d4;
            this.lastAgentsCreatedEmptyPool = d5;
            this.lastAgentsStolen = d6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ArrayList arrayList = null;
            return arrayList;
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        ArrayList<Double> arrayList = new ArrayList<Double>(5);
        arrayList.add(new Double(d));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d8));
        arrayList.add(new Double(d9));
        arrayList.add(new Double(d7));
        return arrayList;
    }
}

