/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;

public class HttpHelper
extends Thread {
    private static String execDebugLogFile = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/logs/http_exec.log";
    public static boolean justPrint = false;
    private HttpURLConnection uc;
    private HttpsURLConnection ucs;
    private String urlString = "";
    private boolean privateKeyURL = false;
    public long getTime = 0L;
    public long firstRespTime = 0L;
    public long lastRespTime = 0L;
    public long startTime = 0L;
    public int tcpConnectionAvailability = 0;
    public int contentValidity = -1;
    public int responseCode = -1;
    public int contentLength = -5;
    public int dnsavail = 100;
    private String cookieFile;
    public boolean done = false;
    public boolean status = false;
    boolean debug = false;
    private String content = "none";
    private String contentMode = "none";
    private String[] argsList = null;
    private boolean deb = false;
    private boolean followRedirects = true;
    private String encoding = null;

    public HttpHelper(HttpURLConnection url, String cookieFile, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile, String actURL, boolean callingFrom) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.privateKeyURL = true;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String encoding, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.encoding = encoding;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile, String encoding, String actURL, boolean callingFrom) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.encoding = encoding;
        this.privateKeyURL = true;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.urlString = actURL;
        this.argsList = args;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args, String encoding, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.argsList = args;
        this.encoding = encoding;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args, boolean deb, boolean followRedirects, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.argsList = args;
        this.deb = deb;
        this.urlString = actURL;
        this.followRedirects = followRedirects;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args, boolean deb, boolean followRedirects, String encoding, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.argsList = args;
        this.deb = deb;
        this.followRedirects = followRedirects;
        this.urlString = actURL;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.urlString = actURL;
        this.content = cont;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile, String mode, String cont, String actURL, boolean callingFrom) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.privateKeyURL = true;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String encoding, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.encoding = encoding;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile, String mode, String cont, String encoding, String actURL, boolean callingFrom) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.encoding = encoding;
        this.privateKeyURL = true;
        this.urlString = actURL;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.urlString = actURL;
        this.argsList = args;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args, String encoding, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.argsList = args;
        this.urlString = actURL;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args, boolean deb, boolean followRedirects, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.argsList = args;
        this.deb = deb;
        this.urlString = actURL;
        this.followRedirects = followRedirects;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args, boolean deb, boolean followRedirects, String encoding, String actURL, boolean callingFrom) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.argsList = args;
        this.deb = deb;
        this.followRedirects = followRedirects;
        this.urlString = actURL;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.privateKeyURL = true;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String encoding) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile, String encoding) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.encoding = encoding;
        this.privateKeyURL = true;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.argsList = args;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args, String encoding) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.argsList = args;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args, boolean deb, boolean followRedirects) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.argsList = args;
        this.deb = deb;
        this.followRedirects = followRedirects;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String[] args, boolean deb, boolean followRedirects, String encoding) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.argsList = args;
        this.deb = deb;
        this.followRedirects = followRedirects;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile, String mode, String cont) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.privateKeyURL = true;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String encoding) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpsURLConnection url, String cookieFile, String mode, String cont, String encoding) {
        this.ucs = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.encoding = encoding;
        this.privateKeyURL = true;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.argsList = args;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args, String encoding) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.argsList = args;
        this.encoding = encoding;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args, boolean deb, boolean followRedirects) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.argsList = args;
        this.deb = deb;
        this.followRedirects = followRedirects;
        this.start();
    }

    public HttpHelper(HttpURLConnection url, String cookieFile, String mode, String cont, String[] args, boolean deb, boolean followRedirects, String encoding) {
        this.uc = url;
        this.cookieFile = cookieFile;
        this.contentMode = mode;
        this.content = cont;
        this.argsList = args;
        this.deb = deb;
        this.followRedirects = followRedirects;
        this.encoding = encoding;
        this.start();
    }

    private boolean patternMatch(String outString, String searchString) {
        if (searchString.equals("*")) {
            return true;
        }
        int ir = searchString.indexOf("*");
        if (ir < 0) {
            return outString.equalsIgnoreCase(searchString);
        }
        boolean flag = false;
        boolean startsWithCond = false;
        boolean endsWithCond = false;
        if (!searchString.startsWith("*")) {
            startsWithCond = true;
        }
        if (!searchString.endsWith("*")) {
            endsWithCond = true;
        }
        StringTokenizer st = new StringTokenizer(searchString, "*");
        int count = st.countTokens();
        String newString = new String(outString);
        String[] patterns = new String[count];
        if (count <= 0) {
            return false;
        }
        int i = 0;
        while (i < count) {
            patterns[i] = st.nextToken();
            ++i;
        }
        int index = 0;
        if (startsWithCond && !newString.startsWith(patterns[0])) {
            return false;
        }
        if (endsWithCond && !newString.endsWith(patterns[count - 1])) {
            return false;
        }
        String s1 = null;
        int j = 0;
        while (j < count) {
            s1 = patterns[j];
            index = newString.indexOf(s1);
            if (index == -1) {
                return false;
            }
            flag = true;
            newString = new String(newString.substring(index += s1.length()));
            ++j;
        }
        return flag;
    }

    public void run() {
        if (this.deb) {
            HttpHelper.debugLog("DEBUG", this.urlString, "**** start thread at: " + new Date());
        }
        this.startTime = System.currentTimeMillis();
        this.responseCode = -1;
        this.contentLength = -5;
        if (this.argsList != null) {
            PrintWriter out = null;
            try {
                out = this.privateKeyURL ? new PrintWriter(this.ucs.getOutputStream()) : new PrintWriter(this.uc.getOutputStream());
                int i = 0;
                while (i < this.argsList.length) {
                    if (i > 0) {
                        out.print("&");
                    }
                    out.print(this.argsList[i]);
                    ++i;
                }
                out.close();
            }
            catch (Exception e) {
                HttpHelper.debugLog("ERROR", this.urlString, "Exception in HttpHelper - " + e.toString());
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.done = true;
                this.status = false;
                return;
            }
        }
        try {
            if (this.privateKeyURL) {
                this.ucs.connect();
            } else {
                this.uc.connect();
            }
            if (this.deb) {
                HttpHelper.debugLog("DEBUG", this.urlString, "**** Connection is Success ");
            }
        }
        catch (Exception e) {
            String error = e.toString();
            HttpHelper.debugLog("DEBUG", this.urlString, "Exception in HttpHelper, checking for valid response - " + e.toString());
            if (error.indexOf("javax.net.ssl.SSLException") >= 0) {
                this.tcpConnectionAvailability = 100;
                this.responseCode = 200;
                this.getTime = this.firstRespTime = System.currentTimeMillis();
                this.lastRespTime = this.firstRespTime;
                this.contentValidity = 100;
                this.contentLength = 0;
            } else if (error.indexOf("java.net.UnknownHostException") >= 0) {
                HttpHelper.debugLog("ERROR", this.urlString, "Exception in HttpHelper - " + e.toString());
                if (this.deb) {
                    e.printStackTrace();
                }
                this.dnsavail = 0;
                this.tcpConnectionAvailability = -5;
            } else {
                this.checkForUnsupportedKeyword(e);
            }
            this.done = true;
            this.status = true;
            try {
                if (this.privateKeyURL) {
                    if (this.ucs != null) {
                        this.ucs.disconnect();
                    }
                } else if (this.uc != null) {
                    this.uc.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            int totalCount;
            boolean checkContent;
            BufferedReader br;
            block68: {
                this.getTime = System.currentTimeMillis();
                this.tcpConnectionAvailability = 100;
                this.responseCode = this.privateKeyURL ? this.ucs.getResponseCode() : this.uc.getResponseCode();
                if (this.deb) {
                    HttpHelper.debugLog("DEBUG", this.urlString, "Response code " + this.responseCode);
                }
                if (this.responseCode == 0) {
                    this.responseCode = 200;
                }
                int times = 0;
                while (this.followRedirects && this.responseCode > 300 && this.responseCode <= 400) {
                    String newurl = "";
                    newurl = this.privateKeyURL ? this.ucs.getHeaderField("Location") : this.uc.getHeaderField("Location");
                    if (this.deb) {
                        HttpHelper.debugLog("DEBUG", this.urlString, "New URL " + newurl);
                    }
                    if (this.privateKeyURL) {
                        this.ucs.disconnect();
                    } else {
                        this.uc.disconnect();
                    }
                    URL url = null;
                    try {
                        url = new URL(newurl);
                    }
                    catch (MalformedURLException m) {
                        HttpHelper.debugLog("DEBUG", this.urlString, "HttpHelper - Invalid URL " + newurl);
                        this.status = false;
                        this.done = true;
                        return;
                    }
                    if (this.privateKeyURL) {
                        this.ucs = (HttpsURLConnection)url.openConnection();
                        this.ucs.setRequestMethod("GET");
                        HttpURLConnection.setFollowRedirects(true);
                        this.responseCode = this.ucs.getResponseCode();
                    } else {
                        this.uc = (HttpURLConnection)url.openConnection();
                        this.uc.setRequestMethod("GET");
                        HttpURLConnection.setFollowRedirects(true);
                        this.responseCode = this.uc.getResponseCode();
                    }
                    if (this.responseCode == 0) {
                        this.responseCode = 200;
                    }
                    if (++times >= 5) break;
                }
                this.firstRespTime = System.currentTimeMillis();
                this.contentLength = this.privateKeyURL ? this.ucs.getContentLength() : this.uc.getContentLength();
                if (this.deb) {
                    HttpHelper.debugLog("DEBUG", this.urlString, "CONTENT " + this.contentLength);
                }
                InputStream input = null;
                input = this.privateKeyURL ? this.ucs.getInputStream() : this.uc.getInputStream();
                if (this.encoding == null || this.encoding.equalsIgnoreCase("none")) {
                    this.encoding = "ISO-8859-1";
                }
                br = new BufferedReader(new InputStreamReader(input, this.encoding));
                checkContent = false;
                if (this.contentMode != null && !this.contentMode.equals("none")) {
                    checkContent = true;
                }
                this.contentValidity = checkContent ? -1 : 100;
                totalCount = 0;
                boolean match = false;
                int ind2 = this.content.indexOf(42);
                if (ind2 >= 0) {
                    match = true;
                }
                boolean isInclude = false;
                boolean isExclude = false;
                if (checkContent && (this.contentMode.startsWith("i") || this.contentMode.startsWith("I"))) {
                    isInclude = true;
                }
                if (checkContent && (this.contentMode.startsWith("e") || this.contentMode.startsWith("E"))) {
                    isExclude = true;
                }
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        boolean found;
                        if (this.deb || justPrint) {
                            System.out.println(line);
                        }
                        if (this.contentLength < 0) {
                            totalCount += line.length();
                        }
                        if (this.contentValidity >= 0) continue;
                        if (isInclude) {
                            found = false;
                            if (match) {
                                if (this.patternMatch(line, this.content)) {
                                    found = true;
                                }
                            } else if (line.indexOf(this.content) >= 0) {
                                found = true;
                            }
                            if (!found) continue;
                            this.contentValidity = 100;
                            continue;
                        }
                        if (!isExclude) continue;
                        found = false;
                        if (match) {
                            if (this.patternMatch(line, this.content)) {
                                found = true;
                            }
                        } else if (line.indexOf(this.content) >= 0) {
                            found = true;
                        }
                        if (!found) continue;
                        this.contentValidity = 0;
                    }
                }
                catch (Exception e) {
                    String err = e.toString();
                    if (err.contains("Premature EOF")) break block68;
                    HttpHelper.debugLog("DEBUG", this.urlString, "HttpHelper **** exception occured in line 700 (inputStream while loop) " + e.toString());
                }
            }
            br.close();
            if (this.contentLength < 0) {
                this.contentLength = totalCount;
            }
            if (checkContent && (this.contentMode.startsWith("e") || this.contentMode.startsWith("E"))) {
                if (this.contentValidity == -1) {
                    this.contentValidity = 100;
                }
            } else if (checkContent && (this.contentMode.startsWith("i") || this.contentMode.startsWith("I")) && this.contentValidity == -1) {
                this.contentValidity = 0;
            }
            this.lastRespTime = System.currentTimeMillis();
            if (this.cookieFile != null) {
                String cookieValue = "";
                cookieValue = this.privateKeyURL ? this.ucs.getHeaderField("Set-cookie") : this.uc.getHeaderField("Set-cookie");
                if (cookieValue != null) {
                    File outputFile = new File(this.cookieFile);
                    PrintWriter out = new PrintWriter(new FileWriter(outputFile));
                    out.println(cookieValue);
                    out.close();
                }
            }
            if (this.privateKeyURL) {
                this.ucs.disconnect();
            } else {
                this.uc.disconnect();
            }
            this.done = true;
            this.status = true;
        }
        catch (Exception e) {
            String error = e.toString();
            HttpHelper.debugLog("DEBUG", this.urlString, "HttpHelper **** Error at line 555 is " + error);
            if (this.debug) {
                e.printStackTrace();
            }
            this.status = false;
            this.done = true;
        }
    }

    private void deleteFile(String s) {
        if (s == null) {
            return;
        }
        File f = new File(s);
        if (f != null) {
            f.delete();
        }
    }

    private void checkForUnsupportedKeyword(Exception e) {
        PrintWriter pw = null;
        BufferedReader br = null;
        String line = null;
        String errorFile = null;
        try {
            File dir = new File(EgConfigInfo.tmpDir);
            File f = File.createTempFile("eghttp", ".txt", dir);
            errorFile = f.getAbsolutePath();
        }
        catch (Exception dir) {
            // empty catch block
        }
        if (errorFile == null) {
            return;
        }
        try {
            if (this.debug) {
                HttpHelper.debugLog("DEBUG", this.urlString, "check for unsupported keyword...");
            }
            pw = new PrintWriter(new FileOutputStream(errorFile));
            if (this.debug) {
                e.printStackTrace(pw);
            }
            pw.close();
            br = new BufferedReader(new FileReader(errorFile));
            if (br == null) {
                this.deleteFile(errorFile);
                return;
            }
            line = br.readLine();
            if (this.debug) {
                HttpHelper.debugLog("DEBUG", this.urlString, "LINE1 " + line);
            }
            if (line == null || line.length() == 0) {
                try {
                    br.close();
                }
                catch (Exception dir) {
                    // empty catch block
                }
                this.deleteFile(errorFile);
                return;
            }
            if (line.indexOf("unsupported keyword") < 0) {
                try {
                    br.close();
                }
                catch (Exception dir) {
                    // empty catch block
                }
                this.deleteFile(errorFile);
                return;
            }
            line = br.readLine();
            if (this.debug) {
                HttpHelper.debugLog("DEBUG", this.urlString, "LINE2 " + line);
            }
            if (line == null || line.length() == 0) {
                try {
                    br.close();
                }
                catch (Exception dir) {
                    // empty catch block
                }
                this.deleteFile(errorFile);
                return;
            }
            if (line.indexOf("com.sun.net.ssl.internal.ssl.AVA") < 0) {
                try {
                    br.close();
                }
                catch (Exception dir) {
                    // empty catch block
                }
                this.deleteFile(errorFile);
                return;
            }
            this.tcpConnectionAvailability = 100;
            this.responseCode = 200;
            this.getTime = this.firstRespTime = System.currentTimeMillis();
            this.lastRespTime = this.firstRespTime;
            this.contentValidity = 100;
            this.contentLength = 0;
            br.close();
            this.deleteFile(errorFile);
        }
        catch (Exception ee) {
            this.deleteFile(errorFile);
            try {
                if (pw != null) {
                    pw.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void debugLog(String type, String component, String msg) {
        PrintWriter logWriter = null;
        EgDateInfo dateInfo = new EgDateInfo();
        String logDateAndTime = dateInfo.egetDate(false);
        File ff = new File(execDebugLogFile);
        if (ff.exists() && ff.length() >= 10000000L) {
            EgInstallInfo.fileRename(execDebugLogFile, String.valueOf(execDebugLogFile) + ".1");
        }
        try {
            logWriter = new PrintWriter(new FileWriter(execDebugLogFile, true));
        }
        catch (Exception e) {
            System.err.println("Cannot open log file ");
            return;
        }
        String log = new String(String.valueOf(logDateAndTime) + " " + type + " " + component + " " + msg);
        logWriter.println(log);
        logWriter.flush();
        logWriter.close();
    }
}

