/*
 * Decompiled with CFR 0.152.
 */
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class HeapDumpGenerator {
    public static String jmxHost = null;
    public static int jmxPort;
    public static String folderPath;
    public static String jmxUserName;
    public static String jmxPassword;
    public static boolean live;
    public static boolean isValidJMXPort;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    static {
        folderPath = null;
        jmxUserName = "none";
        jmxPassword = "none";
        live = false;
        isValidJMXPort = false;
    }

    private static void usage() {
        System.out.println("");
        System.out.println("*******************************************************  JAVA HEAP DUMP GENERATOR via JMX  *******************************************************");
        System.out.println("");
        System.out.println(" Usage : java HeapDumpGenerator -host <<HOST>> -port <<JMX_PORT>> -path <<FOLDER_PATH>> -live<<TRUE/FALSE>> -user <<USER_NAME>> -pass <<PASSWORD>>");
        System.out.println("\n  (e.g)");
        System.out.println("\t java HeapDumpGenerator -host 192.168.10.25 -port 12233 -path /tmp/heap -live false -user john -pass j@hN");
        System.out.println("");
        System.out.println("**************************************************************************************************************************************************");
        System.out.println("\t Note : 1. Default value \"none\" will be considered for USER_NAME & PASSWORD when it is not specified.");
        System.out.println("\t        2. Default value \"false\" will be considered when live is not specified.");
        System.out.println("***************************************************************************************************************************************************");
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length < 6) {
            HeapDumpGenerator.usage();
            return;
        }
        int i = 0;
        while (i < args.length) {
            block24: {
                String argsString = args[i];
                if (argsString.trim().length() > 0) {
                    if (argsString.equalsIgnoreCase("-host")) {
                        String hostName = args[i + 1];
                        if (hostName != null && hostName.trim().length() > 0) {
                            jmxHost = hostName.trim();
                            break block24;
                        } else {
                            System.out.println("HOST value is invalid !!! " + hostName);
                            return;
                        }
                    }
                    if (argsString.equalsIgnoreCase("-port")) {
                        String portNo = args[i + 1];
                        if (portNo != null && portNo.trim().length() > 0) {
                            try {
                                int jmxport;
                                jmxPort = jmxport = Integer.parseInt(portNo);
                                isValidJMXPort = true;
                            }
                            catch (Exception e) {
                                System.out.println("JMX Port is invalid !!! " + portNo);
                                isValidJMXPort = false;
                                return;
                            }
                        } else {
                            System.out.println("JMX Port is invalid !!! " + portNo);
                            isValidJMXPort = false;
                            return;
                        }
                    }
                    if (argsString.equalsIgnoreCase("-path")) {
                        String pathString = args[i + 1];
                        if (pathString != null && pathString.trim().length() > 0) {
                            folderPath = pathString.trim();
                            break block24;
                        } else {
                            System.out.println("FOLDER PATH is invalid !!! " + pathString);
                            return;
                        }
                    }
                    if (argsString.equalsIgnoreCase("-live")) {
                        String liveString = args[i + 1];
                        live = liveString != null && liveString.equalsIgnoreCase("true");
                    }
                    if (argsString.equalsIgnoreCase("-user")) {
                        String userString = args[i + 1];
                        jmxUserName = userString != null && userString.length() > 0 ? userString : "none";
                    } else if (argsString.equalsIgnoreCase("-pass")) {
                        String passwordString = args[i + 1];
                        jmxPassword = passwordString != null && passwordString.length() > 0 ? passwordString : "none";
                    }
                }
            }
            i += 2;
        }
        if (jmxHost == null) return;
        if (!isValidJMXPort) return;
        if (folderPath == null) {
            return;
        }
        MBeanServerConnection beanServerConn = HeapDumpGenerator.getJMXConnection();
        String fileName = "heapDump_" + jmxPort + "_" + System.currentTimeMillis() + ".hprof";
        if (beanServerConn == null) return;
        Class<?> clazz = null;
        String dumpFile = String.valueOf(folderPath) + "/" + fileName;
        try {
            try {
                clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(beanServerConn, HOTSPOT_BEAN_NAME, clazz);
                Method method = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
                method.setAccessible(true);
                method.invoke(hotspotMBean, dumpFile, new Boolean(live));
                System.out.println("Java Heap dump file (" + dumpFile + ") created successfully !!!");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                clazz = null;
                return;
            }
        }
        finally {
            Object var3_4 = null;
        }
    }

    private static MBeanServerConnection getJMXConnection() {
        MBeanServerConnection mbeanServerConnection = null;
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
        String urlString = "service:jmx:rmi:///jndi/rmi://" + jmxHost + ":" + jmxPort + "/jmxrmi";
        JMXServiceURL jmxService = null;
        JMXConnector jmxConnector = null;
        try {
            jmxService = new JMXServiceURL(urlString);
            if (jmxUserName.equalsIgnoreCase("none") || jmxPassword.equalsIgnoreCase("none")) {
                try {
                    jmxConnector = JMXConnectorFactory.connect(jmxService, environment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String[] credentials = new String[]{jmxUserName, jmxPassword};
                environment.put("jmx.remote.credentials", credentials);
                try {
                    jmxConnector = JMXConnectorFactory.connect(jmxService, environment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (jmxConnector != null) {
                mbeanServerConnection = jmxConnector.getMBeanServerConnection();
                System.out.println("JMX Connection is Success for the URL :" + urlString);
            } else {
                System.out.println("JMX Connection Failed !!!");
            }
        }
        catch (Exception e) {
            System.out.println("JMX Connection Failed , due to " + e.getMessage());
            e.printStackTrace();
        }
        if (mbeanServerConnection != null) {
            return mbeanServerConnection;
        }
        System.out.println("Not able to get MBeanServerConnection for the URL " + urlString);
        return null;
    }
}

