/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class GeoLocalXmlFile {
    private static final String COMPONENT_MAP_SECTION_NAME = "NetworkMappingToComponents";
    private static final String XMLS_MAP_SECTION_NAME = "XMLs";
    private static final Hashtable XMLNAME_IPADDRESSRANGESET_MAP = new Hashtable();
    private static final Hashtable XMLNAME_LASTMODIFIEDTIME_MAP = new Hashtable();
    private static final String GEOLOCATION_DEFAULT_FILENAME = "geolocation-local-map-default.xml";
    private static String EG_INSTALL_DIR = EgInstallInfo.getInstallDir();
    private static String GEOXMLFILES_DIR = EG_INSTALL_DIR + "/agent/config/GeoXmlFiles/";
    private IniFile geoMapXMLINI = new IniFile(EG_INSTALL_DIR + "/agent/config/eg_geomapxml.ini");
    private Set xmlFileNameList = null;

    private GeoLocalXmlFile() {
    }

    public GeoLocalXmlFile(String string) {
        this.xmlFileNameList = this.getGeoMapXMLFiles(string);
        this.loadGeoMapXML(this.xmlFileNameList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getLocation(String string) {
        ArrayList arrayList = null;
        try {
            for (String string2 : this.xmlFileNameList) {
                IPAddressRangeSet iPAddressRangeSet;
                if (string2 == null || (iPAddressRangeSet = (IPAddressRangeSet)XMLNAME_IPADDRESSRANGESET_MAP.get(string2)) == null || (arrayList = iPAddressRangeSet.getGeoLocDetails(string)) == null || this.isDefault(arrayList)) continue;
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("[GeoLocalXmlFile][getLocation] Exception occured while getting GeoDetail for IP :" + string);
            exception.printStackTrace();
        }
        finally {
            try {
                IPAddressRangeSet iPAddressRangeSet;
                if (arrayList == null && (iPAddressRangeSet = (IPAddressRangeSet)XMLNAME_IPADDRESSRANGESET_MAP.get(GEOLOCATION_DEFAULT_FILENAME)) != null) {
                    arrayList = iPAddressRangeSet.getGeoLocDetails(string);
                }
            }
            catch (Exception exception) {
                System.err.println("[GeoLocalXmlFile][getLocation] Exception occured while getting default GeoDetail :" + string);
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    public boolean isDefault(ArrayList arrayList) {
        boolean bl = true;
        if (arrayList != null) {
            int n = arrayList.size();
            bl = IPAddressRangeSet.getValidBoolean(arrayList.get(n - 1) + "", true);
        }
        return bl;
    }

    private Set getGeoMapXMLFiles(String string) {
        HashSet hashSet = new HashSet();
        try {
            String string2;
            if (this.geoMapXMLINI != null && (string2 = this.geoMapXMLINI.getValue(COMPONENT_MAP_SECTION_NAME, string)) != null && string2.length() > 0) {
                String[] stringArray = string2.split(",");
                Collections.addAll(hashSet, stringArray);
            }
        }
        catch (Exception exception) {
            System.err.println("[GeoLocalXmlFile][getGeoMapXMLFiles] Exception occured while getting geoXML key for service :" + string);
            exception.printStackTrace();
        }
        return hashSet;
    }

    private void loadGeoMapXML(Set set) {
        try {
            if (set != null && set.size() > 0) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    try {
                        String string;
                        ArrayList arrayList;
                        String string2 = (String)iterator.next();
                        if (!(string2 != null & string2.length() > 0) || (arrayList = this.getXMLFileNameFromKey(string2)).size() <= 0 || !((string = (String)arrayList.get(0)) != null & string.length() > 0)) continue;
                        long l = (Long)arrayList.get(1);
                        Long l2 = (Long)XMLNAME_LASTMODIFIEDTIME_MAP.get(string2);
                        if (l2 != null && l2 == l) continue;
                        XMLNAME_LASTMODIFIEDTIME_MAP.put(string2, l);
                        IPAddressRangeSet iPAddressRangeSet = new IPAddressRangeSet();
                        iPAddressRangeSet.refresh(GEOXMLFILES_DIR + string);
                        XMLNAME_IPADDRESSRANGESET_MAP.put(string2, iPAddressRangeSet);
                    }
                    catch (Exception exception) {
                        System.err.println("[GeoLocalXmlFile][loadGeoMapXML][while] Exception occured while loading geoXML file.");
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[GeoLocalXmlFile][loadGeoMapXML] Exception occured while loading geoXML file.");
            exception.printStackTrace();
        }
    }

    private ArrayList getXMLFileNameFromKey(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            String[] stringArray;
            String string2;
            if (this.geoMapXMLINI != null && (string2 = this.geoMapXMLINI.getValue(XMLS_MAP_SECTION_NAME, string)) != null && (stringArray = string2.split(",")) != null && stringArray.length >= 2) {
                String string3 = stringArray[0];
                File file = new File(GEOXMLFILES_DIR + string3);
                if (file != null && file.exists()) {
                    arrayList.add(string3);
                    long l = file.lastModified();
                    arrayList.add(l);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[GeoLocalXmlFile][getXMLFileNameFromKey] Exception occured while getting XMLFileName for key : " + string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static void loadDefaultGeoMapXML() {
        try {
            File file = new File(GEOXMLFILES_DIR + GEOLOCATION_DEFAULT_FILENAME);
            if (file != null && file.exists()) {
                long l = file.lastModified();
                Long l2 = (Long)XMLNAME_LASTMODIFIEDTIME_MAP.get(GEOLOCATION_DEFAULT_FILENAME);
                if (l2 != null && l2 == l) {
                    return;
                }
                XMLNAME_LASTMODIFIEDTIME_MAP.put(GEOLOCATION_DEFAULT_FILENAME, l);
                IPAddressRangeSet iPAddressRangeSet = new IPAddressRangeSet();
                iPAddressRangeSet.refresh(GEOXMLFILES_DIR + GEOLOCATION_DEFAULT_FILENAME);
                XMLNAME_IPADDRESSRANGESET_MAP.put(GEOLOCATION_DEFAULT_FILENAME, iPAddressRangeSet);
            }
        }
        catch (Exception exception) {
            System.err.println("[GeoLocalXmlFile][loadDefaultGeoMapXML] Exception occured while loading default geoXML file.");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            GeoLocalXmlFile geoLocalXmlFile = new GeoLocalXmlFile(stringArray[0]);
            System.out.println(geoLocalXmlFile.getLocation(stringArray[1]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        GeoLocalXmlFile.loadDefaultGeoMapXML();
    }
}

