/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class FaEventStatusTest
extends EgSnmpGenericTest {
    private static String eventIndexOid = ".1.3.6.1.4.1.1588.2.1.1.1.8.5.1.1";
    private static String eventLevelOid = ".1.3.6.1.4.1.1588.2.1.1.1.8.5.1.3";
    private static String eventDescOid = ".1.3.6.1.4.1.1588.2.1.1.1.8.5.1.5";
    private static String eventDateTimeOid = ".1.3.6.1.4.1.1588.2.1.1.1.8.5.1.2";
    private static String currDateOid = ".1.3.6.1.4.1.1588.2.1.1.1.1.1.0";
    ArrayList critical_eventDD = new ArrayList();
    ArrayList error_eventDD = new ArrayList();
    ArrayList warn_eventDD = new ArrayList();
    ArrayList info_eventDD = new ArrayList();
    ArrayList debug_eventDD = new ArrayList();
    String rptName = "xx";
    boolean start = false;
    public static Hashtable ht_lastTime = new Hashtable();

    public FaEventStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
    }

    public void freeTest() {
        this.critical_eventDD = new ArrayList();
        this.error_eventDD = new ArrayList();
        this.warn_eventDD = new ArrayList();
        this.info_eventDD = new ArrayList();
        this.debug_eventDD = new ArrayList();
    }

    public void computeMeasures(Hashtable hashtable) {
        this.freeTest();
        this.rptName = this.reportingName;
        long l = 0L;
        long l2 = 0L;
        boolean bl = this.runSnmpCmdForOid(currDateOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        String string = this.rhs[0].trim();
        if (string != null && string.length() > 5) {
            l2 = this.getCurrentTime(string);
        }
        if (l2 < 0L) {
            return;
        }
        System.out.println("[FaEventStatusTest] ===> System(SAN Switch) current time ==>" + string);
        System.out.println("[FaEventStatusTest] ===> System(SAN Switch) current time in millisecs ==>" + l2);
        try {
            Long l3 = (Long)ht_lastTime.get(this.rptName);
            if (l3 != null) {
                l = l3;
                this.start = true;
            } else {
                this.start = false;
            }
        }
        catch (Exception exception) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        if (this.start) {
            boolean bl2 = this.runSnmpCmdForOid(eventIndexOid);
            if (!bl2 || this.lhs == null || this.lhs.length == 0) {
                return;
            }
            for (int i = 0; i < this.lhs.length; ++i) {
                hashtable2.put(this.lhs[i], this.rhs[i]);
            }
            hashtable3 = this.getFromSnmp(eventLevelOid);
            hashtable5 = this.getDateTimeFromSnmp(eventDateTimeOid);
            hashtable4 = this.getDDInfoFromSnmp(eventDescOid);
            System.out.println("Event Status Hash : " + hashtable3);
            System.out.println("Event time hash : " + hashtable5);
            System.out.println("Event Desc hash : " + hashtable4);
            long l4 = 0L;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable5.get(string2);
                if (string3 != null && string3.length() > 5) {
                    l4 = this.getEventTime(string3);
                }
                if (l4 < l || l4 > l2) continue;
                System.out.println("FaEventStatusTest ==> Event Occurence Time : " + l4);
                System.out.println("FaEventStatusTest ==> Previous Time : " + l);
                System.out.println("FaEventStatusTest ==> Current Time : " + l2);
                Double d = (Double)hashtable3.get(string2);
                String string4 = (String)hashtable4.get(string2);
                String string5 = d.toString();
                if (string5.equals("1.0")) {
                    ++n;
                    this.critical_eventDD.add(string2);
                    this.critical_eventDD.add(string4);
                    this.critical_eventDD.add(string3);
                    continue;
                }
                if (string5.equals("2.0")) {
                    ++n2;
                    this.error_eventDD.add(string2);
                    this.error_eventDD.add(string4);
                    this.error_eventDD.add(string3);
                    continue;
                }
                if (string5.equals("3.0")) {
                    ++n3;
                    this.warn_eventDD.add(string2);
                    this.warn_eventDD.add(string4);
                    this.warn_eventDD.add(string3);
                    continue;
                }
                if (string5.equals("4.0")) {
                    ++n4;
                    this.info_eventDD.add(string2);
                    this.info_eventDD.add(string4);
                    this.info_eventDD.add(string3);
                    continue;
                }
                if (!string5.equals("5.0")) continue;
                ++n5;
                this.debug_eventDD.add(string2);
                this.debug_eventDD.add(string4);
                this.debug_eventDD.add(string3);
            }
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(n));
        arrayList.add(new Double(n2));
        arrayList.add(new Double(n3));
        arrayList.add(new Double(n4));
        arrayList.add(new Double(n5));
        System.out.println("No of Critical Events : " + n);
        System.out.println("No of Error Events : " + n2);
        System.out.println("No of Warning Events : " + n3);
        System.out.println("No of Information Events : " + n4);
        System.out.println("No of Debug Events : " + n5);
        System.out.println("Critical DD Contents :" + this.critical_eventDD);
        System.out.println("Error DD Contents :" + this.error_eventDD);
        System.out.println("Warning DD Contents :" + this.warn_eventDD);
        System.out.println("Info DD Contents :" + this.info_eventDD);
        System.out.println("Debug DD Contents :" + this.debug_eventDD);
        System.out.println("Measures  : " + arrayList);
        this.addNewMeasure(arrayList);
        ht_lastTime.put(this.rptName, new Long(l2));
    }

    private long getEventTime(String string) {
        try {
            string = this.replace(string, "-", " ");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date(string);
            String string2 = simpleDateFormat.format(date);
            Date date2 = simpleDateFormat.parse(string2);
            long l = date2.getTime();
            return l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -5L;
        }
    }

    private long getCurrentTime(String string) {
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
            Date date = new Date(string);
            String string2 = simpleDateFormat.format(date);
            Date date2 = simpleDateFormat.parse(string2);
            long l = date2.getTime();
            return l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -5L;
        }
    }

    private Hashtable getFromSnmp(String string) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        boolean bl = this.runSnmpCmdForOid(string);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            try {
                double d = Double.parseDouble(this.rhs[i]);
                hashtable.put(this.lhs[i], new Double(d));
                continue;
            }
            catch (Exception exception) {
                hashtable.put(this.lhs[i], new Double(-5.0));
            }
        }
        return hashtable;
    }

    private Hashtable getDateTimeFromSnmp(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.runSnmpCmdForOid(string);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            try {
                hashtable.put(this.lhs[i], this.rhs[i]);
                continue;
            }
            catch (Exception exception) {
                hashtable.put(this.lhs[i], "0");
            }
        }
        return hashtable;
    }

    private Hashtable getDDInfoFromSnmp(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.runSnmpCmdForOid(string);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            try {
                hashtable.put(this.lhs[i], this.rhs[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        FaEventStatusTest faEventStatusTest = new FaEventStatusTest(stringArray);
        faEventStatusTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(2000L);
            faEventStatusTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

