/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class F5StatusTest
extends EgSnmpGenericTest {
    private static String oid = ".1.3.6.1.4.1.3375.1.1.1.2";
    private static int numMeasures = 11;
    boolean isFirst = true;
    private double oldBitsIn = -5.0;
    private double oldBitsOut = -5.0;
    private double oldPktsIn = -5.0;
    private double oldPktsOut = -5.0;
    private double oldConns = -5.0;
    private double oldTimeouts = -5.0;
    private double oldMemErrors = -5.0;
    private static double bToMb = 1048576.0;

    public F5StatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        double d10 = -5.0;
        double d11 = -5.0;
        boolean bl = this.runSnmpCmdForOid(oid);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            if (this.isFirst) {
                this.logToErrorFile("Error :", "[F5StatusTest] The specified targetHost is not F5 BIG-IP.so please manage as F5 BIG-IP Traffic Manager for this targetHost:", this.targetHost);
                this.isFirst = false;
            }
            return;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            double d12;
            if (this.lhs[i].startsWith("2.")) {
                d12 = this.getValue(i);
                if (this.oldBitsIn >= 0.0 && d12 >= 0.0) {
                    d = d12 - this.oldBitsIn;
                    d /= bToMb;
                    d = this.timeSinceLastTest > 0.0 ? (d /= this.timeSinceLastTest) : -5.0;
                }
                this.oldBitsIn = d12;
                continue;
            }
            if (this.lhs[i].startsWith("4.")) {
                d12 = this.getValue(i);
                if (this.oldBitsOut >= 0.0 && d12 >= 0.0) {
                    d2 = d12 - this.oldBitsOut;
                    d2 /= bToMb;
                    d2 = this.timeSinceLastTest > 0.0 ? (d2 /= this.timeSinceLastTest) : -5.0;
                }
                this.oldBitsOut = d12;
                continue;
            }
            if (this.lhs[i].startsWith("6.")) {
                d12 = this.getValue(i);
                if (this.oldPktsIn >= 0.0 && d12 >= 0.0) {
                    d3 = d12 - this.oldPktsIn;
                    d3 = this.timeSinceLastTest > 0.0 ? (d3 /= this.timeSinceLastTest) : -5.0;
                }
                this.oldPktsIn = d12;
                continue;
            }
            if (this.lhs[i].startsWith("8.")) {
                d12 = this.getValue(i);
                if (this.oldPktsOut >= 0.0 && d12 >= 0.0) {
                    d4 = d12 - this.oldPktsOut;
                    d4 = this.timeSinceLastTest > 0.0 ? (d4 /= this.timeSinceLastTest) : -5.0;
                }
                this.oldPktsOut = d12;
                continue;
            }
            if (this.lhs[i].startsWith("10.")) {
                d5 = this.getValue(i);
                continue;
            }
            if (this.lhs[i].startsWith("12.")) {
                d12 = this.getValue(i);
                if (this.oldConns >= 0.0 && d12 >= 0.0) {
                    d6 = d12 - this.oldConns;
                    d6 = this.timeSinceLastTest > 0.0 ? (d6 /= this.timeSinceLastTest) : -5.0;
                }
                this.oldConns = d12;
                continue;
            }
            if (this.lhs[i].startsWith("13.")) {
                d12 = this.getValue(i);
                if (this.oldTimeouts >= 0.0 && d12 >= 0.0) {
                    d7 = d12 - this.oldTimeouts;
                }
                this.oldTimeouts = d12;
                continue;
            }
            if (this.lhs[i].startsWith("14.")) {
                d9 = this.getValue(i);
                continue;
            }
            if (this.lhs[i].startsWith("15.")) {
                d8 = this.getValue(i);
                continue;
            }
            if (!this.lhs[i].startsWith("42.")) continue;
            d12 = this.getValue(i);
            if (this.oldMemErrors >= 0.0 && d12 >= 0.0) {
                d11 = d12 - this.oldMemErrors;
            }
            this.oldMemErrors = d12;
        }
        if (d9 > 0.0 && d8 >= 0.0) {
            d10 = d8 * 100.0 / d9;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d4));
        arrayList.add(new Double(d5));
        arrayList.add(new Double(d6));
        arrayList.add(new Double(d7));
        arrayList.add(new Double(d9));
        arrayList.add(new Double(d8));
        arrayList.add(new Double(d10));
        arrayList.add(new Double(d11));
        this.addNewMeasure(arrayList);
    }
}

