/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import com.eg.EgTesterInfo;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public abstract class EgTomcatBase
extends EgJMXBase {
    protected boolean viaJmx;
    private String ssl;
    private boolean isSsl;
    private String encryptPass;
    private String tomcatUser;
    private String tomcatPassword;
    private String url;
    private HttpURLConnection u;
    private URL up;
    private String urlString;
    private ConnectionThread ct;
    protected int version;
    String domain = null;
    String nodeName = null;
    private static final HashMap configuredDomains = new HashMap();
    private static final Hashtable nodeNameDomainMapping = new Hashtable();
    private static final HashMap entityMap = new HashMap();
    private Hashtable prevMeasure = new Hashtable();
    private static boolean ShowNewServletDescriptor = false;
    private int expctdTmctStrtTmInMS = 900000;

    static {
        EgTesterInfo testerInfo = new EgTesterInfo("agent");
        String domainNamesString = testerInfo.getJmxDomainName();
        if (domainNamesString != null && domainNamesString.length() > 0) {
            StringTokenizer myTokenizer = new StringTokenizer(domainNamesString, ",");
            while (myTokenizer.hasMoreTokens()) {
                String domainName = myTokenizer.nextToken();
                configuredDomains.put(domainName, domainName);
            }
        } else {
            System.out.println("[EgTomcatBase] - Not able to find the list of configured domain names, assigning default value");
            configuredDomains.put("Catalina", "Catalina");
        }
        String newDescriptorString = testerInfo.getValueFor("DD_ROWS", "ShowNewTomcatServletDescriptor");
        if (newDescriptorString != null && newDescriptorString.length() > 0 && (newDescriptorString.equalsIgnoreCase("yes") || newDescriptorString.equalsIgnoreCase("true"))) {
            ShowNewServletDescriptor = true;
        }
        entityMap.put("TomcatCacheTest", "egtomcat/CacheCatalina.jsp");
        entityMap.put("TomcatThreadTest", "egtomcat/ThreadpoolCatalina.jsp?extraMeasures=true");
        entityMap.put("TomcatAppTest", "egtomcat/CatalinaManager.jsp?extraMeasures=true");
        entityMap.put("TomcatConnectorTest", "egtomcat/CatalinaGlobalReqProcessor.jsp");
        entityMap.put("TomcatJspTest", "egtomcat/CatalinaJspMonitor.jsp?extraMeasures=true");
        entityMap.put("TomcatServletTest", "egtomcat/J2eeType.jsp?extraMeasures=true&newServletDescriptor=" + ShowNewServletDescriptor);
        entityMap.put("JVMDetailsTest", "egtomcat/JVMDetails.jsp");
        entityMap.put("JVMGarbageTest", "egtomcat/GarbageCollector.jsp");
        entityMap.put("JVMMemoryTest", "egtomcat/MemoryPool.jsp");
        entityMap.put("UtilityExecutorTest", "egtomcat/CatalinaUtilityExecutor.jsp");
        entityMap.put("TomcatExecutorTest", "egtomcat/CatalinaExecutor.jsp");
        entityMap.put("TomcatDataSrcTest", "egtomcat/CatalinaDataSource.jsp");
        entityMap.put("TomcatConnector_cf", "egtomcat/ConnectorConfigDetails.jsp");
        entityMap.put("TomcatEngine_cf", "egtomcat/EngineConfigDetails.jsp");
        entityMap.put("TomcatHost_cf", "egtomcat/HostConfigDetails.jsp");
        entityMap.put("TomcatRoles_cf", "egtomcat/UserRolesConfigDetails.jsp");
        entityMap.put("TomcatResource_cf", "egtomcat/ResourceConfigDetails.jsp");
        entityMap.put("TomcatValve_cf", "egtomcat/ValveConfigDetails.jsp");
        entityMap.put("TomcatService_cf", "egtomcat/ServiceConfigDetails.jsp");
        entityMap.put("TomcatUsers_cf", "egtomcat/UserConfigDetails.jsp");
        entityMap.put("TomcatRealm_cf", "egtomcat/RealmConfigDetails.jsp");
        entityMap.put("TomcatEnvironment_cf", "egtomcat/EnvironmentConfigDetails.jsp");
        entityMap.put("TomcatCluster_cf", "egtomcat/TomcatClusterDetails.jsp");
        entityMap.put("TomcatContext_cf", "egtomcat/TomcatContextDetails.jsp");
        entityMap.put("TomcatGroups_cf", "egtomcat/GroupsConfigDetails.jsp");
        entityMap.put("TomcatNameResources_cf", "egtomcat/NameResourceParameterDetails.jsp");
        entityMap.put("TomcatResources_cf", "egtomcat/ContextParameterDetails.jsp");
    }

    public EgTomcatBase(String[] arg) {
        super(arg);
        this.nodeName = String.valueOf(this.reportingName) + ":" + this.portNo;
        String measurementMode = this.getValueForParam("measurement_mode");
        if (measurementMode != null && (measurementMode.equalsIgnoreCase("no") || measurementMode.equalsIgnoreCase("false"))) {
            this.viaJmx = true;
        }
        if (!this.viaJmx) {
            this.ssl = this.getValueForParam("ssl");
            this.tomcatUser = this.getValueForParam("username");
            this.tomcatPassword = this.getValueForParam("password");
            this.url = this.getValueForParam("url");
            this.encryptPass = this.getValueForParam("encryptPass");
            if (this.tomcatUser == null || this.tomcatUser.equalsIgnoreCase("none")) {
                this.tomcatUser = "";
            }
            if (this.tomcatPassword == null || this.tomcatPassword.equalsIgnoreCase("none")) {
                this.tomcatPassword = "";
            }
            if (this.ssl != null && (this.ssl.equalsIgnoreCase("true") || this.ssl.equalsIgnoreCase("yes"))) {
                this.isSsl = true;
            }
            if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
                this.tomcatPassword = EgCrypt.encrypt(this.tomcatPassword, true);
            }
            this.tomcatUser = URLEncoder.encode(this.tomcatUser);
            if (this.url != null && this.url.length() > 0 && !this.url.equalsIgnoreCase("none") && this.url.indexOf("://") > -1) {
                this.urlString = this.url;
                if (this.isContainerApp && this.strContainerId != null && this.strContainerId.length() > 0) {
                    String temstrContainerId = this.strContainerId.toLowerCase();
                    if (this.urlString != null && this.urlString.toLowerCase().indexOf(temstrContainerId) > 0) {
                        this.urlString = EgTomcatBase.findAndReplaceInfoString(this.urlString, this.strContainerId, this.targetHost);
                    }
                }
            } else {
                this.urlString = this.isSsl ? "https://" + this.targetHost : "http://" + this.targetHost;
                if (this.portNo != null && !this.portNo.equalsIgnoreCase("null")) {
                    this.urlString = String.valueOf(this.urlString) + ":" + this.portNo;
                }
            }
            if (this.isSsl) {
                this.enableSsl();
            }
            if (entityMap.containsKey(this.entity)) {
                String uri2 = (String)entityMap.get(this.entity);
                this.urlString = String.valueOf(this.urlString) + "/" + uri2;
            }
        } else if (this.domain == null && nodeNameDomainMapping.containsKey(this.nodeName)) {
            this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
        }
    }

    private void findDomainName() {
        block4: {
            String[] defaultDomains = null;
            try {
                if (!this.connect()) break block4;
                defaultDomains = this.beanServerConnection.getDomains();
                boolean found = false;
                if (defaultDomains == null || defaultDomains.length < 0) break block4;
                int i = 0;
                while (i < defaultDomains.length) {
                    String dName = defaultDomains[i];
                    if (configuredDomains.containsKey(dName)) {
                        found = true;
                        this.domain = dName;
                        nodeNameDomainMapping.put(this.nodeName, dName);
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    protected ArrayList getDataFromUrlConnection() {
        ArrayList data = null;
        try {
            try {
                this.up = new URL(this.urlString);
                this.u = (HttpURLConnection)this.up.openConnection();
                if (this.tomcatUser.length() > 0) {
                    String userPassword = String.valueOf(this.tomcatUser) + ":" + EgCrypt.decrypt(this.tomcatPassword);
                    String encoding = Base64Coder.encodeString(userPassword);
                    this.u.setRequestProperty("Authorization", "Basic " + encoding);
                }
                this.u.connect();
                this.ct = new ConnectionThread(this.u, false);
                int code = 0;
                boolean flag = this.checkForTimeout(this.ct);
                if (flag) {
                    code = this.ct.code;
                    if (code != 200) {
                        System.err.println("Error in Tomcat server ..." + code);
                    }
                    data = this.ct.data;
                }
            }
            catch (Exception ee) {
                data = null;
                System.err.println("Exception in EgTomcatBase of getDataFromUrlConnection ..." + ee.getMessage());
                ee.printStackTrace();
                this.ct = null;
                this.u.disconnect();
            }
        }
        finally {
            this.ct = null;
            this.u.disconnect();
        }
        return data;
    }

    protected Hashtable getResults(String paramString) {
        Hashtable resultTable;
        block35: {
            if (this.domain == null) {
                if (nodeNameDomainMapping.containsKey(this.nodeName)) {
                    this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
                } else {
                    this.findDomainName();
                }
            }
            if (this.domain == null) {
                System.out.println("[EgTomcatBase] - Unable to find the MBean domain for the Node :" + this.nodeName + "  & Entity :" + this.entity);
                return null;
            }
            resultTable = new Hashtable();
            try {
                try {
                    block36: {
                        if (!this.connect()) break block36;
                        ObjectName tomObj = new ObjectName(String.valueOf(this.domain) + paramString);
                        Set<ObjectInstance> localSet = this.beanServerConnection.queryMBeans(tomObj, null);
                        for (ObjectInstance io : localSet) {
                            ObjectName objName = io.getObjectName();
                            String thisInfo = objName.toString();
                            if (this.entity.equalsIgnoreCase("TomcatConnectorTest") || this.entity.equalsIgnoreCase("TomcatThreadTest")) {
                                thisInfo = thisInfo.substring(thisInfo.lastIndexOf("=") + 1);
                            } else if (this.entity.equalsIgnoreCase("TomcatAppTest")) {
                                if (thisInfo.contains("path=")) {
                                    thisInfo = objName.getKeyProperty("path");
                                } else if (thisInfo.contains("context=")) {
                                    thisInfo = objName.getKeyProperty("context");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatJspTest")) {
                                if (thisInfo.contains("WebModule=")) {
                                    thisInfo = objName.getKeyProperty("WebModule");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatServletTest")) {
                                if (thisInfo.contains("name=") && thisInfo.contains("WebModule=")) {
                                    thisInfo = objName.getKeyProperty("name");
                                    if (ShowNewServletDescriptor) {
                                        String webModule = objName.getKeyProperty("WebModule");
                                        thisInfo = String.valueOf(webModule) + "#" + thisInfo;
                                    }
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatCacheTest")) {
                                thisInfo = thisInfo.contains("type=WebResourceRoot") ? thisInfo.substring(thisInfo.indexOf("/"), thisInfo.lastIndexOf(",")) : thisInfo.substring(thisInfo.lastIndexOf("=") + 1);
                            } else if (this.entity.equalsIgnoreCase("TomcatDataSrcTest")) {
                                Hashtable<String, String> propertyList = objName.getKeyPropertyList();
                                if (propertyList.containsKey("connectionpool")) continue;
                                if (thisInfo.contains("name=")) {
                                    thisInfo = objName.getKeyProperty("name");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatExecutorTest") && thisInfo.contains("name=")) {
                                thisInfo = objName.getKeyProperty("name");
                            }
                            Hashtable<String, Object> innerHt = new Hashtable<String, Object>();
                            MBeanInfo beanInfo = this.beanServerConnection.getMBeanInfo(objName);
                            MBeanAttributeInfo[] beanAttribute = beanInfo.getAttributes();
                            String attributeName = "";
                            Object attributeValue = "";
                            int k = 0;
                            while (k < beanAttribute.length) {
                                block34: {
                                    try {
                                        attributeName = beanAttribute[k].getName();
                                        attributeValue = this.beanServerConnection.getAttribute(objName, attributeName);
                                        if (attributeName.equals("null")) break block34;
                                        if (attributeValue.equals("null")) {
                                        }
                                    }
                                    catch (Exception eg) {}
                                    break block34;
                                    innerHt.put(attributeName, attributeValue);
                                }
                                ++k;
                            }
                            resultTable.put(thisInfo, innerHt);
                        }
                        break block35;
                    }
                    this.domain = null;
                    nodeNameDomainMapping.remove(this.nodeName);
                }
                catch (Exception e) {
                    System.out.println("Exception in TomacatBase server connection ..." + e.getMessage());
                    e.printStackTrace();
                    this.disconnect();
                }
            }
            finally {
                this.disconnect();
            }
        }
        return resultTable;
    }

    protected Hashtable getResultsForConfig(String paramString) {
        this.obtainDomain();
        Hashtable resultTable = this.getResultsForConfig(this.domain, paramString);
        return resultTable;
    }

    protected Hashtable getResultsForConfig(String domain, String paramString) {
        Hashtable resultTable;
        block35: {
            if (domain == null) {
                System.out.println("[EgTomcatBase] - Unable to find the MBean domain for the Node :" + this.nodeName + "  & Entity :" + this.entity);
                return null;
            }
            resultTable = new Hashtable();
            try {
                try {
                    block36: {
                        this.domain = domain;
                        if (!this.connect()) break block36;
                        ObjectName tomObj = new ObjectName(String.valueOf(domain) + paramString);
                        Set<ObjectInstance> localSet = this.beanServerConnection.queryMBeans(tomObj, null);
                        for (ObjectInstance io : localSet) {
                            ObjectName objName = io.getObjectName();
                            String thisInfo = objName.toString();
                            if (this.entity.equalsIgnoreCase("TomcatContext_cf") || this.entity.equalsIgnoreCase("TomcatNameResources_cf") || this.entity.equalsIgnoreCase("TomcatValve_cf") || this.entity.equalsIgnoreCase("TomcatResources_cf")) {
                                if (thisInfo.contains("name=")) {
                                    thisInfo = objName.getKeyProperty("name");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatConnector_cf")) {
                                if (thisInfo.contains("port=")) {
                                    thisInfo = objName.getKeyProperty("port");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatEnvironment_cf")) {
                                if (thisInfo.contains("name=") && thisInfo.contains("resourcetype=")) {
                                    thisInfo = String.valueOf(objName.getKeyProperty("resourcetype")) + (thisInfo.contains("path=") ? " > " + objName.getKeyProperty("path") : "") + (thisInfo.contains("host=") ? " > " + objName.getKeyProperty("host") : "") + " > " + objName.getKeyProperty("name");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatHost_cf")) {
                                if (thisInfo.contains("host=")) {
                                    thisInfo = objName.getKeyProperty("host");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatRoles_cf")) {
                                if (thisInfo.contains("rolename=")) {
                                    thisInfo = objName.getKeyProperty("rolename");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatService_cf")) {
                                if (thisInfo.contains("serviceName=")) {
                                    thisInfo = objName.getKeyProperty("serviceName");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatGroups_cf")) {
                                if (thisInfo.contains("groupname=")) {
                                    thisInfo = objName.getKeyProperty("groupname");
                                }
                            } else if (this.entity.equalsIgnoreCase("TomcatUsers_cf") && thisInfo.contains("username=")) {
                                thisInfo = objName.getKeyProperty("username");
                            }
                            Hashtable<String, Object> innerHt = new Hashtable<String, Object>();
                            MBeanInfo beanInfo = this.beanServerConnection.getMBeanInfo(objName);
                            MBeanAttributeInfo[] beanAttribute = beanInfo.getAttributes();
                            String attributeName = "";
                            Object attributeValue = "";
                            int k = 0;
                            while (k < beanAttribute.length) {
                                block34: {
                                    try {
                                        attributeName = beanAttribute[k].getName();
                                        attributeValue = this.beanServerConnection.getAttribute(objName, attributeName);
                                        if (attributeName == null || attributeValue == null || attributeName.equals("null")) break block34;
                                        if (attributeValue.equals("null")) {
                                        }
                                    }
                                    catch (Exception eg) {}
                                    break block34;
                                    innerHt.put(attributeName, attributeValue);
                                }
                                ++k;
                            }
                            if (!this.isMBeanSrvrUpForLastXtime(this.expctdTmctStrtTmInMS)) {
                                throw new Exception("Latest up time of the Tomcat is less than " + this.expctdTmctStrtTmInMS + " milliseconds. So, skipping this test run to provide stability period after Tomcat start up.");
                            }
                            resultTable.put(thisInfo, innerHt);
                        }
                        break block35;
                    }
                    this.domain = null;
                    nodeNameDomainMapping.remove(this.nodeName);
                }
                catch (Exception e) {
                    this.domain = null;
                    nodeNameDomainMapping.remove(this.nodeName);
                    System.out.println("Exception in TomacatBase server connection ..." + e.getMessage());
                    e.printStackTrace();
                    this.disconnect();
                }
            }
            finally {
                this.disconnect();
            }
        }
        return resultTable;
    }

    private void obtainDomain() {
        if (this.domain == null) {
            if (nodeNameDomainMapping.containsKey(this.nodeName)) {
                this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
            } else {
                this.findDomainName();
            }
        }
    }

    protected Hashtable getJvmTestDetails() {
        Hashtable<String, Double> resultTable;
        block25: {
            resultTable = new Hashtable<String, Double>();
            try {
                try {
                    if (!this.connect()) break block25;
                    ClassLoadingMXBean clMXBean = null;
                    try {
                        clMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
                    }
                    catch (Exception clm) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + clm.getMessage());
                        clm.printStackTrace();
                    }
                    ThreadMXBean tMXBean = null;
                    try {
                        tMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=Threading", ThreadMXBean.class);
                    }
                    catch (Exception tm) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + tm.getMessage());
                        tm.printStackTrace();
                    }
                    RuntimeMXBean rMXBean = null;
                    try {
                        rMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=Runtime", RuntimeMXBean.class);
                    }
                    catch (Exception rm) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + rm.getMessage());
                        rm.printStackTrace();
                    }
                    double LoadedClassCount = -5.0;
                    double TotalLoadedClassCount = -5.0;
                    double UnloadedClassCount = -5.0;
                    double DaemonThreadCount = -5.0;
                    double ThreadCount = -5.0;
                    double DedlockThreads = 0.0;
                    double Uptime = -5.0;
                    try {
                        LoadedClassCount = clMXBean.getLoadedClassCount();
                    }
                    catch (Exception localException5) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException5.getMessage());
                        LoadedClassCount = -5.0;
                    }
                    try {
                        TotalLoadedClassCount = clMXBean.getTotalLoadedClassCount();
                    }
                    catch (Exception localException6) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException6.getMessage());
                        TotalLoadedClassCount = -5.0;
                    }
                    try {
                        UnloadedClassCount = clMXBean.getUnloadedClassCount();
                    }
                    catch (Exception localException7) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException7.getMessage());
                        UnloadedClassCount = -5.0;
                    }
                    try {
                        DaemonThreadCount = tMXBean.getDaemonThreadCount();
                    }
                    catch (Exception localException8) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException8.getMessage());
                        DaemonThreadCount = -5.0;
                    }
                    try {
                        ThreadCount = tMXBean.getThreadCount();
                    }
                    catch (Exception localException9) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException9.getMessage());
                        ThreadCount = -5.0;
                    }
                    try {
                        long[] arrayOfLong = tMXBean.findMonitorDeadlockedThreads();
                        DedlockThreads = arrayOfLong.length;
                    }
                    catch (Exception localException10) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException10.getMessage());
                        DedlockThreads = 0.0;
                    }
                    try {
                        Uptime = rMXBean.getUptime();
                    }
                    catch (Exception localException11) {
                        System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException11.getMessage());
                        Uptime = -5.0;
                    }
                    resultTable.put("LoadedClassCount", new Double(LoadedClassCount));
                    resultTable.put("TotalLoadedClassCount", new Double(TotalLoadedClassCount));
                    resultTable.put("UnloadedClassCount", new Double(UnloadedClassCount));
                    resultTable.put("DaemonThreadCount", new Double(DaemonThreadCount));
                    resultTable.put("ThreadCount", new Double(ThreadCount));
                    resultTable.put("DedlockThreads", new Double(DedlockThreads));
                    resultTable.put("Uptime", new Double(Uptime));
                }
                catch (Exception localException1) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + localException1.getMessage());
                    localException1.printStackTrace();
                    this.disconnect();
                }
            }
            finally {
                this.disconnect();
            }
        }
        return resultTable;
    }

    protected Hashtable getJvmMemoryPoolDetails() {
        Hashtable resultTable;
        block28: {
            resultTable = new Hashtable();
            ArrayList<Long> localArrayList = new ArrayList<Long>();
            try {
                try {
                    if (!this.connect()) break block28;
                    Set<ObjectName> localSet = this.beanServerConnection.queryNames(new ObjectName("java.lang:type=MemoryPool,*"), null);
                    long Mem_pool_memusage_max = -5L;
                    long Mem_pool_memusage_used = -5L;
                    long Mem_pool_memusage_committed = -5L;
                    long Mem_pool_memusage_init = -5L;
                    long Free_memory = -5L;
                    int Pending_obj = -5;
                    long Heap_mem_init = -5L;
                    long Heap_mem_used = -5L;
                    long Heap_mem_committed = -5L;
                    long Nonheap_mem_init = -5L;
                    long Nonheap_mem_used = -5L;
                    long Nonheap_mem_committed = -5L;
                    Iterator<ObjectName> iterator = localSet.iterator();
                    while (iterator.hasNext()) {
                        ObjectName obj;
                        ObjectName objectname = obj = iterator.next();
                        MemoryPoolMXBean mPoolMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, objectname.toString(), MemoryPoolMXBean.class);
                        localArrayList = new ArrayList();
                        if (mPoolMXBean == null) continue;
                        String infoName = mPoolMXBean.getName();
                        MemoryUsage localMemoryUsage = mPoolMXBean.getUsage();
                        try {
                            Mem_pool_memusage_max = localMemoryUsage.getMax();
                        }
                        catch (Exception localException9) {
                            Mem_pool_memusage_max = -5L;
                        }
                        try {
                            Mem_pool_memusage_used = localMemoryUsage.getUsed();
                        }
                        catch (Exception localException10) {
                            Mem_pool_memusage_used = -5L;
                        }
                        try {
                            Mem_pool_memusage_committed = localMemoryUsage.getCommitted();
                        }
                        catch (Exception localException11) {
                            Mem_pool_memusage_committed = -5L;
                        }
                        try {
                            Mem_pool_memusage_init = localMemoryUsage.getInit();
                        }
                        catch (Exception localException12) {
                            Mem_pool_memusage_init = -5L;
                        }
                        Free_memory = Mem_pool_memusage_committed - Mem_pool_memusage_used;
                        localArrayList.add(new Long(Mem_pool_memusage_used));
                        localArrayList.add(new Long(Free_memory));
                        localArrayList.add(new Long(Mem_pool_memusage_init));
                        localArrayList.add(new Long(Pending_obj));
                        resultTable.put(infoName, localArrayList);
                    }
                    MemoryMXBean memorymxbean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=Memory", MemoryMXBean.class);
                    MemoryUsage heapUsage = memorymxbean.getHeapMemoryUsage();
                    MemoryUsage nonHeapUsage = memorymxbean.getNonHeapMemoryUsage();
                    try {
                        Pending_obj = memorymxbean.getObjectPendingFinalizationCount();
                    }
                    catch (Exception localException2) {
                        Pending_obj = -5;
                    }
                    try {
                        Heap_mem_init = heapUsage.getInit();
                    }
                    catch (Exception localException3) {
                        Heap_mem_init = -5L;
                    }
                    try {
                        Heap_mem_used = heapUsage.getUsed();
                    }
                    catch (Exception localException4) {
                        Heap_mem_used = -5L;
                    }
                    try {
                        Heap_mem_committed = heapUsage.getCommitted();
                    }
                    catch (Exception localException5) {
                        Heap_mem_committed = -5L;
                    }
                    Free_memory = Heap_mem_committed - Heap_mem_used;
                    localArrayList = new ArrayList();
                    localArrayList.add(new Long(Heap_mem_used));
                    localArrayList.add(new Long(Free_memory));
                    localArrayList.add(new Long(Heap_mem_init));
                    localArrayList.add(new Long(Pending_obj));
                    resultTable.put("Heap Memory", localArrayList);
                    try {
                        Nonheap_mem_init = nonHeapUsage.getInit();
                    }
                    catch (Exception localException6) {
                        Nonheap_mem_init = -5L;
                    }
                    try {
                        Nonheap_mem_used = nonHeapUsage.getUsed();
                    }
                    catch (Exception localException7) {
                        Nonheap_mem_used = -5L;
                    }
                    try {
                        Nonheap_mem_committed = nonHeapUsage.getCommitted();
                    }
                    catch (Exception localException8) {
                        Nonheap_mem_committed = -5L;
                    }
                    Free_memory = Nonheap_mem_committed - Nonheap_mem_used;
                    localArrayList = new ArrayList();
                    localArrayList.add(new Long(Nonheap_mem_used));
                    localArrayList.add(new Long(Free_memory));
                    localArrayList.add(new Long(Nonheap_mem_init));
                    localArrayList.add(new Long(Pending_obj));
                    resultTable.put("Nonheap Memory", localArrayList);
                }
                catch (Exception localException1) {
                    System.out.println("Exception in EgTomcatBase of getJvmMemoryPoolDetails..." + localException1.getMessage());
                    localException1.printStackTrace();
                    this.disconnect();
                }
            }
            finally {
                this.disconnect();
            }
        }
        return resultTable;
    }

    protected Hashtable getJvmGarbageDetails() {
        Hashtable resultTable;
        block10: {
            resultTable = new Hashtable();
            try {
                try {
                    if (!this.connect()) break block10;
                    Set<ObjectName> localSet = this.beanServerConnection.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null);
                    for (ObjectName localObject2 : localSet) {
                        ObjectName localObjectName = localObject2;
                        GarbageCollectorMXBean localGarbageCollectorMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, localObjectName.toString(), GarbageCollectorMXBean.class);
                        if (localGarbageCollectorMXBean == null) continue;
                        String Garbage_collector_name = "";
                        long Tot_no_of_collection = -5L;
                        long Collection_elapsed_time = -5L;
                        ArrayList<Long> localArrayList = new ArrayList<Long>();
                        Garbage_collector_name = localGarbageCollectorMXBean.getName();
                        try {
                            Tot_no_of_collection = localGarbageCollectorMXBean.getCollectionCount();
                        }
                        catch (Exception localException2) {
                            Tot_no_of_collection = -5L;
                        }
                        try {
                            Collection_elapsed_time = localGarbageCollectorMXBean.getCollectionTime();
                        }
                        catch (Exception localException3) {
                            Collection_elapsed_time = -5L;
                        }
                        localArrayList.add(new Long(Tot_no_of_collection));
                        localArrayList.add(new Long(Collection_elapsed_time));
                        resultTable.put(Garbage_collector_name, localArrayList);
                    }
                }
                catch (Exception localException1) {
                    System.out.println("Exception in EgTomcatBase of getJvmGarbageDetails..." + localException1.getMessage());
                    localException1.printStackTrace();
                    this.disconnect();
                }
            }
            finally {
                this.disconnect();
            }
        }
        return resultTable;
    }

    protected double parsingOfDouble(String s) {
        double d = -5.0;
        try {
            d = Double.parseDouble(s);
        }
        catch (Exception exception) {
            System.out.println("Exception occur in parseDouble");
            exception.printStackTrace();
            d = -5.0;
            return d;
        }
        return d;
    }

    private void enableSsl() {
        EgSSL e = EgSSL.getInstance();
        EgSSL.enableSSL();
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object sock = null;
        try {
            MyX509TrustManager tm = new MyX509TrustManager();
            KeyManager[] km = null;
            TrustManager[] tma = new TrustManager[]{tm};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(km, tma, new SecureRandom());
            SSLSocketFactory sf1 = sc.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sf1);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception ee) {
            System.out.println("Exception in EgTomcatBase of enableSsl ... " + ee.getMessage());
            ee.printStackTrace();
        }
    }

    public String round(double d, int place) {
        if (place <= 0) {
            String s = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return s;
        }
        String s = "";
        if (d < 0.0) {
            s = String.valueOf(s) + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -place)) > 1.0) {
            long i = (long)d;
            s = String.valueOf(s) + i;
            d -= (double)i;
        } else {
            s = String.valueOf(s) + "0";
        }
        if (d > 0.0) {
            String f = "" + (long)((d += 1.0) * Math.pow(10.0, place));
            s = String.valueOf(s) + "." + f.substring(1);
        }
        return s;
    }

    private boolean checkForTimeout(ConnectionThread ct) {
        long nextSleepTime;
        long totalSleepTime = 0L;
        long sleepTime = 250L;
        this.timeout = 2L * EgConfigInfo.msecPerMin;
        do {
            if (sleepTime < EgAgentCommon.minimumSleep) {
                sleepTime = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(sleepTime);
            if (ct.done) {
                return true;
            }
            if ((totalSleepTime += sleepTime) >= this.timeout) {
                ct.interrupt();
                Thread.currentThread();
                Thread.yield();
                ct.stop();
                return false;
            }
            nextSleepTime = sleepTime;
            if (this.timeout - totalSleepTime >= nextSleepTime) continue;
            nextSleepTime = this.timeout - totalSleepTime;
        } while ((sleepTime = nextSleepTime) > 0L);
        ct.interrupt();
        Thread.currentThread();
        Thread.yield();
        ct.stop();
        return false;
    }

    private void suspendForPeriod(long sleepPeriod) {
        long nextMeasureTime = System.currentTimeMillis() + sleepPeriod;
        while (sleepPeriod > 0L) {
            try {
                Thread.sleep(sleepPeriod);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            long currentTime = System.currentTimeMillis();
            sleepPeriod = nextMeasureTime - currentTime;
        }
    }

    public int getTomcatVersion(String objName, String attribute) {
        int tomcatVersion;
        block12: {
            tomcatVersion = -1;
            String serverInfo = "";
            if (this.domain == null) {
                if (nodeNameDomainMapping.containsKey(this.nodeName)) {
                    this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
                } else {
                    this.findDomainName();
                }
            }
            if (this.domain == null) {
                System.out.println("[EgTomcatBase] - Unable to find the MBean domain for the Node :" + this.nodeName + "  & Entity :" + this.entity);
                return tomcatVersion;
            }
            try {
                try {
                    if (this.connect()) {
                        ObjectName objectname = new ObjectName(String.valueOf(this.domain) + objName);
                        if (this.beanServerConnection != null) {
                            serverInfo = (String)this.beanServerConnection.getAttribute(objectname, attribute);
                        }
                        if (serverInfo != null && serverInfo.length() > 0) {
                            serverInfo = serverInfo.substring(serverInfo.indexOf("/") + 1, serverInfo.indexOf("."));
                            tomcatVersion = Integer.parseInt(serverInfo);
                        }
                        break block12;
                    }
                    this.domain = null;
                    nodeNameDomainMapping.remove(this.nodeName);
                }
                catch (Exception e) {
                    tomcatVersion = 6;
                    this.disconnect();
                }
            }
            finally {
                this.disconnect();
            }
        }
        return tomcatVersion;
    }

    protected double getCurrentMinusPrevious(String keyString, double current_value) {
        double result_value = current_value;
        if (this.prevMeasure != null && this.prevMeasure.containsKey(keyString)) {
            Double prevCount = (Double)this.prevMeasure.get(keyString);
            if (prevCount != null) {
                double pre_count = Double.parseDouble(prevCount.toString());
                if (pre_count >= 0.0) {
                    result_value = current_value >= pre_count ? current_value - pre_count : current_value;
                }
                this.prevMeasure.put(keyString, new Double(current_value));
            }
        } else {
            this.prevMeasure.put(keyString, new Double(current_value));
        }
        return result_value;
    }

    private boolean isMBeanSrvrUpForLastXtime(int xTimeInMillis) {
        boolean status = false;
        long upTime = -1L;
        Object object = null;
        try {
            ObjectName objectname = new ObjectName("java.lang:type=Runtime");
            if (this.beanServerConnection != null) {
                object = this.beanServerConnection.getAttribute(objectname, "Uptime");
                if (object != null) {
                    upTime = new Long(object.toString());
                }
                if (upTime != -1L && upTime >= (long)xTimeInMillis) {
                    status = true;
                }
            }
        }
        catch (Exception e) {
            status = false;
        }
        return status;
    }
}

