/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class ESSearchTest
extends ElasticSearchBase {
    Hashtable searchRateTable = new Hashtable();
    Hashtable queryLaterncyTable = new Hashtable();
    Hashtable fieldDataEvitionTable = new Hashtable();
    Hashtable queryEvitionTable = new Hashtable();
    boolean firstTime = false;

    public ESSearchTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        try {
            logger.info(this.logPrefix + " Initializing ElasticSearchSearchTest ...");
            this.setMeasureCount(this.measureCount);
            logger.info(this.logPrefix + " ElasticSearchSearchTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing ElasticSearchSearchTest", (Throwable)exception);
        }
        this.firstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block32: {
            try {
                logger.debug(this.logPrefix + " ElasticSearchIndexingTest - Test cycle START ");
                String string = this.getElasticSearchRestURLForTest(this.entity);
                logger.debug(this.logPrefix + " [computeMeasures] the URL is :" + string);
                String string2 = this.getElasticsearchJSONData(string);
                logger.debug(this.logPrefix + " [computeMeasures] the jsonData is :" + string2);
                Configuration configuration = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
                ArrayList arrayList = null;
                if (string2 != null && string2.length() > 4) {
                    try {
                        arrayList = (ArrayList)JsonPath.using((Configuration)configuration).parse(string2).read("$['indices'].* ", new Predicate[0]);
                        arrayList.add("$['_all']");
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        logger.debug(this.logPrefix + " [computeMeasures] No indices found");
                        logger.debug(this.logPrefix + " ElasticSearchSearchTest - Test cycle END ");
                        return;
                    }
                    catch (Exception exception) {
                        logger.warn(this.logPrefix + " [computeMeasures] Unable to get JSON paths from JSON Data" + exception.getMessage() + exception.getCause());
                        logger.debug(this.logPrefix + " ElasticSearchSearchTest - Test cycle END ");
                        return;
                    }
                } else {
                    logger.warn(this.logPrefix + " [computeMeasures] JSON data is NULL or Empty.  jsonData : " + string2);
                    return;
                }
                Hashtable hashtable2 = this.jsonBuilder(string2, this.entity.toUpperCase() + "_JSONPATH", arrayList);
                Hashtable hashtable3 = this.getElasticSearchIndexMappingTable(this.entity.toUpperCase() + "_INDEX");
                Hashtable hashtable4 = this.getESSearchDiscriptors(string2, hashtable2);
                if (hashtable4 == null) {
                    return;
                }
                Iterator iterator = (Iterator)((Object)hashtable2.keys());
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    ArrayList arrayList2 = this.getESSearchFinalMeasures(string3, hashtable4, hashtable3);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        double d9;
                        String string4 = arrayList2.get(i).toString();
                        double d10 = Double.parseDouble(string4);
                        if (i == 0) {
                            d = d10;
                            if (this.firstTime) {
                                this.queryLaterncyTable.put(string3, d10);
                                logger.debug(this.logPrefix + "The first queryTime value is : " + d10);
                                d = d10;
                                arrayList2.set(i, new Double(d));
                            } else if (this.queryLaterncyTable.get(string3) != null && (Double)this.queryLaterncyTable.get(string3) <= d10) {
                                d9 = (Double)this.queryLaterncyTable.get(string3);
                                d = d10 - d9;
                                logger.debug(this.logPrefix + "The current queryTime value is : " + d10);
                                logger.debug(this.logPrefix + "The previous queryTime value is : " + d9);
                                logger.debug(this.logPrefix + "The queryTime difference value is : " + d);
                                this.queryLaterncyTable.put(string3, d10);
                            } else {
                                this.queryLaterncyTable.put(string3, d10);
                                d = d10;
                                logger.debug(this.logPrefix + "The current queryTime value is : " + d10);
                            }
                        }
                        if (i == 1) {
                            d2 = d10;
                            if (this.firstTime) {
                                this.searchRateTable.put(string3, d10);
                                logger.debug(this.logPrefix + "The first search rate value is : " + d10);
                                d2 = d10;
                                d3 = d10 / (double)this.measurePeriod * 1000.0;
                                logger.debug(this.logPrefix + "The index rate value per Measure Period is : \n(" + string4 + "/" + this.measurePeriod + ")*1000 = " + d3);
                                arrayList2.set(i, new Double(new DecimalFormat("##.##").format(d3)));
                                continue;
                            }
                            if (this.searchRateTable.get(string3) != null && (Double)this.searchRateTable.get(string3) <= d10) {
                                d9 = (Double)this.searchRateTable.get(string3);
                                d2 = d10 - d9;
                                logger.debug(this.logPrefix + "The current search rate value is : " + d10);
                                logger.debug(this.logPrefix + "The previous search rate value is : " + d9);
                                logger.debug(this.logPrefix + "The search rate difference value is : " + d2);
                                d3 = d2 / (double)this.measurePeriod * 1000.0;
                                logger.debug(this.logPrefix + "The index rate value per Measure Period is : \n(" + string4 + "/" + this.measurePeriod + ")*1000 = " + d3);
                                arrayList2.set(i, new Double(new DecimalFormat("##.##").format(d3)));
                                this.searchRateTable.put(string3, d10);
                                continue;
                            }
                            this.searchRateTable.put(string3, d10);
                            d2 = d10;
                            d3 = d10 / (double)this.measurePeriod * 1000.0;
                            logger.debug(this.logPrefix + "The current search rate value is : " + d10);
                            logger.debug(this.logPrefix + "The index rate value per Measure Period is : \n(" + string4 + "/" + this.measurePeriod + ")*1000 = " + d3);
                            arrayList2.set(i, new Double(new DecimalFormat("##.##").format(d3)));
                            continue;
                        }
                        if (i == 3 || i == 5) {
                            d10 = Double.parseDouble(EgUtils.convertMemoryValues(string4, "B", "MB"));
                            arrayList2.set(i, new Double(d10));
                            continue;
                        }
                        if (i == 2) {
                            if (this.firstTime) {
                                this.queryEvitionTable.put(string3, d10);
                                logger.debug(this.logPrefix + "The first query eviction value is : " + d10);
                                d4 = d10;
                                arrayList2.set(i, new Double(d4));
                                continue;
                            }
                            if (this.queryEvitionTable.get(string3) != null && (Double)this.queryEvitionTable.get(string3) <= d10) {
                                d9 = (Double)this.queryEvitionTable.get(string3);
                                d4 = d10 - d9;
                                logger.debug(this.logPrefix + "The current query Evition value is : " + d10);
                                logger.debug(this.logPrefix + "The previous query Evition value is : " + d9);
                                logger.debug(this.logPrefix + "The query Evition difference value is : " + d4);
                                arrayList2.set(i, new Double(d4));
                                this.queryEvitionTable.put(string3, d10);
                                continue;
                            }
                            this.queryEvitionTable.put(string3, d10);
                            d4 = d10;
                            logger.debug(this.logPrefix + "The current query Evition value is : " + d10);
                            arrayList2.set(i, new Double(d4));
                            continue;
                        }
                        if (i != 4) continue;
                        if (this.firstTime) {
                            this.fieldDataEvitionTable.put(string3, d10);
                            logger.debug(this.logPrefix + "The first field evition value is : " + d10);
                            d5 = d10;
                            arrayList2.set(i, new Double(d5));
                            continue;
                        }
                        if (this.fieldDataEvitionTable.get(string3) != null && (Double)this.fieldDataEvitionTable.get(string3) <= d10) {
                            d9 = (Double)this.fieldDataEvitionTable.get(string3);
                            d5 = d10 - d9;
                            logger.debug(this.logPrefix + "The current field evition value is : " + d10);
                            logger.debug(this.logPrefix + "The previous field evition value is : " + d9);
                            logger.debug(this.logPrefix + "The field evition difference value is : " + d5);
                            arrayList2.set(i, new Double(d5));
                            this.fieldDataEvitionTable.put(string3, d10);
                            continue;
                        }
                        this.fieldDataEvitionTable.put(string3, d10);
                        d5 = d10;
                        logger.debug(this.logPrefix + "The current field evition value is : " + d10);
                        arrayList2.set(i, new Double(d5));
                    }
                    double d11 = 0.0;
                    if (d2 > 0.0) {
                        logger.debug(this.logPrefix + "The current query Time value is : " + d);
                        logger.debug(this.logPrefix + "The current search rate value is : " + d2);
                        d11 = d / d2;
                        logger.debug(this.logPrefix + "The latency value is : " + d11);
                        d6 = d11 + d6;
                    }
                    arrayList2.set(0, new Double(new DecimalFormat("##.##").format(d11)));
                    logger.info(this.logPrefix + "  [computeMeasures]  " + string3 + " - measure contains \n" + arrayList2);
                    this.addNewMeasure(string3, arrayList2);
                }
                this.firstTime = false;
                break block32;
                {
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                logger.debug(this.logPrefix + " ElasticSearchSearchTest - Test cycle END ");
            }
        }
    }

    public Hashtable getESSearchDiscriptors(String string, Hashtable hashtable) {
        if (string == null) {
            return null;
        }
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        Hashtable hashtable2 = new Hashtable();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Hashtable hashtable3 = (Hashtable)hashtable.get(string2);
            Iterator iterator2 = (Iterator)((Object)hashtable3.keys());
            Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                Object v = hashtable3.get(string3);
                try {
                    Object object = JsonPath.read((String)string, (String)v.toString(), (Predicate[])new Predicate[0]);
                    if (object == null) continue;
                    hashtable4.put(string3, object);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    logger.warn(this.logPrefix + " [getValueForKeyFromJSON_NonInfoBased] Path {} not found in JsonData {}", (Object)v.toString(), (Object)string);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getESSearchDiscriptors] Exception Occurred while geting Discriptors", (Throwable)exception);
                }
            }
            hashtable2.put(string2, hashtable4);
        }
        logger.debug(this.logPrefix + "  [getESSearchDiscriptors] finalTable contains \n" + hashtable2);
        return hashtable2;
    }

    public ArrayList getESSearchFinalMeasures(String string, Hashtable hashtable, Hashtable hashtable2) {
        ArrayList arrayList = this.finalMeasures(this.measureCount);
        Hashtable hashtable3 = (Hashtable)hashtable.get(string);
        Iterator iterator = (Iterator)((Object)hashtable3.keys());
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = hashtable3.get(string2).toString();
            if (!hashtable2.containsKey(string2)) continue;
            int n = Integer.parseInt(hashtable2.get(string2).toString());
            arrayList.set(n, new Double(string3));
        }
        logger.debug(this.logPrefix + "  [getESSearchFinalMeasures]  " + string + " - measure contains \n" + arrayList);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        ESSearchTest eSSearchTest = new ESSearchTest(stringArray);
        eSSearchTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

