/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class DbOmsStatsTest
extends DbBaseTest {
    private static String heapUsage = "TOTAL_HEAP_USAGE";
    private static String reserved = "RESERVED";
    private static String allocs = "ALLOC_CNT";
    private static String freeCount = "FREE_CNT";
    private static String spinLocks = "TOTAL_SPINLOCKS";
    private static String collisions = "COLLISIONS";
    private static String spinLoops = "TOTAL_SPINLOOPS";
    private static String yieldLoops = "TOTAL_YIELDLOOPS";
    private static String errors = "ERROR_CNT";
    private static String omsDesc = "DESCRIPTION";
    private static double byteToMb = 1048576.0;
    Hashtable htAllocs = new Hashtable();
    Hashtable htFrees = new Hashtable();
    Hashtable htSpinLocks = new Hashtable();
    Hashtable htCollisions = new Hashtable();
    Hashtable htSpinLoops = new Hashtable();
    Hashtable htYieldLoops = new Hashtable();
    Hashtable htErrors = new Hashtable();

    public DbOmsStatsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(9);
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.getOutput("select description, total_heap_usage, reserved, alloc_cnt, free_cnt, total_spinlocks, collisions, total_spinloops, total_yieldloops, error_cnt from oms_heap_statistics");
        Hashtable hashtable2 = this.parseOutput(arrayList);
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            String string = null;
            ArrayList arrayList2 = new ArrayList();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string == null) continue;
                arrayList2 = (ArrayList)hashtable2.get(string);
                System.out.println("al:" + arrayList2);
                this.addNewMeasure(string, arrayList2);
            }
        }
    }

    public static void main(String[] stringArray) {
        DbOmsStatsTest dbOmsStatsTest = new DbOmsStatsTest(stringArray);
        dbOmsStatsTest.computeMeasures(new Hashtable());
    }

    private Hashtable parseOutput(ArrayList arrayList) {
        double d = -5.0;
        String string = null;
        Hashtable hashtable = new Hashtable();
        ArrayList<Double> arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2 = new ArrayList<Double>();
            string = null;
            hashtable2 = (Hashtable)arrayList.get(i);
            if (hashtable2 == null || hashtable2.size() <= 0) {
                return null;
            }
            d = -5.0;
            string = this.getDesc(hashtable2, omsDesc);
            if (string == null) continue;
            d = this.getMeasureValue(hashtable2, heapUsage);
            if (d > 0.0) {
                d /= byteToMb;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasureValue(hashtable2, reserved);
            if (d > 0.0) {
                d /= byteToMb;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable2, allocs, string);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable2, freeCount, string);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable2, spinLocks, string);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable2, collisions, string);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable2, spinLoops, string);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable2, yieldLoops, string);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable2, errors, string);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            hashtable.put(string, arrayList2);
        }
        return hashtable;
    }

    private double getMeasurePrevValue(Hashtable hashtable, String string, String string2) {
        String string3 = null;
        double d = -5.0;
        double d2 = -5.0;
        Hashtable hashtable2 = null;
        if (hashtable.containsKey(string)) {
            string3 = (String)hashtable.get(string);
            d = this.getValue(string3);
            double d3 = -5.0;
            if (d >= 0.0) {
                if (string.equalsIgnoreCase(allocs)) {
                    hashtable2 = (Hashtable)this.htAllocs.clone();
                } else if (string.equalsIgnoreCase(freeCount)) {
                    hashtable2 = (Hashtable)this.htFrees.clone();
                } else if (string.equalsIgnoreCase(spinLocks)) {
                    hashtable2 = (Hashtable)this.htSpinLocks.clone();
                } else if (string.equalsIgnoreCase(collisions)) {
                    hashtable2 = (Hashtable)this.htCollisions.clone();
                } else if (string.equalsIgnoreCase(spinLoops)) {
                    hashtable2 = (Hashtable)this.htSpinLoops.clone();
                } else if (string.equalsIgnoreCase(yieldLoops)) {
                    hashtable2 = (Hashtable)this.htYieldLoops.clone();
                } else if (string.equalsIgnoreCase(errors)) {
                    hashtable2 = (Hashtable)this.htErrors.clone();
                }
                Double d4 = hashtable2 != null && hashtable2.size() > 0 && hashtable2.containsKey(string2) ? (Double)hashtable2.get(string2) : new Double(-1.0);
                if (d4 != null) {
                    d3 = d4;
                    d2 = d3 >= 0.0 ? d - d3 : -5.0;
                    double d5 = d2 = d2 >= 0.0 ? d2 : -5.0;
                    double d6 = d3 < 0.0 ? d : (d3 = d2 >= 0.0 ? d : -5.0);
                }
            }
            if (string.equalsIgnoreCase(allocs)) {
                this.htAllocs.put(string2, new Double(d3));
            } else if (string.equalsIgnoreCase(freeCount)) {
                this.htFrees.put(string2, new Double(d3));
            } else if (string.equalsIgnoreCase(spinLocks)) {
                this.htSpinLocks.put(string2, new Double(d3));
            } else if (string.equalsIgnoreCase(collisions)) {
                this.htCollisions.put(string2, new Double(d3));
            } else if (string.equalsIgnoreCase(spinLoops)) {
                this.htSpinLoops.put(string2, new Double(d3));
            } else if (string.equalsIgnoreCase(yieldLoops)) {
                this.htYieldLoops.put(string2, new Double(d3));
            } else if (string.equalsIgnoreCase(errors)) {
                this.htErrors.put(string2, new Double(d3));
            }
        }
        return d2;
    }

    private String getDesc(Hashtable hashtable, String string) {
        String string2 = null;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
        }
        return string2;
    }

    private double getMeasureValue(Hashtable hashtable, String string) {
        String string2 = null;
        double d = -5.0;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
            d = this.getValue(string2);
        }
        return d;
    }

    private double getValue(String string) {
        double d;
        if (string == null) {
            return -5.0;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = -5.0;
        }
        return d;
    }
}

