/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class DbLogTest
extends DbLogBaseTest {
    private static String totalLogMem = "USABLESIZE";
    private static String usedLogMem = "USEDSIZE";
    private static String transCount = "TRANSACTIONCOUNT";
    private static String writeTrans = "WRITETRANSACTIONCOUNT";
    private static String queueCount = "QUEUECOUNT";
    private static String queueSize = "QUEUESIZE";
    double prevTrans = -5.0;
    double prevWriteTrans = -5.0;

    public DbLogTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.executeLogQuery();
        ArrayList<Double> arrayList2 = this.parseOutput(arrayList);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < 8; ++i) {
                arrayList2.add(new Double(-5.0));
            }
        }
        System.out.println("al:" + arrayList2);
        this.addNewMeasure(arrayList2);
    }

    public static void main(String[] stringArray) {
        DbLogTest dbLogTest = new DbLogTest(stringArray);
        dbLogTest.computeMeasures(new Hashtable());
    }

    private ArrayList parseOutput(ArrayList arrayList) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        ArrayList<Double> arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        arrayList2 = new ArrayList<Double>();
        hashtable = (Hashtable)arrayList.get(0);
        if (hashtable == null || hashtable.size() <= 0) {
            return null;
        }
        d = -5.0;
        d2 = this.getMeasureValue(hashtable, totalLogMem);
        if (d2 > 0.0) {
            d2 /= 1024.0;
        }
        arrayList2.add(new Double(d2));
        d3 = this.getMeasureValue(hashtable, usedLogMem);
        if (d3 > 0.0) {
            d3 /= 1024.0;
        }
        arrayList2.add(new Double(d3));
        if (d2 > 0.0) {
            d = d3 / d2 * 100.0;
        }
        arrayList2.add(new Double(d));
        d4 = this.getMeasurePrevValue(hashtable, transCount);
        if (d4 > 0.0) {
            d4 /= this.timeSinceLastTest;
        }
        arrayList2.add(new Double(d4));
        d5 = this.getMeasurePrevValue(hashtable, writeTrans);
        if (d5 > 0.0) {
            d5 /= this.timeSinceLastTest;
        }
        arrayList2.add(new Double(d5));
        d = d4 > 0.0 ? d5 / d4 * 100.0 : -5.0;
        arrayList2.add(new Double(d));
        d = this.getMeasureValue(hashtable, queueCount);
        arrayList2.add(new Double(d));
        d = this.getMeasureValue(hashtable, queueSize);
        if (d > 0.0) {
            d /= 1024.0;
        }
        arrayList2.add(new Double(d));
        return arrayList2;
    }

    private double getMeasurePrevValue(Hashtable hashtable, String string) {
        String string2 = null;
        double d = -5.0;
        double d2 = -5.0;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
            d = this.getValue(string2);
            double d3 = -5.0;
            if (d >= 0.0) {
                if (string.equalsIgnoreCase(transCount)) {
                    d3 = this.prevTrans;
                } else if (string.equalsIgnoreCase(writeTrans)) {
                    d3 = this.prevWriteTrans;
                }
                d2 = d3 >= 0.0 ? d - d3 : -5.0;
                double d4 = d2 = d2 >= 0.0 ? d2 : -5.0;
                double d5 = d3 < 0.0 ? d : (d3 = d2 >= 0.0 ? d : -5.0);
            }
            if (string.equalsIgnoreCase(transCount)) {
                this.prevTrans = d3;
            } else if (string.equalsIgnoreCase(writeTrans)) {
                this.prevWriteTrans = d3;
            }
        }
        return d2;
    }
}

