/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class DbDataCacheTest
extends DbBaseTest {
    private static String cacheTotalMem = "USABLESIZE";
    private static String cacheUsedMem = "USEDSIZE";
    private static String cacheOmsMem = "OMSDATASIZE";
    private static String cacheHistMem = "HISTORYDATASIZE";
    private static String cacheSqlMem = "SQLDATASIZE";
    private static String cacheAccess = "ACCESSCOUNT";
    private static String successAccess = "SUCCESSFULACCESSCOUNT";
    double prevAccess = -5.0;
    double prevSuccessAccess = -5.0;

    public DbDataCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
    }

    public static void main(String[] stringArray) {
        DbDataCacheTest dbDataCacheTest = new DbDataCacheTest(stringArray);
        dbDataCacheTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.getOutput("select accesscount, successfulaccesscount from cachestatistics where name='DATA'");
        ArrayList arrayList2 = this.parseHitOutput(arrayList);
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        if (arrayList2 == null || arrayList2.size() == 0) {
            arrayList3.add(new Double(-5.0));
        } else {
            arrayList3.add((Double)arrayList2.get(0));
        }
        ArrayList arrayList4 = this.getOutput("select usablesize, usedsize, omsdatasize, historydatasize, sqldatasize from datacache");
        ArrayList arrayList5 = this.parseMemOutput(arrayList4);
        if (arrayList5 == null || arrayList5.size() == 0) {
            for (int i = 0; i < 6; ++i) {
                arrayList3.add(new Double(-5.0));
            }
        } else {
            for (int i = 0; i < arrayList5.size(); ++i) {
                arrayList3.add((Double)arrayList5.get(i));
            }
        }
        System.out.println("almem:" + arrayList5);
        System.out.println("alhit:" + arrayList2);
        this.addNewMeasure(arrayList3);
    }

    private ArrayList parseHitOutput(ArrayList arrayList) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        ArrayList<Double> arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        arrayList2 = new ArrayList<Double>();
        hashtable = (Hashtable)arrayList.get(0);
        if (hashtable == null || hashtable.size() <= 0) {
            return null;
        }
        d2 = this.getMeasurePrevValue(hashtable, cacheAccess);
        d3 = this.getMeasurePrevValue(hashtable, successAccess);
        if (d2 > 0.0) {
            d = d3 / d2 * 100.0;
        }
        arrayList2.add(new Double(d));
        return arrayList2;
    }

    private ArrayList parseMemOutput(ArrayList arrayList) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        ArrayList<Double> arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        arrayList2 = new ArrayList<Double>();
        hashtable = (Hashtable)arrayList.get(0);
        if (hashtable == null || hashtable.size() <= 0) {
            return null;
        }
        d2 = this.getMeasureValue(hashtable, cacheTotalMem);
        if (d2 > 0.0) {
            d2 /= 1024.0;
        }
        arrayList2.add(new Double(d2));
        d3 = this.getMeasureValue(hashtable, cacheUsedMem);
        if (d3 > 0.0) {
            d3 /= 1024.0;
        }
        arrayList2.add(new Double(d3));
        if (d2 > 0.0) {
            d = d3 / d2 * 100.0;
        }
        arrayList2.add(new Double(d));
        d4 = this.getMeasureValue(hashtable, cacheOmsMem);
        if (d4 > 0.0) {
            d4 /= 1024.0;
        }
        arrayList2.add(new Double(d4));
        d5 = this.getMeasureValue(hashtable, cacheHistMem);
        if (d5 > 0.0) {
            d5 /= 1024.0;
        }
        arrayList2.add(new Double(d5));
        d6 = this.getMeasureValue(hashtable, cacheSqlMem);
        if (d6 > 0.0) {
            d6 /= 1024.0;
        }
        arrayList2.add(new Double(d6));
        return arrayList2;
    }

    private double getMeasurePrevValue(Hashtable hashtable, String string) {
        String string2 = null;
        double d = -5.0;
        double d2 = -5.0;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
            d = this.getValue(string2);
            double d3 = -5.0;
            if (d >= 0.0) {
                if (string.equalsIgnoreCase(cacheAccess)) {
                    d3 = this.prevAccess;
                } else if (string.equalsIgnoreCase(successAccess)) {
                    d3 = this.prevSuccessAccess;
                }
                d2 = d3 >= 0.0 ? d - d3 : d;
                double d4 = d2 = d2 >= 0.0 ? d2 : -5.0;
                double d5 = d3 < 0.0 ? d : (d3 = d2 >= 0.0 ? d : -5.0);
            }
            if (string.equalsIgnoreCase(cacheAccess)) {
                this.prevAccess = d3;
            } else if (string.equalsIgnoreCase(successAccess)) {
                this.prevSuccessAccess = d3;
            }
        }
        return d2;
    }

    private double getMeasureValue(Hashtable hashtable, String string) {
        String string2 = null;
        double d = -5.0;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
            d = this.getValue(string2);
        }
        return d;
    }

    private double getValue(String string) {
        double d;
        if (string == null) {
            return -5.0;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = -5.0;
        }
        return d;
    }
}

