/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgExternalInfo;
import com.eg.EgSpecsInfo;
import com.eg.IPV6Helper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Db2Validator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String database = "";
    public boolean meAgentLess = false;
    public boolean isConnectivityOk = true;
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    EgSpecsInfo specsInfo = new EgSpecsInfo("agent");
    EgExternalInfo extInfo = new EgExternalInfo("agent");
    private static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static final String URL_PREFIX = "jdbc:db2://";

    public Db2Validator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-domain")) {
                    this.domain = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess == null || !this.isAgentLess.equalsIgnoreCase("y")) continue;
                    this.meAgentLess = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-database")) continue;
                this.database = string3;
            }
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port;
        this.validationMsgs = new ArrayList();
        if (this.extInfo.isRemoteBased(this.reportingName)) {
            this.meAgentLess = true;
        }
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            if (!this.checkDb2DPFConnectivity()) {
                this.subject = "ERROR_TESTS";
                this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Db2 DPF Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("Db2 Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port is down or listener is down");
                } else {
                    String string = (String)this.validationErrorMap.get("Db2_Connectivity");
                    this.validationMsgs.add("Db2 Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
                if (!this.isFromManager) {
                    return;
                }
            } else if (!this.checkDB2UsersAuthority()) {
                this.validationMsgs.add("Db2 Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("User Monitoring Privilege$#$User doesn't have required privilege");
                if (!this.isFromManager) {
                    return;
                }
            } else {
                this.validationMsgs.add("Db2 Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("User Monitoring Privilege$#$OK");
            }
            this.logMsgToStatusFile(this.subject, this.key, "OK#" + this.getCurrentTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDb2DPFConnectivity() {
        boolean bl = false;
        String string = "";
        Connection connection = null;
        try {
            this.host = IPV6Helper.getValidIPAddress(this.host);
            connection = this.getConnection(this.host, this.port, this.user, this.password, this.database);
            if (connection == null) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (Exception exception) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDB2UsersAuthority() {
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string;
            this.host = IPV6Helper.getValidIPAddress(this.host);
            connection = this.getConnection(this.host, this.port, this.user, this.password, this.database);
            if (connection != null && (resultSet = (statement = connection.createStatement()).executeQuery(string = "select substr(AUTHORITY,1,30) as Authority , D_GROUP from table(auth_list_authorities_for_authid('" + this.user + "','U')) WHERE authority IN ('SYSADM','SYSMON','SYSCTRL','SYSMAINT')")) != null) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString("Authority");
                    String string3 = resultSet.getString("D_GROUP");
                    if (string3 == null || !string3.equalsIgnoreCase("Y")) continue;
                    bl = true;
                    break;
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(String string, String string2, String string3, String string4, String string5) {
        Connection connection = null;
        boolean bl = false;
        String string6 = "";
        long l = System.currentTimeMillis();
        try {
            String string7 = URL_PREFIX + string + ":" + string2 + "/" + string5;
            Class.forName(DRIVER_CLASS);
            connection = DriverManager.getConnection(string7, string3, string4);
            return connection;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string8 = sQLException.getMessage();
            this.isConnectivityOk = false;
            switch (n) {
                case -4214: {
                    string8 = " Invalid username/password; logon denied";
                    bl = true;
                    break;
                }
                case -1001: {
                    string8 = " Invalid username/database; logon denied";
                    bl = true;
                    break;
                }
                case -4499: {
                    string8 = string8 != null && string8.indexOf("SQLSTATE=08004") > -1 ? " An attempt was made to access a database, " + string5 + ", which was either not found or does not support transactions" : "  A communication error occurred during operations on the connection's underlying socket, socket input stream, or socket output stream.";
                    bl = true;
                }
            }
            String string9 = this.getStackTraceAsString(sQLException);
            string6 = string9.substring(0, string9.indexOf("at"));
            this.validationErrorMsg = bl ? string8.trim() : string6;
            if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    String string10 = stringTokenizer.nextToken();
                    stringBuffer.append(string10.trim() + " ");
                }
                this.validationErrorMsg = stringBuffer.toString();
                this.validationErrorMsg = this.validationErrorMsg.trim();
            }
            this.validationErrorMap.put("Db2_Connectivity", this.validationErrorMsg);
            this.errorMsg = string8.trim() + "#Stack Trace:" + sQLException.getMessage().trim() + " " + string9.trim() + "#" + this.getCurrentTime();
            return this.errorMsg;
        }
        catch (Exception exception) {
            String string11 = this.getStackTraceAsString(exception);
            this.validationErrorMsg = string6;
            this.validationErrorMap.put("Db2_Connectivity", this.validationErrorMsg);
            this.errorMsg = "Stack Trace:" + exception.getMessage().trim() + " " + string11.trim() + "#" + this.getCurrentTime();
            return this.errorMsg;
        }
        finally {
            return connection;
        }
    }

    public static void main(String[] stringArray) {
        Db2Validator db2Validator = new Db2Validator(stringArray, new Boolean(false));
    }
}

