/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgTesterInfo;
import com.eg.IPV6Helper;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public abstract class BobiJMXBase
extends EgSnmpGenericTest {
    public final SimpleDateFormat printSDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss");
    private String jmxPort;
    private String jndiName;
    private String jmxUserName;
    private String jmxPassword;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    protected MBeanServerConnection beanServerConnection = null;
    protected String tempHost;
    private String provider = null;
    private String jmxURL = null;
    private int jmxconnect_timeout = 30000;
    private EgTesterInfo testerInfo = new EgTesterInfo("agent");
    private final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();

    public BobiJMXBase(String[] stringArray) {
        super(stringArray);
        this.jmxPort = this.getValueForParam("Jmx_Remote_Port");
        this.jndiName = this.getValueForParam("Jndi_Name");
        if (this.jndiName == null || "None".equalsIgnoreCase(this.jndiName) || "Null".equalsIgnoreCase(this.jndiName)) {
            this.jndiName = "jmxrmi";
        }
        this.jmxUserName = this.getValueForParam("Jmx_user");
        if (this.jmxUserName == null) {
            this.jmxUserName = "none";
        }
        this.jmxPassword = this.getValueForParam("Jmx_password");
        if (this.jmxPassword == null) {
            this.jmxPassword = "none";
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        String string = this.getValueForParam("Provider");
        if (string != null && string.length() > 0) {
            this.provider = this.testerInfo.getJmxProvider(string);
            this.jmxURL = this.testerInfo.getJmxServiceUrlPrefix(string);
            this.jmxURL = this.jmxURL + this.tempHost + ":" + this.jmxPort + "/" + this.jndiName;
        } else {
            string = "Default";
            this.provider = this.testerInfo.getJmxProvider(string);
            this.jmxURL = this.testerInfo.getJmxServiceUrlPrefix(string);
            this.jmxURL = this.jmxURL + this.tempHost + ":" + this.jmxPort + "/" + this.jndiName;
        }
        this.jmxconnect_timeout = (int)this.timeout / 5;
        if (this.jmxconnect_timeout < 30000) {
            this.jmxconnect_timeout = 30000;
        }
    }

    protected boolean connect(String string) {
        try {
            String[] stringArray;
            JMXServiceURL jMXServiceURL = new JMXServiceURL(this.jmxURL);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("jmx.remote.protocol.provider.pkgs", this.provider);
            boolean bl = false;
            if (!this.jmxUserName.equalsIgnoreCase("none") && !this.jmxPassword.equalsIgnoreCase("none")) {
                stringArray = new String[]{this.jmxUserName, this.jmxPassword};
                hashMap.put("jmx.remote.credentials", stringArray);
            }
            try {
                this.jmxConnector = this.connectWithTimeout(jMXServiceURL, this.jmxconnect_timeout, TimeUnit.MILLISECONDS, hashMap);
            }
            catch (IOException iOException) {
                bl = true;
            }
            if (bl) {
                stringArray = new SslRMIClientSocketFactory();
                Registry registry = LocateRegistry.getRegistry(string, Integer.parseInt(this.jmxPort), (RMIClientSocketFactory)stringArray);
                RMIServer rMIServer = (RMIServer)registry.lookup(this.jndiName);
                this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                this.rmiConnector.connect(hashMap);
                this.beanServerConnection = this.rmiConnector.getMBeanServerConnection();
                this.printOut("BOBI_DBG: registry SSL is true");
            } else {
                this.beanServerConnection = this.jmxConnector.getMBeanServerConnection();
                this.printOut("BOBI_DBG: Created connection without registry SSL");
            }
            if (this.beanServerConnection == null) {
                this.printOut(this.entity.toUpperCase() + " : Connection to JMX Agent is not established for Host : " + this.reportingName);
                this.disconnect();
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error : " + this.reportingName);
            this.printOut("BOBI_DBG: " + this.entity.toUpperCase() + " : Connection to JMX Agent is not established for Host : " + this.reportingName);
            this.disconnect();
            return false;
        }
        return true;
    }

    protected void disconnect() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
                this.printOut("disconnect : jmx connector close");
            }
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
                this.printOut("disconnect : rmi connector close");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error disconnect: " + this.reportingName);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXConnector connectWithTimeout(final JMXServiceURL jMXServiceURL, long l, TimeUnit timeUnit, final Map map) throws IOException {
        final ArrayBlockingQueue<String> arrayBlockingQueue = new ArrayBlockingQueue<String>(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor(this.daemonThreadFactory);
        executorService.submit(new Runnable(){

            public void run() {
                try {
                    JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, map);
                    if (!arrayBlockingQueue.offer(jMXConnector)) {
                        jMXConnector.close();
                    }
                }
                catch (Throwable throwable) {
                    arrayBlockingQueue.offer(throwable);
                }
            }
        });
        Object var8_7 = null;
        try {
            var8_7 = arrayBlockingQueue.poll(l, timeUnit);
            if (var8_7 == null && !arrayBlockingQueue.offer("")) {
                var8_7 = arrayBlockingQueue.take();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executorService.shutdown();
            try {
                executorService.awaitTermination(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (var8_7 == null) {
            this.printOut("JMX Connection timed out: " + jMXServiceURL);
        }
        if (var8_7 instanceof JMXConnector) {
            this.printOut("connectWithTimeout : connected");
            return var8_7;
        }
        try {
            this.printOut("connectWithTimeout : throwing");
            throw (Throwable)var8_7;
        }
        catch (IOException iOException) {
            this.printOut("connectWithTimeout : IOE");
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.printOut("connectWithTimeout : RTE");
            throw runtimeException;
        }
        catch (Error error) {
            this.printOut("connectWithTimeout : Error");
            throw error;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
    }

    public void printOut(String string) {
        System.out.println("[ " + this.printSDF.format(new Date()) + " ]." + this.reportingName + "." + this.entity + " : " + string);
    }
}

