/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

public class BBSysSrpTest
extends EgSnmpGenericTest {
    private static final String ServerInstanceOID = ".1.3.6.1.4.1.3530.5.25.1.1";
    private static final String ServerNameOID = ".1.3.6.1.4.1.3530.5.20.1.2";
    private static final String SrpConnectedStateOID = ".1.3.6.1.4.1.3530.5.25.1.10";
    private static final String SrpReconnectSuccessOID = ".1.3.6.1.4.1.3530.5.25.1.12";
    private static final String SrpReconnectsFailOID = ".1.3.6.1.4.1.3530.5.25.1.13";
    private static final String SrpTotalSecNotConnectedOID = ".1.3.6.1.4.1.3530.5.25.1.14";
    private static final int MEASURES_COUNT = 4;
    private HashMap srpReconnectSuccessMap = new HashMap();
    private HashMap srpReconnectsFailMap = new HashMap();
    private HashMap srpTotalSecNotConnectedMap = new HashMap();

    public BBSysSrpTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
    }

    private void clearHashMaps() {
        this.srpReconnectSuccessMap.clear();
        this.srpReconnectsFailMap.clear();
        this.srpTotalSecNotConnectedMap.clear();
    }

    public void computeMeasures(Hashtable hashtable) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (this.runSnmpCmdForOid(ServerInstanceOID)) {
            Object object;
            Object object2;
            if (this.lhs == null) {
                this.clearHashMaps();
                return;
            }
            for (int i = 0; i < this.lhs.length; ++i) {
                object2 = this.lhs[i];
                if (object2 == null || ((String)object2).trim().length() == 0 || (object = this.rhs[i]) == null || ((String)object).trim().length() == 0) continue;
                hashMap.put(object2, object);
            }
            if (hashMap.size() == 0) {
                this.clearHashMaps();
                return;
            }
            HashMap hashMap2 = this.getStringMap(ServerNameOID);
            object2 = this.getResultMap(SrpConnectedStateOID);
            object = this.getRateMap(SrpReconnectSuccessOID, this.srpReconnectSuccessMap);
            HashMap hashMap3 = this.getRateMap(SrpReconnectsFailOID, this.srpReconnectsFailMap);
            HashMap hashMap4 = this.getRateMap(SrpTotalSecNotConnectedOID, this.srpTotalSecNotConnectedMap);
            Set set = hashMap.keySet();
            if (set == null) {
                this.clearHashMaps();
                return;
            }
            for (String string : set) {
                String string2 = (String)hashMap.get(string);
                String string3 = (String)hashMap2.get(string2);
                ArrayList<Double> arrayList = new ArrayList<Double>(4);
                arrayList.add(this.getMapValue((HashMap)object2, string));
                arrayList.add(this.getMapValue((HashMap)object, string));
                arrayList.add(this.getMapValue(hashMap3, string));
                arrayList.add(this.getMapValue(hashMap4, string));
                this.addNewMeasure(string3, arrayList);
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for .1.3.6.1.4.1.3530.5.25.1.1");
            this.clearHashMaps();
        }
    }

    private Double getMapValue(HashMap hashMap, String string) {
        Double d = (Double)hashMap.get(string);
        if (d == null) {
            d = new Double(-5.0);
        }
        return d;
    }

    private HashMap getStringMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.rhs == null) continue;
                String string2 = this.rhs[i].trim();
                hashMap.put(this.lhs[i], string2);
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost + ", OID=" + string);
        }
        return hashMap;
    }

    private double parseRHSValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            return d;
        }
        return d;
    }

    private HashMap getResultMap(String string) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                double d = this.parseRHSValue(i);
                hashMap.put(this.lhs[i], new Double(d));
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost + ", OID=" + string);
        }
        return hashMap;
    }

    private HashMap getRateMap(String string, HashMap hashMap) {
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                double d = this.parseRHSValue(i);
                Double d2 = (Double)hashMap.get(this.lhs[i]);
                double d3 = -5.0;
                if (d2 != null) {
                    d3 = d2;
                }
                double d4 = -5.0;
                if (d3 >= 0.0 && d >= 0.0 && (d4 = d - d3) < 0.0) {
                    d4 = -5.0;
                }
                hashMap2.put(this.lhs[i], new Double(d4));
                hashMap3.put(this.lhs[i], new Double(d));
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost + ", OID=" + string);
        }
        BBSysSrpTest.replaceHash(hashMap, hashMap3);
        return hashMap2;
    }

    public static void replaceHash(HashMap hashMap, HashMap hashMap2) {
        hashMap.clear();
        Set set = hashMap2.keySet();
        if (set == null) {
            return;
        }
        for (String string : set) {
            Object v = hashMap2.get(string);
            hashMap.put(string, v);
        }
    }
}

