/*
 * Decompiled with CFR 0.152.
 */
import com.sap.mw.jco.JCO;
import java.util.ArrayList;
import java.util.Hashtable;

public class AsAbapIcmJco2Test
extends AsAbapJco2Base {
    String sysnr;
    String user;
    String pass;
    String thisServer = null;
    private static String sync0 = new String("x");
    ArrayList inActiveServicesDDList = null;
    ArrayList waitingThreadsDDList = null;
    protected ArrayList jCo2MeasureArrayList = new ArrayList();
    public static final ArrayList debugMeasureNames = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsAbapIcmJco2Test(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(debugMeasureNames.size());
        if (fieldSep.length() == 0) {
            String string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    ArrayList getICMInfo() {
        JCO.Client client = null;
        try {
            client = this.getConnection();
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception while getting connection from pool " + this.thisServer + " : " + exception.toString());
            this.releaseClient(client);
            return null;
        }
        this.inActiveServicesDDList = new ArrayList();
        this.waitingThreadsDDList = new ArrayList();
        int n = 0;
        int n2 = 0;
        JCO.Function function = this.createFunction("ICM_GET_INFO");
        if (function == null) {
            this.releaseClient(client);
            return null;
        }
        long l = System.currentTimeMillis();
        try {
            this.executeFunction(function, client, false);
        }
        catch (Exception exception) {
            this.printOut("Error : Exception while executing ICM_GET_INFO : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity + " : " + this.reportingName, "Exception while executing ICM_GET_INFO : " + exception.toString());
            exception.printStackTrace();
            this.releaseClient(client);
            return null;
        }
        this.printOut("DEBUG : ICM_GET_INFO successfully executed in " + (System.currentTimeMillis() - l) + " ms.");
        ArrayList<Double> arrayList = new ArrayList<Double>();
        JCO.Structure structure = function.getExportParameterList().getStructure("INFO_DATA");
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        n3 = this.getIntFromStruct(structure, "STATUS");
        if (n3 == 2) {
            arrayList.add(new Double(100.0));
        } else {
            arrayList.add(new Double(0.0));
        }
        n = this.getIntFromStruct(structure, "MAX_THR");
        n3 = this.getIntFromStruct(structure, "CUR_THR");
        n2 = n - n3;
        d = (double)n3 / (double)n * 100.0;
        arrayList.add(new Double(n3));
        arrayList.add(new Double(n2));
        arrayList.add(new Double(d));
        JCO.Table table = function.getTableParameterList().getTable("THRLIST");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = 0;
        Object var19_19 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < table.getNumRows(); ++i) {
            table.setRow(i);
            string = null;
            n3 = this.getIntFromTable(table, "REQ_TYPE");
            if (n3 != -5) {
                switch (n3) {
                    case 5: {
                        string = "Waiting for data";
                        ++n5;
                        break;
                    }
                    case 16: {
                        string = "Waiting for response from the application server";
                        ++n5;
                        break;
                    }
                    case 17: {
                        string = "Waiting for new request from the application server";
                        ++n5;
                    }
                }
            }
            if (string == null) continue;
            string2 = this.getDDStringFromTable(table, "THR_ID");
            string3 = "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + string2 + fieldSep + string;
            this.waitingThreadsDDList.add(string3);
        }
        d = (double)n5 / (double)n * 100.0;
        arrayList.add(new Double(d));
        n4 = this.getIntFromStruct(structure, "MAX_QUEUE");
        n3 = this.getIntFromStruct(structure, "CUR_QUEUE");
        d = (double)n3 / (double)n4 * 100.0;
        arrayList.add(new Double(d));
        arrayList.add(new Double(n3));
        n4 = this.getIntFromStruct(structure, "MAX_CONN");
        n3 = this.getIntFromStruct(structure, "CUR_CONN");
        d = (double)n3 / (double)n4 * 100.0;
        arrayList.add(new Double(d));
        arrayList.add(new Double(n3));
        table = function.getTableParameterList().getTable("SERVLIST");
        String string4 = null;
        int n6 = 0;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < table.getNumRows(); ++i) {
            table.setRow(i);
            string4 = table.getString("ACTIVE").trim();
            if (string4.equalsIgnoreCase("X")) continue;
            ++n6;
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.getProtocolName(table.getString("PROTOCOL")));
            stringBuffer.append(fieldSep).append(this.getDDStringFromTable(table, "KEEPALIVE"));
            stringBuffer.append(fieldSep).append(this.getDDStringFromTable(table, "PROC_TIMEOUT"));
            stringBuffer.append(fieldSep).append(this.getDDStringFromTable(table, "SERVICE"));
            stringBuffer.append(fieldSep).append(this.getDDStringFromTable(table, "HOSTNAME"));
            stringBuffer.append(fieldSep).append(this.getDDStringFromTable(table, "EXTBIND"));
            stringBuffer.append(fieldSep).append("-");
            stringBuffer.append(fieldSep).append("-");
            this.inActiveServicesDDList.add(stringBuffer.toString());
        }
        arrayList.add(new Double(n6));
        this.releaseClient(client);
        return arrayList;
    }

    String getProtocolName(String string) {
        if (string == null) {
            return "N/A";
        }
        if ((string = string.trim()).equals("1")) {
            return "HTTP";
        }
        if (string.equals("4")) {
            return "SMTP";
        }
        return "HTTPS";
    }

    public void freeTest() {
        this.inActiveServicesDDList = new ArrayList();
    }

    public void computeMeasures(Hashtable hashtable) {
        int n;
        ArrayList arrayList = this.getICMInfo();
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < debugMeasureNames.size(); ++i) {
            this.printOut((String)debugMeasureNames.get(i) + " : " + ((Double)arrayList.get(i)).toString());
        }
        this.jCo2MeasureArrayList.add(arrayList);
        this.printOut("===========================================================");
        this.printOut("Inactive services DD : ");
        String string = null;
        for (n = 0; n < this.inActiveServicesDDList.size(); ++n) {
            string = (String)this.inActiveServicesDDList.get(n);
            this.printOut(n + 1 + ".) " + string);
        }
        this.printOut("Waiting threads DD : ");
        for (n = 0; n < this.waitingThreadsDDList.size(); ++n) {
            string = (String)this.waitingThreadsDDList.get(n);
            this.printOut(n + 1 + ".) " + string);
        }
    }

    protected ArrayList getMeasureArrayList() {
        return this.jCo2MeasureArrayList;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        AsAbapIcmJco2Test asAbapIcmJco2Test = new AsAbapIcmJco2Test(stringArray);
        asAbapIcmJco2Test.computeMeasures(null);
    }

    static {
        debugMeasureNames.add("is Available?");
        debugMeasureNames.add("number of  worker threads created");
        debugMeasureNames.add("number of  free worker threads");
        debugMeasureNames.add("Worker thread usage percent");
        debugMeasureNames.add("Waiting worker threads percentage");
        debugMeasureNames.add("Current queue entries");
        debugMeasureNames.add("current Queue entries percentage");
        debugMeasureNames.add("Connections established");
        debugMeasureNames.add("connection established percentage");
        debugMeasureNames.add("Number of inactive services");
    }
}

