/*
 * Decompiled with CFR 0.152.
 */
import com.sap.mw.jco.JCO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AsAbapBGJobJco2Test
extends AsAbapTblJco2Base {
    boolean loggedOnToXBP = false;
    protected Hashtable jCo2MeasureHashtable = new Hashtable();
    JCO.Client jc = null;
    public static final int JOBNAME = 0;
    public static final int JOBCOUNT = 1;
    public static final int SDLSTRTDT = 2;
    public static final int SDLSTRTTM = 3;
    public static final int SDLUNAME = 4;
    public static final int RELUNAME = 5;
    public static final int STRTDATE = 6;
    public static final int STRTTIME = 7;
    public static final int ENDDATE = 8;
    public static final int ENDTIME = 9;
    public static final int PERIODIC = 10;
    public static final int EMERGMODE = 11;
    public static final int STATUS = 12;
    public static final int NEWFLAG = 13;
    public static final int JOBCLASS = 14;
    public static final int PRIORITY = 15;
    public static final int REAXSERVER = 16;
    public static final int INTREPORT = 17;
    public static final ArrayList fieldNamesList = new ArrayList();
    public static final ArrayList measureNamesList;
    public static final ArrayList dummyMeasList;
    public static final ArrayList infoList;
    public static final String timedWhereClause = "STATUS IN ('F','A') AND ";
    public Hashtable mainTbl = new Hashtable();
    public Hashtable allOnlyTbl = new Hashtable();
    public Hashtable abortedDDTbl = new Hashtable();
    public Hashtable longRunningDDTbl = new Hashtable();
    public Hashtable newVeryDelayedDDTbl = new Hashtable();
    public double longRunningCutoff;
    public double highDelayCutoff;
    public int maxLogLines = 5;
    String fromDate = null;
    String fromTime = null;
    public SimpleDateFormat eGSDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public AsAbapBGJobJco2Test(String[] stringArray) {
        super(stringArray);
        this.instanceName = this.getInstanceName();
        this.setMeasureCount(measureNamesList.size());
        String string = this.getValueForParam("LongRunningCutoff(hrs)");
        this.longRunningCutoff = Double.POSITIVE_INFINITY;
        try {
            this.longRunningCutoff = Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.printOut("Exception while parsing LongRunningCutoff(hrs) parameter " + string + " : " + exception.toString());
            this.logToErrorFile("WARNING", this.thisServer + " " + this.entity, "Exception while parsing LongRunningCutoff(hrs) parameter " + string + " : " + exception.toString());
            this.longRunningCutoff = Double.POSITIVE_INFINITY;
        }
        string = this.getValueForParam("HighDelayCutoff(Secs)");
        this.highDelayCutoff = Double.POSITIVE_INFINITY;
        try {
            this.highDelayCutoff = Double.parseDouble(string) * 1000.0;
        }
        catch (Exception exception) {
            this.printOut("Exception while parsing HighDelayCutoff(mins) parameter " + string + " : " + exception.toString());
            this.logToErrorFile("WARNING", this.thisServer + " " + this.entity, "Exception while parsing highDelayCutoff(mins) parameter " + string + " : " + exception.toString());
            this.highDelayCutoff = Double.POSITIVE_INFINITY;
        }
        string = this.getValueForParam("MaxLogLines");
        this.maxLogLines = 3;
        try {
            this.maxLogLines = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.printOut("Exception while parsing MaxLogLines parameter " + string + " : " + exception.toString());
            this.logToErrorFile("WARNING", this.thisServer + " " + this.entity, "Exception while parsing MaxLogLines parameter " + string + " : " + exception.toString());
            this.maxLogLines = 3;
        }
    }

    boolean logonToXBP() {
        if (!this.loggedOnToXBP) {
            this.jc = this.getConnection();
            if (this.jc == null) {
                return false;
            }
            if (!this.logonToXMI("XBP", "2.0", this.jc)) {
                this.logoffAndReleaseClient(this.jc);
                return false;
            }
            this.loggedOnToXBP = true;
        }
        return true;
    }

    void logoffFromXBP() {
        if (this.loggedOnToXBP) {
            this.logoffAndReleaseClient(this.jc);
            this.loggedOnToXBP = false;
        }
    }

    void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        this.jCo2MeasureHashtable = new Hashtable();
        this.mainTbl = new Hashtable();
        this.allOnlyTbl = new Hashtable();
        this.abortedDDTbl = new Hashtable();
        this.longRunningDDTbl = new Hashtable();
        this.newVeryDelayedDDTbl = new Hashtable();
        this.loggedOnToXBP = false;
        this.printOut("DEBUG : Got client");
        this.populateTimedQueryResults();
        this.populateNonTimedQueryResults();
        this.logoffFromXBP();
        this.printOut("Post processing : ");
        String string = null;
        String string2 = null;
        Double d = null;
        Object var6_6 = null;
        Hashtable hashtable2 = null;
        for (int i = 0; i < infoList.size(); ++i) {
            string2 = (String)infoList.get(i);
            this.printOut("Key = " + string2);
            hashtable2 = (Hashtable)this.mainTbl.get(string2);
            if (hashtable2 == null) {
                this.mainTbl.put(string2, dummyMeasList);
                this.printOut("No measures found for " + string2 + ". Populating dummy values for this class");
                this.printOut("Adding measure for info " + string2);
                this.printOut(dummyMeasList.toString());
                if (!bl) continue;
                this.jCo2MeasureHashtable.put(string2, dummyMeasList);
                continue;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int j = 0; j < measureNamesList.size(); ++j) {
                string = (String)measureNamesList.get(j);
                d = (Double)hashtable2.get(string);
                if (d == null) {
                    hashtable2.put(string, new Double(0.0));
                    d = new Double(0.0);
                }
                arrayList.add(d);
            }
            this.printOut("Adding measure for info " + string2);
            this.printOut(arrayList.toString());
            if (!bl) continue;
            this.jCo2MeasureHashtable.put(string2, arrayList);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < measureNamesList.size(); ++i) {
            string = (String)measureNamesList.get(i);
            d = (Double)this.allOnlyTbl.get(string);
            if (d == null) {
                this.allOnlyTbl.put(string, new Double(0.0));
                d = new Double(0.0);
            }
            arrayList.add(d);
        }
        this.printOut("Adding measure for ALL descriptor : ");
        this.printOut(arrayList.toString());
        if (bl) {
            this.jCo2MeasureHashtable.put("ALL", arrayList);
        }
    }

    protected Hashtable getMeasureHashtable() {
        return this.jCo2MeasureHashtable;
    }

    void populateTimedQueryResults() {
        ArrayList arrayList;
        this.printOut("Trying to get timed query results and populate measures");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = null;
        if (this.fromDate == null && this.fromTime == null) {
            arrayList3 = this.getEndAndStartTimestamps();
            if (arrayList3 == null) {
                return;
            }
            this.fromDate = (String)arrayList3.get(2);
            this.fromTime = (String)arrayList3.get(3);
        }
        if ((arrayList = this.getSystemTimestamp()) == null) {
            this.printOut("currentTimeArrayList  is null ,test returned ");
            this.logToErrorFile("ERROR  :", this.reportingName + " : " + this.entity, " currentTimeArrayList  is null ,test returned ");
            return;
        }
        String string = (String)arrayList.get(0);
        String string2 = (String)arrayList.get(1);
        arrayList2.add(timedWhereClause);
        arrayList2.add(" REAXSERVER = '" + this.instanceName + "' AND ");
        arrayList2.add(" ENDDATE <= '" + string + "' AND ");
        arrayList2.add(" ENDTIME <= '" + string2 + "' AND ");
        arrayList2.add(" ENDDATE >= '" + this.fromDate + "' AND ");
        arrayList2.add(" ENDTIME >= '" + this.fromTime + "'");
        this.fromDate = string;
        this.fromTime = string2;
        this.printOut("populateTimedQueryResults : Where clause list " + arrayList2.toString());
        ArrayList arrayList4 = this.getTblData("TBTCO", this.getFieldsCSV(), arrayList2);
        this.printData(fieldNamesList, arrayList4);
        ArrayList arrayList5 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Hashtable hashtable = null;
        ArrayList<String> arrayList6 = null;
        this.printOut("Executed query : Got " + arrayList4.size() + " rows");
        for (int i = 0; i < arrayList4.size(); ++i) {
            String string7;
            arrayList5 = (ArrayList)arrayList4.get(i);
            string3 = (String)arrayList5.get(14);
            string5 = (String)arrayList5.get(0);
            string6 = (String)arrayList5.get(1);
            hashtable = (Hashtable)this.mainTbl.get("Class " + string3);
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.mainTbl.put("Class " + string3, hashtable);
                this.printOut("Created entries for class 'Class " + string3 + "'");
            }
            if ((string4 = (String)arrayList5.get(12)).equalsIgnoreCase("F")) {
                this.incrementTbls(hashtable, "FINISHED", 1.0);
                continue;
            }
            if (!string4.equalsIgnoreCase("A")) continue;
            this.incrementTbls(hashtable, "ABORTED", 1.0);
            arrayList6 = (ArrayList<String>)this.abortedDDTbl.get("Class " + string3);
            if (arrayList6 == null) {
                arrayList6 = new ArrayList<String>();
                this.abortedDDTbl.put("Class " + string3, arrayList6);
            }
            if ((string7 = this.getLogLines(string5, string6)) == null) {
                string7 = "-";
            }
            arrayList6.add(this.getCommonDD(arrayList5, string7, null, null));
        }
    }

    void populateNonTimedQueryResults() {
        Serializable serializable;
        this.printOut("Trying to get non timed query results and populate measures");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("STATUS IN ('R','Y')");
        arrayList.add(" AND REAXSERVER = '" + this.instanceName + "'");
        ArrayList arrayList2 = this.getTblData("TBTCO", this.getFieldsCSV(), arrayList);
        this.printData(fieldNamesList, arrayList2);
        ArrayList arrayList3 = this.getEndAndStartTimestamps();
        if (arrayList3 == null) {
            return;
        }
        ArrayList arrayList4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Hashtable hashtable = null;
        Object var10_10 = null;
        int n = (int)this.measurePeriod / 60000;
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        this.printOut("Got " + arrayList2.size() + " rows");
        ArrayList<String> arrayList5 = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList4 = (ArrayList)arrayList2.get(i);
            string = (String)arrayList4.get(14);
            hashtable = (Hashtable)this.mainTbl.get("Class " + string);
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.mainTbl.put("Class " + string, hashtable);
            }
            string2 = (String)arrayList4.get(12);
            string3 = (String)arrayList4.get(6);
            string4 = (String)arrayList4.get(7);
            if (string2.equalsIgnoreCase("R")) {
                this.incrementTbls(hashtable, "ACTIVE", 1.0);
                l = this.getDateDiff(arrayList3, string3, string4);
                d = (double)l / 3600000.0;
                if (d > this.longRunningCutoff) {
                    this.printOut("DEBUG : Found long running job " + (String)arrayList4.get(0) + " and count " + (String)arrayList4.get(1));
                    this.incrementTbls(hashtable, "LONGRUNNING", 1.0);
                    serializable = (ArrayList)this.longRunningDDTbl.get("Class 14");
                    if (serializable == null) {
                        serializable = new ArrayList();
                        this.longRunningDDTbl.put("Class 14", serializable);
                    }
                    ((ArrayList)serializable).add(this.getCommonDD(arrayList4, "-", Double.toString(d), null));
                }
                if (l > this.measurePeriod) continue;
                this.printOut("DEBUG : Found new job " + (String)arrayList4.get(0) + " and count " + (String)arrayList4.get(1));
                this.incrementTbls(hashtable, "NEW", 1.0);
                serializable = new ArrayList();
                ((ArrayList)serializable).add(string3);
                ((ArrayList)serializable).add(string4);
                l2 = this.getDateDiff((ArrayList)serializable, (String)arrayList4.get(2), (String)arrayList4.get(3));
                double d2 = (double)l2 / 1000.0;
                d2 = this.roundDouble(d2, 2);
                if ((double)l2 >= this.highDelayCutoff) {
                    this.printOut("DEBUG : Found new DELAYED job " + (String)arrayList4.get(0) + " and count " + (String)arrayList4.get(1));
                    this.incrementTbls(hashtable, "NEWVERYDELAYED", 1.0);
                    arrayList5 = (ArrayList<String>)this.newVeryDelayedDDTbl.get("Class 14");
                    if (arrayList5 == null) {
                        arrayList5 = new ArrayList<String>();
                        this.newVeryDelayedDDTbl.put("Class 14", arrayList5);
                    }
                    arrayList5.add(this.getCommonDD(arrayList4, "-", null, Double.toString(d2)));
                    this.incrementTbls(hashtable, "NEWDELAYED", 1.0);
                }
                this.incrementTbls(hashtable, "AVGDELAY", l2);
                continue;
            }
            if (!string2.equalsIgnoreCase("Y")) continue;
            this.incrementTbls(hashtable, "READY", 1.0);
        }
        this.printOut("Post processing ... ");
        Double d3 = null;
        serializable = null;
        Object var21_20 = null;
        Enumeration enumeration = this.mainTbl.keys();
        String string5 = null;
        Object var24_23 = null;
        ArrayList arrayList6 = null;
        while (enumeration.hasMoreElements()) {
            string5 = (String)enumeration.nextElement();
            this.printOut("Post processing for descriptor " + string5);
            hashtable = (Hashtable)this.mainTbl.get(string5);
            d3 = (Double)hashtable.get("AVGDELAY");
            serializable = (Double)hashtable.get("NUMDELAYED");
            this.printOut(string5 + " : Avg delay is " + d3 + " and numDelayedDbl is " + serializable);
            d3 = d3 == null || serializable == null || d3 == -5.0 || (Double)serializable == -5.0 ? NaDbl : ((Double)serializable == 0.0 ? new Double(0.0) : new Double(d3 / (Double)serializable));
            this.printOut("INFO : Average delay calculated for class " + string5 + " is " + d3.toString());
            hashtable.put("AVGDELAY", d3);
            arrayList6 = (ArrayList)this.newVeryDelayedDDTbl.get(string5);
            arrayList6 = this.convDDList2DDStrings(arrayList6);
            this.newVeryDelayedDDTbl.put(string5, arrayList6);
        }
        d3 = (Double)this.allOnlyTbl.get("AVGDELAY");
        serializable = (Double)this.allOnlyTbl.get("NUMDELAYED");
        this.printOut("ALL : Avg delay is " + d3 + " and numDelayedDbl is " + serializable);
        d3 = d3 == null || serializable == null || d3 == -5.0 || (Double)serializable == -5.0 ? NaDbl : ((Double)serializable == 0.0 ? new Double(0.0) : new Double(d3 / (Double)serializable));
        this.allOnlyTbl.put("AVGDELAY", d3);
        this.printOut("INFO : Average delay calculated for class ALL is " + d3.toString());
    }

    ArrayList convDDList2DDStrings(ArrayList arrayList) {
        StringBuffer stringBuffer = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList = new ArrayList();
        ArrayList arrayList3 = null;
        if (arrayList == null || arrayList.size() == 0) {
            return arrayList2;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList3 = (ArrayList)arrayList.get(i);
            stringBuffer = new StringBuffer();
            if (arrayList3 == null || arrayList3.size() == 0) continue;
            stringBuffer.append((String)arrayList.get(0));
            for (int j = 1; j < arrayList3.size(); ++j) {
                stringBuffer.append(fieldSep).append((String)arrayList3.get(j));
            }
            arrayList2.add(stringBuffer.toString());
        }
        arrayList.clear();
        return arrayList2;
    }

    String getCommonDD(ArrayList arrayList, String string, String string2, String string3) {
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        Date date = null;
        Date date2 = null;
        Date date3 = null;
        stringBuffer.append((String)arrayList.get(0));
        stringBuffer.append(fieldSep).append((String)arrayList.get(1));
        stringBuffer.append(fieldSep).append((String)arrayList.get(17));
        stringBuffer.append(fieldSep).append((String)arrayList.get(4));
        stringBuffer.append(fieldSep).append((String)arrayList.get(5));
        String string5 = (String)arrayList.get(2);
        String string6 = (String)arrayList.get(3);
        string6 = this.convertTimeStampForEG(string5 + "_" + string6);
        stringBuffer.append(fieldSep).append("-");
        stringBuffer.append(fieldSep).append(string6);
        try {
            date = this.eGSDF.parse(string6);
        }
        catch (Exception exception) {
            this.printOut("Error parsing scheduled start time " + string6 + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error parsing scheduled start time " + string6 + " : " + exception.toString());
            date = null;
        }
        String string7 = (String)arrayList.get(6);
        String string8 = (String)arrayList.get(7);
        string8 = this.convertTimeStampForEG(string7 + "_" + string8);
        stringBuffer.append(fieldSep).append("-");
        stringBuffer.append(fieldSep).append(string8);
        String string9 = (String)arrayList.get(8);
        String string10 = (String)arrayList.get(9);
        string10 = this.convertTimeStampForEG(string9 + "_" + string10);
        stringBuffer.append(fieldSep).append("-");
        stringBuffer.append(fieldSep).append(string10);
        stringBuffer.append(fieldSep).append((String)arrayList.get(15));
        stringBuffer.append(fieldSep).append((String)arrayList.get(10));
        stringBuffer.append(fieldSep).append((String)arrayList.get(11));
        stringBuffer.append(fieldSep).append(string);
        if (string2 == null) {
            try {
                date2 = this.eGSDF.parse(string8);
            }
            catch (Exception exception) {
                this.printOut("Error parsing start time " + string8 + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Error parsing start time " + string8 + " : " + exception.toString());
                date2 = null;
            }
            try {
                date3 = this.eGSDF.parse(string10);
            }
            catch (Exception exception) {
                this.printOut("Error parsing end time " + string10 + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Error parsing end time " + string10 + " : " + exception.toString());
                date3 = null;
            }
            string4 = "-";
            if (date2 != null && date3 != null) {
                double d = date3.getTime() - date2.getTime();
                d /= 3600000.0;
                d = this.roundDouble(d, 2);
                string4 = Double.toString(d);
            }
            stringBuffer.append(fieldSep).append(string4);
        } else {
            stringBuffer.append(fieldSep).append(string2);
        }
        if (string3 == null) {
            string4 = "-";
            try {
                date2 = this.eGSDF.parse(string8);
            }
            catch (Exception exception) {
                this.printOut("Error parsing start time " + string8 + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Error parsing start time " + string8 + " : " + exception.toString());
                date2 = null;
            }
            try {
                date = this.eGSDF.parse(string6);
            }
            catch (Exception exception) {
                this.printOut("Error parsing scheduled start time " + string6 + " : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Error parsing scheduled start time " + string6 + " : " + exception.toString());
                date = null;
            }
            if (date != null && date2 != null) {
                double d = (double)(date2.getTime() - date.getTime()) / 1000.0;
                d = this.roundDouble(d, 2);
                string4 = Double.toString(d);
            }
            stringBuffer.append(fieldSep).append(string4);
        } else {
            stringBuffer.append(fieldSep).append(string3);
        }
        string4 = stringBuffer.toString();
        this.printOut("Created DD line " + string4);
        return string4;
    }

    void incrementTbls(Hashtable hashtable, String string, double d) {
        if (d == -5.0) {
            return;
        }
        Double d2 = (Double)hashtable.get(string);
        d2 = d2 == null ? new Double(d) : new Double(d2 + d);
        hashtable.put(string, d2);
        d2 = (Double)this.allOnlyTbl.get(string);
        d2 = d2 == null ? new Double(d) : new Double(d2 + d);
        this.allOnlyTbl.put(string, d2);
    }

    String getFieldsCSV() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)fieldNamesList.get(0));
        for (int i = 1; i < fieldNamesList.size(); ++i) {
            stringBuffer.append(",").append((String)fieldNamesList.get(i));
        }
        return stringBuffer.toString();
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, true);
    }

    public String getLogLines(String string, String string2) {
        if (!this.logonToXBP()) {
            return null;
        }
        JCO.Function function = this.createFunction("BAPI_XBP_JOB_JOBLOG_READ");
        if (function == null) {
            return null;
        }
        function.getImportParameterList().setValue(string, "JOBNAME");
        function.getImportParameterList().setValue(string2, "JOBCOUNT");
        function.getImportParameterList().setValue(this.thisServer, "EXTERNAL_USER_NAME");
        try {
            this.executeFunction(function, this.jc, true);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while executing log reader BAPI : " + exception.toString());
            this.logToErrorFile("ERROR", this.thisServer + " " + this.entity, "ERROR : Exception while executing log reader BAPI : " + exception.toString());
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        JCO.Table table = function.getTableParameterList().getTable("JOB_PROTOCOL");
        this.printOut("DEBUG : log table size is " + table.getNumRows() + " and maxLogLines is " + this.maxLogLines);
        String string3 = null;
        for (int i = 0; i < table.getNumRows() && i < this.maxLogLines; ++i) {
            string3 = table.getString("ENTERDATE") + "_" + table.getString("ENTERTIME") + " : " + table.getString("TEXT") + "\n";
            stringBuffer.append(string3);
            table.nextRow();
        }
        this.printOut("Got log lines : " + stringBuffer.toString());
        String string4 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string4 == null) {
            string4 = "-";
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (string5 == null || string5.trim().length() <= 0 || string5.equalsIgnoreCase("")) continue;
                stringBuffer2.append(" " + string5);
            }
        }
        if (!string4.equalsIgnoreCase("-")) {
            string4 = stringBuffer2.toString();
        }
        return string4;
    }

    void printDD() {
        this.printOut("Printing DD : ");
        Enumeration enumeration = null;
        String string = null;
        ArrayList arrayList = null;
        this.printOut("Aborted jobs DD : ");
        enumeration = this.abortedDDTbl.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            arrayList = (ArrayList)this.abortedDDTbl.get(string);
            this.printOut("DD for info : " + string);
            this.printOut(arrayList.toString());
        }
        this.printOut("long Running jobs DD : ");
        enumeration = this.longRunningDDTbl.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            arrayList = (ArrayList)this.longRunningDDTbl.get(string);
            this.printOut("DD for info : " + string);
            this.printOut(arrayList.toString());
        }
        this.printOut("new Delayed jobs DD : ");
        enumeration = this.newVeryDelayedDDTbl.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            arrayList = (ArrayList)this.newVeryDelayedDDTbl.get(string);
            this.printOut("DD for info : " + string);
            this.printOut(arrayList.toString());
        }
        this.printOut("------------------------------");
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        AsAbapBGJobJco2Test asAbapBGJobJco2Test = new AsAbapBGJobJco2Test(stringArray);
        int n = 0;
        while (n++ < 4) {
            asAbapBGJobJco2Test.debugComputeMeasures(new Hashtable(), false);
            asAbapBGJobJco2Test.printDD();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    static {
        fieldNamesList.add("JOBNAME");
        fieldNamesList.add("JOBCOUNT");
        fieldNamesList.add("SDLSTRTDT");
        fieldNamesList.add("SDLSTRTTM");
        fieldNamesList.add("SDLUNAME");
        fieldNamesList.add("RELUNAME");
        fieldNamesList.add("STRTDATE");
        fieldNamesList.add("STRTTIME");
        fieldNamesList.add("ENDDATE");
        fieldNamesList.add("ENDTIME");
        fieldNamesList.add("PERIODIC");
        fieldNamesList.add("EMERGMODE");
        fieldNamesList.add("STATUS");
        fieldNamesList.add("NEWFLAG");
        fieldNamesList.add("JOBCLASS");
        fieldNamesList.add("PRIORITY");
        fieldNamesList.add("REAXSERVER");
        fieldNamesList.add("INTREPORT");
        measureNamesList = new ArrayList();
        measureNamesList.add("ACTIVE");
        measureNamesList.add("READY");
        measureNamesList.add("LONGRUNNING");
        measureNamesList.add("NEW");
        measureNamesList.add("NEWVERYDELAYED");
        measureNamesList.add("ABORTED");
        measureNamesList.add("AVGDELAY");
        measureNamesList.add("FINISHED");
        dummyMeasList = new ArrayList();
        dummyMeasList.add(new Double(0.0));
        dummyMeasList.add(new Double(0.0));
        dummyMeasList.add(new Double(0.0));
        dummyMeasList.add(new Double(0.0));
        dummyMeasList.add(new Double(0.0));
        dummyMeasList.add(new Double(0.0));
        dummyMeasList.add(new Double(0.0));
        dummyMeasList.add(new Double(0.0));
        infoList = new ArrayList();
        infoList.add("Class A");
        infoList.add("Class B");
        infoList.add("Class C");
    }
}

