/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class ANLBMemoryTest
extends GenericTest {
    String userName = this.getValueForParam("ssh_userName");
    String password = this.getValueForParam("ssh_password");
    int port;
    String enPassword = this.getValueForParam("ssh_enable_Password");
    Session session;
    ChannelShell channel;
    private static String outputFilePath = null;
    File tmpFile = null;

    public ANLBMemoryTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("ssh_port");
        this.port = Integer.parseInt(string);
        this.isNewDynamicInfoTest = true;
        this.setMeasureCount(4);
    }

    public void computeMeasures(Hashtable hashtable) {
        outputFilePath = EgInstallInfo.getInstallDir() + "/agent/logs/" + this.reportingName + "_ANLBMemoryTestLog";
        this.tmpFile = new File(outputFilePath);
        try {
            if (this.targetHost == null || this.targetHost.equals("")) {
                return;
            }
            if (this.enPassword == null || this.enPassword.equals("") || this.enPassword.equalsIgnoreCase("None")) {
                this.enPassword = "";
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("en");
            arrayList.add("show memory");
            this.executeCLICommands(arrayList);
            ArrayList arrayList2 = this.readDataFromLog();
            if (arrayList2 != null && arrayList2.size() > 0) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ArrayList arrayList3;
                    String string = (String)arrayList2.get(i);
                    if (string == null || string.trim().length() <= 0 || string.trim().indexOf("ITEM") > -1 || string.trim().indexOf("LIMIT") > -1 || string.trim().indexOf("diskspace:") > -1 || (arrayList3 = this.dataSplit(string, 2, 1)) == null || arrayList3.size() != 2) continue;
                    String string2 = (String)arrayList3.get(0);
                    String string3 = (String)arrayList3.get(1);
                    ArrayList arrayList4 = this.dataSplit(string3, 5, 2);
                    String string4 = "-5";
                    String string5 = "-5";
                    String string6 = "-5";
                    String string7 = "-5";
                    String string8 = "-5";
                    if (arrayList4 != null && arrayList4.size() == 5) {
                        string4 = (String)arrayList4.get(0);
                        if (string4.endsWith(",")) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        if ((string5 = (String)arrayList4.get(1)).endsWith(",")) {
                            string5 = string5.substring(0, string5.length() - 1);
                        }
                        if ((string6 = (String)arrayList4.get(2)).endsWith(",")) {
                            string6 = string6.substring(0, string6.length() - 1);
                        }
                        if ((string7 = (String)arrayList4.get(3)).endsWith(",")) {
                            string7 = string7.substring(0, string7.length() - 1);
                        }
                        string8 = (String)arrayList4.get(4);
                    }
                    ArrayList<Double> arrayList5 = new ArrayList<Double>();
                    arrayList5.add(new Double(string4));
                    arrayList5.add(new Double(string5));
                    arrayList5.add(new Double(string6));
                    arrayList5.add(new Double(string7));
                    System.out.println(this.entity + ",index_final===>" + string2 + ",measureList===>" + arrayList5);
                    this.addNewMeasure(string2, arrayList5);
                }
            } else {
                System.out.print(this.entity + ",ArrayList size is less than zero or empty " + arrayList + ",for targetHost-" + this.targetHost);
                this.logToErrorFile("Error", this.entity + ",ArrayList size is less than zero or empty " + arrayList + "", "for targetHost-" + this.targetHost);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.print(this.entity + ",Exception occur in the compute measure for host-" + this.targetHost + ":" + exception.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList dataSplit(String string, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 == 1) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                if (stringTokenizer.countTokens() != n) return arrayList;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    arrayList.add(string2);
                }
                return arrayList;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(this.entity + ",Exception in dataSplit option 1 for host-" + this.targetHost + "-" + exception.toString());
                return arrayList;
            }
        }
        if (n2 != 2) return arrayList;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() != n) return arrayList;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                arrayList.add(string3);
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",Exception in dataSplit option 2 for host-" + this.targetHost + "-" + exception.toString());
        }
        return arrayList;
    }

    private void executeCLICommands(ArrayList arrayList) {
        try {
            ChannelShell channelShell = this.getChannel();
            System.out.println("Sending commands...");
            this.sendCommands(channelShell, arrayList);
            this.readChannelOutput(channelShell);
            System.out.println("Finished sending commands!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",An error ocurred during executeCLICommands: " + exception.toString() + ",for host-" + this.targetHost);
        }
    }

    private void readChannelOutput(ChannelShell channelShell) {
        byte[] byArray = new byte[5024];
        try {
            if (this.tmpFile.exists()) {
                this.tmpFile.delete();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.tmpFile));
            InputStream inputStream = channelShell.getInputStream();
            String string = "";
            while (true) {
                int n;
                if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 5024)) >= 0) {
                    string = new String(byArray, 0, n);
                    bufferedWriter.write(string);
                    continue;
                }
                if (channelShell.isClosed()) break;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(this.entity + ",Exception occur in thread method " + exception.toString() + ",for targetHost-" + this.targetHost);
                }
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",Error while reading channel output: " + exception.toString() + ",for targetHost-" + this.targetHost);
        }
    }

    public ArrayList readDataFromLog() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(EgInstallInfo.getInstallDir() + "/agent/logs/" + this.reportingName + "_ANLBMemoryTestLog")));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",Exception occur while readDataFromLog: " + exception.toString() + ",for host-" + this.targetHost);
        }
        return arrayList;
    }

    private void sendCommands(ChannelShell channelShell, ArrayList arrayList) {
        try {
            PrintStream printStream = new PrintStream(channelShell.getOutputStream());
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                System.out.println("command===>" + string);
                if (string.trim().equals("en")) {
                    printStream.print(string + "\n");
                    printStream.println(this.enPassword + "\n");
                    continue;
                }
                printStream.println(string + "\n");
            }
            printStream.println("exit");
            printStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",Error while sending commands: " + exception.toString() + ",for host-" + this.targetHost);
        }
    }

    private ChannelShell getChannel() {
        try {
            if (this.channel == null || !this.channel.isConnected()) {
                try {
                    this.channel = (ChannelShell)this.getSession().openChannel("shell");
                    this.channel.setPty(false);
                    this.channel.connect();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(this.entity + ",Error while opening channel: " + exception.toString() + ",for host-" + this.targetHost);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",Exception occur in channel creation," + exception.toString() + ",for host-" + this.targetHost);
        }
        return this.channel;
    }

    private Session getSession() {
        try {
            if (this.session == null || !this.session.isConnected()) {
                this.session = this.connect(this.targetHost, this.userName, this.password);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",Exception occur in session creation" + exception.toString() + ",for host-" + this.targetHost);
        }
        return this.session;
    }

    private Session connect(String string, String string2, String string3) {
        JSch jSch = new JSch();
        try {
            this.session = jSch.getSession(string2, string, 22);
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            this.session.setConfig(properties);
            this.session.setPassword(string3);
            System.out.println("Connecting SSH to " + string + " - Please wait for few seconds... ");
            this.session.connect();
            System.out.println("Connected!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(this.entity + ",An error occurred while connecting to " + string + ": " + exception.toString());
        }
        return this.session;
    }

    public static void main(String[] stringArray) {
        ANLBMemoryTest aNLBMemoryTest = new ANLBMemoryTest(stringArray);
        try {
            aNLBMemoryTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception occur in the main method of the Array memory test:" + exception.toString());
        }
    }
}

