/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCloseRep;
import com.ibm.as400.access.IFSCloseReq;
import com.ibm.as400.access.IFSCommitReq;
import com.ibm.as400.access.IFSCopyReq;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSExchangeAttrRep;
import com.ibm.as400.access.IFSExchangeAttrReq;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileOutputStreamImplRemote;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSLockBytesRep;
import com.ibm.as400.access.IFSLockBytesReq;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSOpenReq;
import com.ibm.as400.access.IFSRandomAccessFileImplRemote;
import com.ibm.as400.access.IFSReadRep;
import com.ibm.as400.access.IFSReadReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.IFSUnlockBytesReq;
import com.ibm.as400.access.IFSWriteRep;
import com.ibm.as400.access.IFSWriteReq;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;

class IFSFileDescriptorImplRemote
implements IFSFileDescriptorImpl {
    private static final int UNINITIALIZED = -1;
    private static final int MAX_BYTES_PER_READ = 16000000;
    ConverterImplRemote converter_;
    private int fileHandle_ = -1;
    int preferredServerCCSID_;
    private int fileDataCCSID_ = -1;
    int serverDatastreamLevel_;
    int requestedDatastreamLevel_;
    private long fileOffset_;
    boolean isOpen_;
    boolean isOpenAllowed_ = true;
    private Object parent_;
    String path_ = "";
    byte[] pathnameBytes_;
    AS400Server server_;
    private int shareOption_;
    AS400ImplRemote system_;
    private Boolean fileOffsetLock_ = new Boolean("true");
    private int maxDataBlockSize_ = 1024;
    private boolean determinedSystemVRM_ = false;
    private int systemVRM_;
    transient int errorRC_;
    int patternMatching_ = 0;
    private static final boolean DEBUG = false;

    IFSFileDescriptorImplRemote() {
    }

    static IFSFileDescriptorImplRemote castImplToImplRemote(IFSFileDescriptorImpl iFSFileDescriptorImpl) {
        try {
            return (IFSFileDescriptorImplRemote)iFSFileDescriptorImpl;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "Argument is not an instance of IFSFileDescriptorImplRemote", (Throwable)classCastException);
            throw new InternalErrorException(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkAccess(int n, int n2) throws IOException, AS400SecurityException {
        int n3 = -1;
        try {
            n3 = this.createFileHandle(n, n2);
        }
        finally {
            if (n3 != -1) {
                this.close(n3);
            }
        }
        return this.errorRC_;
    }

    public void close() {
        try {
            this.close0();
        }
        catch (IOException iOException) {
            Trace.log(2, "Error while closing file " + this.path_, (Throwable)iOException);
        }
    }

    public void close0() throws IOException {
        this.isOpen_ = false;
        this.close(this.fileHandle_);
        this.fileHandle_ = -1;
    }

    void close(int n) throws IOException {
        if (n == -1) {
            return;
        }
        ClientAccessDataStream clientAccessDataStream = null;
        IFSCloseReq iFSCloseReq = new IFSCloseReq(n);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCloseReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream connection lost during close", (Throwable)connectionDroppedException);
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSCloseRep) {
            int n2 = ((IFSCloseRep)clientAccessDataStream).getReturnCode();
            if (n2 != 0) {
                Trace.log(2, "IFSCloseRep return code ", n2);
                throw new ExtendedIOException(this.path_, n2);
            }
        } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n3 != 0) {
                Trace.log(2, "IFSReturnCodeRep return code ", n3);
                throw new ExtendedIOException(this.path_, n3);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    void connect() throws IOException, AS400SecurityException {
        if (this.server_ == null) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            try {
                this.server_ = this.system_.getConnection(0, false);
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Access to byte stream server on '" + this.system_.getSystemName() + "' denied.", (Throwable)aS400SecurityException);
                throw aS400SecurityException;
            }
            this.exchangeServerAttributes();
        }
    }

    void connectionDropped(ConnectionDroppedException connectionDroppedException) throws ConnectionDroppedException {
        if (this.server_ != null) {
            this.system_.disconnectServer(this.server_);
            this.server_ = null;
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.log(2, "Byte stream connection lost.");
        throw connectionDroppedException;
    }

    boolean copyTo(String string, boolean bl) throws AS400SecurityException, IOException {
        ClientAccessDataStream clientAccessDataStream = null;
        IFSCopyReq iFSCopyReq = new IFSCopyReq(this.path_, string, bl);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCopyReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream connection lost during copy", (Throwable)connectionDroppedException);
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                this.throwSecurityExceptionIfAccessDenied(n);
                Trace.log(2, "IFSReturnCodeRep return code ", n);
                String string2 = n == 4 ? string : this.path_;
                throw new ExtendedIOException(string2, n);
            }
            return true;
        }
        Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
        throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
    }

    private final int createFileHandle() throws IOException, AS400SecurityException {
        return this.createFileHandle(1, 8);
    }

    int createFileHandle(int n, int n2) throws IOException, AS400SecurityException {
        int n3;
        int n4;
        block7: {
            n4 = 2;
            n3 = -1;
            this.errorRC_ = 0;
            try {
                IFSOpenReq iFSOpenReq = new IFSOpenReq(this.getPathnameAsBytes(), this.preferredServerCCSID_, 0, n, 0, 0, n2, this.serverDatastreamLevel_);
                ClientAccessDataStream clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSOpenReq);
                if (clientAccessDataStream instanceof IFSOpenRep) {
                    n4 = 0;
                    n3 = ((IFSOpenRep)clientAccessDataStream).getFileHandle();
                    break block7;
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n4 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    this.throwSecurityExceptionIfAccessDenied(n4);
                    if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                        Trace.log(2, "IFSReturnCodeRep return code ", n4);
                    }
                    break block7;
                }
                Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost", (Throwable)connectionDroppedException);
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
        if (n4 != 0) {
            Trace.log(2, "Failed to open file: IFSReturnCodeRep return code = ", n4);
            this.errorRC_ = n4;
            return -1;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exchangeServerAttributes() throws IOException, AS400SecurityException {
        AS400Server aS400Server = this.server_;
        synchronized (aS400Server) {
            DataStream dataStream = this.server_.getExchangeAttrReply();
            IFSExchangeAttrRep iFSExchangeAttrRep = null;
            try {
                iFSExchangeAttrRep = (IFSExchangeAttrRep)dataStream;
            }
            catch (ClassCastException classCastException) {
                if (dataStream instanceof IFSReturnCodeRep) {
                    int n = ((IFSReturnCodeRep)dataStream).getReturnCode();
                    this.throwSecurityExceptionIfAccessDenied(n);
                    Trace.log(2, "IFSReturnCodeRep return code ", n);
                    throw new ExtendedIOException(this.path_, n);
                }
                String string = dataStream == null ? "null" : dataStream.getClass().getName();
                Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + string);
                throw new InternalErrorException(2);
            }
            this.requestedDatastreamLevel_ = this.getSystemVRM() >= 393472 ? 16 : (this.getSystemVRM() >= 328448 ? 8 : (this.getSystemVRM() >= 263424 ? 2 : 0));
            if (iFSExchangeAttrRep == null) {
                dataStream = null;
                try {
                    int[] nArray = this.getSystemVRM() >= 328448 ? new int[]{1200, 13488, 61952} : (this.getSystemVRM() >= 263424 ? new int[]{13488, 61952} : new int[]{61952});
                    dataStream = this.server_.sendExchangeAttrRequest(new IFSExchangeAttrReq(true, false, 2, -1, this.requestedDatastreamLevel_, nArray));
                    iFSExchangeAttrRep = (IFSExchangeAttrRep)dataStream;
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                catch (IOException iOException) {
                    this.system_.disconnectServer(this.server_);
                    this.server_ = null;
                    Trace.log(2, "I/O error during attribute exchange.");
                    throw iOException;
                }
                catch (ClassCastException classCastException) {
                    if (dataStream instanceof IFSReturnCodeRep) {
                        int n = ((IFSReturnCodeRep)dataStream).getReturnCode();
                        this.throwSecurityExceptionIfAccessDenied(n);
                        Trace.log(2, "IFSReturnCodeRep return code ", n);
                        throw new ExtendedIOException(this.path_, n);
                    }
                    String string = dataStream == null ? "null" : dataStream.getClass().getName();
                    Trace.log(2, "Unexpected reply from Exchange Server Attributes: " + string);
                    throw new InternalErrorException(2);
                }
            }
            if (!(iFSExchangeAttrRep instanceof IFSExchangeAttrRep)) {
                this.system_.disconnectServer(this.server_);
                this.server_ = null;
                if (iFSExchangeAttrRep != null) {
                    Trace.log(2, "Unknown reply data stream ", iFSExchangeAttrRep.data_);
                    throw new InternalErrorException(Integer.toHexString(iFSExchangeAttrRep.getReqRepID()), 2);
                }
                Trace.log(2, "Null reply data stream");
                throw new InternalErrorException(2);
            }
            this.maxDataBlockSize_ = iFSExchangeAttrRep.getMaxDataBlockSize();
            this.preferredServerCCSID_ = iFSExchangeAttrRep.getPreferredCCSID();
            this.serverDatastreamLevel_ = iFSExchangeAttrRep.getDataStreamLevel();
            this.setConverter(ConverterImplRemote.getConverter(this.preferredServerCCSID_, this.system_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalize0() throws Throwable {
        block8: {
            try {
                if (this.fileHandle_ == -1) break block8;
                IFSCloseReq iFSCloseReq = new IFSCloseReq(this.fileHandle_);
                try {
                    this.server_.sendAndDiscardReply(iFSCloseReq);
                }
                finally {
                    this.close0();
                }
            }
            catch (Throwable throwable) {
                Trace.log(2, "Error during finalization.", throwable);
            }
            finally {
                super.finalize();
            }
        }
    }

    void flush() throws IOException, AS400SecurityException {
        IFSCommitReq iFSCommitReq = new IFSCommitReq(this.fileHandle_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSCommitReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                this.throwSecurityExceptionIfAccessDenied(n);
                Trace.log(2, "IFSReturnCodeRep return code ", n);
                throw new ExtendedIOException(this.path_, n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    ConverterImplRemote getConverter() {
        return this.converter_;
    }

    public int getCCSID() throws IOException {
        if (this.fileDataCCSID_ == -1) {
            try {
                this.connect();
                IFSListAttrsRep iFSListAttrsRep = this.listObjAttrs2();
                if (iFSListAttrsRep != null) {
                    this.fileDataCCSID_ = iFSListAttrsRep.getCCSID(this.serverDatastreamLevel_);
                }
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        return this.fileDataCCSID_;
    }

    int getFileHandle() {
        return this.fileHandle_;
    }

    public long getFileOffset() {
        return this.fileOffset_;
    }

    Object getParent() {
        return this.parent_;
    }

    String getPath() {
        return this.path_;
    }

    final byte[] getPathnameAsBytes() {
        if (this.pathnameBytes_ == null) {
            this.pathnameBytes_ = this.converter_.stringToByteArray(this.path_);
        }
        return this.pathnameBytes_;
    }

    int getPreferredCCSID() {
        return this.preferredServerCCSID_;
    }

    AS400Server getServer() {
        return this.server_;
    }

    int getShareOption() {
        return this.shareOption_;
    }

    AS400ImplRemote getSystem() {
        return this.system_;
    }

    int getSystemVRM() {
        if (!this.determinedSystemVRM_) {
            this.systemVRM_ = this.system_.getVRM();
            this.determinedSystemVRM_ = true;
        }
        return this.systemVRM_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementFileOffset(long l) {
        Boolean bl = this.fileOffsetLock_;
        synchronized (bl) {
            this.fileOffset_ += l;
        }
    }

    public void initialize(long l, Object object, String string, int n, AS400Impl aS400Impl) {
        this.fileOffset_ = l;
        this.parent_ = object;
        this.path_ = string;
        this.shareOption_ = n;
        this.system_ = (AS400ImplRemote)aS400Impl;
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    boolean isOpenAllowed() {
        return this.isOpenAllowed_;
    }

    Vector listAttributes(IFSListAttrsReq iFSListAttrsReq) throws IOException, AS400SecurityException {
        this.errorRC_ = 0;
        Vector<ClientAccessDataStream> vector = new Vector<ClientAccessDataStream>(256);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSListAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = -1;
        boolean bl = false;
        do {
            if (clientAccessDataStream instanceof IFSListAttrsRep) {
                vector.addElement(clientAccessDataStream);
            } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0 && n != 18 && n != 2 && n != 3) {
                    this.throwSecurityExceptionIfAccessDenied(n);
                    Trace.log(2, "Error getting file attributes for file " + this.path_ + ": " + "IFSReturnCodeRep return code = ", n);
                    throw new ExtendedIOException(this.path_, n);
                }
            } else {
                Trace.log(2, "Unknown reply data stream: ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            bl = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
            if (bl) continue;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.server_.receive(iFSListAttrsReq.getCorrelation());
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        } while (!bl);
        if (n == 3) {
            this.errorRC_ = n;
            vector = null;
        } else {
            vector.trimToSize();
        }
        return vector;
    }

    IFSListAttrsRep listObjAttrs1(int n, int n2) throws IOException, AS400SecurityException {
        return this.listObjAttrs(1, n, n2);
    }

    IFSListAttrsRep listObjAttrs2() throws IOException, AS400SecurityException {
        return this.listObjAttrs(2, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFSListAttrsRep listObjAttrs(int n, int n2, int n3) throws IOException, AS400SecurityException {
        IFSListAttrsRep iFSListAttrsRep = null;
        int n4 = -1;
        boolean bl = false;
        try {
            if (this.fileHandle_ != -1) {
                n4 = this.fileHandle_;
                bl = true;
            } else {
                n4 = this.createFileHandle();
            }
            if (n4 != -1) {
                IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(n4, n, n2, n3);
                iFSListAttrsReq.setPatternMatching(this.patternMatching_);
                Vector vector = this.listAttributes(iFSListAttrsReq);
                if (vector == null) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "Received null from listAttributes(fileHandle).");
                    }
                } else if (vector.size() == 0) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "Received no replies from listAttributes(fileHandle).");
                    }
                } else if (vector.size() > 1) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "Received multiple replies from listAttributes(fileHandle) (" + vector.size() + ")");
                    }
                } else {
                    iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
                }
            }
        }
        finally {
            if (!bl) {
                this.close(n4);
            }
        }
        return iFSListAttrsRep;
    }

    IFSKey lock(long l) throws IOException, AS400SecurityException {
        return this.lock(this.fileOffset_, l);
    }

    IFSKey lock(long l, long l2) throws IOException, AS400SecurityException {
        int n;
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            IFSLockBytesReq iFSLockBytesReq = new IFSLockBytesReq(this.fileHandle_, true, false, l, l2, this.serverDatastreamLevel_);
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSLockBytesReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSLockBytesRep) {
            n = ((IFSLockBytesRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                Trace.log(2, "IFSLockBytesRep return code ", n);
                throw new ExtendedIOException(this.path_, n);
            }
        } else if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                this.throwSecurityExceptionIfAccessDenied(n);
                Trace.log(2, "IFSReturnCodeRep return code", n);
                throw new ExtendedIOException(this.path_, n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        IFSKey iFSKey = new IFSKey(this.fileHandle_, l, l2, true);
        return iFSKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int read(byte[] byArray, int n, int n2) throws IOException, AS400SecurityException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = n2;
        boolean bl = false;
        while (true) {
            ClientAccessDataStream clientAccessDataStream;
            IFSReadReq iFSReadReq;
            if (n3 < n2 && !bl) {
                int n5 = Math.min(n4, 16000000);
                iFSReadReq = new IFSReadReq(this.fileHandle_, this.fileOffset_, n5, this.serverDatastreamLevel_);
                clientAccessDataStream = null;
                try {
                    clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSReadReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
            } else {
                if (bl && n3 == 0) {
                    return -1;
                }
                int n6 = n3;
                return n6;
            }
            boolean bl2 = false;
            int n7 = 0;
            do {
                if (clientAccessDataStream instanceof IFSReadRep) {
                    byte[] byArray2 = ((IFSReadRep)clientAccessDataStream).getData();
                    if (byArray2.length > 0) {
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                        n7 += byArray2.length;
                        n += byArray2.length;
                    } else {
                        n7 = -1;
                        bl = true;
                    }
                } else {
                    if (!(clientAccessDataStream instanceof IFSReturnCodeRep)) {
                        Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                        throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                    }
                    int n8 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n8 != 0) {
                        if (n8 != 22) {
                            this.throwSecurityExceptionIfAccessDenied(n8);
                            Trace.log(2, "IFSReturnCodeRep return code ", n8);
                            throw new ExtendedIOException(this.path_, n8);
                        }
                        n7 = -1;
                        bl = true;
                    }
                }
                bl2 = ((IFSDataStream)clientAccessDataStream).isEndOfChain();
                if (bl2) continue;
                try {
                    clientAccessDataStream = (ClientAccessDataStream)this.server_.receive(iFSReadReq.getCorrelation());
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost");
                    this.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted", (Throwable)interruptedException);
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
            } while (!bl2);
            if (n7 <= 0) continue;
            this.incrementFileOffset(n7);
            n3 += n7;
            n4 -= n7;
        }
    }

    void setConverter(ConverterImplRemote converterImplRemote) {
        this.converter_ = converterImplRemote;
    }

    void setCCSID(int n) throws IOException {
        this.fileDataCCSID_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileOffset(long l) {
        Boolean bl = this.fileOffsetLock_;
        synchronized (bl) {
            this.fileOffset_ = l;
        }
    }

    boolean setLength(long l) throws IOException, AS400SecurityException {
        ClientAccessDataStream clientAccessDataStream = null;
        int n = -1;
        try {
            n = this.createFileHandle(2, 8);
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(n, l, this.serverDatastreamLevel_);
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        finally {
            this.close(n);
        }
        boolean bl = false;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n2 == 0) {
                bl = true;
            } else {
                this.throwSecurityExceptionIfAccessDenied(n2);
                Trace.log(2, "IFSReturnCodeRep return code ", n2);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        if (this.fileOffset_ > l) {
            this.fileOffset_ = l;
        }
        return bl;
    }

    void setOpen(boolean bl, int n) {
        if (bl) {
            if (n == -1) {
                Trace.log(2, "Called setOpen with invalid file handle: " + n);
                throw new InternalErrorException(10);
            }
            if (n != this.fileHandle_) {
                this.close();
            }
            this.fileHandle_ = n;
        }
        this.isOpen_ = bl;
    }

    void setOpenAllowed(boolean bl) {
        this.isOpenAllowed_ = bl;
    }

    void setPreferredCCSID(int n) {
        this.preferredServerCCSID_ = n;
    }

    void setServer(AS400Server aS400Server) {
        this.server_ = aS400Server;
    }

    public void sync() throws IOException {
        if (this.parent_ == null) {
            Trace.log(2, "IFSFileDescriptor.sync() was called when parent is null.");
        } else if (this.parent_ instanceof IFSRandomAccessFileImplRemote) {
            ((IFSRandomAccessFileImplRemote)this.parent_).flush();
        } else if (this.parent_ instanceof IFSFileOutputStreamImplRemote) {
            ((IFSFileOutputStreamImplRemote)this.parent_).flush();
        } else {
            Trace.log(4, "IFSFileDescriptor.sync() was called when parent is neither an IFSRandomAccessFile nor an IFSFileOutputStream.");
        }
    }

    private final void throwSecurityExceptionIfAccessDenied(int n) throws AS400SecurityException {
        if (n == 5 || n == 13) {
            Trace.log(2, "Access denied to file " + this.path_ + ". " + "IFSReturnCodeRep return code ", n);
            throw new AS400SecurityException(1);
        }
    }

    void unlock(IFSKey iFSKey) throws IOException, AS400SecurityException {
        if (iFSKey.fileHandle_ != this.fileHandle_) {
            Trace.log(2, "Attempt to use IFSKey on different file stream.");
            throw new ExtendedIllegalArgumentException("key", 2);
        }
        ClientAccessDataStream clientAccessDataStream = null;
        IFSUnlockBytesReq iFSUnlockBytesReq = new IFSUnlockBytesReq(iFSKey.fileHandle_, iFSKey.offset_, iFSKey.length_, iFSKey.isMandatory_, this.serverDatastreamLevel_);
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSUnlockBytesReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost");
            this.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted", (Throwable)interruptedException);
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0) {
                this.throwSecurityExceptionIfAccessDenied(n);
                Trace.log(2, "IFSReturnCodeRep return code ", n);
                throw new ExtendedIOException(this.path_, n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    void writeBytes(byte[] byArray, int n, int n2) throws IOException, AS400SecurityException {
        this.writeBytes(byArray, n, n2, false);
    }

    void writeBytes(byte[] byArray, int n, int n2, boolean bl) throws IOException, AS400SecurityException {
        while (n2 > 0) {
            int n3 = n2 > this.maxDataBlockSize_ ? this.maxDataBlockSize_ : n2;
            IFSWriteReq iFSWriteReq = new IFSWriteReq(this.fileHandle_, this.fileOffset_, byArray, n, n3, 65535, bl, this.serverDatastreamLevel_);
            if (n2 - n3 > 0) {
                iFSWriteReq.setChainIndicator(1);
            }
            ClientAccessDataStream clientAccessDataStream = null;
            try {
                clientAccessDataStream = (ClientAccessDataStream)this.server_.sendAndReceive(iFSWriteReq);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost");
                this.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted", (Throwable)interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
            if (clientAccessDataStream instanceof IFSWriteRep) {
                IFSWriteRep iFSWriteRep = (IFSWriteRep)clientAccessDataStream;
                int n4 = iFSWriteRep.getReturnCode();
                if (n4 != 0) {
                    Trace.log(2, "IFSWriteRep return code ", n4);
                    throw new ExtendedIOException(this.path_, n4);
                }
                int n5 = n3 - iFSWriteRep.getLengthNotWritten();
                this.incrementFileOffset(n5);
                n += n5;
                n2 -= n5;
                if (n5 == n3) continue;
                Trace.log(2, "Incomplete write.  Only " + Integer.toString(n5) + " bytes of a requested " + Integer.toString(n3) + " were written.");
                throw new ExtendedIOException(this.path_, 25);
            }
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                int n6 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n6 == 0) continue;
                this.throwSecurityExceptionIfAccessDenied(n6);
                Trace.log(2, "IFSReturnCodeRep return code ", n6);
                throw new ExtendedIOException(this.path_, n6);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSCloseRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSExchangeAttrRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSLockBytesRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSWriteRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReadRep(), 0);
    }
}

