/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.CancelController;
import com.thinweb.tds.Column;
import com.thinweb.tds.Columns;
import com.thinweb.tds.Connection;
import com.thinweb.tds.Context;
import com.thinweb.tds.DriverVersion;
import com.thinweb.tds.EncodingHelper;
import com.thinweb.tds.MSSqlServerEscapeProcessor;
import com.thinweb.tds.PacketColumnInfoResult;
import com.thinweb.tds.PacketColumnNamesResult;
import com.thinweb.tds.PacketColumnOrderResult;
import com.thinweb.tds.PacketControlResult;
import com.thinweb.tds.PacketDoneInProcResult;
import com.thinweb.tds.PacketEndTokenResult;
import com.thinweb.tds.PacketErrorResult;
import com.thinweb.tds.PacketMsgResult;
import com.thinweb.tds.PacketOutputParamResult;
import com.thinweb.tds.PacketResult;
import com.thinweb.tds.PacketRetStatResult;
import com.thinweb.tds.PacketRowResult;
import com.thinweb.tds.PacketTabNameResult;
import com.thinweb.tds.PacketUnknown;
import com.thinweb.tds.SQLWarningChain;
import com.thinweb.tds.SqlMessage;
import com.thinweb.tds.Statement;
import com.thinweb.tds.TdsComm;
import com.thinweb.tds.TdsConfused;
import com.thinweb.tds.TdsDefinitions;
import com.thinweb.tds.TdsException;
import com.thinweb.tds.TdsNotImplemented;
import com.thinweb.tds.TdsUnknownPacketSubType;
import com.thinweb.tds.TimeoutHandler;
import com.thinweb.tds.util.Logger;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public final class Tds
implements TdsDefinitions {
    static boolean ignoreNotImplemented;
    Socket sock = null;
    TdsComm comm = null;
    Connection connection;
    String host;
    int serverType = -1;
    int port;
    String database;
    String user;
    String password;
    String appName;
    String serverName;
    String progName;
    byte progMajorVersion;
    byte progMinorVersion;
    boolean haveProcNameTable = false;
    String procNameGeneratorName = null;
    String procNameTableName = null;
    String initialSettings = null;
    private Properties initialProps = null;
    private EncodingHelper encoder = null;
    private String charset = null;
    private boolean moreResults = false;
    private boolean moreResults2 = true;
    CancelController cancelController = null;
    SqlMessage lastServerMessage = null;
    private int tdsVer = 42;
    private boolean showWarnings = false;
    private int zoneOffset = Calendar.getInstance().get(15);
    Vector tables;
    PacketRowResult rowResult;

    public Tds(Connection connection, Properties properties, String string) throws IOException, UnknownHostException, SQLException, TdsException {
        this.connection = connection;
        connection.tds = this;
        this.initialProps = properties;
        this.host = properties.getProperty("HOST");
        this.serverType = Integer.parseInt(properties.getProperty("SERVERTYPE"));
        this.port = Integer.parseInt(properties.getProperty("PORT"));
        this.database = properties.getProperty("DBNAME");
        this.user = properties.getProperty("user");
        this.password = properties.getProperty("password");
        this.appName = properties.getProperty("APPNAME", "jdbclib");
        this.serverName = properties.getProperty("SERVERNAME", this.host);
        this.progName = properties.getProperty("PROGNAME", "java_app");
        this.progMajorVersion = (byte)DriverVersion.getDriverMajorVersion();
        this.progMinorVersion = (byte)DriverVersion.getDriverMinorVersion();
        String string2 = properties.getProperty("TDS", "42");
        this.tdsVer = 42;
        if (string2.equals("5.0")) {
            this.tdsVer = 50;
        } else if (string2.equals("7.0")) {
            this.tdsVer = 70;
        }
        if (System.getProperty("TDS_SHOW_WARNINGS") != null || properties.getProperty("TDS_SHOW_WARNINGS") != null) {
            this.showWarnings = true;
        }
        this.cancelController = new CancelController();
        this.sock = new Socket(this.host, this.port);
        this.sock.setSoTimeout(0);
        this.sock.setTcpNoDelay(true);
        this.comm = new TdsComm(this.sock, this.tdsVer);
        this.setCharset(properties.getProperty("CHARSET"));
        if (!this.logon()) {
            throw new SQLException("Logon failed.  " + this.lastServerMessage);
        }
    }

    void cancel() throws IOException, TdsException {
        this.cancelController.doCancel(this.comm);
    }

    protected synchronized boolean changeDB(String string) throws SQLException {
        boolean bl = true;
        try {
            PacketResult packetResult;
            if (string.length() > 32) {
                throw new SQLException("Name too long " + string);
            }
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!(c == '_' && n != 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    throw new SQLException("Bad database name- " + string);
                }
                ++n;
            }
            if (!this.hitEndOfData()) {
                this.discardAllResults();
            }
            String string2 = "use " + string;
            this.comm.startPacket(1);
            if (this.tdsVer == 70) {
                this.comm.appendChars(string2);
            } else {
                byte[] byArray = this.encoder.getBytes(string2);
                this.comm.appendBytes(byArray, byArray.length, (byte)0);
            }
            this.moreResults2 = true;
            this.comm.sendPacket();
            while (!((packetResult = this.processSubPacket()) instanceof PacketEndTokenResult)) {
                if (!(packetResult instanceof PacketErrorResult)) continue;
                bl = false;
            }
        }
        catch (TdsUnknownPacketSubType tdsUnknownPacketSubType) {
            throw new SQLException("Unknown response. " + tdsUnknownPacketSubType.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Network problem. " + iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        this.database = string;
        return bl;
    }

    synchronized boolean changeSettings(String string, String string2) throws SQLException {
        boolean bl = true;
        try {
            if (string != null) {
                bl = this.changeDB(string);
            }
            if (bl && string2 != null && string2.length() > 0) {
                String string3 = string2;
                this.comm.startPacket(1);
                if (this.tdsVer == 70) {
                    this.comm.appendChars(string3);
                } else {
                    byte[] byArray = this.encoder.getBytes(string3);
                    this.comm.appendBytes(byArray, byArray.length, (byte)0);
                }
                this.moreResults2 = true;
                this.comm.sendPacket();
                boolean bl2 = false;
                while (!bl2) {
                    PacketResult packetResult = this.processSubPacket();
                    boolean bl3 = bl2 = packetResult instanceof PacketEndTokenResult && !((PacketEndTokenResult)packetResult).moreResults();
                    if (!(packetResult instanceof PacketErrorResult)) continue;
                    bl = false;
                }
            }
        }
        catch (TdsUnknownPacketSubType tdsUnknownPacketSubType) {
            throw new SQLException("Unknown response. " + tdsUnknownPacketSubType.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Network problem. " + iOException.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        return bl;
    }

    void close() throws SQLException {
        try {
            this.comm.close();
            this.sock = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error closing connection, " + iOException.getMessage());
        }
    }

    static int cvtNativeTypeToJdbcType(int n, int n2) throws TdsException {
        switch (n) {
            case 31: {
                return 0;
            }
            case 50: {
                return -7;
            }
            case 58: 
            case 61: 
            case 111: {
                return 93;
            }
            case 59: {
                return 7;
            }
            case 62: {
                return 6;
            }
            case 109: {
                switch (n2) {
                    case 4: {
                        return 7;
                    }
                    case 8: {
                        return 6;
                    }
                }
                return 6;
            }
            case 34: {
                return -4;
            }
            case 48: {
                return -6;
            }
            case 52: {
                return 5;
            }
            case 56: {
                return 4;
            }
            case 127: {
                return -5;
            }
            case 38: {
                switch (n2) {
                    case 1: {
                        return -6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 4;
                    }
                    case 8: {
                        return -5;
                    }
                }
                return 4;
            }
            case 60: 
            case 110: 
            case 122: {
                return 2;
            }
            case 106: {
                return 3;
            }
            case 108: {
                return 2;
            }
            case 45: 
            case 173: 
            case 189: {
                return -2;
            }
            case 37: 
            case 165: {
                switch (n2) {
                    case 3: 
                    case 80: {
                        return -2;
                    }
                }
                return -3;
            }
            case 225: {
                return -3;
            }
            case -17: 
            case 47: 
            case 175: {
                return 1;
            }
            case 39: 
            case 167: {
                switch (n2) {
                    case 1: {
                        return 1;
                    }
                }
                return 12;
            }
            case 35: {
                return -1;
            }
            case 103: {
                return 12;
            }
            case 104: {
                return -7;
            }
            case 239: {
                return -8;
            }
            case 231: {
                return -9;
            }
            case 99: {
                return -10;
            }
            case 36: {
                return -11;
            }
            case 98: {
                return -150;
            }
        }
        throw new TdsException("Unknown native data type " + Integer.toHexString(n & 0xFF));
    }

    protected void discardAllResults() throws IOException, TdsException {
        while (this.comm.isMoreIncomingPackets()) {
            this.comm.getBytes(this.comm.inBufferLen - this.comm.inBufferIndex);
            this.comm.getByte();
        }
        this.comm.getBytes(this.comm.inBufferLen - this.comm.inBufferIndex);
    }

    synchronized void discardResultSet(Columns columns) throws IOException, TdsException {
        String string = "";
        if (this.comm.peek() == -95) {
            this.processSubPacket();
            string = string + -95;
        }
        while (this.isResultRow()) {
            if (columns == null) {
                throw new TdsConfused();
            }
            this.comm.skip(1);
            this.getRow(columns);
        }
        if (this.comm.peek() == -29) {
            this.processSubPacket();
            string = string + -29;
        }
        if (this.comm.peek() == -1 || this.comm.peek() == -2 || this.comm.peek() == -3) {
            string = string + 123;
            this.processSubPacket();
            if (this.comm.inBufferIndex == this.comm.inBufferLen - 1) {
                this.comm.getByte();
            }
        }
        if (this.comm.inBufferIndex == this.comm.inBufferLen) {
            return;
        }
        if (this.comm.peek() == -86 || this.comm.peek() == -85) {
            this.processSubPacket();
            string = string + 8685;
        }
        if (this.isEndOfResults()) {
            this.processSubPacket();
        } else if (!this.isResultSet() && this.comm.peek() != -84) {
            throw new TdsConfused("Was expecting an end of results token.  Found a 0x" + this.comm.peek() + Integer.toHexString(this.comm.peek() & 0xFF) + "  " + string);
        }
    }

    void eatRow() throws TdsUnknownPacketSubType, IOException, TdsException {
        byte by = this.comm.peek();
        boolean bl = true;
        while (bl) {
            switch (by) {
                case -127: 
                case -96: 
                case -95: 
                case -92: 
                case -91: 
                case -87: 
                case -86: 
                case -85: 
                case -84: 
                case -83: 
                case -82: 
                case -47: 
                case -29: 
                case -3: 
                case -2: 
                case -1: 
                case 121: 
                case 124: {
                    bl = false;
                }
            }
            this.comm.getByte();
            by = this.comm.peek();
        }
    }

    private Object getCharValue(boolean bl) throws TdsException, IOException {
        int n = this.tdsVer != 70 ? this.comm.getByte() & 0xFF : this.comm.getTdsShort();
        String string = null;
        if (this.tdsVer == 70 && n == 65535) {
            string = null;
        } else if (n > 0) {
            string = bl ? this.comm.getString(n / 2) : this.encoder.getString(this.comm.getBytes(n));
        } else if (n == 0) {
            string = "";
        } else if (n < 0) {
            throw new TdsConfused("String with length<0");
        }
        return string;
    }

    private String getClientName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (string != null) {
            return string.toUpperCase();
        }
        return null;
    }

    TdsComm getComm() {
        return this.comm;
    }

    private Object getDatetimeValue(int n) throws IOException, TdsException {
        int n2 = n == 111 ? this.comm.getByte() : (n == 58 ? 4 : 8);
        Timestamp timestamp = null;
        TimeZone timeZone = TimeZone.getDefault();
        long l = -timeZone.getRawOffset();
        switch (n2) {
            case 0: {
                timestamp = null;
                return null;
            }
            case 8: {
                int n3 = this.comm.getTdsInt();
                int n4 = this.comm.getTdsInt();
                l += ((long)n3 - 25567L) * 24L * 60L * 60000L + Math.round((double)n4 * 10.0 / 3.0);
                break;
            }
            case 4: {
                int n5 = this.comm.getTdsShort();
                int n6 = this.comm.getTdsShort();
                l += ((long)n5 - 25567L) * 24L * 60L * 60000L + Math.round((double)n6 * 10.0 / 3.0);
                break;
            }
            default: {
                timestamp = null;
                throw new TdsNotImplemented("Don't now how to handle date with size of " + n2);
            }
        }
        timestamp = new Timestamp(l);
        l = l / 1000L * 1000L;
        if (timeZone.inDaylightTime(timestamp)) {
            ((java.util.Date)timestamp).setTime(l - 3600000L);
        }
        return timestamp;
    }

    private Object getDecimalValue(int n) throws TdsException, IOException, NumberFormatException {
        int n2 = this.comm.getByte() & 0xFF;
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = this.comm.getBytes(n2);
        byte[] byArray2 = new byte[n2 - 1];
        int n3 = 0;
        while (n3 < byArray2.length) {
            byArray2[n3] = byArray[n2 - n3 - 1];
            ++n3;
        }
        int n4 = byArray[0];
        if (n4 == 0) {
            n4 = -1;
        }
        BigInteger bigInteger = new BigInteger(n4, byArray2);
        return new BigDecimal(bigInteger, n);
    }

    private long getDstOffset(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        return calendar.get(16);
    }

    EncodingHelper getEncoder() {
        return this.encoder;
    }

    private Object getImageValue() throws TdsException, IOException {
        byte[] byArray;
        byte by = this.comm.getByte();
        if (by == 0) {
            byArray = null;
        } else {
            this.comm.skip(24);
            int n = this.comm.getTdsInt();
            if (n >= 0) {
                byArray = this.comm.getBytes(n);
            } else {
                throw new TdsConfused("String with length<0");
            }
        }
        return byArray;
    }

    private Object getIntValue(int n) throws IOException, TdsException {
        Long l;
        int n2;
        switch (n) {
            case 38: {
                n2 = this.comm.getByte();
                break;
            }
            case 56: {
                n2 = 4;
                break;
            }
            case 52: {
                n2 = 2;
                break;
            }
            case 48: {
                n2 = 1;
                break;
            }
            default: {
                Object var2_3 = null;
                throw new TdsNotImplemented("can't handle integer of type " + Integer.toHexString(n));
            }
        }
        switch (n2) {
            case 4: {
                l = new Long(this.comm.getTdsInt());
                break;
            }
            case 2: {
                l = new Long(this.comm.getTdsShort());
                break;
            }
            case 1: {
                int n3 = Tds.toUInt(this.comm.getByte());
                l = new Long(n3);
                break;
            }
            case 0: {
                l = null;
                break;
            }
            default: {
                Object var2_5 = null;
                throw new TdsConfused("Bad SYBINTN length of " + n2);
            }
        }
        return l;
    }

    private Object getMoneyValue(int n) throws IOException, TdsException {
        BigDecimal bigDecimal;
        int n2 = n == 110 ? this.comm.getByte() : this.lookupColumnSize((byte)n);
        if (n2 == 0) {
            bigDecimal = null;
        } else {
            BigInteger bigInteger = null;
            if (n2 == 4) {
                bigInteger = BigInteger.valueOf(this.comm.getTdsInt());
            } else if (n2 == 8) {
                byte by = this.comm.getByte();
                byte by2 = this.comm.getByte();
                byte by3 = this.comm.getByte();
                byte by4 = this.comm.getByte();
                byte by5 = this.comm.getByte();
                byte by6 = this.comm.getByte();
                byte by7 = this.comm.getByte();
                byte by8 = this.comm.getByte();
                long l = (long)(by5 & 0xFF) + ((long)(by6 & 0xFF) << 8) + ((long)(by7 & 0xFF) << 16) + ((long)(by8 & 0xFF) << 24) + ((long)(by & 0xFF) << 32) + ((long)(by2 & 0xFF) << 40) + ((long)(by3 & 0xFF) << 48) + ((long)(by4 & 0xFF) << 56);
                bigInteger = BigInteger.valueOf(l);
            } else {
                throw new TdsConfused("Don't know what to do with len of " + n2);
            }
            bigInteger = bigInteger.divide(BigInteger.valueOf(100L));
            bigDecimal = new BigDecimal(bigInteger, 2);
        }
        return bigDecimal;
    }

    private synchronized PacketRowResult getRow(Columns columns) throws TdsException, IOException {
        int n = 1;
        while (n <= columns.getColumnCount()) {
            Object object;
            int n2 = columns.getType(n);
            Logger.println("colno=" + n + " type=" + n2 + " offset=" + Integer.toHexString(this.comm.inBufferIndex));
            switch (n2) {
                case 38: 
                case 48: 
                case 52: 
                case 56: {
                    object = this.getIntValue(n2);
                    break;
                }
                case 34: {
                    object = this.getImageValue();
                    break;
                }
                case 35: {
                    object = this.getTextValue(false);
                    break;
                }
                case 99: {
                    object = this.getTextValue(true);
                    break;
                }
                case 39: 
                case 47: {
                    object = this.getCharValue(false);
                    break;
                }
                case -17: 
                case 103: {
                    object = this.getCharValue(true);
                    break;
                }
                case 59: {
                    object = this.readFloatN(4);
                    break;
                }
                case 62: {
                    object = this.readFloatN(8);
                    break;
                }
                case 109: {
                    byte by = this.comm.getByte();
                    object = this.readFloatN(by);
                    break;
                }
                case 60: 
                case 110: 
                case 122: {
                    object = this.getMoneyValue(n2);
                    break;
                }
                case 106: 
                case 108: {
                    object = this.getDecimalValue(columns.getScale(n));
                    break;
                }
                case 58: 
                case 61: 
                case 111: {
                    object = this.getDatetimeValue(n2);
                    break;
                }
                case 37: {
                    int n3;
                    Column column = (Column)columns.getColumns().elementAt(n - 1);
                    int n4 = n3 = this.tdsVer != 70 || column.getDisplaySize() == 16 ? this.comm.getByte() & 0xFF : this.comm.getTdsShort();
                    if (this.tdsVer == 70 && n3 == 65535) {
                        object = null;
                        break;
                    }
                    object = this.comm.getBytes(n3);
                    break;
                }
                case 45: {
                    int n5;
                    Column column = (Column)columns.getColumns().elementAt(n - 1);
                    int n6 = n5 = this.tdsVer != 70 || column.getDisplaySize() == 16 ? this.comm.getByte() & 0xFF : this.comm.getTdsShort();
                    if (this.tdsVer == 70 && n5 == 65535) {
                        object = null;
                        break;
                    }
                    object = this.comm.getBytes(n5);
                    break;
                }
                case 50: 
                case 104: {
                    if (n2 == 104 && this.comm.getByte() == 0) {
                        object = null;
                        break;
                    }
                    object = new Boolean(this.comm.getByte() != 0);
                    break;
                }
                default: {
                    object = null;
                    throw new TdsNotImplemented("Don't now how to handle column type 0x" + Integer.toHexString(n2));
                }
            }
            this.rowResult.setElementAt(object, n);
            ++n;
        }
        return this.rowResult;
    }

    int getServerType() {
        return this.serverType;
    }

    private int getSubPacketLength() throws IOException, TdsException {
        return this.comm.getTdsShort();
    }

    int getTdsVer() {
        return this.tdsVer;
    }

    private Object getTextValue(boolean bl) throws TdsException, IOException {
        String string;
        byte by = this.comm.getByte();
        if (by == 0) {
            string = null;
        } else {
            this.comm.skip(24);
            int n = this.comm.getTdsInt();
            if (n >= 0) {
                string = bl ? this.comm.getString(n / 2) : this.encoder.getString(this.comm.getBytes(n));
                if (" ".equals(string)) {
                    string = "";
                }
            } else {
                throw new TdsConfused("String with length<0");
            }
        }
        return string;
    }

    private static boolean isBlobType(int n) {
        return n == 35 || n == 34 || n == 99;
    }

    synchronized boolean isDoneInProc() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -1;
    }

    synchronized boolean isEndOfPacket() {
        return this.comm.isEndOfPacket();
    }

    synchronized boolean isEndOfResults() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -3 || by == -2;
    }

    synchronized boolean isErrorPacket() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -86;
    }

    private synchronized boolean isFixedSizeColumn(byte by) throws TdsException {
        switch (by) {
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 112: 
            case 122: {
                return true;
            }
            case -17: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 99: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return false;
            }
        }
        throw new TdsException("Unrecognized column type 0x" + Integer.toHexString(by));
    }

    private static boolean isLargeType(int n) {
        return n == -17 || n > 128;
    }

    synchronized boolean isMessagePacket() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -85;
    }

    synchronized boolean isMoreIncomingPackets() {
        return this.comm.isMoreIncomingPackets();
    }

    synchronized boolean isProcId() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == 124;
    }

    synchronized boolean isResultRow() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -47;
    }

    synchronized boolean isResultSet() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -96 || by == -127;
    }

    synchronized boolean isRetStat() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == 121;
    }

    synchronized boolean isTextUpdate() throws TdsException, IOException {
        byte by = this.comm.peek();
        return by == -84;
    }

    private boolean logon() throws SQLException, TdsUnknownPacketSubType, IOException, TdsException {
        PacketResult packetResult;
        boolean bl = true;
        byte by = 0;
        byte[] byArray = new byte[]{};
        if (this.tdsVer == 70) {
            this.send70Login();
        } else {
            this.comm.startPacket(2);
            byte[] byArray2 = this.encoder.getBytes(this.getClientName());
            this.comm.appendBytes(byArray2, 30, by);
            this.comm.appendByte(byArray2.length >= 30 ? (byte)30 : (byte)byArray2.length);
            byte[] byArray3 = this.encoder.getBytes(this.user);
            this.comm.appendBytes(byArray3, 30, by);
            this.comm.appendByte(byArray3.length >= 30 ? (byte)30 : (byte)byArray3.length);
            byte[] byArray4 = this.encoder.getBytes(this.password);
            this.comm.appendBytes(byArray4, 30, by);
            this.comm.appendByte(byArray4.length >= 30 ? (byte)30 : (byte)byArray4.length);
            byte[] byArray5 = this.encoder.getBytes("00000116");
            this.comm.appendBytes(byArray5, 8, by);
            this.comm.appendBytes(byArray, 16, by);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)-96);
            this.comm.appendByte((byte)36);
            this.comm.appendByte((byte)-52);
            this.comm.appendByte((byte)80);
            this.comm.appendByte((byte)18);
            this.comm.appendByte((byte)8);
            this.comm.appendByte((byte)3);
            this.comm.appendByte((byte)1);
            this.comm.appendByte((byte)6);
            this.comm.appendByte((byte)10);
            this.comm.appendByte((byte)9);
            this.comm.appendByte((byte)1);
            this.comm.appendByte((byte)1);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)0);
            this.comm.appendBytes(byArray, 7, by);
            byte[] byArray6 = this.encoder.getBytes(this.appName);
            this.comm.appendBytes(byArray6, 30, by);
            this.comm.appendByte(byArray6.length >= 30 ? (byte)30 : (byte)byArray6.length);
            byte[] byArray7 = this.encoder.getBytes(this.serverName);
            this.comm.appendBytes(byArray7, 30, by);
            this.comm.appendByte(byArray7.length >= 30 ? (byte)30 : (byte)byArray7.length);
            this.comm.appendBytes(byArray, 2, by);
            byte[] byArray8 = this.encoder.getBytes(this.password);
            this.comm.appendBytes(byArray8, 253, by);
            this.comm.appendByte(byArray8.length >= 253 ? (byte)-1 : (byte)(byArray8.length + 2));
            this.comm.appendByte((byte)4);
            this.comm.appendByte((byte)2);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)0);
            byte[] byArray9 = this.encoder.getBytes(this.progName);
            this.comm.appendBytes(byArray9, 10, by);
            this.comm.appendByte(byArray9.length >= 10 ? (byte)10 : (byte)byArray9.length);
            this.comm.appendByte((byte)6);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)0);
            this.comm.appendByte((byte)13);
            this.comm.appendByte((byte)17);
            byte[] byArray10 = this.encoder.getBytes("us_english");
            this.comm.appendBytes(byArray10, 30, by);
            this.comm.appendByte(byArray10.length >= 30 ? (byte)30 : (byte)byArray10.length);
            this.comm.appendByte((byte)1);
            this.comm.appendShort((short)0);
            this.comm.appendBytes(byArray, 8, by);
            this.comm.appendShort((short)0);
            this.comm.appendByte((byte)0);
            byte[] byArray11 = this.encoder.getBytes(this.charset);
            this.comm.appendBytes(byArray11, 30, by);
            this.comm.appendByte(byArray11.length >= 30 ? (byte)30 : (byte)byArray11.length);
            this.comm.appendByte((byte)1);
            byte[] byArray12 = this.encoder.getBytes("512");
            this.comm.appendBytes(byArray12, 6, by);
            this.comm.appendByte((byte)3);
            this.comm.appendBytes(byArray, 8, by);
            this.moreResults2 = true;
        }
        this.comm.sendPacket();
        while (!((packetResult = this.processSubPacket()) instanceof PacketEndTokenResult)) {
            if (!(packetResult instanceof PacketErrorResult)) continue;
            bl = false;
        }
        if (bl) {
            if (this.initialSettings == null) {
                this.initialSettings = "SET QUOTED_IDENTIFIER,ANSI_NULL_DFLT_ON,ANSI_PADDING,ANSI_WARNINGS,ANSI_NULLS ON SET TEXTSIZE 2147483647";
            }
            bl = this.changeSettings(this.database, this.initialSettings);
        }
        return bl;
    }

    private int lookupColumnSize(byte by) throws TdsException {
        switch (by) {
            case 48: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 56: {
                return 4;
            }
            case 59: {
                return 4;
            }
            case 62: {
                return 8;
            }
            case 61: {
                return 8;
            }
            case 58: {
                return 8;
            }
            case 50: {
                return 1;
            }
            case 60: {
                return 8;
            }
            case 112: 
            case 122: {
                return 4;
            }
        }
        throw new TdsException("Not fixed size column " + by);
    }

    boolean moreResults() {
        return this.moreResults2;
    }

    synchronized byte peek() throws IOException, TdsException {
        return this.comm.peek();
    }

    private PacketColumnInfoResult processColumnInfo() throws IOException, TdsException {
        int n;
        Columns columns = new Columns();
        int n2 = this.comm.getTdsShort();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n = -1;
            int n5 = -1;
            int n6 = -1;
            byte[] byArray = new byte[4];
            int n7 = 0;
            while (n7 < 4) {
                byArray[n7] = this.comm.getByte();
                ++n3;
                ++n7;
            }
            boolean bl = (byArray[2] & 1) > 0;
            boolean bl2 = (byArray[2] & 8) > 0;
            boolean bl3 = (byArray[2] & 0x10) > 0;
            byte by = this.comm.getByte();
            ++n3;
            if (by == 35 || by == 34) {
                this.comm.skip(4);
                n3 += 4;
                int n8 = this.comm.getTdsShort();
                n3 += 2;
                this.encoder.getString(this.comm.getBytes(n8));
                n3 += n8;
                n6 = Integer.MIN_VALUE;
            } else if (by == 106 || by == 108) {
                n6 = this.comm.getByte();
                ++n3;
                n5 = this.comm.getByte();
                ++n3;
                n = this.comm.getByte();
                ++n3;
            } else if (this.isFixedSizeColumn(by)) {
                n6 = this.lookupColumnSize(by);
            } else {
                n6 = this.comm.getByte() & 0xFF;
                ++n3;
            }
            ++n4;
            if (n != -1) {
                columns.setScale(n4, n);
            }
            if (n5 != -1) {
                columns.setPrecision(n4, n5);
            }
            columns.setType(n4, by);
            columns.setDisplaySize(n4, n6);
            columns.setNullable(n4, bl ? 1 : 0);
            columns.setAutoIncrement(n4, bl3);
            columns.setReadOnly(n4, !bl2);
        }
        n = n2 - n3;
        if (n != 0) {
            throw new TdsException("skipping " + n + " bytes");
        }
        return new PacketColumnInfoResult(columns);
    }

    private PacketColumnNamesResult processColumnNames() throws IOException, TdsException {
        Columns columns = new Columns();
        int n = this.comm.getTdsShort();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = this.comm.getByte();
            String string = this.encoder.getString(this.comm.getBytes(by));
            n2 = n2 + 1 + by;
            columns.setName(++n3, string);
            columns.setLabel(n3, string);
        }
        return new PacketColumnNamesResult(columns);
    }

    private PacketDoneInProcResult processDoneInProc(byte by) throws TdsException, IOException {
        byte by2 = this.comm.getByte();
        this.comm.skip(3);
        int n = this.comm.getTdsInt();
        PacketDoneInProcResult packetDoneInProcResult = new PacketDoneInProcResult(by, by2, n);
        if (!packetDoneInProcResult.moreResults()) {
            throw new TdsException("What? No more results with a DONEINPROC!");
        }
        if (packetDoneInProcResult.moreResults() && this.peek() == -1) {
            packetDoneInProcResult = (PacketDoneInProcResult)this.processSubPacket();
        }
        while (packetDoneInProcResult.moreResults() && (this.peek() == 124 || this.peek() == 121)) {
            if (this.peek() == 124) {
                this.processSubPacket();
                continue;
            }
            if (this.peek() != 121) continue;
            PacketRetStatResult packetRetStatResult = (PacketRetStatResult)this.processSubPacket();
            packetDoneInProcResult.setRetStat(packetRetStatResult.getRetStat());
        }
        this.cancelController.finishQuery(packetDoneInProcResult.wasCanceled(), packetDoneInProcResult.moreResults());
        return packetDoneInProcResult;
    }

    private PacketEndTokenResult processEndToken(byte by) throws TdsException, IOException {
        byte by2 = this.comm.getByte();
        this.comm.skip(3);
        int n = this.comm.getTdsInt();
        if (by == -1) {
            throw new TdsException("Internal error.  TDS_DONEINPROC  is no longer considered an end token");
        }
        PacketEndTokenResult packetEndTokenResult = new PacketEndTokenResult(by, by2, n);
        this.moreResults = packetEndTokenResult.moreResults();
        this.cancelController.finishQuery(packetEndTokenResult.wasCanceled(), packetEndTokenResult.moreResults());
        return packetEndTokenResult;
    }

    private PacketResult processEnvChange() throws IOException, TdsException {
        int n = this.getSubPacketLength();
        byte by = this.comm.getByte();
        switch (by) {
            case 3: {
                String string;
                int n2 = this.comm.getByte() & 0xFF;
                if (this.tdsVer == 70) {
                    string = this.comm.getString(n2);
                    this.comm.skip(n - 2 - n2 * 2);
                } else {
                    string = this.encoder.getString(this.comm.getBytes(n2));
                    this.comm.skip(n - 2 - n2);
                }
                this.setCharset(string);
                break;
            }
            default: {
                this.comm.skip(n - 1);
            }
        }
        return new PacketResult(-29);
    }

    private PacketMsgResult processMsg(byte by) throws IOException, TdsException {
        String string;
        SqlMessage sqlMessage = new SqlMessage();
        this.getSubPacketLength();
        sqlMessage.number = this.comm.getTdsInt();
        sqlMessage.state = this.comm.getByte();
        sqlMessage.level = this.comm.getByte();
        int n = this.comm.getTdsShort();
        sqlMessage.message = this.comm.getString(n);
        if (!this.showWarnings || sqlMessage.message == null || (string = sqlMessage.message.trim()).length() > 0) {
            // empty if block
        }
        int n2 = this.comm.getByte() & 0xFF;
        sqlMessage.server = this.comm.getString(n2);
        if (by != -85 && by != -86) {
            throw new TdsConfused("Was expecting a msg or error token.  Found 0x" + Integer.toHexString(by & 0xFF));
        }
        int n3 = this.comm.getByte() & 0xFF;
        sqlMessage.procName = this.comm.getString(n3);
        sqlMessage.line = this.comm.getByte();
        this.comm.getByte();
        this.lastServerMessage = sqlMessage;
        if (by == -86) {
            return new PacketErrorResult(by, sqlMessage);
        }
        return new PacketMsgResult(by, sqlMessage);
    }

    private PacketResult processProcId() throws IOException, TdsException {
        int n = 0;
        while (n < 8) {
            this.comm.getByte();
            ++n;
        }
        return new PacketResult(124);
    }

    private PacketRetStatResult processRetStat() throws IOException, TdsException {
        return new PacketRetStatResult(this.comm.getTdsInt());
    }

    PacketResult processSubPacket() throws TdsUnknownPacketSubType, IOException, TdsException {
        return this.processSubPacket(null);
    }

    synchronized PacketResult processSubPacket(Context context) throws TdsUnknownPacketSubType, IOException, TdsException {
        PacketResult packetResult = null;
        this.moreResults = false;
        byte by = this.comm.getByte();
        Logger.println("processSubPacket: " + by + " " + "moreResults: " + this.moreResults());
        switch (by) {
            case -29: {
                packetResult = this.processEnvChange();
                break;
            }
            case -86: {
                packetResult = this.processMsg(by);
                throw new TdsException(((PacketErrorResult)packetResult).getMsg().toString());
            }
            case -85: 
            case -27: {
                packetResult = this.processMsg(by);
                break;
            }
            case -84: {
                packetResult = this.processOutputParams();
                break;
            }
            case -83: {
                int n = this.getSubPacketLength();
                this.comm.skip(n);
                packetResult = new PacketResult(-83);
                break;
            }
            case 121: {
                packetResult = this.processRetStat();
                break;
            }
            case 124: {
                packetResult = this.processProcId();
                break;
            }
            case -1: {
                packetResult = this.processDoneInProc(by);
                break;
            }
            case -2: {
                packetResult = this.processEndToken(by);
                this.moreResults2 = ((PacketEndTokenResult)packetResult).moreResults();
                break;
            }
            case -3: {
                packetResult = this.processEndToken(by);
                this.moreResults2 = ((PacketEndTokenResult)packetResult).moreResults();
                break;
            }
            case -96: {
                packetResult = this.processColumnNames();
                break;
            }
            case -95: {
                packetResult = this.processColumnInfo();
                break;
            }
            case -91: 
            case -89: 
            case -88: {
                this.comm.skip(this.comm.getTdsShort());
                packetResult = new PacketUnknown(by);
                break;
            }
            case -92: {
                packetResult = this.processTabName();
                break;
            }
            case -87: {
                int n = this.comm.getTdsShort();
                this.comm.skip(n);
                packetResult = new PacketColumnOrderResult();
                break;
            }
            case -82: {
                int n = this.comm.getTdsShort();
                this.comm.skip(n);
                packetResult = new PacketControlResult();
                break;
            }
            case -47: {
                if (context == null) {
                    this.eatRow();
                    break;
                }
                packetResult = this.getRow(context.getColumnInfo());
                break;
            }
            case -127: {
                packetResult = this.processTds7Result();
                Columns columns = ((PacketColumnNamesResult)packetResult).getColumnNames();
                this.rowResult = new PacketRowResult(columns.getColumnCount());
                break;
            }
            default: {
                throw new TdsUnknownPacketSubType(by);
            }
        }
        return packetResult;
    }

    private PacketTabNameResult processTabName() throws IOException, TdsException {
        int n = this.comm.getTdsShort();
        this.comm.skip(n);
        return new PacketTabNameResult();
    }

    private PacketResult processTds7Result() throws IOException, TdsException {
        int n = this.comm.getTdsShort();
        Columns columns = new Columns();
        int n2 = 1;
        while (n2 <= n) {
            int n3;
            byte[] byArray = new byte[4];
            int n4 = 0;
            while (n4 < 4) {
                byArray[n4] = this.comm.getByte();
                ++n4;
            }
            boolean bl = (byArray[2] & 1) > 0;
            boolean bl2 = (byArray[2] & 8) > 0;
            boolean bl3 = (byArray[2] & 0x10) > 0;
            int n5 = this.comm.getByte() & 0xFF;
            if (n5 == 36) {
                n5 = 37;
            }
            if (n5 == 239) {
                n5 = -17;
            }
            int n6 = -1;
            if (Tds.isLargeType(n5)) {
                n6 = n5;
                if (n5 != -17) {
                    n5 -= 128;
                }
            }
            if (Tds.isBlobType(n5)) {
                n3 = this.comm.getTdsInt();
                this.comm.getString(this.comm.getTdsShort());
            } else {
                n3 = this.isFixedSizeColumn((byte)n5) ? this.lookupColumnSize((byte)n5) : (Tds.isLargeType(n6) ? this.comm.getTdsShort() : (int)this.comm.getByte());
            }
            int n7 = -1;
            int n8 = -1;
            if (n5 == 106 || n5 == 108) {
                n7 = this.comm.getByte();
                n8 = this.comm.getByte();
            }
            byte by = this.comm.getByte();
            String string = this.comm.getString(by);
            columns.setType(n2, n5);
            columns.setName(n2, string);
            columns.setLabel(n2, string);
            columns.setDisplaySize(n2, n3);
            columns.setNullable(n2, bl ? 1 : 0);
            columns.setAutoIncrement(n2, bl3);
            columns.setReadOnly(n2, !bl2);
            if (n7 != -1) {
                columns.setPrecision(n2, n7);
            }
            if (n8 != -1) {
                columns.setScale(n2, n8);
            }
            ++n2;
        }
        return new PacketColumnNamesResult(columns);
    }

    private Object readFloatN(int n) throws TdsException, IOException {
        Number number;
        switch (n) {
            case 8: {
                long l = this.comm.getTdsInt64();
                number = new Double(Double.longBitsToDouble(l));
                break;
            }
            case 4: {
                int n2 = this.comm.getTdsInt();
                number = new Float(Float.intBitsToFloat(n2));
                break;
            }
            case 0: {
                number = null;
                break;
            }
            default: {
                throw new TdsNotImplemented("Don't now how to handle float with size of " + n + "(0x" + Integer.toHexString(n & 0xFF) + ")");
            }
        }
        return number;
    }

    private void send70Login() throws IOException {
        byte[] byArray = new byte[]{6, -125, -14, -8, -1, 0, 0, 0, 0, -32, 3, 0, 0, -120, -1, -1, -1, 54, 4, 0, 0};
        byte[] byArray2 = new byte[]{0, 64, 51, -102, 107, 80};
        byte[] byArray3 = this.encoder.getBytes("NTLMSSP");
        String string = "DB-Library";
        byte by = 0;
        byte[] byArray4 = new byte[]{};
        String string2 = "CDR";
        short s = (short)(86 + 2 * (this.user.length() + this.password.length() + string2.length() + this.serverName.length() + string.length()));
        short s2 = (short)(s + 48);
        this.comm.startPacket(16);
        this.comm.appendTdsShort(s2);
        this.comm.appendBytes(byArray4, 5, by);
        this.comm.appendByte((byte)112);
        this.comm.appendBytes(byArray4, 7, by);
        this.comm.appendBytes(byArray, 21, by);
        short s3 = 86;
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)this.user.length());
        s3 = (short)(s3 + this.user.length() * 2);
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)this.password.length());
        s3 = (short)(s3 + this.password.length() * 2);
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)string2.length());
        s3 = (short)(s3 + string2.length() * 2);
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)this.serverName.length());
        s3 = (short)(s3 + this.serverName.length() * 2);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)string.length());
        s3 = (short)(s3 + string.length() * 2);
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)0);
        this.comm.appendTdsShort(s3);
        this.comm.appendTdsShort((short)0);
        this.comm.appendBytes(byArray2, 6, by);
        this.comm.appendTdsShort(s);
        this.comm.appendTdsShort((short)48);
        this.comm.appendTdsShort(s2);
        this.comm.appendTdsShort((short)0);
        String string3 = Tds.tds7CryptPass(this.password);
        this.comm.appendChars(this.user);
        this.comm.appendChars(string3);
        this.comm.appendChars(string2);
        this.comm.appendChars(this.serverName);
        this.comm.appendChars(string);
        this.comm.appendBytes(byArray3, 7, by);
        this.comm.appendByte((byte)0);
        this.comm.appendByte((byte)1);
        this.comm.appendBytes(byArray4, 3, by);
        this.comm.appendByte((byte)6);
        this.comm.appendByte((byte)-126);
        this.comm.appendBytes(byArray4, 22, by);
        this.comm.appendByte((byte)48);
        this.comm.appendBytes(byArray4, 7, by);
        this.comm.appendByte((byte)48);
        this.comm.appendBytes(byArray4, 3, by);
    }

    private void sendSybChar(String string, int n) throws IOException {
        byte[] byArray = string == null ? new byte[]{} : this.encoder.getBytes(string);
        if (byArray.length > 255 && this.tdsVer != 70) {
            throw new IOException("String too long");
        }
        if (byArray.length > 256) {
            this.comm.appendByte((byte)-89);
            this.comm.appendTdsShort((short)n);
            this.comm.appendTdsShort((short)byArray.length);
        } else {
            this.comm.appendByte((byte)39);
            this.comm.appendByte((byte)n);
            this.comm.appendByte((byte)byArray.length);
        }
        this.comm.appendBytes(byArray);
    }

    private void sendSybImage(byte[] byArray) throws IOException {
        int n = byArray != null ? byArray.length : 0;
        this.comm.appendTdsInt(n);
        this.comm.appendTdsInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.comm.appendByte(byArray[n2]);
            ++n2;
        }
    }

    private void setCharset(String string) {
        if (string == null || string.length() > 30) {
            string = "iso_1";
        }
        if (!string.equals(this.charset)) {
            this.encoder = EncodingHelper.getHelper(string);
            if (this.encoder == null) {
                string = "iso_1";
                this.encoder = EncodingHelper.getHelper(string);
            }
            this.charset = string;
        }
    }

    void stringToByte(byte[] byArray, StringBuffer stringBuffer, int n, String string) {
        if (string == null) {
            string = "";
        }
        int n2 = 2 * stringBuffer.length() + 86;
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >>> 8);
        n2 = string.length();
        byArray[n + 2] = (byte)n2;
        byArray[n + 3] = (byte)(n2 >>> 8);
        stringBuffer.append(string);
    }

    synchronized PacketResult submitProcedure(String string, SQLWarningChain sQLWarningChain) throws SQLException {
        PacketResult packetResult = null;
        Object var4_4 = null;
        boolean bl = true;
        SQLException sQLException = null;
        try {
            PacketResult packetResult2;
            this.executeQuery(string, null, 0, false);
            byte by = (byte)(this.comm.peek() & 0xFF);
            while (!((packetResult2 = this.processSubPacket()) instanceof PacketEndTokenResult)) {
                if (packetResult2 instanceof PacketErrorResult) {
                    packetResult = packetResult2;
                    bl = false;
                    sQLException = ((PacketErrorResult)packetResult2).getMsg().toSQLException();
                    continue;
                }
                if (packetResult2 instanceof PacketMsgResult) {
                    sQLWarningChain.addOrReturn((PacketMsgResult)packetResult2);
                    continue;
                }
                throw new SQLException("Was expecting the end of result, found a " + packetResult2.getClass().getName());
            }
            if (packetResult == null) {
                packetResult = packetResult2;
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Network error" + iOException.getMessage());
        }
        catch (TdsUnknownPacketSubType tdsUnknownPacketSubType) {
            throw new SQLException(tdsUnknownPacketSubType.getMessage());
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        if (!bl) {
            throw sQLException;
        }
        return packetResult;
    }

    private static String tds7CryptPass(String string) {
        int n = 23130;
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = string.charAt(n3) ^ n;
            int n5 = n4 >> 4 & 0xF0F;
            int n6 = n4 << 4 & 0xF0F0;
            cArray[n3] = (char)(n5 | n6);
            ++n3;
        }
        return new String(cArray);
    }

    byte[] toByteArray(String string) {
        int n = 0;
        int n2 = string.length();
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            byArray[n++] = (byte)c;
            byArray[n++] = (byte)(c >> 8);
            ++n3;
        }
        return byArray;
    }

    static String toNativeSql(String string, int n) throws SQLException {
        MSSqlServerEscapeProcessor mSSqlServerEscapeProcessor = new MSSqlServerEscapeProcessor(string);
        return mSSqlServerEscapeProcessor.nativeString();
    }

    public String toString() {
        return "database: " + this.database + ", " + super.toString();
    }

    private static int toUInt(byte by) {
        int n = by & 0xFF;
        return n;
    }

    private void waitForDataOrTimeout(Statement statement, int n) throws IOException, TdsException {
        if (n == 0 || statement == null) {
            this.comm.peek();
        } else {
            TimeoutHandler timeoutHandler = new TimeoutHandler(statement, n);
            timeoutHandler.start();
            this.comm.peek();
            timeoutHandler.stop();
            timeoutHandler = null;
        }
    }

    boolean hitEndOfData() {
        return this.isEndOfPacket() && !this.isMoreIncomingPackets();
    }

    /*
     * Unable to fully structure code
     */
    void parseOutTableNames(String var1_1) {
        var2_2 = new StringTokenizer(var1_1, " \t\n\r\f,", true);
        var3_3 = null;
        var4_4 = "";
        var5_5 = new Vector<String>();
        var6_6 = false;
        var7_7 = true;
        var8_8 = false;
        try {
            while (var2_2.hasMoreTokens()) {
                if (var3_3 != null && !var3_3.equalsIgnoreCase("FROM")) {
                    var3_3 = var2_2.nextToken();
                } else if (var3_3 == null) {
                    var3_3 = var2_2.nextToken();
                }
                if (!var3_3.equalsIgnoreCase("FROM") && !var3_3.equalsIgnoreCase("JOIN") && !var3_3.equalsIgnoreCase("INTO")) continue;
                while (var2_2.hasMoreTokens()) {
                    if ((var7_7 || var8_8) && var2_2.hasMoreTokens()) {
                        var3_3 = var2_2.nextToken();
                    }
                    if (var7_7 && !var3_3.equalsIgnoreCase(" ")) {
                        var4_4 = var4_4 + var3_3;
                        var7_7 = false;
                        if (var2_2.hasMoreTokens()) {
                            var3_3 = var2_2.nextToken();
                        }
                    }
                    if (var3_3.equalsIgnoreCase(" ")) {
                        var8_8 = true;
                        continue;
                    }
                    if (var3_3.startsWith(".")) {
                        var4_4 = var4_4 + var3_3;
                    }
                    if (var3_3.equalsIgnoreCase(",")) {
                        var8_8 = false;
                        var6_6 = true;
                        var5_5.addElement(var4_4);
                        var4_4 = "";
                        if (var2_2.hasMoreTokens()) {
                            var3_3 = var2_2.nextToken();
                        }
                    }
                    if (!var3_3.equalsIgnoreCase("FROM")) ** GOTO lbl47
                    var7_7 = true;
                    break;
lbl-1000:
                    // 1 sources

                    {
                        if (var3_3.equalsIgnoreCase(" ")) {
                            if (!var2_2.hasMoreTokens()) continue;
                            var3_3 = var2_2.nextToken();
                            continue;
                        }
                        var4_4 = var4_4 + var3_3;
                        var6_6 = false;
                        if (!var2_2.hasMoreTokens()) continue;
                        var3_3 = var2_2.nextToken();
lbl47:
                        // 5 sources

                        ** while (var6_6)
                    }
lbl48:
                    // 1 sources

                }
                var5_5.addElement(var4_4);
                var4_4 = "";
            }
        }
        catch (NoSuchElementException var9_9) {
            // empty catch block
        }
        this.tables = var5_5;
    }

    synchronized void executeQuery(String string, Statement statement, int n, boolean bl) throws IOException, SQLException, TdsException {
        if (!this.connection.getDatabase().trim().equalsIgnoreCase(this.database.trim())) {
            this.changeDB(this.connection.getDatabase());
        }
        if (string.trim().substring(0, 6).equalsIgnoreCase("select") || bl) {
            this.parseOutTableNames(string);
        }
        this.cancelController.setQueryInProgressFlag();
        this.comm.startPacket(1);
        if (this.tdsVer == 70) {
            this.comm.appendChars(string);
        } else {
            byte[] byArray = this.encoder.getBytes(string);
            this.comm.appendBytes(byArray, byArray.length, (byte)0);
        }
        this.moreResults2 = true;
        this.comm.sendPacket();
        this.waitForDataOrTimeout(statement, n);
    }

    Vector getTableNames() {
        return this.tables;
    }

    PacketOutputParamResult processOutputParams() throws TdsException, IOException {
        int n = this.getSubPacketLength();
        String string = this.comm.getString(this.comm.getByte() & 0xFF);
        this.comm.getBytes(5);
        int n2 = this.comm.getByte();
        if (n2 <= 0) {
            n2 = 256 + n2;
        }
        byte by = this.comm.getByte();
        Object object = null;
        switch (n2) {
            case 38: 
            case 48: 
            case 52: 
            case 56: {
                object = this.getIntValue(n2);
                break;
            }
            case 34: {
                object = this.getImageValue();
                break;
            }
            case 35: {
                object = this.getTextValue(false);
                break;
            }
            case 99: {
                object = this.getTextValue(true);
                break;
            }
            case 39: 
            case 47: 
            case 167: 
            case 175: {
                this.comm.skip(1);
                object = this.getCharValue(false);
                break;
            }
            case -17: 
            case 103: 
            case 231: 
            case 239: {
                object = this.getCharValue(true);
                break;
            }
            case 59: {
                object = this.readFloatN(4);
                break;
            }
            case 62: {
                object = this.readFloatN(8);
                break;
            }
            case 109: {
                byte by2 = this.comm.getByte();
                object = this.readFloatN(by2);
                break;
            }
            case 60: 
            case 110: 
            case 122: {
                object = this.getMoneyValue(n2);
                break;
            }
            case 106: 
            case 108: {
                byte by3 = this.comm.getByte();
                byte by4 = this.comm.getByte();
                object = this.getDecimalValue(by4);
                break;
            }
            case 58: 
            case 61: 
            case 111: {
                object = this.getDatetimeValue(n2);
                break;
            }
            case 37: 
            case 45: 
            case 165: 
            case 173: 
            case 189: 
            case 225: {
                int n3;
                this.comm.skip(1);
                int n4 = n3 = this.tdsVer == 70 ? this.comm.getTdsShort() : this.comm.getByte() & 0xFF;
                if (this.tdsVer == 70 && n3 == 65535) {
                    object = null;
                    break;
                }
                object = this.comm.getBytes(n3);
                break;
            }
            case 50: 
            case 104: {
                if (n2 == 104 && this.comm.getByte() == 0) {
                    object = null;
                    break;
                }
                object = new Boolean(this.comm.getByte() != 0);
                break;
            }
            default: {
                object = null;
                throw new TdsNotImplemented("Don't now how to handle column type 0x" + Integer.toHexString(n2));
            }
        }
        return new PacketOutputParamResult(-84, object);
    }
}

