/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.PacketResult;
import com.thinweb.tds.TdsConfused;

final class PacketDoneInProcResult
extends PacketResult {
    private byte status;
    private int rowCount;
    private int retStat;
    private boolean isRetStatSet;

    public PacketDoneInProcResult(byte by, byte by2, int n) throws TdsConfused {
        super(by);
        if (by != -1) {
            throw new TdsConfused("Error processing DoneInProcResult.");
        }
        this.status = by2;
        this.rowCount = n;
        this.isRetStatSet = false;
    }

    public int getRetStat() {
        return this.retStat;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean haveRetStat() {
        return this.isRetStatSet;
    }

    public boolean moreResults() {
        return (this.status & 1) != 0;
    }

    public void setRetStat(int n) {
        this.retStat = n;
        this.isRetStatSet = true;
    }

    public String toString() {
        return "token type- " + Integer.toHexString(this.getPacketType() & 0xFF) + ", rowCount- " + this.getRowCount() + ", moreResults- " + this.moreResults() + ", wasCanceled- " + this.wasCanceled() + ", " + (this.haveRetStat() ? "retstat- " + this.getRetStat() : "no retstat");
    }

    public boolean wasCanceled() {
        return (this.status & 0x20) != 0;
    }
}

