/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Cacheable;
import java.io.IOException;
import java.io.InputStream;

public abstract class CacheableInputStream
extends InputStream
implements Cacheable {
    protected InputStream _is;
    protected CacheManager _cm;
    protected int _state = 0;

    public void setManager(CacheManager cacheManager) {
        this._cm = cacheManager;
    }

    public void open(boolean bl) throws IOException {
        this._state = bl ? 2 : 1;
    }

    public int read() throws IOException {
        this.checkRead();
        return this._is.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkRead();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this._is.read(byArray, n + n3, n2);
            if (n4 < 0) {
                if (n3 != 0) break;
                return -1;
            }
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        this.checkRead();
        return this._is.skip(l);
    }

    public void close() throws IOException {
        this._state = 0;
        this._cm.dead(this);
        this._cm = null;
    }

    public void resetInputStream(InputStream inputStream) {
        this._is = inputStream;
    }

    public void reset() throws IOException {
        if (this._state == 2) {
            this.cache();
        }
        ((CacheStream)this._is).reset();
    }

    public void checkRead() throws IOException {
        if (this._state == 0) {
            CacheManager.raiseIOException("IO_NOT_OPEN");
        }
    }

    public int getState() {
        return this._state;
    }

    public abstract void cache() throws IOException;

    public abstract void clear() throws IOException;
}

