/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.utils.BufferInterval;

public class BufferPool {
    public static final int BUFF_SIZE = 4096;
    private BufferInterval _head;
    private int _bufSize;
    private int _packetSize;
    private InStreamMgr _inMgr;
    private boolean _noLimit;
    protected static final boolean DEBUG = false;

    public BufferPool(InStreamMgr inStreamMgr, int n, int n2) {
        this._inMgr = inStreamMgr;
        this._noLimit = n <= 0;
        this._packetSize = n2;
        this._bufSize = n <= 0 ? (4096 < 2 * n2 ? 2 * n2 : 4096) : (n < 2 * n2 ? 2 * n2 : n);
        this._head = this.makeBuffer();
    }

    public void setNetBufSize(int n) {
        if (this._packetSize == n) {
            return;
        }
        this._packetSize = n;
        if (this._bufSize < 2 * n && !this._noLimit) {
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                while (this._head != null) {
                    BufferInterval bufferInterval = this._head;
                    if (bufferInterval._length != this._bufSize) break;
                    BufferInterval bufferInterval2 = this._head._next;
                    this._head.detach();
                    this._head = bufferInterval2;
                }
                this._bufSize = 2 * n;
                this.put(this.makeBuffer());
            }
        }
        if (this._bufSize < 2 * n) {
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                this._bufSize = 2 * n;
            }
        }
    }

    public void put(BufferInterval bufferInterval) {
        if (this._noLimit) {
            return;
        }
        boolean bl = false;
        block3: while (true) {
            if (bl) {
                this.checkMgr();
                return;
            }
            bl = true;
            BufferPool bufferPool = this;
            synchronized (bufferPool) {
                if (bufferInterval == null) {
                    return;
                }
                if (this._head == null) {
                    this._head = bufferInterval;
                    continue;
                }
                boolean bl2 = false;
                BufferInterval bufferInterval2 = this._head;
                while (bufferInterval2 != null) {
                    if (bufferInterval2.merge(bufferInterval, bl2)) {
                        if (bl2) {
                            bufferInterval2.detach();
                            break;
                        }
                        bufferInterval = bufferInterval2;
                        bl2 = true;
                    }
                    bufferInterval2 = bufferInterval2._next;
                }
                if (bl2) {
                    if (bufferInterval._prev == null || bufferInterval._prev._length >= bufferInterval._length) {
                        continue;
                    }
                    bufferInterval.detach();
                }
                BufferInterval bufferInterval3 = null;
                BufferInterval bufferInterval4 = this._head;
                while (bufferInterval4 != null) {
                    if (bufferInterval._length >= bufferInterval4._length) {
                        if (bufferInterval4 == this._head) {
                            this._head = bufferInterval;
                        }
                        bufferInterval.attachBefore(bufferInterval4);
                        continue block3;
                    }
                    bufferInterval3 = bufferInterval4;
                    bufferInterval4 = bufferInterval4._next;
                }
                bufferInterval.attachAfter(bufferInterval3);
            }
        }
    }

    private void checkMgr() {
        InStreamMgr inStreamMgr = this._inMgr;
        synchronized (inStreamMgr) {
            if (this._head != null && this._head._length >= this._packetSize) {
                this._inMgr.notify();
            }
        }
    }

    public synchronized BufferInterval getBI(boolean bl) {
        if (this._head == null || this._head._length < this._packetSize) {
            if (bl || this._noLimit) {
                return this.makeBuffer();
            }
            return null;
        }
        BufferInterval bufferInterval = this._head;
        BufferInterval bufferInterval2 = this._head._next;
        this._head.detach();
        this._head = bufferInterval2;
        return bufferInterval;
    }

    private BufferInterval makeBuffer() {
        byte[] byArray = new byte[this._bufSize];
        return new BufferInterval(byArray, 0, byArray.length, this);
    }
}

