/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxASFException;
import com.informix.jdbc.IfmxCancelQuery;
import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class IfxStatement
implements IfmxStatement {
    private String cursorName = null;
    protected boolean cursorOpen = false;
    private int maxRows = 0;
    private Trace trace = null;
    private boolean statementProcessed = false;
    private SQLWarning statementWarnings = null;
    private boolean calledgetResultSet = false;
    private boolean calledgetUpdateCount = false;
    private boolean autoFree = false;
    protected IfxConnection jconn = null;
    public String commandString = null;
    protected IfxResultSet savedResult = null;
    boolean escapeProcessing = true;
    protected int numqmarks = 0;
    private int ResultSetType = 1003;
    private int ResultSetConcurrency = 1007;
    private int FetchSize = 0;
    private int FetchDirection = 1000;
    protected Vector BatchVector = new Vector();
    protected boolean executeBatchInProgress = false;
    protected IfxResultSetMetaData outputMetaData = null;
    protected int statementType = 0;
    private int maxFieldSize;
    protected boolean Closed = false;
    private int timeoutSeconds = 0;
    private boolean versionCheckOK = false;
    Class cquery = null;

    IfxStatement(IfxConnection ifxConnection) {
        this.jconn = ifxConnection;
        if (this.jconn != null) {
            this.autoFree = ((IfxSqliConnect)this.jconn).getAutoFree();
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        if (this.savedResult != null) {
            this.savedResult.closePrev();
            this.savedResult.init();
        }
        return this.executeQueryImpl(false);
    }

    public ResultSet executeQuery(String string, boolean bl) throws SQLException {
        this.validate(string);
        if (this.savedResult != null) {
            this.savedResult.closePrev();
            this.savedResult.init();
        }
        return this.executeQueryImpl(bl);
    }

    void validate(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn == null || this.jconn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        if (this.savedResult != null) {
            this.savedResult.closePrev();
            this.savedResult.init();
        }
        return this.executeUpdateImpl();
    }

    public void close() throws SQLException {
        this.Closed = true;
        if (this.savedResult != null) {
            this.savedResult.closeNow();
            this.savedResult.close();
            this.savedResult.releaseBlob();
            this.savedResult = null;
        }
        if (this.jconn != null) {
            ((IfxSqliConnect)this.jconn).removeFromStmtList(this);
        }
        this.cursorName = null;
        this.statementWarnings = null;
        this.jconn = null;
        this.commandString = null;
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79877, this.jconn);
        }
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLMinorException(-79731, -80007, this.jconn);
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.timeoutSeconds;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (IfxDriver.compareJDKVersion("1.4") < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
        }
        if (!this.versionCheckOK) {
            try {
                Class<?> clazz = Class.forName("java.util.Timer");
                Class<?> clazz2 = Class.forName("java.util.TimerTask");
                this.cquery = Class.forName("com.informix.jdbc.IfxCancelQueryImpl");
                this.versionCheckOK = true;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
            }
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
        this.timeoutSeconds = n;
    }

    public void cancel() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (IfxDriver.compareJDKVersion("1.4") < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": Statement.cancel().", this.jconn);
        }
        try {
            ((IfxSqliConnect)this.jconn).asfconn.sOOBSocket();
        }
        catch (IfxASFException ifxASFException) {
            throw IfxErrMsg.getSQLException(-908, this.jconn);
        }
    }

    private void addWarning(String string, String string2) {
        if (this.statementWarnings == null) {
            this.statementWarnings = string2 != null ? IfxWarnMsg.getSQLWarning(string2, string, this.jconn) : IfxWarnMsg.getSQLWarning(string, this.jconn);
        } else if (string2 != null) {
            SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string2, string, this.jconn);
            this.statementWarnings.setNextWarning(sQLWarning);
        } else {
            SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string, this.jconn);
            this.statementWarnings.setNextWarning(sQLWarning);
        }
    }

    void chainWarnings(SQLWarning sQLWarning) throws SQLException {
        if (sQLWarning != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(sQLWarning);
            } else {
                this.statementWarnings = sQLWarning;
            }
        }
    }

    protected void transferWarnings() throws SQLException {
        SQLWarning sQLWarning;
        if (this.savedResult != null && (sQLWarning = this.savedResult.getWarnings()) != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(sQLWarning);
            } else {
                this.statementWarnings = sQLWarning;
            }
            this.savedResult.clearWarnings();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.savedResult != null) {
            this.chainWarnings(this.savedResult.getWarnings());
        }
        return this.statementWarnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.savedResult != null) {
            this.savedResult.clearWarnings();
        }
        this.statementWarnings = null;
    }

    public void setCursorName(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (string.length() <= 0) {
            throw IfxErrMsg.getSQLException(-79732, this.jconn);
        }
        this.cursorName = string;
    }

    public boolean execute(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        if (this.savedResult != null) {
            this.savedResult.closePrev();
            this.savedResult.init();
        }
        return this.executeImpl();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.calledgetResultSet) {
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetResultSet = true;
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        if (this.savedResult.getUpdateCount() != -1) {
            return null;
        }
        return this.savedResult;
    }

    public int getUpdateCount() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.calledgetUpdateCount) {
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetUpdateCount = true;
        if (this.savedResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        return this.savedResult.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.savedResult != null) {
            this.savedResult.clearWarnings();
            this.savedResult.close();
        }
        return false;
    }

    public String getCursorName() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.cursorName != null) {
            return this.cursorName;
        }
        return this.getGeneratedCursor();
    }

    private String getGeneratedCursor() throws SQLException {
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        this.cursorName = this.jconn.getGeneratedCursor();
        return this.cursorName;
    }

    int getqmarks() {
        return this.numqmarks;
    }

    void setqmarks(int n) {
        this.numqmarks = n;
    }

    public Connection getConnection() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.jconn;
    }

    protected ResultSet executeQueryImpl(boolean bl) throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        IfmxCancelQuery ifmxCancelQuery = null;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery = (IfmxCancelQuery)this.cquery.newInstance();
                ifmxCancelQuery.startCancel(this, this.timeoutSeconds);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        if (this.outputMetaData != null) {
            this.savedResult.executeQuery(this.outputMetaData, bl);
        } else {
            this.savedResult.executeQuery(bl);
        }
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery.stopCancel();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        this.transferWarnings();
        return this.savedResult;
    }

    int executeUpdateImpl() throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        int n = 0;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        n = this.savedResult.executeUpdate();
        this.transferWarnings();
        return n;
    }

    protected boolean executeImpl() throws SQLException {
        this.calledgetUpdateCount = false;
        this.calledgetResultSet = false;
        IfmxCancelQuery ifmxCancelQuery = null;
        if (this.savedResult == null) {
            this.savedResult = new IfxResultSet(this);
        }
        this.clearWarnings();
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery = (IfmxCancelQuery)this.cquery.newInstance();
                ifmxCancelQuery.startCancel(this, this.timeoutSeconds);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        boolean bl = this.outputMetaData != null ? this.savedResult.executeExecute(this.outputMetaData) : this.savedResult.executeExecute();
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery.stopCancel();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        this.transferWarnings();
        return bl;
    }

    public int getSerial() throws SQLException {
        if (this.savedResult == null) {
            return 0;
        }
        return this.savedResult.getSerial();
    }

    public long getSerial8() throws SQLException {
        if (this.savedResult == null) {
            return 0L;
        }
        return this.savedResult.getSerial8();
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n != 1000 && n != 1001 && n != 1002) {
            throw IfxErrMsg.getSQLException(-79764, this.jconn);
        }
        if (this.getResultSetType() == 1003 && n != 1000) {
            throw IfxErrMsg.getSQLException(-79765, this.jconn);
        }
        this.FetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.FetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0 || this.maxRows != 0 && n > this.maxRows) {
            throw IfxErrMsg.getSQLException(-79766, this.jconn);
        }
        this.FetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.FetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.ResultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.ResultSetType;
    }

    public void addBatch(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(string);
        this.commandString = this.commandString.trim();
        if (!this.commandString.endsWith(";")) {
            this.commandString = this.commandString + ";";
        }
        this.BatchVector.addElement(this.commandString);
    }

    public void clearBatch() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.BatchVector.removeAllElements();
        this.scrubBatch();
    }

    protected void scrubBatch() throws SQLException {
        IfxSqli ifxSqli;
        this.executeBatchInProgress = false;
        if (this.savedResult != null && (ifxSqli = (IfxSqli)this.savedResult.prot) != null) {
            ifxSqli.clearBatch();
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] executeBatch() throws SQLException {
        block11: {
            var1_1 = null;
            if (this.Closed) {
                throw IfxErrMsg.getSQLException(-79865, this.jconn);
            }
            this.executeBatchInProgress = true;
            this.commandString = "";
            if (this.BatchVector.size() == 0) {
                return new int[0];
            }
            var2_2 = 0;
            while (var2_2 < this.BatchVector.size()) {
                this.commandString = this.commandString + this.BatchVector.elementAt(var2_2);
                ++var2_2;
            }
            if (((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
                block12: {
                    try {
                        var3_3 = this.executeUpdateImpl();
                        var4_7 = (IfxSqli)this.savedResult.prot;
                        var5_9 = var4_7.batchRowStatus;
                        var1_1 = new int[var5_9.size()];
                        var6_11 = 0;
                        while (var6_11 < var5_9.size()) {
                            var1_1[var6_11] = (Integer)var5_9.get(var6_11);
                            ++var6_11;
                        }
                        var4_7.batchRowStatus.clear();
                        break block11;
                    }
                    catch (SQLException var3_4) {
                        var4_8 = (IfxSqli)this.savedResult.prot;
                        var5_10 = var4_8.batchRowStatus;
                        this.executeBatchInProgress = false;
                        if (var5_10 == null) break block12;
                        var1_1 = new int[var5_10.size()];
                        var6_12 = 0;
                        ** while (var6_12 < var5_10.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var1_1[var6_12] = (Integer)var5_10.get(var6_12);
                        ++var6_12;
                        continue;
                    }
lbl37:
                    // 1 sources

                    var4_8.batchRowStatus.clear();
                    this.clearBatch();
                    throw new BatchUpdateException(var3_4.getMessage(), var3_4.getSQLState(), var3_4.getErrorCode(), var1_1);
                }
                this.clearBatch();
                throw new BatchUpdateException(var3_4.getMessage(), var3_4.getSQLState(), var3_4.getErrorCode(), new int[0]);
            }
            try {
                var1_1 = new int[this.BatchVector.size()];
                var1_1[0] = this.executeUpdateImpl();
                var3_5 = 1;
                while (var3_5 < this.BatchVector.size()) {
                    var1_1[var3_5] = -2;
                    ++var3_5;
                }
            }
            catch (SQLException var3_6) {
                this.clearBatch();
                throw new BatchUpdateException(var3_6.getMessage(), var3_6.getSQLState(), var3_6.getErrorCode(), new int[0]);
            }
        }
        this.clearBatch();
        this.executeBatchInProgress = false;
        return var1_1;
    }

    protected void setResultSetType(int n) throws SQLException {
        if (n != 1004 && n != 1003) {
            this.addWarning(IfxErrMsg.getSQLException(-79775, this.jconn).toString(), "01000");
        }
        this.ResultSetType = n == 1005 ? 1004 : n;
    }

    protected void setResultSetConcurrency(int n) throws SQLException {
        if (n != 1008 && n != 1007) {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
        this.ResultSetConcurrency = n;
    }

    public void setAutoFree(boolean bl) {
        this.autoFree = bl && this.jconn.isAutoFree() ? bl : false;
    }

    public boolean getAutoFree() {
        return this.autoFree;
    }

    protected void setStatementType(int n) {
        this.statementType = n;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.getMoreResults(int)", this.jconn);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.getGeneratedKeys().", this.jconn);
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.executeUpdate(String,int).", this.jconn);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.executeUpdate(String,int[])", this.jconn);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.executeUpdate(String,String[])", this.jconn);
    }

    public boolean execute(String string, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.execute(String,int)", this.jconn);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.execute(String,int[])", this.jconn);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": Statement.execute(String,String[])", this.jconn);
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }
}

