/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jdk.net.ExtendedSocketOptions;
import sun.net.ExtendedOptionsImpl;
import sun.net.ResourceManager;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.MembershipKeyImpl;
import sun.nio.ch.MembershipRegistry;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static NativeDispatcher nd = new DatagramDispatcher();
    private final FileDescriptor fd;
    private final int fdVal;
    private final ProtocolFamily family;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private InetAddress cachedSenderInetAddress;
    private int cachedSenderPort;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_CONNECTED = 1;
    private static final int ST_KILLED = 2;
    private int state = -1;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private DatagramSocket socket;
    private MembershipRegistry registry;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;
    private static String osname;
    private static String osversion;
    private SocketAddress sender;

    public DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        ResourceManager.beforeUdpCreate();
        try {
            this.family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
            this.fd = Net.socket(this.family, false);
            this.fdVal = IOUtil.fdVal(this.fd);
            this.state = 0;
        }
        catch (IOException iOException) {
            ResourceManager.afterUdpClose();
            throw iOException;
        }
    }

    public DatagramChannelImpl(SelectorProvider selectorProvider, ProtocolFamily protocolFamily) throws IOException {
        super(selectorProvider);
        if (protocolFamily != StandardProtocolFamily.INET && protocolFamily != StandardProtocolFamily.INET6) {
            if (protocolFamily == null) {
                throw new NullPointerException("'family' is null");
            }
            throw new UnsupportedOperationException("Protocol family not supported");
        }
        if (protocolFamily == StandardProtocolFamily.INET6 && !Net.isIPv6Available()) {
            throw new UnsupportedOperationException("IPv6 not available");
        }
        this.family = protocolFamily;
        this.fd = Net.socket(protocolFamily, false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    public DatagramChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) throws IOException {
        super(selectorProvider);
        this.family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
        this.localAddress = Net.localAddress(fileDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return Net.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> DatagramChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (socketOption == StandardSocketOptions.IP_TOS || socketOption == StandardSocketOptions.IP_MULTICAST_TTL || socketOption == StandardSocketOptions.IP_MULTICAST_LOOP) {
                Net.setSocketOption(this.fd, this.family, socketOption, t);
                return this;
            }
            if (socketOption == StandardSocketOptions.IP_MULTICAST_IF) {
                if (t == null) {
                    throw new IllegalArgumentException("Cannot set IP_MULTICAST_IF to 'null'");
                }
                NetworkInterface networkInterface = (NetworkInterface)t;
                if (this.family == StandardProtocolFamily.INET6) {
                    int n = networkInterface.getIndex();
                    if (n == -1) {
                        throw new IOException("Network interface cannot be identified");
                    }
                    Net.setInterface6(this.fd, n);
                } else {
                    Inet4Address inet4Address = Net.anyInet4Address(networkInterface);
                    if (inet4Address == null) {
                        throw new IOException("Network interface not configured for IPv4");
                    }
                    int n = Net.inet4AsInt(inet4Address);
                    Net.setInterface4(this.fd, n);
                }
                return this;
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind() && this.localAddress != null) {
                this.reuseAddressEmulated = true;
                this.isReuseAddress = (Boolean)t;
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (socketOption == StandardSocketOptions.IP_TOS || socketOption == StandardSocketOptions.IP_MULTICAST_TTL || socketOption == StandardSocketOptions.IP_MULTICAST_LOOP) {
                return (T)Net.getSocketOption(this.fd, this.family, socketOption);
            }
            if (socketOption == StandardSocketOptions.IP_MULTICAST_IF) {
                if (this.family == StandardProtocolFamily.INET) {
                    int n = Net.getInterface4(this.fd);
                    if (n == 0) {
                        return null;
                    }
                    InetAddress inetAddress = Net.inet4FromInt(n);
                    NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
                    if (networkInterface == null) {
                        throw new IOException("Unable to map address to interface");
                    }
                    return (T)networkInterface;
                }
                int n = Net.getInterface6(this.fd);
                if (n == 0) {
                    return null;
                }
                NetworkInterface networkInterface = NetworkInterface.getByIndex(n);
                if (networkInterface == null) {
                    throw new IOException("Unable to map index to interface");
                }
                return (T)networkInterface;
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && this.reuseAddressEmulated) {
                return (T)Boolean.valueOf(this.isReuseAddress);
            }
            return (T)Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public SocketAddress receive(ByteBuffer var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (byteBuffer instanceof DirectBuffer && n > 0) {
            return this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer, n, n2);
        }
        int n5 = Math.max(n, 1);
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n5);
        try {
            int n6 = this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer2, n5, 0);
            byteBuffer2.flip();
            if (n6 > 0 && n > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n7 = n6;
            return n7;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int receiveIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n, int n2) throws IOException {
        int n3 = this.receive0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, this.isConnected());
        if (n3 > 0) {
            byteBuffer.position(n2 + n3);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n3;
            int n;
            Object object2;
            InetSocketAddress inetSocketAddress;
            block24: {
                this.ensureOpen();
                inetSocketAddress = Net.checkAddress(socketAddress);
                InetAddress inetAddress = inetSocketAddress.getAddress();
                if (inetAddress == null) {
                    throw new IOException("Target address not resolved");
                }
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected()) {
                        if (socketAddress == null) {
                            throw new NullPointerException();
                        }
                        object2 = System.getSecurityManager();
                        if (object2 != null) {
                            if (inetAddress.isMulticastAddress()) {
                                ((SecurityManager)object2).checkMulticast(inetAddress);
                            } else {
                                ((SecurityManager)object2).checkConnect(inetAddress.getHostAddress(), inetSocketAddress.getPort());
                            }
                        }
                    } else {
                        if (!socketAddress.equals(this.remoteAddress)) {
                            throw new IllegalArgumentException("Connected address not equal to target address");
                        }
                        return this.write(byteBuffer);
                    }
                }
                n = 0;
                this.begin();
                if (this.isOpen()) break block24;
                int n2 = 0;
                this.writerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                return n2;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((n = this.send(this.fd, byteBuffer, inetSocketAddress)) == -3 && this.isOpen()) {
                }
                object2 = this.stateLock;
                synchronized (object2) {
                    if (this.isOpen() && this.localAddress == null) {
                        this.localAddress = Net.localAddress(this.fd);
                    }
                }
                n3 = IOStatus.normalize(n);
                this.writerThread = 0L;
                this.end(n > 0 || n == -2);
            }
            catch (Throwable throwable) {
                this.writerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fileDescriptor, byteBuffer, inetSocketAddress);
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n3);
        try {
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n);
            int n4 = this.sendFromNativeBuffer(fileDescriptor, byteBuffer2, inetSocketAddress);
            if (n4 > 0) {
                byteBuffer.position(n + n4);
            }
            int n5 = n4;
            return n5;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int sendFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        boolean bl = this.family != StandardProtocolFamily.INET;
        try {
            n = this.send0(bl, fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        catch (PortUnreachableException portUnreachableException) {
            if (this.isConnected()) {
                throw portUnreachableException;
            }
            n = n4;
        }
        if (n > 0) {
            byteBuffer.position(n2 + n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n2;
            int n;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                n = 0;
                this.begin();
                if (this.isOpen()) break block13;
                int n3 = 0;
                this.readerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                return n3;
            }
            try {
                this.readerThread = NativeThread.current();
                while ((n = IOUtil.read(this.fd, byteBuffer, -1L, nd)) == -3 && this.isOpen()) {
                }
                n2 = IOStatus.normalize(n);
                this.readerThread = 0L;
                this.end(n > 0 || n == -2);
            }
            catch (Throwable throwable) {
                this.readerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.readLock;
        synchronized (object) {
            long l2;
            long l;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                l = 0L;
                this.begin();
                if (this.isOpen()) break block13;
                long l3 = 0L;
                this.readerThread = 0L;
                this.end(l > 0L || l == -2L);
                assert (IOStatus.check(l));
                return l3;
            }
            try {
                this.readerThread = NativeThread.current();
                while ((l = IOUtil.read(this.fd, byteBufferArray, n, n2, nd)) == -3L && this.isOpen()) {
                }
                l2 = IOStatus.normalize(l);
                this.readerThread = 0L;
                this.end(l > 0L || l == -2L);
            }
            catch (Throwable throwable) {
                this.readerThread = 0L;
                this.end(l > 0L || l == -2L);
                assert (IOStatus.check(l));
                throw throwable;
            }
            assert (IOStatus.check(l));
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n2;
            int n;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                n = 0;
                this.begin();
                if (this.isOpen()) break block13;
                int n3 = 0;
                this.writerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                return n3;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((n = IOUtil.write(this.fd, byteBuffer, -1L, nd)) == -3 && this.isOpen()) {
                }
                n2 = IOStatus.normalize(n);
                this.writerThread = 0L;
                this.end(n > 0 || n == -2);
            }
            catch (Throwable throwable) {
                this.writerThread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            long l2;
            long l;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                l = 0L;
                this.begin();
                if (this.isOpen()) break block13;
                long l3 = 0L;
                this.writerThread = 0L;
                this.end(l > 0L || l == -2L);
                assert (IOStatus.check(l));
                return l3;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((l = IOUtil.write(this.fd, byteBufferArray, n, n2, nd)) == -3L && this.isOpen()) {
                }
                l2 = IOStatus.normalize(l);
                this.writerThread = 0L;
                this.end(l > 0L || l == -2L);
            }
            catch (Throwable throwable) {
                this.writerThread = 0L;
                this.end(l > 0L || l == -2L);
                assert (IOStatus.check(l));
                throw throwable;
            }
            assert (IOStatus.check(l));
            return l2;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    Object object4;
                    InetSocketAddress inetSocketAddress;
                    this.ensureOpen();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    if (socketAddress == null) {
                        inetSocketAddress = this.family == StandardProtocolFamily.INET ? new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0) : new InetSocketAddress(0);
                    } else {
                        inetSocketAddress = Net.checkAddress(socketAddress);
                        if (this.family == StandardProtocolFamily.INET && !((object4 = inetSocketAddress.getAddress()) instanceof Inet4Address)) {
                            throw new UnsupportedAddressTypeException();
                        }
                    }
                    object4 = System.getSecurityManager();
                    if (object4 != null) {
                        ((SecurityManager)object4).checkListen(inetSocketAddress.getPort());
                    }
                    Net.bind(this.family, this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state != 0) {
                throw new IllegalStateException("Connect already invoked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        boolean bl = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    int n;
                    this.ensureOpenAndUnconnected();
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    if ((n = Net.connect(this.family, this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort())) <= 0) {
                        throw new Error();
                    }
                    this.state = 1;
                    this.remoteAddress = inetSocketAddress;
                    this.sender = inetSocketAddress;
                    this.cachedSenderInetAddress = inetSocketAddress.getAddress();
                    this.cachedSenderPort = inetSocketAddress.getPort();
                    this.localAddress = Net.localAddress(this.fd);
                    boolean bl2 = false;
                    Object object4 = this.blockingLock();
                    synchronized (object4) {
                        try {
                            bl2 = this.isBlocking();
                            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                            if (bl2) {
                                this.configureBlocking(false);
                            }
                            do {
                                byteBuffer.clear();
                            } while (this.receive(byteBuffer) != null);
                        }
                        finally {
                            if (bl2) {
                                this.configureBlocking(true);
                            }
                        }
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected() || !this.isOpen()) {
                        return this;
                    }
                    InetSocketAddress inetSocketAddress = this.remoteAddress;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    boolean bl = this.family == StandardProtocolFamily.INET6;
                    DatagramChannelImpl.disconnect0(this.fd, bl);
                    this.remoteAddress = null;
                    this.state = 0;
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MembershipKey innerJoin(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) throws IOException {
        SecurityManager securityManager;
        if (!inetAddress.isMulticastAddress()) {
            throw new IllegalArgumentException("Group not a multicast address");
        }
        if (inetAddress instanceof Inet4Address) {
            if (this.family == StandardProtocolFamily.INET6 && !Net.canIPv6SocketJoinIPv4Group()) {
                throw new IllegalArgumentException("IPv6 socket cannot join IPv4 multicast group");
            }
        } else if (inetAddress instanceof Inet6Address) {
            if (this.family != StandardProtocolFamily.INET6) {
                throw new IllegalArgumentException("Only IPv6 sockets can join IPv6 multicast group");
            }
        } else {
            throw new IllegalArgumentException("Address type not supported");
        }
        if (inetAddress2 != null) {
            if (inetAddress2.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (inetAddress2.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (inetAddress2.getClass() != inetAddress.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkMulticast(inetAddress);
        }
        Object object = this.stateLock;
        synchronized (object) {
            MembershipKey membershipKey;
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.registry == null) {
                this.registry = new MembershipRegistry();
            } else {
                membershipKey = this.registry.checkMembership(inetAddress, networkInterface, inetAddress2);
                if (membershipKey != null) {
                    return membershipKey;
                }
            }
            if (this.family == StandardProtocolFamily.INET6 && (inetAddress instanceof Inet6Address || Net.canJoin6WithIPv4Group())) {
                byte[] byArray;
                int n = networkInterface.getIndex();
                if (n == -1) {
                    throw new IOException("Network interface cannot be identified");
                }
                byte[] byArray2 = Net.inet6AsByteArray(inetAddress);
                int n2 = Net.join6(this.fd, byArray2, n, byArray = inetAddress2 == null ? null : Net.inet6AsByteArray(inetAddress2));
                if (n2 == -2) {
                    throw new UnsupportedOperationException();
                }
                membershipKey = new MembershipKeyImpl.Type6(this, inetAddress, networkInterface, inetAddress2, byArray2, n, byArray);
            } else {
                int n;
                int n3;
                Inet4Address inet4Address = Net.anyInet4Address(networkInterface);
                if (inet4Address == null) {
                    throw new IOException("Network interface not configured for IPv4");
                }
                int n4 = Net.inet4AsInt(inetAddress);
                int n5 = Net.join4(this.fd, n4, n3 = Net.inet4AsInt(inet4Address), n = inetAddress2 == null ? 0 : Net.inet4AsInt(inetAddress2));
                if (n5 == -2) {
                    throw new UnsupportedOperationException();
                }
                membershipKey = new MembershipKeyImpl.Type4(this, inetAddress, networkInterface, inetAddress2, n4, n3, n);
            }
            this.registry.add((MembershipKeyImpl)membershipKey);
            return membershipKey;
        }
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        return this.innerJoin(inetAddress, networkInterface, null);
    }

    @Override
    public MembershipKey join(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) throws IOException {
        if (inetAddress2 == null) {
            throw new NullPointerException("source address is null");
        }
        if ("HP-UX".equals(osname) && inetAddress2 != null && !"B.11.31".equals(osversion)) {
            throw new UnsupportedOperationException(" OS does not support Source filtering before 11.31");
        }
        return this.innerJoin(inetAddress, networkInterface, inetAddress2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drop(MembershipKeyImpl membershipKeyImpl) {
        assert (membershipKeyImpl.channel() == this);
        Object object = this.stateLock;
        synchronized (object) {
            if (!membershipKeyImpl.isValid()) {
                return;
            }
            try {
                if (membershipKeyImpl instanceof MembershipKeyImpl.Type6) {
                    MembershipKeyImpl.Type6 type6 = (MembershipKeyImpl.Type6)membershipKeyImpl;
                    Net.drop6(this.fd, type6.groupAddress(), type6.index(), type6.source());
                } else {
                    MembershipKeyImpl.Type4 type4 = (MembershipKeyImpl.Type4)membershipKeyImpl;
                    Net.drop4(this.fd, type4.groupAddress(), type4.interfaceAddress(), type4.source());
                }
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            membershipKeyImpl.invalidate();
            this.registry.remove(membershipKeyImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void block(MembershipKeyImpl membershipKeyImpl, InetAddress inetAddress) throws IOException {
        assert (membershipKeyImpl.channel() == this);
        assert (membershipKeyImpl.sourceAddress() == null);
        Object object = this.stateLock;
        synchronized (object) {
            int n;
            if (!membershipKeyImpl.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            if (inetAddress.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Source address is a wildcard address");
            }
            if (inetAddress.isMulticastAddress()) {
                throw new IllegalArgumentException("Source address is multicast address");
            }
            if (inetAddress.getClass() != membershipKeyImpl.group().getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            if (membershipKeyImpl instanceof MembershipKeyImpl.Type6) {
                MembershipKeyImpl.Type6 type6 = (MembershipKeyImpl.Type6)membershipKeyImpl;
                n = Net.block6(this.fd, type6.groupAddress(), type6.index(), Net.inet6AsByteArray(inetAddress));
            } else {
                MembershipKeyImpl.Type4 type4 = (MembershipKeyImpl.Type4)membershipKeyImpl;
                n = Net.block4(this.fd, type4.groupAddress(), type4.interfaceAddress(), Net.inet4AsInt(inetAddress));
            }
            if (n == -2) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblock(MembershipKeyImpl membershipKeyImpl, InetAddress inetAddress) {
        assert (membershipKeyImpl.channel() == this);
        assert (membershipKeyImpl.sourceAddress() == null);
        Object object = this.stateLock;
        synchronized (object) {
            if (!membershipKeyImpl.isValid()) {
                throw new IllegalStateException("key is no longer valid");
            }
            try {
                if (membershipKeyImpl instanceof MembershipKeyImpl.Type6) {
                    MembershipKeyImpl.Type6 type6 = (MembershipKeyImpl.Type6)membershipKeyImpl;
                    Net.unblock6(this.fd, type6.groupAddress(), type6.index(), Net.inet6AsByteArray(inetAddress));
                } else {
                    MembershipKeyImpl.Type4 type4 = (MembershipKeyImpl.Type4)membershipKeyImpl;
                    Net.unblock4(this.fd, type4.groupAddress(), type4.interfaceAddress(), Net.inet4AsInt(inetAddress));
                }
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            long l;
            if (this.state != 2) {
                nd.preClose(this.fd);
            }
            ResourceManager.afterUdpClose();
            if (this.registry != null) {
                this.registry.invalidateAll();
            }
            if ((l = this.readerThread) != 0L) {
                NativeThread.signal(l);
            }
            if ((l = this.writerThread) != 0L) {
                NativeThread.signal(l);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            if (this.state == -1) {
                this.state = 2;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 2;
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLIN) != 0 && (n3 & 1) != 0) {
            n5 |= 1;
        }
        if ((n & Net.POLLOUT) != 0 && (n3 & 4) != 0) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int poll(int n, long l) throws IOException {
        int n2;
        block10: {
            int n3;
            if (!$assertionsDisabled) {
                if (!Thread.holdsLock(this.blockingLock())) throw new AssertionError();
                if (this.isBlocking()) {
                    throw new AssertionError();
                }
            }
            Object object = this.readLock;
            // MONITORENTER : object
            n2 = 0;
            try {
                this.begin();
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (this.isOpen()) break block10;
                n3 = 0;
                // MONITOREXIT : object2
                this.readerThread = 0L;
                this.end(n2 > 0);
            }
            catch (Throwable throwable) {
                this.readerThread = 0L;
                this.end(n2 > 0);
                throw throwable;
            }
            return n3;
        }
        this.readerThread = NativeThread.current();
        // MONITOREXIT : object2
        n2 = Net.poll(this.fd, n, l);
        this.readerThread = 0L;
        this.end(n2 > 0);
        return n2;
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        if ((n & 8) != 0) {
            n2 |= Net.POLLIN;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private static native void initIDs();

    private static native void disconnect0(FileDescriptor var0, boolean var1) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4, boolean var5) throws IOException;

    private native int send0(boolean var1, FileDescriptor var2, long var3, int var5, InetAddress var6, int var7) throws IOException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                osname = System.getProperty("os.name");
                osversion = System.getProperty("os.version");
                return null;
            }
        });
        IOUtil.load();
        DatagramChannelImpl.initIDs();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Object>> hashSet = new HashSet<SocketOption<Object>>(8);
            hashSet.add(StandardSocketOptions.SO_SNDBUF);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            hashSet.add(StandardSocketOptions.SO_BROADCAST);
            hashSet.add(StandardSocketOptions.IP_TOS);
            hashSet.add(StandardSocketOptions.IP_MULTICAST_IF);
            hashSet.add(StandardSocketOptions.IP_MULTICAST_TTL);
            hashSet.add(StandardSocketOptions.IP_MULTICAST_LOOP);
            if (ExtendedOptionsImpl.flowSupported()) {
                hashSet.add(ExtendedSocketOptions.SO_FLOW_SLA);
            }
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

