/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.tools.objects;

import com.intersys.pojo.tools.objects.SchemaBuilder;
import com.intersys.pojo.tools.objects.ant.ClassesToGenerate;
import com.intersys.pojo.tools.objects.ant.Connection;
import com.intersys.pojo.tools.objects.ant.IntrospectionOptions;
import com.intersys.pojo.tools.objects.ant.RoundTripProjectionOptions;
import com.intersys.pojo.tools.objects.gui.PersisterProperties;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SchemaBuilderTask
extends Task {
    private boolean merge = false;
    private Connection connection;
    private ClassesToGenerate classesToGenerate;
    private IntrospectionOptions introspectionOptions;
    private RoundTripProjectionOptions roundTripProjectionOptions;

    public void execute() throws BuildException {
        System.out.println("Beginning class generation in ant task...");
        Properties properties = new Properties();
        if (this.connection == null) {
            System.out.println("fatal error no connection element");
            return;
        }
        if (this.classesToGenerate == null) {
            System.out.println("fatal error no classesToGenerate element");
            return;
        }
        if (this.introspectionOptions == null) {
            System.out.println("fatal error no introspectionOptions element");
            return;
        }
        if (this.roundTripProjectionOptions == null) {
            this.roundTripProjectionOptions = new RoundTripProjectionOptions();
        }
        properties.setProperty("com.intersys.schemabuilder.namespace", this.connection.getNamespace());
        properties.setProperty("com.intersys.schemabuilder.classpath", this.classesToGenerate.getClasspath());
        properties.setProperty("com.intersys.schemabuilder.host", this.connection.getHost());
        properties.setProperty("com.intersys.schemabuilder.defaultaccesslevel", this.introspectionOptions.getDefaultAccessLevel());
        properties.setProperty("user", this.connection.getUser());
        properties.setProperty("com.intersys.schemabuilder.port", this.connection.getPort());
        properties.setProperty("com.intersys.schemabuilder.metadata", this.introspectionOptions.getMetadata());
        properties.setProperty("com.intersys.schemabuilder.logfile", this.connection.getLogfile());
        properties.setProperty("com.intersys.schemabuilder.exclude", this.introspectionOptions.getExclude());
        properties.setProperty("com.intersys.schemabuilder.defaultaccesstype", this.introspectionOptions.getDefaultAccessType());
        properties.setProperty("com.intersys.schemabuilder.defaultjavaprojectionpackage", this.roundTripProjectionOptions.getDefaultJavaProjectionPackage());
        properties.setProperty("com.intersys.schemabuilder.generationtype", this.roundTripProjectionOptions.getGenerationType());
        properties.setProperty("com.intersys.schemabuilder.classes", this.classesToGenerate.getClasses());
        properties.setProperty("password", this.connection.getPassword());
        properties.setProperty(PersisterProperties.IS_MERGE, new Boolean(this.merge).toString());
        properties.setProperty("com.intersys.schemabuilder.projectiondir", this.roundTripProjectionOptions.getProjectionDir());
        SchemaBuilder schemaBuilder = SchemaBuilder.getRunPersister(properties);
        try {
            schemaBuilder.run(schemaBuilder.getDB(), null, this.roundTripProjectionOptions.getGenerationType(), System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addConnection(Connection connection) {
        this.connection = connection;
    }

    public void addClassesToGenerate(ClassesToGenerate classesToGenerate) {
        this.classesToGenerate = classesToGenerate;
    }

    public void addIntrospectionOptions(IntrospectionOptions introspectionOptions) {
        this.introspectionOptions = introspectionOptions;
    }

    public void addRoundTripProjectionOptions(RoundTripProjectionOptions roundTripProjectionOptions) {
        this.roundTripProjectionOptions = roundTripProjectionOptions;
    }

    public void setMerge(boolean bl) {
        this.merge = bl;
    }
}

