/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.tools.objects;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class GenericsProcessor {
    public static Class getCollectionElementType(Member member, boolean bl) {
        Class<?> clazz;
        String string;
        Type type;
        AccessibleObject accessibleObject;
        if (member instanceof Field) {
            accessibleObject = (Field)member;
            type = ((Field)accessibleObject).getGenericType();
            string = ((Field)accessibleObject).toGenericString();
            clazz = ((Field)accessibleObject).getType();
        } else if (member instanceof Method) {
            accessibleObject = (Method)member;
            type = ((Method)accessibleObject).getGenericReturnType();
            string = ((Method)accessibleObject).toGenericString();
            clazz = ((Method)accessibleObject).getReturnType();
        } else {
            throw new IllegalArgumentException("Unknown Memeber type " + member.getClass().getName());
        }
        if (type instanceof Class) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            accessibleObject = ((ParameterizedType)type).getActualTypeArguments();
            if (((AccessibleObject)accessibleObject).length == 0) {
                return null;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                if (((AccessibleObject)accessibleObject).length != 1) {
                    throw new IllegalArgumentException("Field " + string + " is not a valid collection.");
                }
                if (!(accessibleObject[0] instanceof Class)) {
                    return GenericsProcessor.handleNestedGenerics(bl, type, string);
                }
                return (Class)((Object)accessibleObject[0]);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                if (((AccessibleObject)accessibleObject).length != 2) {
                    throw new IllegalArgumentException("Field " + string + " is not a valid collection.");
                }
                if (!(accessibleObject[1] instanceof Class)) {
                    return GenericsProcessor.handleNestedGenerics(bl, type, string);
                }
                return (Class)((Object)accessibleObject[1]);
            }
            throw new IllegalArgumentException("Field " + string + " is not a valid collection.");
        }
        throw new IllegalArgumentException("Failed to process field " + string + ". Type " + type.toString() + " is not supported.");
    }

    private static Class handleNestedGenerics(boolean bl, Type type, String string) {
        if (bl) {
            return null;
        }
        throw new IllegalArgumentException("Failed to process field " + string + ". Nested generics: " + type.toString() + " are not supported.");
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName("bank.Customer");
        Field field = clazz.getField("name");
        Field field2 = clazz.getField("accounts");
        Field field3 = clazz.getField("addresses");
        System.out.println(field.toString() + ": " + GenericsProcessor.getCollectionElementType(field, false));
        System.out.println(field2.toString() + ": " + GenericsProcessor.getCollectionElementType(field2, false));
        System.out.println(field3.toString() + ": " + GenericsProcessor.getCollectionElementType(field3, false));
    }
}

