/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.tools.objects;

import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.intersys.pojo.annotations.CacheClass;
import com.intersys.pojo.annotations.CacheProperty;
import com.intersys.pojo.annotations.ClassParameter;
import com.intersys.pojo.annotations.ClassParameters;
import com.intersys.pojo.annotations.Collection;
import com.intersys.pojo.annotations.Embeddable;
import com.intersys.pojo.annotations.Extends;
import com.intersys.pojo.annotations.FetchType;
import com.intersys.pojo.annotations.ID;
import com.intersys.pojo.annotations.IDType;
import com.intersys.pojo.annotations.Implements;
import com.intersys.pojo.annotations.Index;
import com.intersys.pojo.annotations.Indices;
import com.intersys.pojo.annotations.Lob;
import com.intersys.pojo.annotations.LobType;
import com.intersys.pojo.annotations.PropertyParameter;
import com.intersys.pojo.annotations.PropertyParameters;
import com.intersys.pojo.annotations.Relationship;
import com.intersys.pojo.annotations.Transient;
import com.intersys.pojo.annotations.Version;
import com.intersys.pojo.tools.objects.ClassMetadata;
import com.intersys.pojo.tools.objects.Java2DBMapping;
import com.intersys.pojo.tools.objects.PropertyMetadata;
import com.intersys.pojo.tools.objects.ProviderTest;
import com.intersys.pojo.tools.objects.RelationshipMetadata;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationProvider
implements Java2DBMapping {
    private HashMap<Class, ClassMetadata> classMetadata = new HashMap();

    public String cacheClassNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getClassName();
    }

    public String sqlTableNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getSQLTableName();
    }

    public String primaryKeyNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getPrimaryKey();
    }

    public CacheIndexInfo[] allIndicesFor(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getIndices();
    }

    public int getAccessLevel(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessLevel();
    }

    public int getAccessType(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessType();
    }

    public String getJavaProjectionPackage(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionPackageName();
    }

    public String getJavaProjectionClassName(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionClassName();
    }

    public String cacheFieldNameFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getName();
    }

    public String cacheFieldTypeFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getType();
    }

    public int getPropertyKind(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return -1;
        }
        return propertyMetadata.getKind();
    }

    public boolean isFetchTypeEager(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isFetchTypeEager();
    }

    public CacheRelationshipInfo relationshipFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getRelationshipMetadata();
    }

    public boolean isSerial(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.getIsSerial();
    }

    public String getVersionID(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getVersionID();
    }

    public boolean isClassTransient(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isTransient();
    }

    public boolean isMemberTransient(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isTransient();
    }

    public Map getPropertyParameters(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getPropertyParameters();
    }

    public String getDatabaseID(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getDatabaseID();
    }

    public int getDatabaseIDType(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getDatabaseIDType();
    }

    public boolean isPopulatable(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isPopulatable();
    }

    public boolean isXMLSerializable(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isXMLSerializable();
    }

    public Map getClassParameters(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getClassParameters();
    }

    public String getExtendedClass(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getExtendedClass();
    }

    public String[] getImplementedClasses(Class clazz) {
        ClassMetadata classMetadata = this.getAnnotationInfo(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getImplementedClasses();
    }

    public void close() {
        this.classMetadata.clear();
    }

    private ClassMetadata getAnnotationInfo(Class clazz) {
        boolean bl;
        PropertyMetadata propertyMetadata;
        int n;
        ClassMetadata classMetadata = this.classMetadata.get(clazz);
        if (classMetadata != null) {
            return classMetadata;
        }
        classMetadata = new ClassMetadata();
        this.classMetadata.put(clazz, classMetadata);
        this.processCacheClassAnnotation(clazz, classMetadata);
        this.processIndexAnnotation(clazz, classMetadata);
        this.processIndicesAnnotation(clazz, classMetadata);
        this.processEmbeddableAnnotation(clazz, classMetadata);
        this.processTransientAnnotation(clazz, classMetadata);
        this.processExtendsAnnotation(clazz, classMetadata);
        this.processImplementsAnnotation(clazz, classMetadata);
        this.processClassParametersAnnotation(clazz, classMetadata);
        this.processClassParameterAnnotation(clazz, classMetadata);
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            this.processVersionAnnotation(fieldArray[n], classMetadata);
            this.processDatabaseIDAnnotation(fieldArray[n], classMetadata);
            propertyMetadata = new PropertyMetadata();
            bl = this.processPropertyAnnotation(fieldArray[n], propertyMetadata);
            bl = this.processTransientAnnotation(fieldArray[n], propertyMetadata) || bl;
            bl = this.processPropertyParameterAnnotation(fieldArray[n], propertyMetadata) || bl;
            bl = this.processPropertyParametersAnnotation(fieldArray[n], propertyMetadata) || bl;
            bl = this.processRelationshipAnnotation(fieldArray[n], propertyMetadata) || bl;
            bl = this.processCollectionAnnotation(fieldArray[n], propertyMetadata) || bl;
            boolean bl2 = bl = this.processLobAnnotation(fieldArray[n], propertyMetadata) || bl;
            if (!bl) continue;
            classMetadata.addPropertyMetadata(fieldArray[n], propertyMetadata);
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (n = 0; n < methodArray.length; ++n) {
            String string = methodArray[n].getName();
            if (!this.isAccessor(methodArray[n])) continue;
            try {
                clazz.getField(string.substring(3));
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.processVersionAnnotation(methodArray[n], classMetadata);
                this.processDatabaseIDAnnotation(methodArray[n], classMetadata);
                propertyMetadata = new PropertyMetadata();
                bl = this.processPropertyAnnotation(methodArray[n], propertyMetadata);
                bl = this.processTransientAnnotation(methodArray[n], propertyMetadata) || bl;
                bl = this.processPropertyParameterAnnotation(methodArray[n], propertyMetadata) || bl;
                bl = this.processPropertyParametersAnnotation(methodArray[n], propertyMetadata) || bl;
                bl = this.processRelationshipAnnotation(methodArray[n], propertyMetadata) || bl;
                bl = this.processCollectionAnnotation(methodArray[n], propertyMetadata) || bl;
                boolean bl3 = bl = this.processLobAnnotation(methodArray[n], propertyMetadata) || bl;
                if (!bl) continue;
                classMetadata.addPropertyMetadata(methodArray[n], propertyMetadata);
            }
        }
        return classMetadata;
    }

    private boolean isAccessor(Method method) {
        String string = method.getName();
        if (!string.startsWith("set") && !string.startsWith("get")) {
            return false;
        }
        return !(string.startsWith("get") ? method.getParameterTypes().length != 0 || method.getReturnType() == null : method.getParameterTypes().length != 1 || method.getReturnType() != null);
    }

    private void processCacheClassAnnotation(Class clazz, ClassMetadata classMetadata) {
        CacheClass cacheClass = clazz.getAnnotation(CacheClass.class);
        if (cacheClass != null) {
            classMetadata.setClassName(cacheClass.name());
            classMetadata.setSQLTableName(cacheClass.sqlTableName());
            classMetadata.setPrimaryKey(cacheClass.primaryKey());
            classMetadata.setJavaProjectionPackageName(cacheClass.javaProjectionPackageName());
            classMetadata.setJavaProjectionClassName(cacheClass.javaProjectionClassName());
            classMetadata.setAccessLevel(cacheClass.accessLevel());
            classMetadata.setAccessType(cacheClass.accessType());
            classMetadata.setPopulatable(cacheClass.populatable());
            classMetadata.setXMLSerializable(cacheClass.xmlSerializable());
        }
    }

    private boolean processPropertyAnnotation(Member member, PropertyMetadata propertyMetadata) {
        CacheProperty cacheProperty = null;
        if (member instanceof Field) {
            cacheProperty = ((Field)member).getAnnotation(CacheProperty.class);
        } else if (member instanceof Method) {
            cacheProperty = ((Method)member).getAnnotation(CacheProperty.class);
        }
        if (cacheProperty == null) {
            return false;
        }
        propertyMetadata.setName(cacheProperty.name());
        propertyMetadata.setType(cacheProperty.type());
        propertyMetadata.setSQLColumnName(cacheProperty.sqlColumnName());
        return true;
    }

    private boolean processRelationshipAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Relationship relationship = null;
        if (member instanceof Field) {
            relationship = ((Field)member).getAnnotation(Relationship.class);
        } else if (member instanceof Method) {
            relationship = ((Method)member).getAnnotation(Relationship.class);
        }
        if (relationship == null) {
            return false;
        }
        RelationshipMetadata relationshipMetadata = new RelationshipMetadata(relationship.type(), relationship.parentChild(), relationship.inverseClass(), relationship.inverseProperty());
        propertyMetadata.setRelationship(relationshipMetadata);
        if (relationship.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    private boolean processLobAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Lob lob = null;
        if (member instanceof Field) {
            lob = ((Field)member).getAnnotation(Lob.class);
        } else if (member instanceof Method) {
            lob = ((Method)member).getAnnotation(Lob.class);
        }
        if (lob == null) {
            return false;
        }
        if (lob.type() == LobType.BLOB) {
            propertyMetadata.setKind(32);
        } else {
            propertyMetadata.setKind(64);
        }
        if (lob.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    private void processVersionAnnotation(Member member, ClassMetadata classMetadata) {
        Version version = null;
        if (member instanceof Field) {
            version = ((Field)member).getAnnotation(Version.class);
        } else if (member instanceof Method) {
            version = ((Method)member).getAnnotation(Version.class);
        }
        if (version != null) {
            classMetadata.setVersionID(member.getName());
        }
    }

    private boolean processDatabaseIDAnnotation(Member member, ClassMetadata classMetadata) {
        ID iD = null;
        if (member instanceof Field) {
            iD = ((Field)member).getAnnotation(ID.class);
        } else if (member instanceof Method) {
            iD = ((Method)member).getAnnotation(ID.class);
        }
        if (iD == null) {
            return false;
        }
        if (iD.type() == IDType.SYSTEM_ASSIGNED) {
            classMetadata.setDatabaseIDType(0);
        } else {
            classMetadata.setDatabaseIDType(1);
        }
        classMetadata.setDatabaseID(member.getName());
        return true;
    }

    private boolean processPropertyParameterAnnotation(Member member, PropertyMetadata propertyMetadata) {
        PropertyParameter propertyParameter = null;
        if (member instanceof Field) {
            propertyParameter = ((Field)member).getAnnotation(PropertyParameter.class);
        } else if (member instanceof Method) {
            propertyParameter = ((Method)member).getAnnotation(PropertyParameter.class);
        }
        if (propertyParameter == null) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(propertyParameter.name(), propertyParameter.value());
        propertyMetadata.setPropertyParameters(hashMap);
        return true;
    }

    private boolean processPropertyParametersAnnotation(Member member, PropertyMetadata propertyMetadata) {
        PropertyParameters propertyParameters = null;
        if (member instanceof Field) {
            propertyParameters = ((Field)member).getAnnotation(PropertyParameters.class);
        } else if (member instanceof Method) {
            propertyParameters = ((Method)member).getAnnotation(PropertyParameters.class);
        }
        if (propertyParameters == null) {
            return false;
        }
        PropertyParameter[] propertyParameterArray = propertyParameters.value();
        HashMap<String, String> hashMap = new HashMap<String, String>(propertyParameterArray.length);
        for (int i = 0; i < propertyParameterArray.length; ++i) {
            PropertyParameter propertyParameter = propertyParameterArray[i];
            hashMap.put(propertyParameter.name(), propertyParameter.value());
        }
        propertyMetadata.setPropertyParameters(hashMap);
        return true;
    }

    private void processClassParameterAnnotation(Class clazz, ClassMetadata classMetadata) {
        ClassParameter classParameter = clazz.getAnnotation(ClassParameter.class);
        if (classParameter != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put(classParameter.name(), classParameter.value());
            classMetadata.setClassParameters(hashMap);
        }
    }

    private void processClassParametersAnnotation(Class clazz, ClassMetadata classMetadata) {
        ClassParameters classParameters = clazz.getAnnotation(ClassParameters.class);
        if (classParameters == null) {
            return;
        }
        ClassParameter[] classParameterArray = classParameters.value();
        HashMap<String, String> hashMap = new HashMap<String, String>(classParameterArray.length);
        for (int i = 0; i < classParameterArray.length; ++i) {
            ClassParameter classParameter = classParameterArray[i];
            hashMap.put(classParameter.name(), classParameter.value());
        }
        classMetadata.setClassParameters(hashMap);
    }

    private boolean processCollectionAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Collection collection = null;
        if (member instanceof Field) {
            collection = ((Field)member).getAnnotation(Collection.class);
        } else if (member instanceof Method) {
            collection = ((Method)member).getAnnotation(Collection.class);
        }
        if (collection == null) {
            return false;
        }
        if (collection.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        propertyMetadata.setCollectionType(collection.type());
        propertyMetadata.setType(collection.elementType());
        return true;
    }

    private void processIndicesAnnotation(Class clazz, ClassMetadata classMetadata) {
        Indices indices = clazz.getAnnotation(Indices.class);
        if (indices == null) {
            return;
        }
        Index[] indexArray = indices.value();
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            classMetadata.setIndex(index.data(), index.description(), index.isIdKey(), index.name(), index.isPrimaryKey(), index.propertyNames(), index.sqlName(), index.type(), index.isUnique(), index.collation());
        }
    }

    private void processIndexAnnotation(Class clazz, ClassMetadata classMetadata) {
        Index index = clazz.getAnnotation(Index.class);
        if (index != null) {
            classMetadata.setIndex(index.data(), index.description(), index.isIdKey(), index.name(), index.isPrimaryKey(), index.propertyNames(), index.sqlName(), index.type(), index.isUnique(), index.collation());
        }
    }

    private void processExtendsAnnotation(Class clazz, ClassMetadata classMetadata) {
        Extends extends_ = clazz.getAnnotation(Extends.class);
        if (extends_ != null) {
            classMetadata.setExtendedClass(extends_.className());
        }
    }

    private void processImplementsAnnotation(Class clazz, ClassMetadata classMetadata) {
        Implements implements_ = clazz.getAnnotation(Implements.class);
        if (implements_ != null) {
            classMetadata.setImplementedClasses(implements_.classNames());
        }
    }

    private boolean processTransientAnnotation(Object object, Object object2) {
        if (object instanceof Class) {
            if (((Class)object).getAnnotation(Transient.class) != null) {
                ((ClassMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        if (object instanceof Field) {
            if (((Field)object).getAnnotation(Transient.class) != null) {
                ((PropertyMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        if (object instanceof Method) {
            if (((Method)object).getAnnotation(Transient.class) != null) {
                ((PropertyMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        return false;
    }

    private void processEmbeddableAnnotation(Class clazz, ClassMetadata classMetadata) {
        Embeddable embeddable = clazz.getAnnotation(Embeddable.class);
        if (embeddable != null) {
            classMetadata.setIsSerial();
        }
    }

    private PropertyMetadata getPropertyMetadata(Object object) {
        Member member = (Member)object;
        ((AccessibleObject)((Object)member)).setAccessible(true);
        ClassMetadata classMetadata = this.getAnnotationInfo(member.getDeclaringClass());
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getPropertyMetadata(member);
    }

    public boolean isPropertyAnnotated(Member member) {
        return this.getPropertyMetadata(member) != null;
    }

    public static void main(String[] stringArray) throws Throwable {
        ProviderTest.test(new AnnotationProvider(), Class.forName(stringArray[0]));
    }
}

