/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.runtime;

import com.intersys.classes.CacheRootObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.XML.Reader;
import com.intersys.classes.XML.Writer;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectHandleHolder;
import com.intersys.objects.StatusCodeHolder;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.pojo.Utilities;
import com.intersys.pojo.runtime.CacheObjectManager;
import java.io.Serializable;
import java.util.ArrayList;

public class CachePOJOUtilities
implements Utilities {
    private CacheObjectManager mManager;

    public CachePOJOUtilities(CacheObjectManager cacheObjectManager) {
        this.mManager = cacheObjectManager;
    }

    public String serializeToXML(Object object) throws Exception {
        return this.serializeToXML(object, null, null);
    }

    public String serializeToXML(Object object, String string, String string2) throws Exception {
        Persistent persistent = this.getRunnableObject(object);
        Writer writer = new Writer(this.getFullDatabase());
        if (string != null) {
            writer.setCharset(string);
        }
        if (string2 != null) {
            writer.setDefaultNamespace(string2);
        }
        writer.setNoXMLDeclaration(Boolean.TRUE);
        writer.OutputToString();
        writer.RootObject(persistent, null, null, null);
        String string3 = writer.GetXMLString(new StatusCodeHolder(null));
        if (this.amIUseLightConnection()) {
            persistent.release();
        }
        writer.release();
        return string3;
    }

    public Object startXMLDocument(String string, String string2, String string3) throws Exception {
        Writer writer = new Writer(this.getFullDatabase());
        if (string2 != null) {
            writer.setCharset(string2);
        }
        if (string3 != null) {
            writer.setDefaultNamespace(string3);
        }
        writer.OutputToString();
        writer.StartDocument();
        writer.RootElement(string, null);
        return writer;
    }

    public void addToXMLDocument(Object object, Object object2) throws Exception {
        if (!(object instanceof Writer)) {
            throw new IllegalArgumentException("XML Document was not created by this ObjectManager.  It must be cxreated by startXMLDocument method.");
        }
        Writer writer = (Writer)object;
        Persistent persistent = this.getRunnableObject(object2);
        writer.Object(persistent, null, null, null);
        if (this.amIUseLightConnection()) {
            persistent.release();
        }
    }

    public String closeXMLDocument(Object object) throws Exception {
        if (!(object instanceof Writer)) {
            throw new IllegalArgumentException("XML Document was not created by this ObjectManager.  It must be cxreated by startXMLDocument method.");
        }
        Writer writer = (Writer)object;
        writer.EndRootElement();
        writer.EndDocument();
        String string = writer.GetXMLString(new StatusCodeHolder(null));
        writer.release();
        return string;
    }

    public Object readFromXML(Class clazz, String string) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        Reader reader = new Reader(this.getFullDatabase());
        String string2 = cacheClass.getName();
        int n = string2.lastIndexOf(46);
        String string3 = n < 0 ? string2 : string2.substring(n + 1);
        reader.OpenString(string, null);
        reader.Correlate(string3, string2);
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        int n2 = 0;
        Object object = null;
        while (reader.Next(objectHandleHolder, new StatusCodeHolder(null)) > 0) {
            Object object2;
            if (n2 == 1) {
                object2 = new ArrayList<Object>();
                ((ArrayList)object2).add(object);
                object = object2;
            }
            CacheRootObject cacheRootObject = (CacheRootObject)objectHandleHolder.value;
            object2 = ObjectHandle.class.isAssignableFrom(clazz) ? cacheRootObject : cacheRootObject.detach(this.mManager.allowProxy());
            if (n2 > 0) {
                ((ArrayList)object).add(object2);
            } else {
                object = object2;
            }
            ++n2;
        }
        return object;
    }

    private Persistent getRunnableObject(Object object) throws Exception {
        Persistent persistent;
        CacheClass cacheClass = this.findImplementation(object.getClass());
        cacheClass = this.getFullDatabase().getCacheClass(cacheClass.getName());
        if (this.amIUseLightConnection()) {
            Serializable serializable = this.mManager.save(object, true);
            persistent = (Persistent)cacheClass.openObject(new Id(serializable.toString()));
        } else {
            persistent = this.attachInternal(object, true);
        }
        return persistent;
    }

    private Database getFullDatabase() throws Exception {
        return this.mManager.getFullDatabase();
    }

    private Persistent attachInternal(Object object, boolean bl) throws Exception {
        return this.mManager.attachInternal(object, bl);
    }

    private CacheClass findImplementation(Class clazz) throws Exception {
        return this.mManager.findImplementation(clazz);
    }

    private boolean amIUseLightConnection() {
        return this.mManager.amIUseLightConnection();
    }
}

