/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.runtime;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.jdbc.CacheConnection;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.POJOIterator;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.pojo.ExtentManager;
import com.intersys.pojo.ObjectManager;
import com.intersys.pojo.Settings;
import com.intersys.pojo.Utilities;
import com.intersys.pojo.runtime.CachePOJOExtentManager;
import com.intersys.pojo.runtime.CachePOJOUtilities;
import com.intersys.pojo.runtime.DetachedObjectsManager;
import com.intersys.pojo.runtime.InstanceSettings;
import com.intersys.pojo.runtime.ObjectFactory;
import com.intersys.pojo.runtime.PojoOperations;
import com.intersys.pojo.runtime.PopulateUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;

public class CacheObjectManager
implements ObjectManager {
    private Database mDB;
    private Database mFullDB;
    private Connection mConnectionToClose;
    private PopulateUtils mPopulateUtils;
    private CachePOJOExtentManager mExtentManager;
    private CachePOJOUtilities mUtilities;
    private boolean mAllowProxy = true;
    private Settings mSettings;

    public CacheObjectManager(String string, String string2, String string3, Settings settings) throws CacheException {
        this.mDB = CacheDatabase.getLightDatabase(string, string2, string3);
        this.setUp(settings);
    }

    public CacheObjectManager(String string, String string2, String string3, String string4) throws CacheException {
        if ("full".equalsIgnoreCase(string4)) {
            this.mDB = CacheDatabase.getDatabase(string, string2, string3);
        } else if (string4 == null || "light".equalsIgnoreCase(string4)) {
            this.mDB = CacheDatabase.getLightDatabase(string, string2, string3);
        } else {
            throw new IllegalArgumentException("Unknown connection mode: " + string4);
        }
        this.setUp(null);
    }

    public CacheObjectManager(Connection connection, Settings settings) throws CacheException {
        this(connection, null, false, settings);
    }

    public CacheObjectManager(Connection connection, String string, boolean bl, Settings settings) throws CacheException {
        if ("full".equalsIgnoreCase(string)) {
            this.mDB = CacheDatabase.getDatabase(connection);
        } else if (string == null || "light".equalsIgnoreCase(string)) {
            this.mDB = CacheDatabase.getLightDatabase(connection);
        } else {
            throw new IllegalArgumentException("Unknown connection mode: " + string);
        }
        if (bl) {
            this.closeConnectionOnClose(connection);
        }
        this.setUp(settings);
    }

    private final void setUp(Settings settings) {
        if (settings == null) {
            this.mSettings = new InstanceSettings(this);
            return;
        }
        this.mSettings = new InstanceSettings(this, settings);
    }

    public static boolean accepts(Connection connection) {
        try {
            CacheConnection cacheConnection = JDBCAdapter.getCacheConnection(connection);
            return cacheConnection != null;
        }
        catch (CacheServerException cacheServerException) {
            return false;
        }
    }

    public void startTransaction() throws CacheException {
        if (this.isInTransaction()) {
            throw new CacheException("Already in transaction.");
        }
        this.mDB.transactionStart();
    }

    public void commit() throws CacheException {
        if (!this.isInTransaction()) {
            throw new CacheException("Not in transaction.");
        }
        this.mDB.transactionCommit();
    }

    public void rollback() throws CacheException {
        if (!this.isInTransaction()) {
            throw new CacheException("Not in transaction.");
        }
        this.mDB.transactionRollback();
    }

    public boolean isInTransaction() throws CacheException {
        return this.mDB.transactionLevel() > 0;
    }

    public Object openById(Class clazz, Object object) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        Id id = PojoOperations.toId(object);
        CacheRootObject cacheRootObject = (CacheRootObject)cacheClass.openObject(id);
        if (ObjectHandle.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            return cacheRootObject;
        }
        return cacheRootObject.detach(this.mAllowProxy);
    }

    public Object openByPrimaryKey(Class clazz, Object object) throws Exception {
        CandidateKey candidateKey;
        CacheClass cacheClass = this.findImplementation(clazz);
        if (object instanceof CandidateKey) {
            candidateKey = (CandidateKey)object;
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            String string = Array.get(object, 0).toString();
            for (int i = 1; i < n; ++i) {
                string = string + "," + Array.get(object, i).toString();
            }
            candidateKey = this.parseKeyString(cacheClass, string);
        } else {
            candidateKey = this.parseKeyString(cacheClass, object.toString());
        }
        CacheRootObject cacheRootObject = (CacheRootObject)cacheClass.openByKey(candidateKey);
        if (ObjectHandle.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            return cacheRootObject;
        }
        return cacheRootObject.detach(this.mAllowProxy);
    }

    public Iterator openByQuery(Class clazz, String string, Object[] objectArray) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        Iterator iterator = this.mDB.openByQuery(cacheClass.getName(), string, objectArray);
        if (ObjectHandle.class.isAssignableFrom(clazz) || clazz.isInterface()) {
            return iterator;
        }
        return new POJOIterator(iterator, this.mAllowProxy);
    }

    public Iterator openByQuery(String string, Object[] objectArray) throws Exception {
        Iterator iterator = this.mDB.openByQuery(string, objectArray);
        return new POJOIterator(iterator, this.mAllowProxy);
    }

    public Iterator openByQuery(String string, Object[] objectArray, boolean bl) throws Exception {
        Iterator iterator = this.mDB.openByQuery(string, objectArray);
        if (!bl) {
            iterator = new POJOIterator(iterator, this.mAllowProxy);
        }
        return iterator;
    }

    protected void closeConnectionOnClose(Connection connection) {
        this.mConnectionToClose = connection;
    }

    public void close() throws Exception {
        if (this.mFullDB != null && this.mFullDB != this.mDB) {
            this.mFullDB.close();
            this.mFullDB = null;
        }
        this.mDB.closeAllObjects();
        this.mDB.close();
        this.mDB = null;
        if (this.mConnectionToClose != null) {
            this.mConnectionToClose.close();
        }
    }

    public boolean isOpen() throws Exception {
        if (this.mDB == null) {
            return false;
        }
        return !this.mDB.isLowLevelConnectionClosed();
    }

    public ExtentManager extentManager() {
        if (this.mExtentManager == null) {
            this.mExtentManager = new CachePOJOExtentManager(this);
        }
        return this.mExtentManager;
    }

    public Utilities utilities() {
        if (this.mUtilities == null) {
            this.mUtilities = new CachePOJOUtilities(this);
        }
        return this.mUtilities;
    }

    public void removeFromDatabase(Class clazz, Serializable serializable) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        Id id = PojoOperations.toId(serializable);
        cacheClass.deleteObject(id);
    }

    public Serializable getId(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        Persistent persistent = this.findProxy(object, true);
        if (persistent != null) {
            return persistent.getId();
        }
        return PojoOperations.getPojoId(object, this.findImplementation(object.getClass()));
    }

    public Object getPrimaryKey(Object object) throws Exception {
        if (object instanceof Persistent) {
            Persistent persistent = (Persistent)object;
            return persistent.getBestCandidateKey();
        }
        if (object instanceof ObjectHandle) {
            return null;
        }
        Persistent persistent = this.findProxy(object, true);
        if (persistent != null) {
            return persistent.getBestCandidateKey();
        }
        return this.manager().findPojoPrimaryKey(object, null);
    }

    public Serializable save(Object object, boolean bl) throws Exception {
        if (object instanceof Persistent) {
            Persistent persistent = (Persistent)object;
            persistent.save();
            return persistent.getId();
        }
        Persistent persistent = this.attachInternal(object, bl);
        persistent.save(bl);
        persistent.copyTo(object, new HashMap(), bl);
        Id id = persistent.getId();
        return id;
    }

    public Serializable insert(Object object, boolean bl) throws Exception {
        if (object instanceof Persistent) {
            throw new IllegalArgumentException("Object " + object + " already exists in the database.");
        }
        CacheClass cacheClass = this.findImplementation(object.getClass());
        Persistent persistent = (Persistent)cacheClass.newInstance((String)null);
        persistent.attach(object, bl);
        persistent.save(bl);
        persistent.copyTo(object, new HashMap(), bl);
        Id id = persistent.getId();
        return id;
    }

    public void update(Object object, boolean bl) throws Exception {
        if (object instanceof Persistent) {
            Persistent persistent = (Persistent)object;
            persistent.save();
            return;
        }
        Persistent persistent = this.findProxy(object, false);
        if (persistent == null) {
            throw new IllegalArgumentException("Object " + object + " is not found in the database.");
        }
        persistent.attach(object, bl);
        persistent.save(bl);
        persistent.copyTo(object, new HashMap(), bl);
    }

    public void purgeFromMemory(Object object) throws Exception {
        this.manager().purge(object);
    }

    public void purgeEverything() throws Exception {
        this.manager().clear();
        this.mDB.closeAllObjects();
    }

    public void attach(Object object) throws Exception {
        this.attach(object, false);
    }

    public Serializable attach(Object object, boolean bl) throws Exception {
        Persistent persistent = this.attachInternal(object, bl);
        return persistent.getId();
    }

    public void refresh(Object object) throws Exception {
        Persistent persistent = this.findProxy(object, false);
        if (this.mDB.isLightConnection()) {
            Oid oid = persistent.getOid();
            Object object2 = persistent.getZRef();
            this.purgeFromMemory(object);
            this.mDB.closeObject(object2);
            persistent = (Persistent)Persistent._open(this.mDB, oid);
        } else {
            persistent._reload();
        }
        persistent.copyTo(object, new HashMap(), this.mAllowProxy);
    }

    public void swizzle(Object object) throws Exception {
        if (!ObjectFactory.isProxy(object)) {
            return;
        }
        Persistent persistent = this.attachInternal(object, false);
        persistent.swizzleOneLevel(object);
    }

    public Object detach(Object object) throws Exception {
        Persistent persistent = this.attachInternal(object, true);
        return persistent.detach(false);
    }

    public void flush() throws Exception {
        this.mDB.flush();
    }

    public void removeFromDatabase(Object object) throws Exception {
        this.removeFromDatabase(object.getClass(), this.getId(object));
    }

    public void removeFromDatabase(Class clazz, Object object) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        Id id = PojoOperations.toId(object);
        cacheClass.deleteObject(id);
    }

    public void removeFromDatabaseByPrimaryKey(Class clazz, Object object) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        CandidateKey candidateKey = object instanceof CandidateKey ? (CandidateKey)object : this.parseKeyString(cacheClass, object.toString());
        cacheClass.deleteObjectByKey(candidateKey);
    }

    public PopulateUtils populateUtils() throws Exception {
        if (this.mPopulateUtils == null) {
            this.mPopulateUtils = new PopulateUtils(this.getFullDatabase());
        }
        return this.mPopulateUtils;
    }

    public Settings settings() {
        return this.mSettings;
    }

    protected boolean allowProxy() {
        return this.mAllowProxy;
    }

    protected Database getFullDatabase() throws Exception {
        if (this.mFullDB == null) {
            this.mFullDB = this.mDB;
            if (this.mFullDB.isLightConnection()) {
                Connection connection = this.mFullDB.createStatement().getConnection();
                this.mFullDB = CacheDatabase.getDatabase(connection);
            }
        }
        return this.mFullDB;
    }

    protected Persistent attachInternal(Object object, boolean bl) throws Exception {
        Persistent persistent = this.findProxy(object, false);
        if (persistent == null) {
            CacheClass cacheClass = this.findImplementation(object.getClass());
            persistent = (Persistent)cacheClass.newInstance((String)null);
        }
        try {
            persistent.attach(object, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CacheException(exception, "Failed to copy from instance of " + object.getClass().getName() + " with id " + persistent.getId());
        }
        return persistent;
    }

    private Persistent findProxy(Object object, boolean bl) throws CacheException {
        if (object instanceof Persistent) {
            return (Persistent)object;
        }
        return this.manager().findProxy(object, bl);
    }

    protected CacheClass findImplementation(Class clazz) throws ClassNotFoundException, CacheException {
        Class clazz2 = ObjectFactory.getOriginalClass(clazz);
        return this.manager().findImplementation(clazz2);
    }

    private DetachedObjectsManager manager() {
        DetachedObjectsManager detachedObjectsManager = ((SysDatabase)this.mDB).getDetachedObjectsManager();
        return detachedObjectsManager;
    }

    private CandidateKey parseKeyString(CacheClass cacheClass, String string) throws CacheException {
        int n = string.indexOf(58);
        if (n < 0) {
            return this.createCandidateKey(cacheClass, string);
        }
        int n2 = string.indexOf(123);
        if (n2 < 0) {
            return this.createCandidateKey(cacheClass, string);
        }
        int n3 = string.indexOf(125);
        if (n3 < 0) {
            return this.createCandidateKey(cacheClass, string);
        }
        String string2 = string.substring(0, n).trim();
        if (!cacheClass.getName().equals(string2)) {
            throw new CacheException("Given key value is for class " + string2 + ". Must be for class " + cacheClass.getName());
        }
        String string3 = string.substring(n + 1, n2).trim();
        int n4 = string.indexOf(91);
        int n5 = string.indexOf(93);
        if (n4 < 0 || n5 < 0) {
            throw new CacheException("Key string: " + string + " contains no value");
        }
        string = string.substring(n4 + 1, n5);
        CandidateKey candidateKey = cacheClass.createKey(string3, string);
        return candidateKey;
    }

    private CandidateKey createCandidateKey(CacheClass cacheClass, String string) throws CacheException {
        CandidateKey candidateKey = cacheClass.createBestCandidateKey();
        candidateKey.set(string);
        return candidateKey;
    }

    protected boolean amIUseLightConnection() {
        return this.mDB.isLightConnection();
    }

    protected ClassLoader getClassLoader() {
        return ((SysDatabase)this.mDB).getClassLoader();
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.mDB.setClassLoader(classLoader);
        if (this.mFullDB != null && this.mFullDB != this.mDB) {
            this.mFullDB.setClassLoader(classLoader);
        }
    }

    protected int getClientCacheType() {
        return this.manager().getCacheType();
    }

    protected int setClientCacheType(int n) {
        int n2 = this.manager().getCacheType();
        this.manager().setCacheType(n);
        return n2;
    }

    protected int getFetchPolicy() {
        return this.manager().getFetchPolicy();
    }

    protected int setFetchPolicy(int n) {
        return this.manager().setFetchPolicy(n);
    }
}

