/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.cache.Dataholder;
import com.intersys.classes.ObjectHandle;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;

public class SList
extends AbstractList {
    Object mSysList;
    int mDefaultElementType = 24;

    public SList() {
        this.mSysList = SysListProxy.createSysList();
        SysListProxy.setServerLocale(this.mSysList, true, null);
    }

    public SList(Object object) {
        this.mSysList = object;
        SysListProxy.setServerLocale(this.mSysList, true, null);
    }

    public SList(Object object, boolean bl) {
        this.mSysList = object;
        if (!bl) {
            SysListProxy.setServerLocale(this.mSysList, true, null);
        }
    }

    public void setEncoding(String string) {
        SysListProxy.setServerLocale(this.mSysList, true, string);
    }

    public Object getAs(int n, String string) throws CacheException {
        try {
            Object object = SysListProxy.getWrappedItem(this.mSysList, n);
            Dataholder dataholder = new Dataholder(4096, object);
            return dataholder.getObject(string);
        }
        catch (SQLException sQLException) {
            String string2 = sQLException.getSQLState();
            if ("S1002".equals(string2)) {
                throw new IndexOutOfBoundsException("No data at Index " + n + " in the List: " + sQLException.getMessage());
            }
            throw new CacheException(sQLException, "Failed to get data at position " + n + " as " + string);
        }
    }

    public Object getAs(int n, Class clazz) throws CacheException {
        return this.getAs(n, clazz.getName());
    }

    public Object getAs(int n, Object object) throws CacheException {
        return this.getAs(n, object.getClass());
    }

    public Object get(int n) {
        try {
            return SysListProxy.getObject(this.mSysList, n);
        }
        catch (SQLException sQLException) {
            String string = sQLException.getSQLState();
            if ("S1002".equals(string)) {
                throw new IndexOutOfBoundsException("No data at Index " + n + " in the List: " + sQLException.getMessage());
            }
            throw new IllegalStateException("List is corrupted: " + sQLException.getMessage());
        }
    }

    public int size() {
        try {
            return SysListProxy.countItems(this.mSysList);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("List is corrupted: " + sQLException.getMessage());
        }
    }

    public String toString() {
        return this.mSysList.toString();
    }

    public SList sublist(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 < n) {
            throw new IndexOutOfBoundsException("Bad indices: [" + n + "," + n2 + "]");
        }
        try {
            Object object = SysListProxy.getSubList(this.mSysList, n2 - n, n);
            SList sList = new SList(object, true);
            return sList;
        }
        catch (SQLException sQLException) {
            if ("S1002".equals(sQLException.getSQLState())) {
                throw new IndexOutOfBoundsException("Second index is too big: [" + n + "," + n2 + "]");
            }
            throw new IllegalStateException("List is corrupted: " + sQLException.getMessage());
        }
    }

    public byte[] getData() {
        return SysListProxy.getBinaryData(this.mSysList);
    }

    public boolean add(Object object) {
        SList.appendObject(this.mSysList, object);
        return true;
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof SList) {
            if (collection.isEmpty()) {
                return false;
            }
            try {
                SysListProxy.concatenate(this.mSysList, ((SList)collection).mSysList);
            }
            catch (SQLException sQLException) {
                throw new IllegalArgumentException("Failed to concatenate two $Lists. Reason:  " + sQLException.getMessage());
            }
            return true;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SList.appendObject(this.mSysList, iterator.next());
            bl = true;
        }
        return bl;
    }

    public static SList build(Object object) {
        Object object2 = SysListProxy.createSysList();
        SList.appendObject(object2, object);
        return new SList(object2);
    }

    public static SList build(char c) {
        return SList.build((int)c);
    }

    public static SList build(byte by) {
        return SList.build((int)by);
    }

    public static SList build(int n) {
        try {
            Object object = SysListProxy.createSysList();
            SysListProxy.setInteger(object, n);
            return new SList(object);
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException("Failed to add object " + n + " to $List. Reason:  " + sQLException.getMessage());
        }
    }

    public static SList build(long l) {
        try {
            Object object = SysListProxy.createSysList();
            SysListProxy.setLong(object, l);
            return new SList(object);
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException("Failed to add object " + l + " to $List. Reason:  " + sQLException.getMessage());
        }
    }

    public static SList build(float f) {
        try {
            Object object = SysListProxy.createSysList();
            SysListProxy.setDouble(object, f);
            return new SList(object);
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException("Failed to add object " + f + " to $List. Reason:  " + sQLException.getMessage());
        }
    }

    public static SList build(double d) {
        try {
            Object object = SysListProxy.createSysList();
            SysListProxy.setDouble(object, d);
            return new SList(object);
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException("Failed to add object " + d + " to $List. Reason:  " + sQLException.getMessage());
        }
    }

    public static SList build(boolean bl) {
        try {
            Object object = SysListProxy.createSysList();
            SysListProxy.setBoolean(object, bl);
            return new SList(object);
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException("Failed to add object " + bl + " to $List. Reason:  " + sQLException.getMessage());
        }
    }

    public static SList buildAll(Collection collection) {
        Object object = SysListProxy.createSysList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SList.appendObject(object, iterator.next());
        }
        return new SList(object);
    }

    public void clear() {
        SysListProxy.clearList(this.mSysList);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SList)) {
            return false;
        }
        SList sList = (SList)object;
        return this.mSysList.equals(sList.mSysList);
    }

    private static void appendObject(Object object, Object object2) {
        try {
            SysListProxy.skipAll(object);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("List is corrupted: " + sQLException.getMessage());
        }
        try {
            if (object2 instanceof Dataholder) {
                ((Dataholder)object2).stuff(object);
            } else if (object2 instanceof ObjectHandle) {
                SysListProxy.setInteger(object, ((ObjectHandle)object2).getOref());
            } else if (object2 instanceof SList) {
                SysListProxy.setObject(object, ((SList)object2).mSysList);
            } else {
                SysListProxy.setObject(object, object2);
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException("Failed to add object " + object2 + " to $List. Reason:  " + sQLException.getMessage());
        }
        catch (CacheException cacheException) {
            throw new IllegalArgumentException("Failed to add object " + object2 + " to $List. Reason:  " + cacheException.getMessage());
        }
    }
}

