/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheParameterMetaData;
import com.intersys.jdbc.CacheResultSetMetaData;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.CacheStruct;
import com.intersys.jdbc.SysList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class CachePreparedStatement
extends CacheStatement
implements PreparedStatement {
    private static final int S_INIT = 0;
    private static final int S_ID = 1;
    private static final int S_CONSTANT = 2;
    private static final int S_ID_OP = 3;
    private static final int S_CONST_OP = 4;

    CachePreparedStatement(CacheConnection cacheConnection, int n, int n2, String string, String string2) throws SQLException {
        super(cacheConnection, n, n2, string2);
        this.prepare(string);
    }

    CachePreparedStatement(CacheConnection cacheConnection, int n, String string, int n2, long l) throws SQLException {
        super(cacheConnection, n, 1007, null);
        this.prepare(string, n2, l);
    }

    CachePreparedStatement(CacheConnection cacheConnection) throws SQLException {
        super(cacheConnection, 1003, 1007, null);
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        this.genericExecuteCalled = false;
        this.Query();
        this.myResultSet = this.createResultSet();
        this.updateCnt = -1;
        return this.myResultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw new SQLException("executeQuery(String sql) form not allowed", "S1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void Query() throws SQLException {
        this.fetchDone = false;
        if (this.statementType != 1 && this.statementType != 12) {
            throw new SQLException("executeQuery called with a non-query", "24000", 24000);
        }
        this.validateParameters();
        if (this.connection.cachedPrepares.get(new Integer(this.serverCursorNumber)) == null) {
            this.query404();
            return;
        }
        if (this instanceof CacheCallableStatement || this.statementType == 12) {
            this.storedProcedureQuery();
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            if (this.resultSetType == 1004) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_STATIC_CURSOR);
            } else {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_QUERY_EXECUTE);
            }
            this.writeParameters(this.output.wire);
            if (this.connection.protocolVersion > 38) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            this.handleError504(this.input.readHeader(this.serverCursorNumber, 0, 504));
        }
    }

    public synchronized int executeUpdate() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        this.genericExecuteCalled = false;
        this.Update();
        if (this.parameterSets == 0 || this.connection.protocolVersion < 14) {
            this.updateCnt = this.input.wire.getInt();
        }
        return this.updateCnt;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        throw new SQLException("executeUpdate(String sql) form not allowed", "S1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void Update() throws SQLException {
        if (this.statementType == 1 || this.statementType == 12) {
            throw new SQLException("executeUpdate called with a query", "24000", 24000);
        }
        this.validateParameters();
        if (this.connection.cachedPrepares.get(new Integer(this.serverCursorNumber)) == null) {
            this.update404();
            return;
        }
        if (this instanceof CacheCallableStatement || this.statementType == 13 || this.statementType == 11) {
            this.storedProcedureUpdate();
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_UPDATE_EXECUTE);
            if (this.connection.protocolVersion > 36) {
                this.output.wire.set(this.autoGeneratedKeyColumn);
            }
            int n = this.writePSUpdateParameters(this.output.wire);
            if (this.connection.protocolVersion == 35) {
                this.output.wire.set(this.autoGeneratedKeyColumn);
            }
            if (n != -1) {
                this.output.send(n);
            } else {
                this.output.send(this.connection.messageCount.getCount());
            }
            if (this.input.readHeader(this.serverCursorNumber, 0, 504) == 404) {
                this.update404();
                return;
            }
            this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
        }
    }

    protected synchronized int writePSUpdateParameters(SysList sysList) throws SQLException {
        int n = this.parameterSets;
        int n2 = -1;
        if (this.parameterSets == 0) {
            n = 1;
        }
        sysList.set(n);
        if (this.connection.protocolVersion > 2) {
            sysList.set(this.parameters.size());
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.parameters.size(); ++j) {
                CacheStatement.Parameter parameter = (CacheStatement.Parameter)this.parameters.elementAt(j);
                if (parameter.mode == 5) {
                    sysList.setParameter(parameter.values.elementAt(0));
                    continue;
                }
                if (parameter.mode == 6) {
                    sysList.setUndefined();
                    continue;
                }
                if (parameter.whatever.elementAt(i) == null) {
                    if (parameter.values.elementAt(i) instanceof CacheStatement.StreamWrapper) {
                        sysList.setParameter(this.sendStream(j, (CacheStatement.StreamWrapper)parameter.values.elementAt(i)));
                        continue;
                    }
                    n2 = sysList.setParameter(this.output.outputStream, this.connection, n2, parameter.values.elementAt(i));
                    continue;
                }
                sysList.setParameter(parameter.values.elementAt(i), parameter.whatever.elementAt(i));
            }
        }
        return n2;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setGeneric(n, null);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setGeneric(n, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setGeneric(n, new Short(by));
    }

    public void setShort(int n, short s) throws SQLException {
        this.setGeneric(n, new Short(s));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setGeneric(n, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.setGeneric(n, new Long(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setGeneric(n, new Float(f));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setGeneric(n, new Double(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setGeneric(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.setGeneric(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.getParameterTypeAbsolute(n) == -1) {
            throw new SQLException("Unsupported type conversion: byte[] to java.sql.Types.LONGVARCHAR", "S1000");
        }
        this.setGeneric(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setGeneric(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setGeneric(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setGeneric(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setGeneric(n, null);
            return;
        }
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        this.setGeneric(n, new CacheStatement.StreamWrapper(this, inputStream, 0, n2));
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("This api is no longer supported", "S1000");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setGeneric(n, null);
            return;
        }
        if (n2 == 0) {
            throw new SQLException("Cache currently does not support empty binary streams", "S1000");
        }
        if (this.getParameterTypeAbsolute(n) == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR", "S1000");
        }
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        }
        this.setGeneric(n, new CacheStatement.StreamWrapper(this, inputStream, 1, n2));
    }

    public synchronized void clearParameters() throws SQLException {
        if (this.parameterSets <= 1) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.unbindParameter(i);
            }
            this.parameterSets = 0;
            return;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            CacheStatement.Parameter parameter = (CacheStatement.Parameter)this.parameters.get(i);
            if (parameter.mode == 5 || parameter.mode == 6) continue;
            parameter.values.removeElementAt(this.parameterSets);
            parameter.whatever.removeElementAt(this.parameterSets);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setGeneric(n, null);
            return;
        }
        if (n2 == 2 || n2 == 3) {
            this.setGeneric(n, object, new Integer(n3));
        } else {
            this.setObject(n, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setGeneric(n, null);
            return;
        }
        int n2 = this.getParameterTypeAbsolute(n);
        if (n2 == -1 || n2 == -4) {
            if (object instanceof String) {
                if (((String)object).length() > 10000) {
                    this.setCharacterStream(n, (Reader)new StringReader((String)object), -1);
                    return;
                } else {
                    this.setGeneric(n, object);
                }
                return;
            } else if (object instanceof byte[]) {
                if (((byte[])object).length > 10000) {
                    this.setBinaryStream(n, (InputStream)new ByteArrayInputStream((byte[])object), -1);
                    return;
                } else {
                    this.setGeneric(n, object);
                }
                return;
            } else if (object instanceof InputStream) {
                if (n2 == -1) {
                    this.setAsciiStream(n, (InputStream)object, -1);
                    return;
                } else {
                    this.setBinaryStream(n, (InputStream)object, -1);
                }
                return;
            } else if (object instanceof Reader && n2 == -1) {
                this.setCharacterStream(n, (Reader)object, -1);
                return;
            } else {
                if (!(object instanceof Clob) || n2 != -1) throw new SQLException("Unsupported type conversion: " + object.getClass().getName() + " to java.sql.Types.LONGVARCHAR or java.sql.Types.LONGVARBINARY", "S1000");
                this.setClob(n, (Clob)object);
            }
            return;
        } else if (n2 == 2002) {
            try {
                SysList sysList = (SysList)((CacheStruct)object).serialize();
                SysList sysList2 = new SysList();
                sysList2.set(1);
                sysList2.set(sysList);
                this.setGeneric(n, sysList2);
                return;
            }
            catch (Exception exception) {
                SQLException sQLException = new SQLException("Invalid value for STRUCT", "S1000");
                sQLException.initCause(exception);
                throw sQLException;
            }
        } else {
            this.setGeneric(n, object);
        }
    }

    public synchronized boolean execute() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        this.genericExecuteCalled = true;
        if (this.multipleResultSets) {
            return this.executeMultipleResultSets();
        }
        if (this.statementType == 1 || this.statementType == 12) {
            this.Query();
            this.updateCnt = -1;
            return true;
        }
        this.Update();
        if (this.parameterSets == 0 || this.connection.protocolVersion < 14) {
            this.updateCnt = this.input.wire.getInt();
        }
        return false;
    }

    public boolean execute(String string) throws SQLException {
        throw new SQLException("execute(String sql) form not allowed", "S1000");
    }

    protected synchronized void prepare(String string) throws SQLException {
        this.cleanUp();
        this.preparse(string);
        this.prepareInternal();
    }

    protected synchronized void prepare(String string, int n, long l) throws SQLException {
        this.cleanUp();
        this.preparse(string, n, l);
        this.prepareInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void prepareInternal() throws SQLException {
        if (this.statementType == 7) {
            throw new SQLException("No output parameters allowed");
        }
        if (this.statementType == 2) {
            if (!this.getCachedInfo(this.sqlText)) {
                this.prepareStoredProcedure();
            }
            return;
        }
        if (this.statementType != 8 && this.statementType != 9 && this.getCachedInfo(this.sqlText)) {
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARE);
            this.output.wire.setSQLText(this.sqlText, this.connection.protocolVersion);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.serverCursorNumber, 0, 0);
            if (this.statementType == 1) {
                this.columnInfo(this.input.wire);
                this.parameterInfo(this.input.wire);
                if (this.statementType != 9) {
                    this.connection.addCachedPrepare(this.sqlText, this.serverCursorNumber, this, this.columns, this.parameters, this.statementType, this.hasReturnValue);
                }
            } else {
                this.parameterInfo(this.input.wire);
                if (this.statementType != 9) {
                    this.connection.addCachedPrepare(this.sqlText, this.serverCursorNumber, this, null, this.parameters, this.statementType, this.hasReturnValue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void prepareStoredProcedure() throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARE_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.serverCursorNumber, 0, 0);
            this.processStoredProcedureMetaData(this.input.wire, false, false);
            if (this.statementType == 1) {
                this.connection.addCachedPrepare(this.sqlText, this.serverCursorNumber, this, this.columns, this.parameters, this.statementType, this.hasReturnValue);
            } else {
                this.connection.addCachedPrepare(this.sqlText, this.serverCursorNumber, this, null, this.parameters, this.statementType, this.hasReturnValue);
            }
        }
    }

    private synchronized void setGeneric(int n, Object object) throws SQLException {
        this.setGeneric(n, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setGeneric(int n, Object object, Object object2) throws SQLException {
        Vector vector = this.parameters;
        synchronized (vector) {
            ((CacheStatement.Parameter)this.parameters.elementAt(this.getAbsoluteParameterIndex(n))).bind(object, object2, this.parameterSets);
        }
    }

    protected void validateParameters() throws SQLException {
        int n = 0;
        if (this.hasReturnValue == 1) {
            n = 1;
        }
        while (n < this.parameters.size()) {
            if (0 == ((CacheStatement.Parameter)this.parameters.elementAt((int)n)).mode) {
                throw new SQLException("Not all parameters bound/registered", "07001", 7001);
            }
            ++n;
        }
    }

    public synchronized void setDefault(int n) throws SQLException {
        ((CacheStatement.Parameter)this.parameters.elementAt((int)this.getAbsoluteParameterIndex((int)n))).mode = 6;
    }

    public synchronized void addBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        ++this.parameterSets;
        for (int i = 0; i < this.parameters.size(); ++i) {
            CacheStatement.Parameter parameter = (CacheStatement.Parameter)this.parameters.elementAt(i);
            if (parameter.mode == 5 || parameter.values.size() == this.parameterSets) continue;
            if (this.parameterSets != 1 && parameter.values.size() + 1 == this.parameterSets) {
                parameter.whatever.add(parameter.whatever.elementAt(parameter.values.size() - 1));
                parameter.values.add(parameter.values.elementAt(parameter.values.size() - 1));
                continue;
            }
            throw new SQLException("Not all parameters bound for this addBatch", "S1000");
        }
    }

    public void addBatch(String string) throws SQLException {
        throw new SQLException("addBatch(String sql) form not allowed", "S1000");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null) {
            this.setGeneric(n, null);
            return;
        }
        this.setGeneric(n, new CacheStatement.StreamWrapper(this, reader, 4, n2));
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (blob == null) {
            this.setGeneric(n, null);
            return;
        }
        if (this.getParameterTypeAbsolute(n) != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (clob == null) {
            this.setGeneric(n, null);
            return;
        }
        if (this.getParameterTypeAbsolute(n) != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        this.setCharacterStream(n, clob.getCharacterStream(), (int)clob.length());
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        return new CacheResultSetMetaData(this);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setGeneric(n, date, calendar);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setGeneric(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setGeneric(n, timestamp, calendar);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setGeneric(n, null);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new CacheParameterMetaData(this.parameters);
    }
}

