/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.DatabaseWithReferenceMap;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.ListBuffer;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SysListOfObjects;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheNullValueException;
import com.intersys.objects.Logger;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ObjectListBuffer
extends ListBuffer {
    private Object mClassBuffer = null;
    private Set mUnusedOrefs = new HashSet();
    private Set mLockedOrefs = new HashSet();

    ObjectListBuffer(SysListOfObjects sysListOfObjects, int n) throws CacheException {
        super(sysListOfObjects, n);
    }

    ObjectListBuffer(SysListOfObjects sysListOfObjects) throws CacheException {
        super(sysListOfObjects);
    }

    protected Object getListBuffer(int n, int n2) throws CacheException {
        this.clearUnusedOrefs(true);
        SysDatabase sysDatabase = this.mList.getDatabase();
        Object object = sysDatabase.getObjectListBuffer(this.mList.getOref(), n, n2);
        Object object2 = null;
        Object object3 = null;
        try {
            object3 = SysListProxy.createSysList();
            object2 = this.processListBuffer(sysDatabase, object, object3);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to process received list object buffer");
        }
        sysDatabase.processObjectBuffer(object3, object, this);
        return object2;
    }

    private Object processListBuffer(SysDatabase sysDatabase, Object object, Object object2) throws CacheException, SQLException {
        Object object3 = SysListProxy.getSysList(object);
        if (SysListProxy.atEnd(object3)) {
            return null;
        }
        Object object4 = SysListProxy.getSysList(object3);
        this.mClassBuffer = SysListProxy.getSysList(object3);
        while (!SysListProxy.atEnd(object4)) {
            boolean bl;
            int n = SysListProxy.getInteger(object4);
            String string = SysListProxy.getString(this.mClassBuffer);
            if (n == 0) continue;
            Integer n2 = new Integer(n);
            boolean bl2 = bl = this.mLockedOrefs.contains(n2) || sysDatabase.ensureInMap(n, string);
            if (!bl) {
                if (this.mUnusedOrefs.add(n2)) {
                    SysListProxy.setInteger(object2, n);
                }
                if (Logger.getDebugReferenceCountLevel() <= 0) continue;
                Logger.out.println("List Buffer: Added oref = " + n);
                continue;
            }
            this.mLockedOrefs.add(n2);
            if (Logger.getDebugReferenceCountLevel() <= 0) continue;
            Logger.out.println("List Buffer: Skipped oref = " + n);
        }
        return object4;
    }

    public Object dbGetAt(Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mList.runInstanceMethod("GetAt", dataholderArray, 1);
        CacheObject cacheObject = null;
        if (dataholder.getType() == 1026) {
            cacheObject = dataholder.getCacheObject();
        } else {
            Integer n2 = dataholder.getInteger();
            if (n2 == null) {
                return null;
            }
            int n3 = n2;
            String string = RegisteredObject.getCacheClassName();
            cacheObject = this.mList.getDatabase().getCacheObjectUnsafe(string, n3);
        }
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.newJavaInstance(true);
    }

    public Object _getAt(Integer n) throws CacheException {
        if (n == null || n < 0 || n > this.count()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index " + n + " of List " + this.mList.getOref());
        }
        int n2 = n;
        ListBuffer.DataWithIndex dataWithIndex = this.getAt(n2);
        Dataholder dataholder = dataWithIndex.data;
        if (dataholder == null) {
            return this.dbGetAt(n);
        }
        try {
            int n3 = dataholder.getIntValue();
            Integer n4 = new Integer(n3);
            boolean bl = !this.mUnusedOrefs.remove(n4);
            String string = SysListProxy.getString(this.mClassBuffer, dataWithIndex.index - 1);
            SysDatabase sysDatabase = this.mList.getDatabase();
            CacheObject cacheObject = sysDatabase.getCacheObjectUnsafe(string, n3);
            CacheClass cacheClass = sysDatabase.getCacheClass(string);
            cacheObject.setCacheClass(cacheClass);
            Object object = cacheObject.newJavaInstance(true);
            return object;
        }
        catch (CacheNullValueException cacheNullValueException) {
            return null;
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to process received array object buffer");
        }
    }

    public void onDatabaseDestroy() throws CacheException {
        this.clearUnusedOrefs(false);
        super.onDatabaseDestroy();
    }

    public void invalidateCache(boolean bl) throws CacheException {
        this.clearUnusedOrefs(bl);
        super.invalidateCache(bl);
    }

    private void clearUnusedOrefs(boolean bl) throws CacheException {
        if (this.mUnusedOrefs.isEmpty() && this.mLockedOrefs.isEmpty()) {
            if (Logger.getDebugReferenceCountLevel() > 1) {
                Logger.out.println("List Buffer: no orefs to remove.");
            }
            return;
        }
        DatabaseWithReferenceMap databaseWithReferenceMap = (DatabaseWithReferenceMap)this.mList.getDatabase();
        for (Integer n : this.mUnusedOrefs) {
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println("List Buffer: Removed oref = " + n);
            }
            databaseWithReferenceMap.decreaseServerReferenceCount(n, 1);
        }
        if (bl) {
            Iterator iterator = this.mLockedOrefs.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (Logger.getDebugReferenceCountLevel() > 1) {
                    Logger.out.println("List Buffer: Releasing oref = " + n);
                }
                databaseWithReferenceMap.releaseEnsuredFromMap(n);
            }
        }
        this.mLockedOrefs.clear();
        this.mUnusedOrefs.clear();
    }

    public void close(boolean bl) throws CacheException {
        this.invalidateCache(bl);
        super.close(bl);
    }

    protected void finalize() throws Throwable {
        this.close(true);
        super.finalize();
    }
}

