/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.serial;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.MetadataFactory;
import com.intersys.cache.serial.FullSerialStorageInfo;
import com.intersys.cache.serial.SerialCacheClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.reflect.CacheClass;
import java.sql.SQLException;

public abstract class SerialMetadataFactory
implements MetadataFactory {
    protected SysDatabase mDB;

    protected SerialMetadataFactory(SysDatabase sysDatabase) {
        this.mDB = sysDatabase;
    }

    public final CacheClass getCacheClass(String string) throws CacheException {
        try {
            byte[] byArray = this.getSerialInfo(string);
            if (byArray == null) {
                throw new CacheException("Class metadata not found: " + string);
            }
            FullSerialStorageInfo fullSerialStorageInfo = new FullSerialStorageInfo(byArray);
            return new SerialCacheClass(string, this.mDB, fullSerialStorageInfo);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get data for serial class " + string);
        }
    }

    public abstract byte[] getSerialInfo(String var1) throws SQLException;
}

