/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.jbind.ZObjValReader;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.classes.SerialObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;

public class ReadOnlyCacheObject
implements CacheObject {
    private String mClassName;
    private ReadOnlyDatabase mDB;
    private ZObjValReader mZobjVal;
    private int mOref;
    private int mState;

    public ReadOnlyCacheObject(ReadOnlyDatabase readOnlyDatabase, String string, int n, ZObjValReader zObjValReader) {
        this.mDB = readOnlyDatabase;
        this.mClassName = string;
        this.mOref = n;
        this.mZobjVal = zObjValReader;
        this.mState |= 0xFF01;
    }

    public final Object getZRef() {
        return new Integer(this.mOref);
    }

    public final int getOref() {
        return this.mOref;
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        boolean bl = n3 == 1;
        Dataholder dataholder = this.mZobjVal.getProperty(n, n2);
        if (dataholder == null) {
            dataholder = Dataholder.create(null);
        }
        if (bl && dataholder.getType() != 1026) {
            dataholder = this.getCacheObject(dataholder);
            this.setCachedObject(n, n2, dataholder);
        }
        return dataholder;
    }

    public SysDatabase getDatabase() {
        return this.mDB;
    }

    private Dataholder getCacheObject(Dataholder dataholder) throws CacheException {
        ReadOnlyDatabase readOnlyDatabase = (ReadOnlyDatabase)this.getDatabase();
        return readOnlyDatabase.getCacheObject(dataholder);
    }

    private Object myKey() {
        return this.mDB.constructKey(this.mClassName, this.mOref);
    }

    private void setCachedObject(int n, int n2, Dataholder dataholder) throws CacheException {
        this.mZobjVal.setCachedObject(n, n2, dataholder);
    }

    public Oid getOid() throws CacheException {
        Oid oid = null;
        if (this.mZobjVal != null) {
            oid = this.mZobjVal.getOid();
        }
        return oid;
    }

    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
        throw new CacheException("Set is not supported in Read-Only mode");
    }

    public int save(boolean bl) throws CacheException {
        throw new CacheException("Save is not supported in Read-Only mode");
    }

    public Object getSerialState(Object object) throws CacheException {
        LightDatabase lightDatabase = (LightDatabase)this.mDB.getLightDatabase();
        CacheClass cacheClass = lightDatabase.getCacheClass(this.getCacheClass().getName());
        SerialObject serialObject = null;
        Object object2 = cacheClass.newInstance("");
        try {
            serialObject = (SerialObject)object2;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            int n = cacheField.isLiteral() ? 0 : 1;
            Dataholder dataholder = this.getProperty(cacheField.getII(), cacheField.getJJ(), n, cacheField.getName());
            Object object3 = cacheField.isLiteral() ? dataholder.getObject(cacheField.getJavaTypeName()) : dataholder.getCacheObject();
            cacheField.set(serialObject, object3);
        }
        return serialObject.getProxy().getSerialState(object);
    }

    public void delete() throws CacheException {
        throw new CacheException("Delete is not supported in Read-Only mode");
    }

    public boolean isClosed() {
        return false;
    }

    public CacheObject getMe() {
        return this;
    }

    public void setCacheClass(CacheClass cacheClass) throws CacheException {
    }

    public String getTypeName() {
        return this.mClassName;
    }

    public Object newJavaInstance() throws CacheException {
        return this.newJavaInstance(false);
    }

    public Object newJavaInstance(boolean bl) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        return cacheClass.newInstance(this, bl);
    }

    public CacheClass getCacheClass() throws CacheException {
        return this.mDB.getCacheClass(this.mClassName);
    }

    public Id getId() throws CacheException {
        return this.getOid().getId();
    }

    public void forceClose() throws CacheException {
    }

    public void increaseReferenceCount() throws CacheException {
    }

    public void decreaseReferenceCount() throws CacheException {
    }

    public Dataholder runInstanceMethod(String string, Dataholder[] dataholderArray, int n) throws CacheException {
        return null;
    }

    public Dataholder[] runInstanceMethod(String string, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        return null;
    }

    public void setUserData(Object object) {
    }

    public Object getUserData() {
        return null;
    }

    public void increaseCount() throws CacheException {
    }

    public void decreaseCount() throws CacheException {
    }

    public void assertNotClosed(boolean bl) throws CacheException {
        throw new UnsupportedOperationException("Method assertNotClosed() is not implemented in class com.intersys.cache.jbind.ReadOnlyCacheObject");
    }

    public String toOrefString() throws CacheException {
        return String.valueOf(this.getOref()) + '@' + this.getCacheClass().getName();
    }

    public int getState() {
        return this.mState;
    }

    public void clearState() {
        this.mState = 65280;
    }

    public void setStateReadDirty() {
        this.mState |= 0xFF01;
    }

    public String toString() {
        return this.mOref + "@" + this.mClassName;
    }
}

