/*
 * Decompiled with CFR 0.152.
 */
package com.citrix.mas.nitro.datatypes;

import java.net.Inet6Address;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class MPSConstraint {
    public abstract void validate(Object var1, String var2) throws Exception;

    public static boolean isValidIP4(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        while (stringTokenizer.hasMoreElements()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n <= 255 && n >= 0) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIP6(String string) {
        try {
            Inet6Address inet6Address = (Inet6Address)Inet6Address.getByName(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isValidIP(String string) {
        if (MPSConstraint.isValidIP4(string)) {
            return true;
        }
        return MPSConstraint.isValidIP6(string);
    }

    public static boolean isValidIP6Net(String string) {
        if (string.contains("/")) {
            String[] stringArray = string.split("/");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (!MPSConstraint.isValidIP6(string2)) {
                return false;
            }
            int n = Integer.parseInt(string3);
            return n >= 1 && n <= 128;
        }
        return false;
    }

    public static boolean isValidHostName(String string) {
        Pattern pattern;
        if (string.length() > 255) {
            return false;
        }
        String string2 = "^[A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9_-]*[A-Za-z0-9]$";
        try {
            pattern = Pattern.compile(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        String[] stringArray = string.split(".");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 63) {
                return false;
            }
            Matcher matcher = pattern.matcher(stringArray[i]);
            if (matcher != null) {
                if (matcher.matches()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isValidInternetHost(String string) {
        if (MPSConstraint.isValidIP(string)) {
            return true;
        }
        return MPSConstraint.isValidHostName(string);
    }
}

