/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseControl;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
extends Thread {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private static transient int m_highMsgId;
    private transient InputStream m_serverInput;
    private transient OutputStream m_serverOutput;
    private transient Hashtable m_requests;
    private transient Hashtable m_messages = null;
    private transient Vector m_registered;
    private transient boolean m_disconnected = false;
    private transient LDAPCache m_cache = null;
    private transient boolean m_doRun = true;
    private Socket m_socket = null;
    private transient Thread m_thread = null;
    transient Object m_sendRequestLock = new Object();
    transient LDAPConnSetupMgr m_connMgr = null;
    transient PrintWriter m_traceOutput = null;

    public LDAPConnThread(LDAPConnSetupMgr lDAPConnSetupMgr, LDAPCache lDAPCache, OutputStream outputStream) throws LDAPException {
        super("LDAPConnThread " + lDAPConnSetupMgr.getHost() + ":" + lDAPConnSetupMgr.getPort());
        this.m_requests = new Hashtable();
        this.m_registered = new Vector();
        this.m_connMgr = lDAPConnSetupMgr;
        this.m_socket = lDAPConnSetupMgr.getSocket();
        this.setCache(lDAPCache);
        this.setTraceOutputStream(outputStream);
        this.setDaemon(true);
        try {
            this.m_serverInput = new BufferedInputStream(this.m_socket.getInputStream());
            this.m_serverOutput = new BufferedOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.m_doRun = false;
            this.start();
            throw new LDAPException("failed to connect to server " + this.m_connMgr.getHost(), 91);
        }
        this.start();
    }

    void abandon(int n) {
        LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)this.m_requests.remove(new Integer(n));
        if (this.m_messages != null) {
            this.m_messages.remove(new Integer(n));
        }
        if (lDAPMessageQueue != null) {
            lDAPMessageQueue.removeRequest(n);
        }
        this.resultRetrieved();
    }

    private int allocateId() {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            int n = m_highMsgId = (m_highMsgId + 1) % Integer.MAX_VALUE;
            Object var3_3 = null;
            return n;
        }
    }

    private synchronized void cacheSearchResult(LDAPSearchListener lDAPSearchListener, LDAPMessage lDAPMessage, int n) {
        Integer n2 = new Integer(lDAPMessage.getID());
        Long l = lDAPSearchListener.getKey();
        Vector vector = null;
        if (this.m_cache == null || l == null) {
            return;
        }
        if (lDAPMessage instanceof LDAPSearchResult) {
            vector = (Vector)this.m_messages.get(n2);
            if (vector == null) {
                vector = new Vector();
                this.m_messages.put(n2, vector);
                vector.addElement(new Long(0L));
            }
            if ((Long)vector.firstElement() == -1L) {
                return;
            }
            long l2 = (Long)vector.firstElement() + (long)n;
            if (l2 > this.m_cache.getSize()) {
                vector.removeAllElements();
                vector.addElement(new Long(-1L));
                return;
            }
            vector.setElementAt(new Long(l2), 0);
            vector.addElement(((LDAPSearchResult)lDAPMessage).getEntry());
        } else if (lDAPMessage instanceof LDAPSearchResultReference) {
            vector = (Vector)this.m_messages.get(n2);
            if (vector == null) {
                vector = new Vector();
                this.m_messages.put(n2, vector);
            } else {
                vector.removeAllElements();
            }
            vector.addElement(new Long(-1L));
        } else if (lDAPMessage instanceof LDAPResponse) {
            boolean bl = ((LDAPResponse)lDAPMessage).getResultCode() > 0;
            vector = (Vector)this.m_messages.remove(n2);
            if (!bl) {
                if (vector == null) {
                    vector = new Vector();
                    vector.addElement(new Long(0L));
                }
                if ((Long)vector.firstElement() != -1L) {
                    this.m_cache.addEntry(l, vector);
                }
            }
        }
    }

    private void checkBacklog() throws InterruptedException {
        boolean bl;
        do {
            Object object;
            bl = false;
            Enumeration enumeration = this.m_requests.elements();
            while (enumeration.hasMoreElements()) {
                object = (LDAPMessageQueue)enumeration.nextElement();
                if (!(object instanceof LDAPSearchListener)) {
                    bl = false;
                    break;
                }
                LDAPSearchListener lDAPSearchListener = (LDAPSearchListener)object;
                if (lDAPSearchListener.isAsynchOp()) {
                    if (lDAPSearchListener.getMessageCount() < lDAPSearchListener.getSearchConstraints().getMaxBacklog()) continue;
                    bl = true;
                    continue;
                }
                if (lDAPSearchListener.getSearchConstraints().getBatchSize() == 0 || lDAPSearchListener.getMessageCount() < lDAPSearchListener.getSearchConstraints().getMaxBacklog()) continue;
                bl = true;
            }
            if (!bl) continue;
            object = this;
            synchronized (object) {
                this.wait();
            }
        } while (bl);
    }

    private void cleanUp() {
        if (!this.m_disconnected) {
            Object object;
            Object object2;
            try {
                try {
                    this.m_serverOutput.close();
                }
                catch (Exception exception) {
                }
                object2 = null;
                this.m_serverOutput = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.m_serverOutput = null;
                throw throwable;
            }
            try {
                try {
                    this.m_serverInput.close();
                }
                catch (Exception exception) {
                }
                object2 = null;
                this.m_serverInput = null;
            }
            catch (Throwable throwable) {
                object2 = null;
                this.m_serverInput = null;
                throw throwable;
            }
            try {
                try {
                    this.m_socket.close();
                }
                catch (Exception exception) {
                }
                object2 = null;
                this.m_socket = null;
            }
            catch (Throwable throwable) {
                object2 = null;
                this.m_socket = null;
                throw throwable;
            }
            this.m_disconnected = true;
            this.m_connMgr.disconnect();
            if (this.m_requests != null) {
                object = this.m_requests.elements();
                while (object.hasMoreElements()) {
                    object2 = (LDAPMessageQueue)object.nextElement();
                    ((LDAPMessageQueue)object2).removeAllRequests(this);
                }
            }
            if (this.m_registered != null) {
                object = (Vector)this.m_registered.clone();
                object2 = ((Vector)object).elements();
                while (object2.hasMoreElements()) {
                    LDAPConnection lDAPConnection = (LDAPConnection)object2.nextElement();
                    lDAPConnection.deregisterConnection();
                }
            }
            this.m_registered = null;
            this.m_messages = null;
            this.m_requests.clear();
        }
    }

    public synchronized void deregister(LDAPConnection lDAPConnection) {
        block6: {
            this.m_registered.removeElement(lDAPConnection);
            if (this.m_registered.size() != 0) break block6;
            try {
                this.m_doRun = false;
                if (!this.m_disconnected) {
                    LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                    this.sendRequest(null, new JDAPUnbindRequest(), null, lDAPSearchConstraints);
                }
                if (this.m_thread != null && this.m_thread != Thread.currentThread()) {
                    this.m_thread.interrupt();
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.cleanUp();
            }
            catch (Exception exception) {
                LDAPConnection.printDebug(exception.toString());
            }
        }
    }

    synchronized int getClientCount() {
        return this.m_registered.size();
    }

    InputStream getInputStream() {
        return this.m_serverInput;
    }

    OutputStream getOutputStream() {
        return this.m_serverOutput;
    }

    private synchronized void networkError(Exception exception) {
        this.m_connMgr.invalidateConnection();
        try {
            Enumeration enumeration = this.m_requests.elements();
            while (enumeration.hasMoreElements()) {
                LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)enumeration.nextElement();
                lDAPMessageQueue.setException(this, new LDAPException("Server down", 80));
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Exception: " + nullPointerException.toString());
        }
        this.cleanUp();
    }

    private void processResponse(LDAPMessage lDAPMessage, int n) {
        int n2;
        LDAPConnection lDAPConnection;
        LDAPControl[] lDAPControlArray;
        Integer n3 = new Integer(lDAPMessage.getID());
        LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)this.m_requests.get(n3);
        if (lDAPMessageQueue == null) {
            return;
        }
        if (!lDAPMessageQueue.isAsynchOp() && (lDAPControlArray = lDAPMessage.getControls()) != null && (lDAPConnection = lDAPMessageQueue.getConnection(n2 = lDAPMessage.getID())) != null) {
            lDAPConnection.setResponseControls(this, new LDAPResponseControl(lDAPConnection, n2, lDAPControlArray));
        }
        if (this.m_cache != null && lDAPMessageQueue instanceof LDAPSearchListener) {
            this.cacheSearchResult((LDAPSearchListener)lDAPMessageQueue, lDAPMessage, n);
        }
        lDAPMessageQueue.addMessage(lDAPMessage);
        if (lDAPMessage instanceof LDAPResponse) {
            this.m_requests.remove(n3);
        }
    }

    public synchronized void register(LDAPConnection lDAPConnection) {
        if (!this.m_registered.contains(lDAPConnection)) {
            this.m_registered.addElement(lDAPConnection);
        }
    }

    synchronized void resultRetrieved() {
        this.notifyAll();
    }

    public void run() {
        if (!this.m_doRun) {
            return;
        }
        this.m_thread = Thread.currentThread();
        LDAPMessage lDAPMessage = null;
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        while (this.m_doRun) {
            Object object;
            Thread.yield();
            int[] nArray = new int[]{0};
            try {
                this.checkBacklog();
                BERElement bERElement = BERElement.getElement(jDAPBERTagDecoder, this.m_serverInput, nArray);
                lDAPMessage = LDAPMessage.parseMessage(bERElement);
                if (this.m_traceOutput != null) {
                    object = this.m_sendRequestLock;
                    synchronized (object) {
                        this.m_traceOutput.println(lDAPMessage.toTraceString());
                        this.m_traceOutput.flush();
                    }
                }
                this.processResponse(lDAPMessage, nArray[0]);
            }
            catch (Exception exception) {
                if (this.m_doRun) {
                    this.networkError(exception);
                    this.m_doRun = false;
                    continue;
                }
                object = this;
                synchronized (object) {
                    this.m_thread = null;
                    this.notifyAll();
                }
            }
        }
    }

    void sendRequest(LDAPConnection lDAPConnection, JDAPProtocolOp jDAPProtocolOp, LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (this.m_serverOutput == null) {
            throw new LDAPException("not connected to a server", 81);
        }
        LDAPMessage lDAPMessage = new LDAPMessage(this.allocateId(), jDAPProtocolOp, lDAPConstraints.getServerControls());
        if (lDAPMessageQueue != null) {
            if (!(jDAPProtocolOp instanceof JDAPAbandonRequest) && !(jDAPProtocolOp instanceof JDAPUnbindRequest)) {
                this.m_requests.put(new Integer(lDAPMessage.getID()), lDAPMessageQueue);
                this.resultRetrieved();
            }
            lDAPMessageQueue.addRequest(lDAPMessage.getID(), lDAPConnection, this, lDAPConstraints.getTimeLimit());
        }
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            try {
                if (this.m_traceOutput != null) {
                    this.m_traceOutput.println(lDAPMessage.toTraceString());
                    this.m_traceOutput.flush();
                }
                lDAPMessage.write(this.m_serverOutput);
                this.m_serverOutput.flush();
            }
            catch (IOException iOException) {
                this.networkError(iOException);
            }
        }
    }

    synchronized void setCache(LDAPCache lDAPCache) {
        this.m_cache = lDAPCache;
        this.m_messages = this.m_cache != null ? new Hashtable() : null;
    }

    void setInputStream(InputStream inputStream) {
        this.m_serverInput = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.m_serverOutput = outputStream;
    }

    void setTraceOutputStream(OutputStream outputStream) {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            this.m_traceOutput = outputStream == null ? null : new PrintWriter(outputStream);
        }
    }
}

