/*
 * Decompiled with CFR 0.152.
 */
package com.zehon.ftps;

import com.zehon.BatchTransferProgress;
import com.zehon.FileTransferClient;
import com.zehon.exception.FileTransferException;
import com.zehon.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;

public class FTPsClient
extends FileTransferClient {
    private String serverName;
    private String username;
    private String password;
    private String keyStoreFilePath;
    private String keyStorePassword;
    private boolean isImplicit = false;
    private int port = 21;
    private boolean passive = true;
    private static final Log log = LogFactory.getLog(FTPsClient.class);

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public void setImplicit(boolean isImplicit) {
        this.isImplicit = isImplicit;
    }

    public FTPsClient() {
    }

    public FTPsClient(String serverName, String username, String password, boolean isImplicit) {
        this.setServerName(serverName);
        this.setUsername(username);
        this.setPassword(password);
        this.setImplicit(isImplicit);
    }

    public FTPsClient(String serverName, int port, String username, String password, boolean isImplicit) {
        this.setServerName(serverName);
        this.setPort(port);
        this.setUsername(username);
        this.setPassword(password);
        this.setImplicit(isImplicit);
    }

    public FTPsClient(String serverName, String username, String password, boolean isImplicit, String keyStoreFilePath, String keyStorePassword) {
        this.setServerName(serverName);
        this.setUsername(username);
        this.setPassword(password);
        this.setImplicit(isImplicit);
        if (keyStoreFilePath == null || keyStorePassword == null) {
            throw new RuntimeException("keyStoreFilePath or keyStorePassword can not be null!");
        }
        this.setKeyStoreFilePath(keyStoreFilePath);
        this.setKeyStorePassword(keyStorePassword);
    }

    public FTPsClient(String serverName, int port, String username, String password, boolean isImplicit, String keyStoreFilePath, String keyStorePassword) {
        this.setServerName(serverName);
        this.setPort(port);
        this.setUsername(username);
        this.setPassword(password);
        this.setImplicit(isImplicit);
        if (keyStoreFilePath == null || keyStorePassword == null) {
            throw new RuntimeException("keyStoreFilePath or keyStorePassword can not be null!");
        }
        this.setKeyStoreFilePath(keyStoreFilePath);
        this.setKeyStorePassword(keyStorePassword);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected boolean validate() {
        try {
            Class<?> ftpsDependency = Class.forName("org.apache.commons.net.ftp.FTPSClient");
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"++++++++++++PLEASE MAKE SURE HAVE ALL THE DEPENDENCY JARS IN THE CLASSPATH ++++++");
            return false;
        }
        return super.validate();
    }

    public int sendFile(String localFilePath, String ftpDestFolder) throws FileTransferException {
        return this.sendFile(localFilePath, ftpDestFolder, null);
    }

    public int sendFile(String localFilePath, String filetransferDestFolder, String nameOfFileToStore) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        BufferedInputStream is = null;
        try {
            int status;
            File localFile = new File(localFilePath);
            if (!localFile.exists()) {
                throw new FileTransferException(localFilePath + " does not exist!");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading file from " + localFilePath));
            }
            is = new BufferedInputStream(new FileInputStream(localFile));
            if (nameOfFileToStore == null) {
                nameOfFileToStore = FileUtils.getFileName(localFilePath);
            }
            int n = status = this.sendFile(is, nameOfFileToStore, filetransferDestFolder);
            return n;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public int sendFile(InputStream inputStream, String nameOfFileToStore, String ftpDestFolder) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            int n = this.sendFileHelper(inputStream, nameOfFileToStore, ftpDestFolder, client);
            return n;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    private int sendFileHelper(InputStream inputStream, String nameOfFileToStore, String ftpDestFolder, FTPSClient client) throws IOException {
        String filePath = FileUtils.getFilePath(ftpDestFolder, nameOfFileToStore, false);
        client.setFileTransferMode(10);
        client.setFileType(2);
        boolean storeFile = client.storeFile(filePath, inputStream);
        if (storeFile) {
            return 1;
        }
        return 0;
    }

    public InputStream getFileAsStream(String remoteFileName, String ftpFolder) throws FileTransferException {
        if (!this.validate()) {
            return null;
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            InputStream inputStream = this.getFileAsStreamHelper(remoteFileName, ftpFolder, client);
            return inputStream;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    private InputStream getFileAsStreamHelper(String remoteFileName, String ftpFolder, FTPSClient client) throws IOException, FileTransferException {
        String filePath = FileUtils.getFilePath(ftpFolder, remoteFileName, false);
        client.setFileTransferMode(10);
        client.setFileType(2);
        InputStream retrieveFileStream = client.retrieveFileStream(filePath);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtils.readStream(retrieveFileStream, byteArrayOutputStream);
        if (!FTPReply.isPositivePreliminary((int)client.getReplyCode())) {
            throw new FileTransferException(filePath + " can not be read!");
        }
        client.completePendingCommand();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return byteArrayInputStream;
    }

    public int getFile(String remoteFileName, String ftpFolder, String toLocalFolder) throws FileTransferException {
        return super.getFile(remoteFileName, ftpFolder, toLocalFolder);
    }

    public int deleteFile(String nameOfFileToDelete, String ftpFolder) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            int n = this.deleteFileHelper(nameOfFileToDelete, ftpFolder, client);
            return n;
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    private int deleteFileHelper(String nameOfFileToDelete, String ftpFolder, FTPSClient client) throws IOException {
        String filePath = FileUtils.getFilePath(ftpFolder, nameOfFileToDelete, false);
        if (!this.fileExistsHelper(ftpFolder, nameOfFileToDelete, client)) {
            return 3;
        }
        boolean delete = client.deleteFile(filePath);
        if (log.isDebugEnabled()) {
            log.debug((Object)new StringBuffer(50).append("Deleting file: ").append(filePath).toString());
        }
        if (delete) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createFolder(String nameOfFolderToCreate, String ftpsFolder) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        FTPSClient client = null;
        try {
            boolean makeDirectory;
            client = this.getFTPSClient();
            String filePath = FileUtils.getFilePath(ftpsFolder, nameOfFolderToCreate, false);
            if (this.folderExists(filePath)) {
                int n = 1;
                return n;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer(50).append("Creating folder ").append(filePath).toString());
            }
            if (makeDirectory = client.makeDirectory(filePath)) {
                int n = 1;
                return n;
            }
            throw new FileTransferException("Can not create folder" + filePath);
        }
        catch (Exception ex) {
            throw new FileTransferException(ex);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    public int moveFile(String nameOfFileToMove, String ftpFromFolder, String newNameOfFile, String ftpToFolder) throws FileTransferException {
        int n;
        if (!this.validate()) {
            return 2;
        }
        if (ftpFromFolder.equals(ftpToFolder) && nameOfFileToMove.equals(newNameOfFile)) {
            throw new FileTransferException("Can not move to the same folder with the same name");
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            if (!this.fileExistsHelper(ftpFromFolder, nameOfFileToMove, client)) {
                int n2 = 3;
                return n2;
            }
            InputStream fileToMoveStream = this.getFileAsStreamHelper(nameOfFileToMove, ftpFromFolder, client);
            this.sendFileHelper(fileToMoveStream, newNameOfFile, ftpToFolder, client);
            this.deleteFileHelper(nameOfFileToMove, ftpFromFolder, client);
            n = 1;
        }
        catch (Throwable t) {
            throw new FileTransferException(t);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
        return n;
    }

    public int copyFile(String sourceFilePath, String destFilePath) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        if (sourceFilePath.equals(destFilePath)) {
            throw new FileTransferException("Can not copy to itself");
        }
        String nameOfFileToCopy = FileUtils.getFileName(sourceFilePath);
        String sourceFilePathPrefix = FileUtils.getFilePathPrefix(sourceFilePath);
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            if (!this.fileExistsHelper(sourceFilePathPrefix, nameOfFileToCopy, client)) {
                int n = 3;
                return n;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer(50).append("Copying file(s) from ").append(sourceFilePath).append(" to ").append(destFilePath).toString());
            }
            if (this.folderExistsHelper(sourceFilePath, client)) {
                this.copyFileHelper(sourceFilePath, destFilePath, client);
            } else {
                this.copyAFile(nameOfFileToCopy, sourceFilePathPrefix, destFilePath, client);
            }
        }
        catch (Throwable t) {
            throw new FileTransferException(t);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
        return 1;
    }

    private void copyAFile(String nameOfFileToCopy, String copySourcePath, String destPath, FTPSClient client) throws FileTransferException, IOException {
        InputStream fileToCopyStream = this.getFileAsStreamHelper(nameOfFileToCopy, copySourcePath, client);
        String destFileName = "";
        String destFolder = "";
        if (this.folderExistsHelper(destPath, client)) {
            destFileName = nameOfFileToCopy;
            destFolder = destPath;
        } else {
            destFileName = FileUtils.getFileName(destPath);
            destFolder = FileUtils.getFilePathPrefix(destPath);
        }
        this.sendFileHelper(fileToCopyStream, destFileName, destFolder, client);
    }

    private void copyFileHelper(String sourcePath, String destPath, FTPSClient client) throws FileTransferException, IOException {
        FTPFile[] listFiles = client.listFiles(sourcePath);
        for (int i = 0; i < listFiles.length; ++i) {
            FTPFile ftpFile = listFiles[i];
            String ftpFileName = ftpFile.getName();
            String fullFTPPath = FileUtils.getFilePath(sourcePath, ftpFileName, false);
            if (ftpFile.isDirectory()) {
                String subDestPath = FileUtils.getFilePath(destPath, ftpFileName, false);
                if (!client.makeDirectory(subDestPath)) {
                    throw new FileTransferException("Can not create directory " + subDestPath);
                }
                this.copyFileHelper(fullFTPPath, subDestPath, client);
                continue;
            }
            this.copyAFile(ftpFileName, sourcePath, destPath, client);
        }
    }

    public int getFolder(String ftpsFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return this.getFolder(ftpsFolder, toLocalFolder, batchTransferProgress, true, true);
    }

    public int getFolder(String ftpsFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return this.getFolder(ftpsFolder, toLocalFolder, batchTransferProgress, true, recursive);
    }

    public int getFolderCreate(String ftpsFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return this.getFolder(ftpsFolder, toLocalFolder, batchTransferProgress, false, true);
    }

    public int getFolderCreate(String ftpsFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return this.getFolder(ftpsFolder, toLocalFolder, batchTransferProgress, false, recursive);
    }

    protected int getFolder(String filetransferFolder, String toLocalFolder, BatchTransferProgress batchTransferProgress, boolean justFolderContent, boolean recursive) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        File file = new File(toLocalFolder);
        if (!file.exists()) {
            throw new FileTransferException(toLocalFolder + " does not exist!");
        }
        if (!file.isDirectory()) {
            throw new FileTransferException(toLocalFolder + " is not a directory");
        }
        FTPSClient client = null;
        try {
            String nameOfFolderToCreate22;
            File newFolder;
            boolean mkdir;
            client = this.getFTPSClient();
            if (!justFolderContent && !(mkdir = (newFolder = new File(toLocalFolder = FileUtils.getFilePath(toLocalFolder, nameOfFolderToCreate22 = FileUtils.getFileName(filetransferFolder), true))).mkdir())) {
                throw new FileTransferException(toLocalFolder + " can not be created!");
            }
            this.getFolderHelper(filetransferFolder, toLocalFolder, client, batchTransferProgress, recursive);
            int nameOfFolderToCreate22 = 1;
            return nameOfFolderToCreate22;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    private void getFolderHelper(String ftpFolder, String toLocalFolder, FTPSClient client, BatchTransferProgress batchTransferProgress, boolean recursive) throws IOException, Exception {
        FTPFile[] listFiles = client.listFiles(ftpFolder);
        for (int i = 0; i < listFiles.length; ++i) {
            String filePath;
            block6: {
                FTPFile ftpFile = listFiles[i];
                String ftpFileName = ftpFile.getName();
                String fullFTPPath = FileUtils.getFilePath(ftpFolder, ftpFileName, false);
                if (ftpFile.isDirectory()) {
                    String subToLocalFolder = FileUtils.getFilePath(toLocalFolder, ftpFileName, true);
                    File subDir = new File(subToLocalFolder);
                    subDir.mkdir();
                    if (!recursive) continue;
                    this.getFolderHelper(fullFTPPath, subToLocalFolder, client, batchTransferProgress, recursive);
                    continue;
                }
                filePath = fullFTPPath;
                if (batchTransferProgress != null) {
                    batchTransferProgress.transferStart(filePath);
                }
                try {
                    client.setFileType(2);
                    InputStream retrieveFileStream = client.retrieveFileStream(fullFTPPath);
                    this.writeToFile(retrieveFileStream, toLocalFolder, ftpFileName);
                    if (!FTPReply.isPositivePreliminary((int)client.getReplyCode())) {
                        throw new FileTransferException(fullFTPPath + " can not be read!");
                    }
                    client.completePendingCommand();
                }
                catch (Throwable t) {
                    log.error((Object)t);
                    if (batchTransferProgress == null) break block6;
                    batchTransferProgress.transferError(filePath, t);
                }
            }
            if (batchTransferProgress == null) continue;
            batchTransferProgress.transferComplete(filePath);
        }
    }

    public String[] getFileNamesInFolder(String ftpFolder) throws FileTransferException {
        if (!this.validate()) {
            return null;
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            FTPFile[] listFiles = client.listFiles(ftpFolder);
            String[] listNames = new String[listFiles.length];
            for (int i = 0; i < listFiles.length; ++i) {
                FTPFile file = listFiles[i];
                listNames[i] = file.getName();
            }
            String[] stringArray = listNames;
            return stringArray;
        }
        catch (Throwable t) {
            throw new FileTransferException(t);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    public int sendFolder(String sendingFolder, String ftpsFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return this.sendFolder(sendingFolder, ftpsFolder, batchTransferProgress, true, true);
    }

    public int sendFolder(String sendingFolder, String ftpsFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return this.sendFolder(sendingFolder, ftpsFolder, batchTransferProgress, true, recursive);
    }

    public int sendFolderCreate(String sendingFolder, String ftpsFolder, BatchTransferProgress batchTransferProgress) throws FileTransferException {
        return this.sendFolder(sendingFolder, ftpsFolder, batchTransferProgress, false, true);
    }

    public int sendFolderCreate(String sendingFolder, String ftpsFolder, BatchTransferProgress batchTransferProgress, boolean recursive) throws FileTransferException {
        return this.sendFolder(sendingFolder, ftpsFolder, batchTransferProgress, false, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFolderHelper(String sendingFolder, String ftpFolder, BatchTransferProgress batchTransferProgress, FTPSClient client, boolean recursive) throws FileTransferException, IOException {
        File folder = new File(sendingFolder);
        File[] listFiles = folder.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            File localFile = listFiles[i];
            String localFileName = localFile.getName();
            String fullFTPPath = FileUtils.getFilePath(ftpFolder, localFileName, false);
            if (localFile.isDirectory()) {
                String subFTPFolder = fullFTPPath;
                if (!client.makeDirectory(subFTPFolder)) {
                    throw new FileTransferException("Can not create directory " + subFTPFolder);
                }
                if (!recursive) continue;
                this.sendFolderHelper(localFile.getCanonicalPath(), subFTPFolder, batchTransferProgress, client, recursive);
                continue;
            }
            String filePath = localFile.getCanonicalPath();
            if (batchTransferProgress != null) {
                batchTransferProgress.transferStart(filePath);
            }
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(localFile));
                client.setFileTransferMode(10);
                client.setFileType(2);
                if (!client.storeFile(fullFTPPath, is)) {
                    throw new FileTransferException("Can not upload file " + fullFTPPath);
                }
            }
            catch (Throwable t) {
                log.error((Object)t);
                if (batchTransferProgress != null) {
                    batchTransferProgress.transferError(filePath, t);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (batchTransferProgress == null) continue;
            batchTransferProgress.transferComplete(filePath);
        }
    }

    protected int sendFolder(String sendingFolder, String filetransferFolder, BatchTransferProgress batchTransferProgress, boolean justFolderContent, boolean recursive) throws FileTransferException {
        if (!this.validate()) {
            return 2;
        }
        File directory = new File(sendingFolder);
        if (!directory.exists()) {
            throw new FileTransferException(sendingFolder + " does not exist!");
        }
        if (!directory.isDirectory()) {
            throw new FileTransferException(sendingFolder + " is not a directory");
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            if (!justFolderContent) {
                String nameOfFolderToCreate = FileUtils.getFileName(sendingFolder);
                this.createFolder(nameOfFolderToCreate, filetransferFolder);
                filetransferFolder = FileUtils.getFilePath(filetransferFolder, nameOfFolderToCreate, false);
            }
            this.sendFolderHelper(sendingFolder, filetransferFolder, batchTransferProgress, client, recursive);
            int nameOfFolderToCreate = 1;
            return nameOfFolderToCreate;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean folderExists(String ftpFolder) throws FileTransferException {
        if (!this.validate()) {
            throw new FileTransferException("Invalid Setting, username or password or servername is missing!");
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            boolean bl = this.folderExistsHelper(ftpFolder, client);
            return bl;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean folderExistsHelper(String ftpFolder, FTPSClient client) throws IOException {
        if (ftpFolder == null) {
            return false;
        }
        if ("/".equals(ftpFolder)) {
            return true;
        }
        if (ftpFolder.endsWith("/")) {
            ftpFolder = ftpFolder.substring(0, ftpFolder.length() - 1);
        }
        if (ftpFolder.lastIndexOf("/") >= 0) {
            String parentFolder = ftpFolder.substring(0, ftpFolder.lastIndexOf("/") + 1);
            String fileName = FileUtils.getFileName(ftpFolder);
            FTPFile[] listFiles = client.listFiles(parentFolder);
            for (int i = 0; i < listFiles.length; ++i) {
                FTPFile file = listFiles[i];
                if (!file.getName().equals(fileName) || !file.isDirectory()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fileExists(String ftpFolder, String nameOfFile) throws FileTransferException {
        if (!this.validate()) {
            throw new FileTransferException("Invalid Setting, username or password or servername is missing!");
        }
        FTPSClient client = null;
        try {
            client = this.getFTPSClient();
            boolean bl = this.fileExistsHelper(ftpFolder, nameOfFile, client);
            return bl;
        }
        catch (Throwable e) {
            throw new FileTransferException(e);
        }
        finally {
            if (client != null) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean fileExistsHelper(String ftpFolder, String nameOfFile, FTPSClient client) throws IOException {
        if (nameOfFile == null) {
            return false;
        }
        FTPFile[] listFiles = client.listFiles(ftpFolder);
        for (int i = 0; i < listFiles.length; ++i) {
            FTPFile file = listFiles[i];
            if (!file.getName().equals(nameOfFile) || !file.isFile()) continue;
            return true;
        }
        return false;
    }

    private KeyManager[] getKeyManagers() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, java.security.cert.CertificateException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(this.getKeyStoreFilePath()), this.getKeyStorePassword().toCharArray());
        KeyManagerFactory tmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ks, this.getKeyStorePassword().toCharArray());
        return tmf.getKeyManagers();
    }

    private TrustManager[] getTrustManagers() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, java.security.cert.CertificateException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(this.getKeyStoreFilePath()), this.getKeyStorePassword().toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        return tmf.getTrustManagers();
    }

    private FTPSClient getFTPSClient() throws NoSuchAlgorithmException, SocketException, IOException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, java.security.cert.CertificateException, CertificateException {
        FTPSClient client = new FTPSClient(this.isImplicit());
        client.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        if (this.useSecureData()) {
            KeyManager keyManager = this.getKeyManagers()[0];
            TrustManager trustManager = this.getTrustManagers()[0];
            client.setControlEncoding("UTF-8");
            client.setKeyManager(keyManager);
            client.setTrustManager(trustManager);
            client.setTrustManager((TrustManager)new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            });
        }
        client.connect(this.getServerName(), this.getPort());
        if (this.useSecureData()) {
            client.execPBSZ(0L);
            client.execPROT("P");
        }
        client.login(this.getUsername(), this.getPassword());
        int replyCode = client.getReplyCode();
        if (FTPReply.isPositiveCompletion((int)replyCode)) {
            if (this.isPassive()) {
                client.enterLocalPassiveMode();
            }
            return client;
        }
        if (client.isConnected()) {
            client.disconnect();
        }
        return null;
    }

    private boolean useSecureData() {
        return this.getKeyStoreFilePath() != null && this.getKeyStorePassword() != null;
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        return null;
    }

    protected String getProtocol() {
        return "ftps";
    }
}

