/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.trace.RootTracer;
import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMPojoBoolean;
import com.eg.jtm.JTMSqlBoolean;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.RequestIdentifier;
import com.eg.jtm.UPDManager;
import com.eg.jtm.URLPatternData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MethodEventProcessor {
    private static ThreadLocal<RequestIdentifier> reqIdTL = new ThreadLocal();

    public static RequestIdentifier getRequestIdentifier() {
        RequestIdentifier ReqId = reqIdTL.get();
        return ReqId;
    }

    static void removeObjectFromThreadLocal() {
        reqIdTL.remove();
        reqIdTL.set(null);
        RootTracer.pojoBlockLocal.set(null);
        RootTracer.sqlBlockLocal.set(null);
    }

    static void removeFromThreadLocal() {
        RequestIdentifier ReqId = reqIdTL.get();
        if (ReqId != null) {
            MethodInfo Minfo = ReqId.getRootMinfo();
            ReqId.removeObjectFromCutOffMethodTracker(Minfo);
            ReqId.freeMemory();
            ReqId = null;
        }
        reqIdTL.remove();
        reqIdTL.set(null);
        RootTracer.pojoBlockLocal.set(null);
        RootTracer.sqlBlockLocal.set(null);
    }

    public static boolean eventStarted(RequestIdentifier ReqId, Map reqProps, String compType, String className, String methodName, String desc, long timeStamp, List urlPatternsMatched) {
        boolean rootSuccess;
        block9: {
            rootSuccess = false;
            try {
                if (ReqId == null) {
                    if (urlPatternsMatched != null) {
                        if (MethodInfo.isFrontEndComp(compType)) {
                            ReqId = new RequestIdentifier(new MethodInfo(null, null, null, null, null));
                            reqIdTL.set(ReqId);
                            boolean isRootMethodInfo = true;
                            JTMPojoBoolean pojoBoolean = new JTMPojoBoolean();
                            pojoBoolean.setPojoFlag(false);
                            JTMSqlBoolean sqlBoolean = new JTMSqlBoolean();
                            sqlBoolean.setSqlFlag(false);
                            RootTracer.pojoBlockLocal.set(pojoBoolean);
                            RootTracer.sqlBlockLocal.set(sqlBoolean);
                            rootSuccess = ReqId.onMethodStart(className, methodName, desc, timeStamp, reqProps, compType, urlPatternsMatched, isRootMethodInfo);
                            JTMLog.logger.debug(String.valueOf(compType) + "  EventStarted  " + ReqId.getReqGUID() + "    " + (String)reqProps.get("requestID") + "    " + className + "." + methodName);
                        }
                    } else if (MethodInfo.isFrontEndComp(compType)) {
                        JTMLog.logger.debug("URL request " + className + "." + methodName + "." + desc + " did not match any patterns. Not monitoring it");
                    }
                    break block9;
                }
                boolean isRootMethodInfo = false;
                boolean result = false;
                try {
                    result = ReqId.onMethodStart(className, methodName, desc, timeStamp, reqProps, compType, urlPatternsMatched, isRootMethodInfo);
                    JTMLog.logger.debug(String.valueOf(compType) + "  EventStarted  " + ReqId.getReqGUID() + "    " + className + "." + methodName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
            catch (Exception excpn) {
                JTMLog.logger.warn("[MethodEventProcessor - eventStarted ] Exception while recording an event start", excpn);
                rootSuccess = false;
            }
        }
        return rootSuccess;
    }

    public static void eventEnded(RequestIdentifier ReqId, boolean addToUPD, boolean hasMethodFailed, long timeStamp) {
        try {
            if (ReqId != null) {
                MethodInfo Minfo;
                JTMLog.logger.debug(String.valueOf(ReqId.getCurrentMinfo().getType()) + "   EventEnded   " + ReqId.getReqGUID() + "  " + ReqId.getCurrentMinfo().getClassName() + "." + ReqId.getCurrentMinfo().getMethodName());
                if (ReqId.onMethodEnd(hasMethodFailed, timeStamp) && addToUPD && (Minfo = ReqId.getRootMinfo()).isCompleted()) {
                    boolean isMoreThanCutOff;
                    reqIdTL.remove();
                    reqIdTL.set(null);
                    RootTracer.pojoBlockLocal.remove();
                    RootTracer.sqlBlockLocal.remove();
                    Minfo.calculateMinfo(ReqId, true);
                    boolean bl = isMoreThanCutOff = Minfo.getExecutionTime() > UPDManager.getMethExecCutOff();
                    if (isMoreThanCutOff || Minfo.isErrorURL() || Minfo.isExtCallURL()) {
                        MethodEventProcessor.addToUPD(Minfo);
                    } else if (!isMoreThanCutOff) {
                        MethodEventProcessor.updateAllUrlDetails(Minfo);
                    }
                    ReqId.removeObjectFromCutOffMethodTracker(Minfo);
                    ReqId.freeMemory();
                    ReqId = null;
                }
            }
        }
        catch (Exception excpn) {
            JTMLog.logger.warn("[MethodEventProcessor - eventEnded ] Exception ", excpn);
        }
    }

    public static void eventEnded(boolean hasMethodFailed, long timeStamp) {
        try {
            RequestIdentifier ReqId = reqIdTL.get();
            if (ReqId != null) {
                JTMLog.logger.debug(String.valueOf(ReqId.getCurrentMinfo().getType()) + "    EventEnded    " + ReqId.getReqGUID() + "    " + ReqId.getCurrentMinfo().getClassName() + "." + ReqId.getCurrentMinfo().getMethodName());
                ReqId.onMethodEnd(hasMethodFailed, timeStamp);
            }
        }
        catch (Exception excpn) {
            JTMLog.logger.warn("[MethodEventProcessor - eventEnded ] Exception ", excpn);
        }
    }

    public static void pojoEventEnded(RequestIdentifier ReqId, boolean addToUPD, boolean hasMethodFailed, long timeStamp) {
        try {
            if (ReqId != null) {
                ReqId.onMethodEnd(hasMethodFailed, timeStamp);
            }
        }
        catch (Exception excpn) {
            JTMLog.logger.warn("[MethodEventProcessor - pojoEventEnded ] Exception ", excpn);
        }
    }

    private static void updateAllUrlDetails(MethodInfo Minfo) {
        JTMLog.logger.info("URL " + Minfo.getProperties().get("requestID") + " matched patterns " + Minfo.getUrlPatternsMatched());
        Iterator itr = Minfo.getUrlPatternsMatched().iterator();
        boolean doNull = true;
        while (itr.hasNext()) {
            String pName = (String)itr.next();
            URLPatternData matchingUPD = (URLPatternData)UPDManager.getUPDTblWC().get(pName);
            if (matchingUPD == null) continue;
            matchingUPD.updateAllUrlCount(Minfo);
            doNull = false;
        }
        if (doNull) {
            Minfo.clearURLTree();
        }
    }

    private static void addToUPD(MethodInfo Minfo) {
        JTMLog.logger.info("URL " + Minfo.getProperties().get("requestID") + " matched patterns " + Minfo.getUrlPatternsMatched());
        Iterator itr = Minfo.getUrlPatternsMatched().iterator();
        boolean doNull = true;
        while (itr.hasNext()) {
            String pName = (String)itr.next();
            URLPatternData matchingUPD = (URLPatternData)UPDManager.getUPDTblWC().get(pName);
            if (matchingUPD == null) continue;
            matchingUPD.addURLInfo(Minfo);
            doNull = false;
        }
        if (doNull) {
            Minfo.clearURLTree();
        }
    }

    public static void addStalledURLDetails(MethodInfo Minfo, RequestIdentifier requestIdentifier) {
        JTMLog.logger.warn("Stalled URL " + Minfo.getProperties().get("requestID") + "  " + Minfo.getExecutionTime() + " matched patterns " + Minfo.getUrlPatternsMatched());
        Minfo.clearURLTree();
    }
}

