/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMPojoBoolean;
import com.eg.jtm.JTMSqlBoolean;
import com.eg.jtm.JTMUtils;
import com.eg.jtm.MethodEventProcessor;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.RequestIdentifier;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class LongRunningTrackerThread
implements Runnable {
    private RequestIdentifier requestIdentifier = null;
    private Thread parentThread = null;
    private JTMPojoBoolean booleanPojoObject = null;
    private JTMSqlBoolean booleanSqlObject = null;

    public LongRunningTrackerThread(RequestIdentifier requestIdentifier, JTMPojoBoolean booleanPojoObject, JTMSqlBoolean booleanSqlObject, Thread parentThread) {
        this.requestIdentifier = requestIdentifier;
        this.parentThread = parentThread;
        this.booleanPojoObject = booleanPojoObject;
        this.booleanSqlObject = booleanSqlObject;
    }

    public void run() {
        if (this.requestIdentifier != null && this.parentThread != null) {
            MethodEventProcessor.removeObjectFromThreadLocal();
            this.parentThreadLocalDetails();
            MethodInfo rootMinfo = this.requestIdentifier.getRootMinfo();
            long timestamp = JTMUtils.getTimeStamp();
            while (!rootMinfo.isCompleted()) {
                this.requestIdentifier.onMethodEnd(false, timestamp);
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MethodEventProcessor.addStalledURLDetails(rootMinfo, this.requestIdentifier);
            this.requestIdentifier.removeObjectFromCutOffMethodTracker(rootMinfo);
            this.requestIdentifier.freeMemory();
            this.requestIdentifier = null;
        }
    }

    private boolean parentThreadLocalDetails() {
        boolean result;
        block25: {
            result = false;
            if (this.parentThread == null) {
                return result;
            }
            Field threadLocalsField = null;
            try {
                threadLocalsField = Thread.class.getDeclaredField("threadLocals");
                threadLocalsField.setAccessible(true);
            }
            catch (SecurityException e) {
                return result;
            }
            catch (NoSuchFieldException e) {
                return result;
            }
            Class<?> threadLocalMapKlazz = null;
            Field tableField = null;
            Object fieldLocal = null;
            Object table = null;
            try {
                threadLocalMapKlazz = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            }
            catch (ClassNotFoundException e) {
                return result;
            }
            try {
                try {
                    tableField = threadLocalMapKlazz.getDeclaredField("table");
                    tableField.setAccessible(true);
                    fieldLocal = threadLocalsField.get(this.parentThread);
                    if (fieldLocal == null || (table = tableField.get(fieldLocal)) == null) break block25;
                    int threadLocalCount = Array.getLength(table);
                    int i = 0;
                    while (i < threadLocalCount) {
                        Object entry = Array.get(table, i);
                        if (entry != null) {
                            try {
                                String className;
                                Field valueField = entry.getClass().getDeclaredField("value");
                                valueField.setAccessible(true);
                                Object value = valueField.get(entry);
                                if (value != null && (className = value.getClass().getName()).startsWith("com.eg.jtm.")) {
                                    if (value instanceof RequestIdentifier) {
                                        if (this.requestIdentifier == value) {
                                            valueField.set(entry, null);
                                            result = true;
                                        }
                                    } else if (value instanceof JTMPojoBoolean) {
                                        if (this.booleanPojoObject == value) {
                                            valueField.set(entry, null);
                                            result = true;
                                        }
                                    } else if (value instanceof JTMSqlBoolean && this.booleanSqlObject == value) {
                                        valueField.set(entry, null);
                                        result = true;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            catch (Throwable throwable) {}
        }
        return result;
    }
}

