/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.EgClassFileTransformer;
import com.eg.agent.adapter.EgJSPMethodAdviceAdapter;
import com.eg.agent.adapter.EgPojoMethodAdviceAdapter;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;

public class EgJSPClassVisitor
extends ClassVisitor {
    private String className;
    private boolean isExcludePojoClass = false;
    private int classFileVersion;
    private String serviceMethodName = "_jspService";
    private static final String serviceMethodDesc = "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V";

    public EgJSPClassVisitor(ClassVisitor classVisitor, String className, ClassLoader loader, int classFileVersion) {
        super(327680, classVisitor);
        this.className = className;
        this.classFileVersion = classFileVersion;
        this.isExcludePojoClass = EgClassFileTransformer.isClassPresentExcludePojo(className);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv != null) {
            if ((access & 0x100) != 0) {
                return mv;
            }
            if ((access & 0x400) != 0) {
                return mv;
            }
            if (name.equals("<clinit>") || name.equals("<init>") || name.equals("init")) {
                return mv;
            }
            if (name.equals(this.serviceMethodName) && desc.equals(serviceMethodDesc)) {
                mv = new EgJSPMethodAdviceAdapter(access, mv, name, desc, this.className, true, this.classFileVersion);
            } else if (PropsManager.isPojoTrack() && !this.isExcludePojoClass) {
                boolean proceed = true;
                if (name.indexOf("$") > 0) {
                    proceed = false;
                } else if (name.startsWith("_")) {
                    proceed = false;
                } else if (this.isExcludePojoClass) {
                    proceed = false;
                }
                if (proceed) {
                    mv = new EgPojoMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
                }
            }
            return mv;
        }
        return null;
    }
}

