/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.trace.utils;

import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMUtils;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import com.eg.org.objectweb.asm.Type;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;

public class TraceUtils {
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern, Locale.US);
    public static final int NumRowsInStackTrace = 10;
    public static final String ExcpnRowSep = "?^?";
    public static final long smallDummyTime = 9000L;
    private static final char space = ' ';

    public static String getParamNames(String descString) {
        StringBuffer paramString = new StringBuffer();
        Type[] paramTypes = Type.getArgumentTypes(descString);
        int paramLen = paramTypes.length;
        int k = 0;
        while (k < paramLen) {
            Type tp = paramTypes[k];
            String internalName = "";
            internalName = tp.equals(Type.BOOLEAN_TYPE) ? "boolean" : (tp.equals(Type.BYTE_TYPE) ? "byte" : (tp.equals(Type.CHAR_TYPE) ? "char" : (tp.equals(Type.SHORT_TYPE) ? "short" : (tp.equals(Type.INT_TYPE) ? "int" : (tp.equals(Type.LONG_TYPE) ? "long" : (tp.equals(Type.FLOAT_TYPE) ? "float" : (tp.equals(Type.DOUBLE_TYPE) ? "double" : (tp.equals(Type.VOID_TYPE) ? "void" : tp.getInternalName()))))))));
            int lastIndex = internalName.lastIndexOf("/");
            if (lastIndex > 0) {
                String paramClassName = internalName.substring(lastIndex + 1);
                paramString.append(String.valueOf(paramClassName) + ",");
            } else {
                paramString.append(String.valueOf(internalName) + ",");
            }
            ++k;
        }
        String resultParam = paramString.toString();
        int index = resultParam.lastIndexOf(",");
        if (index > 0) {
            resultParam = resultParam.substring(0, index);
        }
        return resultParam;
    }

    public static HashMap getSOAPCallInfo(Object soapMsgObject, Object urlObject) {
        HashMap<String, String> result = new HashMap<String, String>();
        ClassLoader soapCallObjLoader = soapMsgObject.getClass().getClassLoader();
        Object[] args = new Object[]{};
        Class<?> clazz = null;
        Object targetUrl = "-";
        Object operationName = "-";
        try {
            if (urlObject != null) {
                targetUrl = urlObject;
            }
            clazz = soapCallObjLoader == null ? Class.forName("javax.xml.soap.SOAPMessage") : soapCallObjLoader.loadClass("javax.xml.soap.SOAPMessage");
            Method getSOAPBodyMethod = clazz.getMethod("getSOAPBody", new Class[0]);
            getSOAPBodyMethod.setAccessible(true);
            Object soapBodyObject = getSOAPBodyMethod.invoke(soapMsgObject, args);
            if (soapBodyObject != null) {
                Class<?> soapBodyClazz = null;
                soapBodyClazz = soapCallObjLoader != null ? soapCallObjLoader.loadClass("javax.xml.soap.SOAPBody") : Class.forName("javax.xml.soap.SOAPBody");
                Method getFirstChildMethod = soapBodyClazz.getMethod("getFirstChild", new Class[0]);
                getFirstChildMethod.setAccessible(true);
                Object firstChildObject = getFirstChildMethod.invoke(soapBodyObject, args);
                Class<?> nodeClazz = null;
                nodeClazz = soapCallObjLoader != null ? soapCallObjLoader.loadClass("org.w3c.dom.Node") : Class.forName("org.w3c.dom.Node");
                Method getLocalNameMethod = nodeClazz.getMethod("getLocalName", new Class[0]);
                getLocalNameMethod.setAccessible(true);
                operationName = getLocalNameMethod.invoke(firstChildObject, args);
                if (operationName == null) {
                    operationName = "-";
                }
            }
        }
        catch (Exception e) {
            JTMLog.logger.error("[TraceUtils - getSOAPCallInfo] Exception Occured ", e);
        }
        result.put("OperationName", operationName.toString());
        result.put("TargetUrl", targetUrl.toString());
        return result;
    }

    public static HashMap getHttpCallInfo(Object httpCallObj) {
        HashMap<String, String> result = new HashMap<String, String>();
        String extUrl = "-";
        String requestMethod = "GET";
        boolean isHttpCall = httpCallObj instanceof HttpURLConnection;
        if (isHttpCall) {
            HttpURLConnection httpConn = (HttpURLConnection)httpCallObj;
            URL httpUrl = httpConn.getURL();
            extUrl = httpUrl.toString();
            requestMethod = httpConn.getRequestMethod();
        }
        result.put("EXTURL", extUrl);
        result.put("METHOD", requestMethod);
        return result;
    }

    public static HashMap getAxisCallInfo(Object callObj) {
        HashMap<String, String> result = new HashMap<String, String>();
        ClassLoader axisCallObjLoader = callObj.getClass().getClassLoader();
        Object[] args = new Object[]{};
        Class<?> clazz = null;
        Object targetUrl = "-";
        Object operationName = "-";
        try {
            clazz = axisCallObjLoader.loadClass("org.apache.axis.client.Call");
            Method getTargetEndPointAddressMethod = clazz.getMethod("getTargetEndpointAddress", new Class[0]);
            getTargetEndPointAddressMethod.setAccessible(true);
            targetUrl = getTargetEndPointAddressMethod.invoke(callObj, args);
            if (targetUrl == null) {
                targetUrl = "-";
            }
            Method getOperationNameMethod = clazz.getMethod("getOperationName", new Class[0]);
            getOperationNameMethod.setAccessible(true);
            Object operationNameQName = getOperationNameMethod.invoke(callObj, args);
            if (operationNameQName != null) {
                Class<?> qnameClazz = axisCallObjLoader.loadClass("javax.xml.namespace.QName");
                Method getLocalPartMethod = qnameClazz.getMethod("getLocalPart", new Class[0]);
                getLocalPartMethod.setAccessible(true);
                operationName = getLocalPartMethod.invoke(operationNameQName, args);
                if (operationName == null) {
                    operationName = "-";
                }
            }
        }
        catch (Exception e) {
            JTMLog.logger.error("[TraceUtils - getAxisCallInfo] Exception Occured ", e);
        }
        result.put("OperationName", operationName.toString());
        result.put("TargetUrl", targetUrl.toString());
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static HashMap requestDetails(Object requestObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> matchedPatterns = null;
        Object requestURL = null;
        Object requestURI = null;
        ClassLoader resquestObjLoader = requestObj.getClass().getClassLoader();
        Object[] args = new Object[]{};
        Class<?> clazz = null;
        try {
            clazz = resquestObjLoader.loadClass("javax.servlet.http.HttpServletRequest");
            Method getRequestURLMethod = clazz.getMethod("getRequestURL", new Class[0]);
            getRequestURLMethod.setAccessible(true);
            requestURL = getRequestURLMethod.invoke(requestObj, args);
            if (requestURL == null) {
                requestURL = "-";
            }
            for (String excludeChar : PropsManager.excludeCharsList) {
                if (requestURL.toString().indexOf(excludeChar) <= -1) continue;
                return null;
            }
            for (String filtPattern : PropsManager.FilteredPatternsList) {
                boolean toBeFiltered = JTMUtils.patternMatch(requestURL.toString(), filtPattern);
                if (!toBeFiltered) continue;
                return null;
            }
        }
        catch (Exception e) {
            JTMLog.logger.error("Exception while loading HttpServletRequest class ... ", e);
        }
        try {
            Method getRequestURImethod = clazz.getMethod("getRequestURI", new Class[0]);
            getRequestURImethod.setAccessible(true);
            requestURI = getRequestURImethod.invoke(requestObj, args);
            Method getRemoteAddrMethod = clazz.getMethod("getRemoteAddr", new Class[0]);
            getRemoteAddrMethod.setAccessible(true);
            Object remoteHost = getRemoteAddrMethod.invoke(requestObj, args);
            if (requestURI == null) {
                requestURI = "-";
            }
            if (remoteHost == null) {
                remoteHost = "UNKNOWN_HOST";
            }
            String URIString = requestURI.toString();
            if (PropsManager.isAutoURLPatternDiscovery) {
                StringTokenizer urlTokenizer = new StringTokenizer(URIString, "/");
                int countTokens = urlTokenizer.countTokens();
                String patternName = URIString;
                if (countTokens <= PropsManager.URLLevel) {
                    patternName = URIString;
                } else {
                    StringBuffer patternBuffer = new StringBuffer();
                    patternBuffer.append("/");
                    int k = 0;
                    while (k < PropsManager.URLLevel) {
                        patternBuffer.append(urlTokenizer.nextToken());
                        patternBuffer.append("/");
                        ++k;
                    }
                    patternName = patternBuffer.toString();
                }
                Object patternObject = PropsManager.patternTbl.get(patternName);
                if (patternObject == null) {
                    PropsManager.patternTbl.put(patternName, patternName);
                    UPDManager.updateTbls();
                }
                matchedPatterns = new ArrayList();
                matchedPatterns.add(patternName);
            } else {
                Enumeration patternsEnum = PropsManager.patternTbl.keys();
                if (patternsEnum.hasMoreElements()) {
                    matchedPatterns = new ArrayList<String>();
                    while (patternsEnum.hasMoreElements()) {
                        String pName = (String)patternsEnum.nextElement();
                        boolean matched = JTMUtils.patternMatch(URIString, (String)PropsManager.patternTbl.get(pName));
                        if (!matched) continue;
                        matchedPatterns.add(pName);
                    }
                }
            }
            result.put("MATCH", matchedPatterns);
            String requestTime = mySDF.format(new Date());
            StringBuffer URLSB = new StringBuffer();
            URLSB.append(requestURI.toString()).append(" @ ").append(requestTime);
            result.put("requestID", URLSB.toString());
            URLSB = null;
            result.put("remoteHost", remoteHost);
        }
        catch (SecurityException e) {
            JTMLog.logger.error("[TraceUtils - requestDetails] SecurityException Occured ", e);
        }
        catch (NoSuchMethodException e) {
            JTMLog.logger.error("[TraceUtils - requestDetails] NoSuchMethodException Occured ", e);
        }
        catch (Exception e) {
            JTMLog.logger.error("[TraceUtils - requestDetails] Exception Occured ", e);
        }
        return result;
    }

    public static String STEs2Str(Throwable t) {
        return TraceUtils.partialSTEs2Str(t, -1);
    }

    public static String partialSTEs2Str(Throwable t) {
        return TraceUtils.partialSTEs2Str(t, 10);
    }

    public static String partialSTEs2Str(Throwable throwable, int numRows) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        StringBuffer TraceSB = new StringBuffer();
        String shortExpDes = stringWriter.toString().trim();
        StringTokenizer expTokenizer = new StringTokenizer(shortExpDes, "\n");
        StringBuffer expBuffer = new StringBuffer();
        int totalRows = expTokenizer.countTokens();
        if (numRows < 1 || numRows > totalRows) {
            numRows = totalRows;
        }
        while (expTokenizer.hasMoreTokens() && numRows >= 0) {
            String expToken = expTokenizer.nextToken();
            if (expToken.indexOf("...") > -1 || expToken == null || expToken.length() <= 0) continue;
            expBuffer.append(expToken.trim());
            expBuffer.append(ExcpnRowSep);
            --numRows;
        }
        TraceSB.append(expBuffer);
        return TraceSB.toString();
    }
}

