/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.adapter;

import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.commons.AdviceAdapter;

public class EgWebServiceMethodAdviceAdapter
extends AdviceAdapter {
    private String methodName;
    private String className;
    private String description;
    private int classFileVersion;
    private static final String SOAP_CALL_METHOD_DESC = "(Ljavax/xml/soap/SOAPMessage;Ljava/lang/Object;)Ljavax/xml/soap/SOAPMessage;";
    private static final String AXIS_INVOKE_METHOD_DESC = "()V";
    private boolean isAxisWebService = false;
    private boolean isSoapWebService = false;
    private int okFlag = this.newLocal(Type.BOOLEAN_TYPE);
    Label startFinally = new Label();

    public EgWebServiceMethodAdviceAdapter(int access, MethodVisitor mv, String methodName, String description, String className, int classFileVersion) {
        super(327680, mv, access, methodName, description);
        this.className = className;
        this.methodName = methodName;
        this.description = description;
        this.classFileVersion = classFileVersion;
        if (methodName.equals("invoke") && description.equals(AXIS_INVOKE_METHOD_DESC)) {
            this.isAxisWebService = true;
        } else if (methodName.equals("call") && description.equals(SOAP_CALL_METHOD_DESC)) {
            this.isSoapWebService = true;
        }
        if (PropsManager.jtmDebugEnabled) {
            JTMLog.debugLogger.info(" [WEB-Service MethodAdviceAdapter] :" + className + " \t " + methodName + " \t  " + description);
        }
    }

    public void visitCode() {
        super.visitCode();
        this.mv.visitLabel(this.startFinally);
    }

    protected void onMethodEnter() {
        if (this.isSoapWebService) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "soapWebServiceMethodBegin", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        } else if (this.isAxisWebService) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "axisWebServiceMethodBegin", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        }
    }

    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.onFinally(opcode);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.onFinally(191);
        this.mv.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    private void onFinally(int opcode) {
        if (this.isSoapWebService) {
            if (opcode == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordPOJOException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(opcode);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "soapWebServiceMethodEnd", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        } else if (this.isAxisWebService) {
            if (opcode == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordPOJOException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(opcode);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "axisWebServiceMethodEnd", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        }
    }
}

