/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMAssociatorNamesOp;
import javax.wbem.client.CIMAssociatorsOp;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMCreateClassOp;
import javax.wbem.client.CIMCreateInstanceOp;
import javax.wbem.client.CIMCreateNameSpaceOp;
import javax.wbem.client.CIMCreateQualifierTypeOp;
import javax.wbem.client.CIMDeleteClassOp;
import javax.wbem.client.CIMDeleteInstanceOp;
import javax.wbem.client.CIMDeleteNameSpaceOp;
import javax.wbem.client.CIMDeleteQualifierTypeOp;
import javax.wbem.client.CIMEnumClassNamesOp;
import javax.wbem.client.CIMEnumClassOp;
import javax.wbem.client.CIMEnumInstanceNamesOp;
import javax.wbem.client.CIMEnumInstancesOp;
import javax.wbem.client.CIMEnumNameSpaceOp;
import javax.wbem.client.CIMEnumQualifierTypesOp;
import javax.wbem.client.CIMExecQueryOp;
import javax.wbem.client.CIMGetClassOp;
import javax.wbem.client.CIMGetInstanceOp;
import javax.wbem.client.CIMGetQualifierTypeOp;
import javax.wbem.client.CIMInvokeArgsMethodOp;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMReferenceNamesOp;
import javax.wbem.client.CIMReferencesOp;
import javax.wbem.client.CIMSetClassOp;
import javax.wbem.client.CIMSetInstanceOp;
import javax.wbem.client.CIMSetPropertyOp;
import javax.wbem.client.CIMSetQualifierTypeOp;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.adapter.http.DtdResolver;
import javax.wbem.client.adapter.http.Errors;
import javax.wbem.client.adapter.http.HttpEventListener;
import javax.wbem.client.adapter.http.XmlRpcClient;
import javax.wbem.client.adapter.http.transport.HttpClientConnection;
import javax.wbem.client.adapter.http.transport.HttpSocketFactory;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import javax.wbem.security.BasicClientSecurity;
import javax.wbem.security.ClientSecurityContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CIMClientXML
extends XmlRpcClient
implements CIMClientAPI {
    private static final String protocol_name = "cim-xml";
    public static final String HTTPPORT = "5988";
    public static final String HTTPSPORT = "5989";
    private CIMNameSpace nameSpace;
    private CIMListener clientListener;
    private String version;
    private HttpClientConnection conn = null;
    private int debug = 3;
    private boolean useChunking = false;
    DtdResolver resolver = new DtdResolver();
    private static final String PUBLICID = "-//DMTF//DTD CIM 2.0//EN";
    private String prefix = "";
    private static final String HANDLERCLASS = "CIM_IndicationHandlerCIMXML";
    private static final String LISTENERCLASS = "CIM_ListenerDestinationCIMXML";
    private CIMXml xmlImpl;
    private HttpEventListener listener = null;
    private static final String TRACEFILE = "CIMClientXML_Trace.txt";
    private FileOutputStream fout = null;
    private PrintStream psout = null;
    private PasswordAuthentication passwordAuthentication = null;
    private ClassCache cache = new ClassCache();

    public CIMClientXML(String version, CIMNameSpace name, CIMListener clientListener, Integer dbg) throws CIMException {
        this.nameSpace = name;
        this.clientListener = clientListener;
        String scheme = this.nameSpace.getScheme();
        if (scheme == null || scheme.length() == 0) {
            scheme = "http";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(scheme);
        buffer.append("://");
        buffer.append(this.nameSpace.getHost());
        buffer.append(':');
        String port = this.nameSpace.getPort();
        if (port == null) {
            port = scheme.toLowerCase().equals("https") ? HTTPSPORT : HTTPPORT;
        }
        buffer.append(port);
        buffer.append("/CIMOM");
        buffer.append(version);
        try {
            URL ns = new URL(buffer.toString());
            this.setUrl(ns);
        }
        catch (MalformedURLException ex) {
            throw new CIMTransportException("NO_CIMOM", (Object)buffer.toString());
        }
        this.debug = dbg;
        this.setCheckTypes(System.getProperty("checktypes") != null ? "true".equalsIgnoreCase(System.getProperty("checktypes")) : false);
        this.setupResolver(this.resolver);
        this.xmlImpl = CIMXmlFactory.getCIMXmlImpl();
    }

    public void setupResolver(DtdResolver resolver) {
        resolver.registerCatalogEntry(PUBLICID, "javax/wbem/client/adapter/http/cim20.dtd", this.getClass().getClassLoader());
        this.customizeResolver(resolver);
    }

    private PasswordAuthentication getPasswordAuthentication() {
        return this.passwordAuthentication;
    }

    public String getProtocol() {
        return protocol_name;
    }

    public synchronized void initSecurityContext(String version, ClientSecurityContext csc) throws CIMException {
        BasicClientSecurity cs = null;
        try {
            cs = (BasicClientSecurity)csc;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", "Bad credential");
        }
        String username = new String(cs.getUserName());
        String password = cs.getUserPassword();
        this.passwordAuthentication = new PasswordAuthentication(username, password.toCharArray());
        Authenticator.setDefault(HttpAuthenticator.instance);
    }

    Document call(Document request) throws CIMException, IOException {
        OutboundRequest outRequest;
        Document d;
        block25: {
            URL url = this.getUrl();
            d = null;
            DocumentBuilder builder = null;
            if (url == null) {
                throw new IllegalStateException("URL is not set");
            }
            HttpAuthenticator.instance.setClient(this);
            PrintStream out = null;
            String host = url.getHost();
            int port = url.getPort();
            HttpSocketFactory factory = new HttpSocketFactory(url.getProtocol());
            outRequest = null;
            for (int i = 0; i < 2; ++i) {
                try {
                    if (this.conn == null) {
                        this.conn = new HttpClientConnection(host, port, factory, false, this.useChunking);
                    }
                    outRequest = this.conn.newRequest(url.getPath());
                    out = new PrintStream(outRequest.getRequestOutputStream(), false, "UTF8");
                    this.setRequestHeaders(outRequest, this.xmlImpl.getXmlRequestHeaders(request));
                    outRequest.endWriteHeader();
                    this.writeDocumentToOutputStream(request, out);
                    out.flush();
                    out.close();
                    break;
                }
                catch (IOException e) {
                    if (this.conn != null) {
                        this.conn.shutdown(true);
                    }
                    this.conn = null;
                    if (i != 1) continue;
                    throw e;
                }
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                builder = dbf.newDocumentBuilder();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.getCheckTypes()) {
                dbf.setValidating(true);
                builder.setErrorHandler(Errors.instance);
            }
            if (this.resolver == null) {
                this.resolver = new DtdResolver();
                this.setupResolver(this.resolver);
            }
            builder.setEntityResolver(this.resolver);
            try {
                InputStream contentInput = outRequest.getResponseInputStream();
                contentInput.available();
                InputSource in = new InputSource(contentInput);
                if (this.debug == 1 || this.debug == 3) {
                    this.dumpRequest(request, outRequest);
                }
                if (outRequest.getResponseCode() >= 400) {
                    throw new IOException();
                }
                try {
                    d = builder.parse(in);
                    contentInput.close();
                }
                catch (SAXException e) {
                    if (this.debug > 0) {
                        StringBuffer buf = new StringBuffer();
                        Reader r = in.getCharacterStream();
                        int i = 0;
                        while (i >= 0) {
                            buf.append((char)i);
                            i = r.read();
                        }
                        if (this.debug >= 2) {
                            this.dumpResponse(null, outRequest);
                        }
                        break block25;
                    }
                    throw new CIMException("XMLERROR", (Object)e);
                }
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().startsWith("stream invalid")) {
                    if (this.conn != null) {
                        this.conn.shutdown(true);
                    }
                    this.conn = null;
                    return this.call(request);
                }
                if (outRequest.getResponseCode() == 401) {
                    throw new CIMException("CIM_ERR_ACCESS_DENIED");
                }
                if (this.debug >= 2) {
                    this.dumpResponse(null, outRequest);
                }
                if (outRequest.getResponseCode() == 411 && this.conn.supportsChunking()) {
                    this.conn.shutdown(true);
                    this.conn = null;
                    this.useChunking = false;
                    return this.call(request);
                }
                throw new CIMException("XMLERROR", (Object)e);
            }
        }
        if (this.debug >= 2) {
            this.dumpResponse(d, outRequest);
        }
        return d;
    }

    private void writeDocumentToOutputStream(Document request, PrintStream out) {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            String systemId;
            Transformer transformer = tFactory.newTransformer();
            DocumentType docType = request.getDoctype();
            if (docType != null && (systemId = docType.getSystemId()) != null) {
                String systemValue = new File(systemId).getName();
                transformer.setOutputProperty("doctype-system", systemValue);
            }
            DOMSource source = new DOMSource(request);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException e) {
            // empty catch block
        }
    }

    private void setRequestHeaders(OutboundRequest outRequest, Map headers) {
        this.prefix = "";
        Iterator it = headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            outRequest.addHeaderField(this.prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void dumpRequest(Document request, OutboundRequest outRequest) throws IOException {
        this.fout = new FileOutputStream(TRACEFILE, true);
        this.psout = new PrintStream(this.fout);
        this.psout.println(">>>>>>>>>>>>>>>>>>>>>>> START OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
        outRequest.dumpOutHeader(this.psout);
        if (request != null) {
            this.writeDocumentToOutputStream(request, this.psout);
        }
        this.psout.println(">>>>>>>>>>>>>>>>>>>>>>> END OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
        this.fout.close();
        this.psout.close();
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>> START OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
        outRequest.dumpOutHeader(System.out);
        if (request != null) {
            this.writeDocumentToOutputStream(request, System.out);
        }
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>> END OF REQUEST  >>>>>>>>>>>>>>>>>>>>>>>");
    }

    private void dumpResponse(Document response, OutboundRequest outRequest) throws IOException {
        this.fout = new FileOutputStream(TRACEFILE, true);
        this.psout = new PrintStream(this.fout);
        this.psout.println("<<<<<<<<<<<<<<<<<<<<<<< START OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
        outRequest.dumpInHeader(this.psout);
        this.psout.println("\n");
        if (response != null) {
            this.writeDocumentToOutputStream(response, this.psout);
        }
        this.psout.println("<<<<<<<<<<<<<<<<<<<<<<< END OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
        this.fout.close();
        this.psout.close();
        System.out.println("<<<<<<<<<<<<<<<<<<<<<<< START OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
        outRequest.dumpInHeader(System.out);
        System.out.println("\n");
        if (response != null) {
            this.writeDocumentToOutputStream(response, System.out);
        }
        System.out.println("<<<<<<<<<<<<<<<<<<<<<<< END OF RESPONSE  <<<<<<<<<<<<<<<<<<<<<<<");
    }

    private Vector getResponse(Document request) throws MalformedURLException, CIMException, IOException {
        if (request == null) {
            throw new CIMException("XMLERROR", "getResponse");
        }
        Document response = this.call(request);
        return this.xmlImpl.getCIMResponse(response);
    }

    private Vector getCIFirstResponse(String method, Document request) throws MalformedURLException, CIMException, IOException {
        Vector multi = this.getResponse(request);
        Hashtable simple = (Hashtable)multi.firstElement();
        Vector v = (Vector)simple.get(method);
        if (v.size() > 0 && v.elementAt(0) instanceof CIMException) {
            throw (CIMException)v.elementAt(0);
        }
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            this.fixKeytype(iter.next());
        }
        return v;
    }

    private Vector getFirstResponse(String method, Document request) throws MalformedURLException, CIMException, IOException {
        Vector multi = this.getResponse(request);
        Hashtable simple = (Hashtable)multi.firstElement();
        Vector v = (Vector)simple.get(method);
        if (v.size() > 0 && v.elementAt(0) instanceof CIMException) {
            throw (CIMException)v.elementAt(0);
        }
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            this.fixKeytype(iter.next());
        }
        return v;
    }

    private Vector getMultiResponse(Document request) throws MalformedURLException, CIMException, IOException {
        Vector v = new Vector();
        Vector multi = this.getResponse(request);
        Vector resp = null;
        for (int i = 0; i < multi.size(); ++i) {
            Hashtable simple = (Hashtable)multi.elementAt(i);
            String method = (String)simple.keySet().iterator().next();
            resp = (Vector)simple.get(method);
            if (method.startsWith("Enum") || method.startsWith("Asso") || method.startsWith("Refe") || method.startsWith("ExecQ")) {
                if (resp.size() > 0 && resp.firstElement() instanceof CIMException) {
                    v.addElement(resp.firstElement());
                    continue;
                }
                v.addElement(resp);
                continue;
            }
            try {
                v.addElement(resp.firstElement());
                continue;
            }
            catch (Exception e) {
                v.addElement(null);
            }
        }
        return v;
    }

    public synchronized void createNameSpace(String version, CIMNameSpace currNs, CIMNameSpace relNs) throws CIMException {
        try {
            CIMCreateNameSpaceOp cimop = new CIMCreateNameSpaceOp(relNs);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("CreateInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createNameSpace", e);
        }
    }

    public synchronized void close(String version) throws CIMException {
        if (this.conn != null) {
            this.conn.shutdown(true);
        }
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    public synchronized void deleteNameSpace(String version, CIMNameSpace currNs, CIMNameSpace ns) throws CIMException {
        try {
            CIMDeleteNameSpaceOp cimop = new CIMDeleteNameSpaceOp(ns);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteNameSpace", e);
        }
    }

    public synchronized void deleteClass(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMDeleteClassOp cimop = new CIMDeleteClassOp(path);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteClass", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteClass", e);
        }
    }

    public synchronized void deleteInstance(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMDeleteInstanceOp cimop = new CIMDeleteInstanceOp(path);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteInstance", e);
        }
    }

    public synchronized void deleteQualifierType(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMDeleteQualifierTypeOp cimop = new CIMDeleteQualifierTypeOp(path);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("DeleteQualifier", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "deleteQualifierType", e);
        }
    }

    public synchronized Vector enumerateClasses(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        try {
            CIMEnumClassOp cimop = new CIMEnumClassOp(path, deep, localOnly, includeQualifiers, includeClassOrigin);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateClasses", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateClasses", e);
        }
    }

    public synchronized Vector enumerateClassNames(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            CIMEnumClassNamesOp cimop = new CIMEnumClassNamesOp(path, deep);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateClassNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateClassNames", e);
        }
    }

    public synchronized Vector enumNameSpace(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        try {
            path.setObjectName("__Namespace");
            CIMEnumNameSpaceOp cimop = new CIMEnumNameSpaceOp(path, deep);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateInstanceNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumNameSpace", e);
        }
    }

    public Vector enumerateInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMEnumInstancesOp cimop = new CIMEnumInstancesOp(path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            Document doc = this.xmlImpl.getXmlRequest(cimop);
            return this.getFirstResponse("EnumerateInstances", doc);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateInstances", e);
        }
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        try {
            CIMEnumInstanceNamesOp cimop = new CIMEnumInstanceNamesOp(path);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("EnumerateInstanceNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumerateInstanceNames", e);
        }
    }

    public synchronized Vector enumQualifierTypes(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        Vector retval = new Vector();
        try {
            CIMEnumQualifierTypesOp cimop = new CIMEnumQualifierTypesOp(path);
            cimop.setNameSpace(currNs);
            Enumeration e = this.getFirstResponse("EnumerateQualifiers", this.xmlImpl.getXmlRequest(cimop)).elements();
            while (e.hasMoreElements()) {
                retval.addElement(e.nextElement());
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "enumQualifierTypes", e);
        }
        return retval;
    }

    public synchronized CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMGetClassOp cimop = new CIMGetClassOp(name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("GetClass", this.xmlImpl.getXmlRequest(cimop));
            return (CIMClass)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getClass", e);
        }
    }

    public synchronized CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMGetInstanceOp cimop = new CIMGetInstanceOp(name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("GetInstance", this.xmlImpl.getXmlRequest(cimop));
            CIMInstance inst = (CIMInstance)rsp.firstElement();
            Enumeration e = inst.getProperties().elements();
            while (e.hasMoreElements()) {
                CIMProperty p = (CIMProperty)e.nextElement();
                if (p == null || !p.isReference() || p.getValue() == null) continue;
                this.fixCIMOjbectPath((CIMObjectPath)p.getValue().getValue());
            }
            return inst;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getInstance", e);
        }
    }

    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        try {
            CIMInvokeArgsMethodOp cimop = new CIMInvokeArgsMethodOp(name, methodName, inArgs, null);
            cimop.setNameSpace(currNs);
            Vector v = (Vector)this.getFirstResponse(methodName, this.xmlImpl.getXmlRequest(cimop)).firstElement();
            if (null != v && v.size() == 1 && v.elementAt(0) instanceof CIMException) {
                throw (CIMException)v.elementAt(0);
            }
            for (int i = 1; i < v.size(); ++i) {
                if (outArgs == null || outArgs.length < i) continue;
                outArgs[i - 1] = (CIMArgument)v.elementAt(i);
            }
            return (CIMValue)v.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "invokeMethod", e);
        }
    }

    public synchronized CIMQualifierType getQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        try {
            CIMGetQualifierTypeOp cimop = new CIMGetQualifierTypeOp(name);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getFirstResponse("GetQualifier", this.xmlImpl.getXmlRequest(cimop));
            return (CIMQualifierType)rsp.firstElement();
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "getQualifierType", e);
        }
    }

    public synchronized void createQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        try {
            CIMCreateQualifierTypeOp cimop = new CIMCreateQualifierTypeOp(name, qt);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("SetQualifier", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createQualifierType", e);
        }
    }

    public synchronized void createClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        try {
            CIMCreateClassOp cimop = new CIMCreateClassOp(name, cc);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("CreateClass", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createClass", e);
        }
    }

    public synchronized CIMObjectPath createInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        try {
            CIMCreateInstanceOp cimop = new CIMCreateInstanceOp(name, ci);
            cimop.setNameSpace(currNs);
            Vector rsp = this.getCIFirstResponse("CreateInstance", this.xmlImpl.getXmlRequest(cimop));
            CIMObjectPath cop = (CIMObjectPath)rsp.firstElement();
            if (name.getNameSpace() != null && name.getNameSpace().length() > 0 && name.getNameSpace().startsWith("/")) {
                cop.setNameSpace(name.getNameSpace());
                cop.setHost(currNs.getHost());
            }
            return cop;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "createInstance", e);
        }
    }

    public synchronized void setQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        try {
            CIMSetQualifierTypeOp cimop = new CIMSetQualifierTypeOp(name, qt);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("SetQualifier", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setQualifierType", e);
        }
    }

    public synchronized void setClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        try {
            CIMSetClassOp cimop = new CIMSetClassOp(name, cc);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("ModifyClass", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setClass", e);
        }
    }

    public synchronized void setInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
        try {
            CIMSetInstanceOp cimop = new CIMSetInstanceOp(name, ci, includeQualifier, propertyList);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("ModifyInstance", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setInstance", e);
        }
    }

    public synchronized CIMValue getProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName) throws CIMException {
        String[] propList = new String[]{propertyName};
        CIMInstance inst = this.getInstance(version, currNs, name, false, false, false, propList);
        CIMProperty prop = inst.getProperty(propertyName);
        if (prop == null) {
            throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", propertyName);
        }
        if (prop.getValue() != null) {
            return prop.getValue();
        }
        return null;
    }

    public synchronized void setProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv) throws CIMException {
        try {
            CIMSetPropertyOp cimop = new CIMSetPropertyOp(name, propertyName, cv);
            cimop.setNameSpace(currNs);
            this.getFirstResponse("SetProperty", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setProperty", e);
        }
    }

    public synchronized Vector execQuery(String version, CIMNameSpace currNs, CIMObjectPath relNS, String query, String ql) throws CIMException {
        try {
            CIMExecQueryOp cimop = new CIMExecQueryOp(relNS, query, ql);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("ExecQuery", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "execQuery", e);
        }
    }

    public Vector associators(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMAssociatorsOp cimop = new CIMAssociatorsOp(objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("Associators", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "associators", e);
        }
    }

    public Vector associatorNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        try {
            CIMAssociatorNamesOp cimop = new CIMAssociatorNamesOp(objectName, assocClass, resultClass, role, resultRole);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("AssociatorNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "associatorNames", e);
        }
    }

    public Vector references(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        try {
            CIMReferencesOp cimop = new CIMReferencesOp(objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("References", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "references", e);
        }
    }

    public Vector referenceNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        try {
            CIMReferenceNamesOp cimop = new CIMReferenceNamesOp(objectName, resultClass, role);
            cimop.setNameSpace(currNs);
            return this.getFirstResponse("ReferenceNames", this.xmlImpl.getXmlRequest(cimop));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "referenceNames", e);
        }
    }

    public Vector performOperations(String version, CIMOperation[] batchedOperations) throws CIMException {
        try {
            return this.getMultiResponse(this.xmlImpl.getXmlRequest(batchedOperations));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "performOperations", e);
        }
    }

    public void setListener(String version) throws CIMException {
        this.setListener(version, 0);
    }

    public void setListener(String version, int port) throws CIMException {
        try {
            this.listener = new HttpEventListener(this.clientListener, port);
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", "setListener", e);
        }
    }

    public CIMInstance getIndicationHandler(CIMListener cl) throws CIMException {
        int port;
        String host;
        if (cl != null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        try {
            host = this.listener.getHostIP();
            port = this.listener.getPort();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
        CIMClass cc = this.getClass(this.version, this.nameSpace, new CIMObjectPath(HANDLERCLASS), false, false, false, null);
        CIMInstance ci = cc.newInstance();
        ci.setProperty("SystemName", new CIMValue(host));
        ci.setProperty("Name", new CIMValue(CIMClientXML.getUniqueString()));
        ci.setProperty("SystemCreationClassName", new CIMValue("wbemsolutions_computersystem"));
        ci.setProperty("CreationClassName", new CIMValue(HANDLERCLASS));
        ci.setProperty("Destination", new CIMValue("http://" + host + ":" + port));
        return ci;
    }

    public CIMInstance getIndicationListener(CIMListener cl) throws CIMException {
        int port;
        String host;
        if (cl != null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        try {
            host = this.listener.getHostIP();
            port = this.listener.getPort();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
        CIMClass cc = this.getClass(this.version, this.nameSpace, new CIMObjectPath(LISTENERCLASS), false, false, false, null);
        CIMInstance ci = cc.newInstance();
        ci.setProperty("Name", new CIMValue(CIMClientXML.getUniqueString()));
        ci.setProperty("SystemName", new CIMValue(host));
        ci.setProperty("SystemCreationClassName", new CIMValue("wbemsolutions_computersystem"));
        ci.setProperty("CreationClassName", new CIMValue(LISTENERCLASS));
        ci.setProperty("Destination", new CIMValue("http://" + host + ":" + port));
        return ci;
    }

    private static synchronized String getUniqueString() {
        return new String(new Date().toString() + System.currentTimeMillis());
    }

    private void fixKeytype(Object o) throws CIMException {
        if (o == null) {
            return;
        }
        if (o instanceof CIMObjectPath) {
            this.fixCIMOjbectPath((CIMObjectPath)o);
        } else if (o instanceof CIMInstance) {
            this.fixCIMInstance((CIMInstance)o);
        } else if (o instanceof CIMClass) {
            this.fixCIMClass((CIMClass)o);
        } else if (o instanceof Vector) {
            this.fixCIMArgument((Vector)o);
        }
    }

    private void fixCIMArgument(Vector v) throws CIMException {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            CIMArgument argument;
            Object o = e.nextElement();
            if (!(o instanceof CIMArgument) || (argument = (CIMArgument)o).getType() == null || !argument.getType().isReferenceType()) continue;
            if (argument.getType().isArrayType()) {
                Vector args = (Vector)argument.getValue().getValue();
                Enumeration eArgs = args.elements();
                while (eArgs.hasMoreElements()) {
                    this.fixCIMOjbectPath((CIMObjectPath)eArgs.nextElement());
                }
                continue;
            }
            this.fixCIMOjbectPath((CIMObjectPath)argument.getValue().getValue());
        }
    }

    private void fixCIMInstance(CIMInstance inst) throws CIMException {
        CIMObjectPath path = inst.getObjectPath();
        this.fixCIMOjbectPath(path);
        inst.setObjectPath(path);
    }

    private void fixCIMClass(CIMClass cs) throws CIMException {
        CIMObjectPath path = cs.getObjectPath();
        if (path.getNameSpace() == null || path.getNameSpace().length() == 0) {
            path.setNameSpace(this.nameSpace.getNameSpace());
        }
        if (path.getHost() == null || path.getHost().length() == 0) {
            path.setHost(this.nameSpace.getHost());
        }
        cs.setObjectPath(path);
    }

    private static boolean isFixNeeded(CIMObjectPath path) {
        Vector keys = path.getKeys();
        if (keys == null || keys.size() == 0) {
            return false;
        }
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            CIMProperty cp = (CIMProperty)iter.next();
            if (cp.getType().equals(new CIMDataType(-1))) {
                return true;
            }
            if (!cp.isReference() || !CIMClientXML.isFixNeeded((CIMObjectPath)cp.getValue().getValue())) continue;
            return true;
        }
        return false;
    }

    private void fixCIMOjbectPath(CIMObjectPath path) throws CIMException {
        if (path.getNameSpace() == null || path.getNameSpace().length() == 0) {
            path.setNameSpace(this.nameSpace.getNameSpace());
        }
        if (path.getHost() == null || path.getHost().length() == 0) {
            path.setHost(this.nameSpace.getHost());
        }
        if (CIMClientXML.isFixNeeded(path)) {
            CIMProperty[] metakeys = this.cache.get(path);
            Vector v = path.getKeys();
            CIMProperty[] keys = new CIMProperty[v.size()];
            v.toArray(keys);
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].isReference()) {
                    CIMObjectPath refpath = (CIMObjectPath)keys[i].getValue().getValue();
                    CIMProperty[] refmetakeys = this.cache.get(refpath);
                    CIMClientXML.fixInstanceName(refpath, refmetakeys);
                    continue;
                }
                CIMClientXML.fixInstancekeyProperty(keys[i], metakeys);
            }
        }
    }

    public static void fixInstanceName(CIMObjectPath path, CIMProperty[] metakeys) {
        Vector v = path.getKeys();
        if (v == null || v.size() == 0) {
            return;
        }
        CIMProperty[] keys = new CIMProperty[v.size()];
        v.toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            CIMClientXML.fixInstancekeyProperty(keys[i], metakeys);
        }
    }

    private static void fixInstancekeyProperty(CIMProperty p, CIMProperty[] metakeys) {
        for (int i = 0; i < metakeys.length; ++i) {
            if (!p.getName().equalsIgnoreCase(metakeys[i].getName())) continue;
            CIMClientXML.convertType(p, metakeys[i].getType());
        }
    }

    private static void convertType(CIMProperty p, CIMDataType type) {
        Object value;
        if (p == null) {
            return;
        }
        String cimtype = type.toString();
        if (p != null && p.getValue() != null && (value = p.getValue().getValue()) instanceof String) {
            Object o = CIMClientXML.valueObject((String)value, cimtype);
            p.setValue(new CIMValue(o));
            p.setType(type);
        }
    }

    private static Object valueObject(String value, String type) {
        Object o = null;
        type = type.length() > 0 ? type : "string";
        int radix = 10;
        if (type.startsWith("sint") && (value.startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x") || value.startsWith("0X") || value.startsWith("+0X") || value.startsWith("-0X")) || type.startsWith("uint") && (value.startsWith("0x") || value.startsWith("0X"))) {
            radix = 16;
            int dot = (value.indexOf("x") > 0 ? value.indexOf("x") : value.indexOf("X")) + 1;
            String string = value = value.startsWith("-") ? "-" + value.substring(dot) : value.substring(dot);
        }
        if (type.equals("boolean")) {
            o = Boolean.valueOf(value);
        } else if (type.equals("char16")) {
            o = new Character(value.charAt(0));
        } else if (type.equals("datetime")) {
            o = new CIMDateTime(value);
        } else if (type.equals("real32")) {
            o = new Float(value);
        } else if (type.equals("real64")) {
            o = new Double(value);
        } else if (type.equals("sint16")) {
            o = Short.valueOf(value, radix);
        } else if (type.equals("sint32")) {
            o = Integer.valueOf(value, radix);
        } else if (type.equals("sint64")) {
            o = Long.valueOf(value, radix);
        } else if (type.equals("sint8")) {
            o = Byte.valueOf(value, radix);
        } else if (type.equals("string")) {
            o = value == null ? "" : value;
        } else if (type.equals("uint16")) {
            o = new UnsignedInt16(Integer.valueOf(value, radix));
        } else if (type.equals("uint32")) {
            o = new UnsignedInt32(Long.valueOf(value, radix));
        } else if (type.equals("uint64")) {
            o = new UnsignedInt64(new BigInteger(value, radix));
        } else if (type.equals("uint8")) {
            o = new UnsignedInt8(Short.valueOf(value, radix));
        } else if (value.indexOf("e") > 0 || value.indexOf("E") > 0) {
            o = new Double(value);
        } else if (value.startsWith("+") || value.startsWith("-")) {
            o = new Long(value);
        }
        return o;
    }

    private class ClassCache {
        private HashMap classCache = new HashMap();
        private ArrayList classCacheNames = new ArrayList();
        private static final int CACHE_SIZE = 200;

        private ClassCache() {
        }

        public CIMProperty[] get(CIMObjectPath op) throws CIMException {
            String className = op.getObjectName();
            CIMProperty[] metakeys = (CIMProperty[])this.classCache.get(className);
            if (metakeys == null) {
                metakeys = this.add(op);
            }
            return metakeys;
        }

        private CIMProperty[] add(CIMObjectPath op) throws CIMException {
            CIMClass cs = CIMClientXML.this.getClass(CIMClientXML.this.version, new CIMNameSpace("", op.getNameSpace()), new CIMObjectPath(op.getObjectName()), false, true, false, null);
            Vector kv = cs.getKeys();
            if (kv == null) {
                kv = new Vector(0);
            }
            CIMProperty[] metakeys = new CIMProperty[kv.size()];
            kv.toArray(metakeys);
            if (this.classCacheNames.size() == 200) {
                String csName = (String)this.classCacheNames.remove(0);
                this.classCache.remove(csName);
            }
            this.classCache.put(op.getObjectName(), metakeys);
            this.classCacheNames.add(op.getObjectName());
            return metakeys;
        }
    }

    private static class HttpAuthenticator
    extends Authenticator {
        static HttpAuthenticator instance = new HttpAuthenticator();
        ThreadLocal clientPerThread = new ThreadLocal();

        private HttpAuthenticator() {
        }

        public void setClient(CIMClientXML client) {
            this.clientPerThread.set(client);
        }

        public CIMClientXML getClient() {
            return (CIMClientXML)this.clientPerThread.get();
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.getClient().getPasswordAuthentication();
        }
    }
}

