/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import org.jboss.mq.il.Invoker;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.uil2.ServerSocketManagerHandler;
import org.jboss.mq.il.uil2.SocketManager;
import org.jboss.mq.il.uil2.UILClientILService;
import org.jboss.mq.il.uil2.UILServerIL;
import org.jboss.mq.il.uil2.UILServerILServiceMBean;
import org.jboss.mq.il.uil2.msgs.BaseMsg;
import org.jboss.mq.il.uil2.msgs.MsgTypes;
import org.jboss.security.SecurityDomain;
import org.jboss.system.server.ServerConfigUtil;

public class UILServerILService
extends ServerILJMXService
implements MsgTypes,
Runnable,
UILServerILServiceMBean {
    static final int SO_TIMEOUT = 5000;
    private String securityDomain;
    private String clientSocketFactoryName;
    private ServerSocketFactory serverSocketFactory;
    private ServerSocket serverSocket;
    private UILServerIL serverIL;
    private boolean running;
    private int serverBindPort = 0;
    private InetAddress bindAddress = null;
    private Thread acceptThread;
    private InetAddress clientAddress;
    private String connectAddress;
    private int connectPort;
    private boolean enableTcpNoDelay = false;
    private int readTimeout = 0;
    private int clientReadTimeout = 0;
    private int bufferSize = 1;
    private int chunkSize = 0x40000000;
    private Properties connectionProperties;

    public Properties getClientConnectionProperties() {
        return this.connectionProperties;
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    public void run() {
        boolean trace = this.log.isTraceEnabled();
        while (this.running) {
            Socket socket = null;
            SocketManager socketMgr = null;
            try {
                socket = this.serverSocket.accept();
                if (trace) {
                    this.log.trace((Object)("Accepted connection: " + socket));
                }
                socket.setSoTimeout(this.readTimeout);
                socket.setTcpNoDelay(this.enableTcpNoDelay);
                socketMgr = new SocketManager(socket);
                ServerSocketManagerHandler handler = new ServerSocketManagerHandler(this.getJMSServer(), socketMgr);
                socketMgr.setHandler(handler);
                socketMgr.setBufferSize(this.bufferSize);
                socketMgr.setChunkSize(this.chunkSize);
                Invoker s = this.getJMSServer();
                socketMgr.start(s.getThreadGroup());
            }
            catch (IOException e) {
                if (!this.running) continue;
                this.log.warn((Object)"Failed to setup client connection", (Throwable)e);
            }
            catch (Throwable e) {
                if (!this.running && !trace) continue;
                this.log.warn((Object)"Unexpected error in setup of client connection", e);
            }
        }
    }

    public void startService() throws Exception {
        super.startService();
        this.running = true;
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.securityDomain != null) {
            try {
                InitialContext ctx = new InitialContext();
                Class<?> ssfClass = this.serverSocketFactory.getClass();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.securityDomain);
                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)this.serverSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.error((Object)"Socket factory does not support setSecurityDomain(SecurityDomain)");
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to setSecurityDomain=" + this.securityDomain + " on socket factory"));
            }
        }
        this.serverSocket = this.serverSocketFactory.createServerSocket(this.serverBindPort, 50, this.bindAddress);
        InetAddress socketAddress = this.serverSocket.getInetAddress();
        this.log.info((Object)("JBossMQ UIL service available at : " + socketAddress + ":" + this.serverSocket.getLocalPort()));
        this.acceptThread = new Thread(this.getJMSServer().getThreadGroup(), this, "UILServerILService Accept Thread");
        this.acceptThread.start();
        socketAddress = ServerConfigUtil.fixRemoteAddress((InetAddress)socketAddress);
        if (this.clientAddress != null) {
            socketAddress = this.clientAddress;
        }
        this.serverIL = new UILServerIL(socketAddress, this.serverSocket.getLocalPort(), this.clientSocketFactoryName, this.enableTcpNoDelay, this.bufferSize, this.chunkSize, this.clientReadTimeout, this.connectAddress, this.connectPort);
        this.connectionProperties = super.getClientConnectionProperties();
        this.connectionProperties.setProperty("ClientILService", UILClientILService.class.getName());
        this.connectionProperties.setProperty("UIL_PORT_KEY", "" + this.serverSocket.getLocalPort());
        this.connectionProperties.setProperty("UIL_ADDRESS_KEY", "" + socketAddress.getHostAddress());
        this.connectionProperties.setProperty("UIL_TCPNODELAY_KEY", this.enableTcpNoDelay ? "yes" : "no");
        this.connectionProperties.setProperty("UIL_BUFFERSIZE_KEY", "" + this.bufferSize);
        this.connectionProperties.setProperty("UIL_CHUNKSIZE_KEY", "" + this.chunkSize);
        this.connectionProperties.setProperty("UIL_RECEIVE_REPLIES_KEY", "No");
        this.connectionProperties.setProperty("UIL_SOTIMEOUT_KEY", "" + this.clientReadTimeout);
        this.connectionProperties.setProperty("UIL_CONNECTADDRESS_KEY", "" + this.connectAddress);
        this.connectionProperties.setProperty("UIL_CONNECTPORT_KEY", "" + this.connectPort);
        this.bindJNDIReferences();
        BaseMsg.setUseJMSServerMsgIDs(true);
    }

    public void stopService() {
        try {
            this.running = false;
            this.unbindJNDIReferences();
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception occured when trying to stop UIL Service: ", (Throwable)e);
        }
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public String getBindAddress() {
        String addr = "0.0.0.0";
        if (this.bindAddress != null) {
            addr = this.bindAddress.getHostName();
        }
        return addr;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress addr) {
        this.log.warn((Object)"ClientAddress has been deprecated, use ConnectAddress");
        this.clientAddress = addr;
    }

    public String getConnectAddress() {
        return this.connectAddress;
    }

    public void setConnectAddress(String addr) {
        this.connectAddress = addr;
    }

    public int getConnectPort() {
        return this.connectPort;
    }

    public void setConnectPort(int port) {
        this.connectPort = port;
    }

    public boolean getEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int size) {
        this.chunkSize = size;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getClientReadTimeout() {
        return this.clientReadTimeout;
    }

    public void setClientReadTimeout(int timeout) {
        this.clientReadTimeout = timeout;
    }

    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactory(String name) {
        this.clientSocketFactoryName = name;
    }

    public void setServerSocketFactory(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> ssfClass = loader.loadClass(name);
        this.serverSocketFactory = (ServerSocketFactory)ssfClass.newInstance();
    }

    public String getServerSocketFactory() {
        String name = null;
        if (this.serverSocketFactory != null) {
            name = this.serverSocketFactory.getClass().getName();
        }
        return name;
    }

    public void setSecurityDomain(String domainName) {
        this.securityDomain = domainName;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }
}

