/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.jvm;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;

public class JVMClientIL
implements ClientIL {
    Connection connection;
    boolean stopped = true;

    JVMClientIL(Connection c) {
        this.connection = c;
    }

    public void close() throws Exception {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        this.connection.asynchClose();
    }

    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        this.connection.asynchDeleteTemporaryDestination(dest);
    }

    public void receive(ReceiveRequest[] messages) throws Exception {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        for (int i = 0; i < messages.length; ++i) {
            messages[i].message = messages[i].message.myClone();
        }
        this.connection.asynchDeliver(messages);
    }

    public void pong(long serverTime) throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped");
        }
        this.connection.asynchPong(serverTime);
    }
}

