/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbSQLInput;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.ArrayList;
import java.util.Map;

public class TbStructDescriptor
extends TbTypeDescriptor {
    private TbConnection conn;
    private int memberNo;
    private int numOfFields;
    private int[] attributeTypes;
    private String[] attributeTypeNames;

    protected TbStructDescriptor(String string, Connection connection) throws SQLException {
        this.init(32, string.toUpperCase());
        this.conn = (TbConnection)connection;
    }

    protected TbStructDescriptor(int n, String string, int n2, int[] nArray, String[] stringArray, TbConnection tbConnection) throws SQLException {
        this.init(n, string);
        this.numOfFields = nArray.length;
        this.attributeTypes = nArray;
        this.attributeTypeNames = stringArray;
        this.conn = tbConnection;
    }

    public static TbStructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        if (!tbConnection.getExtFeatureInfo().supports(2)) {
            throw TbError.newSQLException(-90203);
        }
        String string2 = string.toUpperCase();
        Object object = tbConnection.getDescriptor(string2);
        if (object instanceof TbStructDescriptor) {
            return (TbStructDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        TbStructDescriptor tbStructDescriptor = new TbStructDescriptor(string2, connection);
        try {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ResultSet resultSet = connection.getMetaData().getAttributes(null, tbStructDescriptor.getSchemaName(), tbStructDescriptor.getTypeName(), null);
            while (resultSet.next()) {
                n = DataType.getDataType(resultSet.getInt(5));
                arrayList.add(new Integer(n));
                String string3 = null;
                if (n == 32 || n == 28 || n == 29 || n == 30) {
                    string3 = resultSet.getString(6);
                }
                arrayList2.add(string3);
            }
            tbStructDescriptor.numOfFields = arrayList.size();
            tbStructDescriptor.attributeTypes = new int[tbStructDescriptor.numOfFields];
            tbStructDescriptor.attributeTypeNames = new String[tbStructDescriptor.numOfFields];
            for (n = 0; n < tbStructDescriptor.numOfFields; ++n) {
                tbStructDescriptor.attributeTypes[n] = (Integer)arrayList.get(n);
                tbStructDescriptor.attributeTypeNames[n] = (String)arrayList2.get(n);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90664, exception);
        }
        if (tbStructDescriptor.numOfFields == 0) {
            throw TbError.newSQLException(-90665);
        }
        return tbStructDescriptor;
    }

    public static TbStructDescriptor createDescriptor(String string, int n, int[] nArray, String[] stringArray, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        String string2 = string.toUpperCase();
        TbStructDescriptor tbStructDescriptor = new TbStructDescriptor(32, string2, n, nArray, stringArray, tbConnection);
        tbConnection.putDescriptor(tbStructDescriptor.getSQLTypeName(), tbStructDescriptor);
        return tbStructDescriptor;
    }

    public SQLInput toSQLInput(TbStruct tbStruct, Map map) throws SQLException {
        return new TbSQLInput(tbStruct, this, map);
    }

    public SQLOutput toSQLOutput() {
        return new TbSQLOutput(this, this.conn);
    }

    public int getNumOfFields() {
        return this.numOfFields;
    }

    public int[] getAttributeTypes() {
        return this.attributeTypes;
    }

    public String[] getAttributeTypeNames() {
        return this.attributeTypeNames;
    }

    public int getObjectId() {
        return this.getId();
    }

    public int getMemberNo() {
        return this.memberNo;
    }

    public Class getClass(Map map) throws SQLException {
        Object v;
        String string = this.getSQLTypeName();
        Class clazz = (Class)map.get(string);
        if (clazz == null && this.conn != null && (v = this.conn.getTypeMap().get(string)) instanceof Class) {
            clazz = (Class)v;
        }
        return clazz;
    }
}

